<?php

// includes and security
include_once('../_local_auth.inc.php');

$categoryId    = (int) $_REQUEST['categoryId'];
$categoryName = $_REQUEST['categoryName'];

// prepare result
$result = array();
$result['error'] = false;
$result['msg']   = '';

if (_CONFIG_DEMO_MODE == true)
{
    $result['error'] = true;
    $result['msg']   = adminFunctions::t("no_changes_in_demo_mode");
}
else
{
    if($categoryId > 0)
    {
        $rs = $db->query('UPDATE font_categories SET categoryName = :categoryName WHERE id = :id', array('categoryName' => $categoryName, 'id'          => $categoryId));
        if ($rs)
        {
            $result['error'] = false;
            $result['msg']   = 'Category updated.';
        }
        else
        {
            $result['error'] = true;
            $result['msg']   = 'Could not update the category.';
        }
    }
    else
    // add
    {
        $row = $db->getRow('SELECT id FROM font_categories WHERE categoryName = ' . $db->quote($categoryName));
        if (is_array($row))
        {
            $result['error'] = true;
            $result['msg']   = adminFunctions::t("category_already_exists", "A category with that name already exists in the database.");
        }
        else
        {
            // add the new language
            $dbInsert = new DBObject("font_categories", array("categoryName", "dateAdded"));
            $dbInsert->categoryName = $categoryName;
            $dbInsert->dateAdded = date("Y-m-d H:i:s");
            $rs = $dbInsert->insert();
            if (!$rs)
            {
                $result['error'] = true;
                $result['msg']   = adminFunctions::t("error_problem_category_record", "There was a problem adding the category, please try again.");
            }
            else
            {
                $result['error'] = false;
                $result['msg']   = 'Category \'' . $categoryName . '\' has been added.';
            }
        }
    }
}

echo json_encode($result);
exit;
