<?php

// includes and security
include_once('../_local_auth.inc.php');

$iDisplayLength = (int) $_REQUEST['iDisplayLength'];
$iDisplayStart  = (int) $_REQUEST['iDisplayStart'];
$sSortDir_0     = $_REQUEST['sSortDir_0'] ? $_REQUEST['sSortDir_0'] : "desc";
$filterText     = $_REQUEST['filterText'] ? $_REQUEST['filterText'] : null;
$filterByGroup  = $_REQUEST['filterByGroup'] ? $_REQUEST['filterByGroup'] : "";

// get sorting columns
$iSortCol_0     = (int) $_REQUEST['iSortCol_0'];
$sColumns       = trim($_REQUEST['sColumns']);
$arrCols        = explode(",", $sColumns);
$sortColumnName = $arrCols[$iSortCol_0];
$sort           = 'category_name';
switch ($sortColumnName)
{
    case 'category_name':
        $sort = 'categoryName';
        break;
    case 'total_fonts':
        $sort = 'COUNT(font.id)';
        break;
}

$sqlClause = "WHERE 1=1 ";
if ($filterText)
{
    $filterText = $db->escape($filterText);
    $sqlClause .= "AND (categoryName LIKE '%" . $filterText . "%')";
}

$totalRS   = $db->getValue("SELECT COUNT(font_categories.id) AS total FROM font_categories " . $sqlClause);
$limitedRS = $db->getRows("SELECT font_categories.id, font_categories.categoryName, COUNT(font_categories_join.fontId) AS totalFonts FROM font_categories LEFT JOIN font_categories_join ON font_categories.id = font_categories_join.categoryId " . $sqlClause . " GROUP BY font_categories.categoryName ORDER BY " . $sort . " " . $sSortDir_0 . " LIMIT " . $iDisplayStart . ", " . $iDisplayLength);

$data = array();
if (COUNT($limitedRS) > 0)
{
    foreach ($limitedRS AS $row)
    {
        $lRow = array();
        $icon        = 'assets/images/icons/system/16x16/process.png';
        $lRow[]      = '<img src="' . $icon . '" width="16" height="16" title="category" alt="category"/>';
        $lRow[]      = adminFunctions::makeSafe($row['categoryName']);
        $lRow[]      = adminFunctions::makeSafe($row['totalFonts']);

        $links = array();
        if($row['totalFonts'] > 0)
        {
            $links[] = '<a href="font_manage.php?filterByCategoryId='.(int)$row['id'].'">view fonts</a>';
        }
        $links[] = '<a href="#" onClick="editCategoryForm(' . (int) $row['id'] . '); return false;">edit</a>';
        $links[] = '<a href="#" onClick="confirmRemoveCategory(' . (int) $row['id'] . '); return false;">delete</a>';
        $lRow[]  = implode(" | ", $links);

        $data[] = $lRow;
    }
}

$resultArr = array();
$resultArr["sEcho"]                = intval($_GET['sEcho']);
$resultArr["iTotalRecords"]        = (int) $totalRS;
$resultArr["iTotalDisplayRecords"] = $resultArr["iTotalRecords"];
$resultArr["aaData"]               = $data;

echo json_encode($resultArr);
