<?php
if (!defined('ADMIN_PAGE_TITLE'))
{
    define('ADMIN_PAGE_TITLE', adminFunctions::t("admin_area", "admin area"));
}
if (!defined('ADMIN_SELECTED_PAGE'))
{
    define('ADMIN_SELECTED_PAGE', 'dashboard');
}
?>
<html lang="en-us">

    <head>
        <meta http-equiv="X-UA-Compatible" content="IE=Edge;chrome=1" >
        <meta charset="utf-8" />

        <link rel="apple-touch-con" href="" />

        <title><?php echo adminFunctions::makeSafe(UCwords(ADMIN_PAGE_TITLE)); ?> - Admin</title>

        <meta name="viewport" content="width=device-width, minimum-scale=1.0, maximum-scale=1.0">

        <!-- The Columnal Grid and mobile stylesheet -->
        <link rel="stylesheet" href="<?php echo ADMIN_WEB_ROOT; ?>/assets/styles/columnal/columnal.css" type="text/css" media="screen" />

        <!-- Fixes for IE -->

        <!--[if lt IE 9]>
            <link rel="stylesheet" href="<?php echo ADMIN_WEB_ROOT; ?>/assets/styles/columnal/ie.css" type="text/css" media="screen" />
            <link rel="stylesheet" href="<?php echo ADMIN_WEB_ROOT; ?>/assets/styles/ie8.css" type="text/css" media="screen" />
            <script src="<?php echo ADMIN_WEB_ROOT; ?>/assets/scripts/IE9.js"></script>
        <![endif]-->        


        <!-- Use CDN on production server -->
        <script src="<?php echo ADMIN_WEB_ROOT; ?>/assets/scripts/jquery.min.js"></script>
        <script src="<?php echo ADMIN_WEB_ROOT; ?>/assets/scripts/jquery-ui.min.js"></script>

        <!-- Now that all the grids are loaded, we can move on to the actual styles. --> 
        <link rel="stylesheet" href="<?php echo ADMIN_WEB_ROOT; ?>/assets/scripts/jqueryui/jqueryui.css" type="text/css" media="screen" />
        <link rel="stylesheet" href="<?php echo ADMIN_WEB_ROOT; ?>/assets/styles/style.css" type="text/css" media="screen" />
        <link rel="stylesheet" href="<?php echo ADMIN_WEB_ROOT; ?>/assets/styles/global.css" type="text/css" media="screen" />
        <link rel="stylesheet" href="<?php echo ADMIN_WEB_ROOT; ?>/assets/styles/config.css" type="text/css" media="screen" />

        <!-- Adds HTML5 Placeholder attributes to those lesser browsers (i.e. IE) -->
        <script type="text/javascript" src="<?php echo ADMIN_WEB_ROOT; ?>/assets/scripts/jquery.placeholder.1.2.min.shrink.js"></script>

        <!-- Sortable, searchable DataTable -->
        <script src="<?php echo ADMIN_WEB_ROOT; ?>/assets/scripts/jquery.dataTables.min.js"></script>
        
        <!-- Responsive css  -->
        <link rel="stylesheet" href="<?php echo ADMIN_WEB_ROOT; ?>/assets/styles/responsive.css" type="text/css" media="screen" />

        <!-- Adds HTML5 Placeholder attributes to those lesser browsers (i.e. IE) -->
        <script type="text/javascript" src="<?php echo ADMIN_WEB_ROOT; ?>/assets/scripts/jquery.placeholder.1.2.min.shrink.js"></script>

        <!-- Adds charts -->
        <script type="text/javascript" src="<?php echo ADMIN_WEB_ROOT; ?>/assets/scripts/flot/jquery.flot.min.js"></script>
        <script type="text/javascript" src="<?php echo ADMIN_WEB_ROOT; ?>/assets/scripts/flot/jquery.flot.pie.min.js"></script>
        <script type="text/javascript" src="<?php echo ADMIN_WEB_ROOT; ?>/assets/scripts/flot/jquery.flot.stack.min.js"></script>

        <!-- Form Validation Engine -->
        <script src="<?php echo ADMIN_WEB_ROOT; ?>/assets/scripts/formvalidator/jquery.validationEngine.js"></script>
        <script src="<?php echo ADMIN_WEB_ROOT; ?>/assets/scripts/formvalidator/jquery.validationEngine-en.js"></script>
        <link rel="stylesheet" href="<?php echo ADMIN_WEB_ROOT; ?>/assets/scripts/formvalidator/validationEngine.jquery.css" type="text/css" media="screen" />

        <!-- Custom Tooltips -->
        <script src="<?php echo ADMIN_WEB_ROOT; ?>/assets/scripts/twipsy.js"></script>

        <!-- WYSIWYG Editor -->
        <script src="<?php echo ADMIN_WEB_ROOT; ?>/assets/scripts/cleditor/jquery.cleditor.min.js"></script>
        <link rel="stylesheet" href="<?php echo ADMIN_WEB_ROOT; ?>/assets/scripts/cleditor/jquery.cleditor.css" type="text/css" media="screen" />

        <!-- Colorbox is a lightbox alternative-->
        <script src="<?php echo ADMIN_WEB_ROOT; ?>/assets/scripts/colorbox/jquery.colorbox-min.js"></script>
        <link rel="stylesheet" href="<?php echo ADMIN_WEB_ROOT; ?>/assets/scripts/colorbox/colorbox.css" type="text/css" media="screen" />

        <!-- Menu -->
        <link rel="stylesheet" href="<?php echo ADMIN_WEB_ROOT; ?>/assets/scripts/superfish/superfish.css" type="text/css" media="screen" />
        <script src="<?php echo ADMIN_WEB_ROOT; ?>/assets/scripts/superfish/superfish.js"></script>

        <!-- ddslick, for images in dropdown menus -->
        <script src="<?php echo ADMIN_WEB_ROOT; ?>/assets/scripts/jquery.ddslick.min.js"></script>

        <!-- Js used in the theme -->
        <script src="<?php echo ADMIN_WEB_ROOT; ?>/assets/scripts/global.js"></script>

    </head>
    <body>

        <div id="wrap">
            <div id="main">
                <header class="container" >
                    <div class="row clearfix">
                    
                    <div class="responsiveHeaderWrapper">
                        <div class="left">
                            <a href="<?php echo ADMIN_WEB_ROOT; ?>/index.php" id="logo"><?php echo adminFunctions::t("admin_area", "admin area"); ?></a>
                        </div>

                        <div class="right">
                            <ul id="toolbar">
                                <li><span><?php echo adminFunctions::t("logged_in_as", "Logged in as"); ?></span> <a class="user" href="<?php echo ADMIN_WEB_ROOT; ?>/user_edit.php?id=<?php echo $userObj->id; ?>"><?php echo $userObj->username; ?></a></li>
								<?php
                                // output error
                                if (file_exists('../install/'))
                                {
                                    $systemAlertErrorStr = '<strong>IMPORTANT:</strong><br/><br/>Remove the /install/ folder within your webroot asap.';
                                    ?>
                                    <li>
                                        <a id="alertYellow" href="#" onClick="$('#alertMessage').dialog('open'); return false;">Alert</a>
                                    </li>
                                    <?php
                                }
                                ?>
                                <li><a id="search" href="#">Search</a></li>
                            </ul>
                            <div id="searchdrop">
                                <form action="<?php echo ADMIN_WEB_ROOT; ?>/font_manage.php" method="POST">
                                    <input type="text" id="searchbox" name="filterText" placeholder="Search fonts...">
                                </form>
                            </div>
                        </div>  
                        </div>
                    </div>
                </header>

                <nav class="container" style="background-color: #3B4966;">
                    <select class="mobile-only row" onchange="window.open(this.options[this.selectedIndex].value,'_top')">
                    
                    <optgroup label="<?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('your_account', 'Your Account')))); ?>">
                        <option value="<?php echo ADMIN_WEB_ROOT; ?>/index.php?t=dashboard"><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('dashboard', 'Dashboard')))); ?></option>
                        <option value="<?php echo ADMIN_WEB_ROOT; ?>/logout.php"><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('logout', 'logout')))); ?></option>
                    </optgroup>  
                        
                    <optgroup label="<?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('fonts', 'fonts')))); ?>">    
                        <option <?php if (ADMIN_SELECTED_SUB_PAGE == 'font_manage') echo 'selected' ?> value="<?php echo ADMIN_WEB_ROOT; ?>/font_manage.php"><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('manage_fonts', 'manage fonts')))); ?></option>
                        <option <?php if (ADMIN_SELECTED_SUB_PAGE == 'font_manage_pending_approval') echo 'selected' ?> value="<?php echo ADMIN_WEB_ROOT; ?>/font_manage.php?filterByStatus=pending"><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('pending_font_approval', 'pending font approval')))); ?></option>
                        <option <?php if (ADMIN_SELECTED_SUB_PAGE == 'add_font') echo 'selected' ?> value="<?php echo ADMIN_WEB_ROOT; ?>/font_add.php"><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('add_font', 'add font')))); ?></option>
                    </optgroup>     
                        
                    <optgroup label="<?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('comments', 'comments')))); ?>">
                        <option <?php if (ADMIN_SELECTED_SUB_PAGE == 'comment_manage') echo 'selected' ?> value="<?php echo ADMIN_WEB_ROOT; ?>/comment_manage.php"><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('manage_comments', 'manage comments')))); ?></option>
                        <option <?php if (ADMIN_SELECTED_SUB_PAGE == 'comment_manage_pending') echo 'selected' ?> value="<?php echo ADMIN_WEB_ROOT; ?>/comment_manage.php?filterByStatus=pending"><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('pending_comment_approval', 'pending comment approval')))); ?></option>
                    </optgroup>  
                    
                    <optgroup label="<?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('users', 'users')))); ?>">
                        <option <?php if (ADMIN_SELECTED_SUB_PAGE == "user_manage") echo 'selected'; ?> value="<?php echo ADMIN_WEB_ROOT; ?>/user_manage.php"><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('users', 'users')))); ?></option>
                    </optgroup>  
                    
                    <optgroup label="<?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('categories', 'categories')))); ?>">
                        <option <?php if (ADMIN_SELECTED_SUB_PAGE == 'category_manage') echo 'selected' ?> value="<?php echo ADMIN_WEB_ROOT; ?>/category_manage.php"><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('categories', 'categories')))); ?></option>
                    </optgroup>
                    
                    <optgroup label="<?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('Configuration', 'Configuration')))); ?>">
                       <option <?php if (ADMIN_SELECTED_SUB_PAGE == 'setting_manage') echo 'selected' ?> value="<?php echo ADMIN_WEB_ROOT; ?>/setting_manage.php"><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('site_settings', 'site settings')))); ?></option>
                       <option <?php if (ADMIN_SELECTED_SUB_PAGE == 'translation_manage') echo 'selected' ?> value="<?php echo ADMIN_WEB_ROOT; ?>/translation_manage.php"><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('translations', 'translations')))); ?></option>
                       <option <?php if (ADMIN_SELECTED_SUB_PAGE == 'banned_ip_manage') echo 'selected' ?> value="<?php echo ADMIN_WEB_ROOT; ?>/banned_ip_manage.php"><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('banned_ips', 'banned ips')))); ?></option>
                    </optgroup>
                    
                    <optgroup label="<?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('system_tools', 'system tools')))); ?>">
                        <option <?php if (ADMIN_SELECTED_SUB_PAGE == 'log_file_viewer') echo 'selected' ?> value="<?php echo ADMIN_WEB_ROOT; ?>/log_file_viewer.php"><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('system_logs', 'system logs')))); ?></option>
                        <option <?php if (ADMIN_SELECTED_SUB_PAGE == 'database_browser') echo 'selected' ?> value="<?php echo ADMIN_WEB_ROOT; ?>/database_browser.php?username=&db=<?php echo _CONFIG_DB_NAME; ?>"><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('database_browser', 'database browser')))); ?></option>
                        <option <?php if (ADMIN_SELECTED_SUB_PAGE == 'server_info') echo 'selected' ?> value="<?php echo ADMIN_WEB_ROOT; ?>/server_info.php"><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('server_info', 'server info')))); ?></option>
                    </optgroup>
                    
                    <optgroup label="<?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('plugins', 'Plugins')))); ?>">
                        <option <?php if (ADMIN_SELECTED_SUB_PAGE == 'plugins_manage') echo 'selected' ?> value="<?php echo ADMIN_WEB_ROOT; ?>/plugin_manage.php"><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('manage_plugins', 'manage plugins')))); ?></option>
                        <option <?php if (ADMIN_SELECTED_SUB_PAGE == 'add_plugins') echo 'selected' ?> value="<?php echo ADMIN_WEB_ROOT; ?>/plugin_manage_add.php"><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('add_plugin', 'add plugin')))); ?></option>
                    </optgroup>
                        
                    </select>

                    <ul class="sf-menu mobile-hide row clearfix">
                        <li class="<?php if (ADMIN_SELECTED_PAGE == 'dashboard') echo 'active'; ?> iconed"><a href="<?php echo ADMIN_WEB_ROOT; ?>/index.php?t=dashboard"><span><img src="<?php echo ADMIN_WEB_ROOT; ?>/assets/images/header/icon_dashboard.png" /> Dashboard</span></a></li>

                        <li<?php if (ADMIN_SELECTED_PAGE == 'font_manage') echo ' class="active"'; ?>><a href="<?php echo ADMIN_WEB_ROOT; ?>/font_manage.php"><span><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('fonts', 'fonts')))); ?></span></a>
                            <ul>
                                <li><a href="<?php echo ADMIN_WEB_ROOT; ?>/font_manage.php"><span><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('manage_fonts', 'manage fonts')))); ?></span></a></li>
                                <li><a href="<?php echo ADMIN_WEB_ROOT; ?>/font_manage.php?filterByStatus=pending"><span><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('pending_font_approval', 'pending font approval')))); ?></span></a></li>
                                <li><a href="<?php echo ADMIN_WEB_ROOT; ?>/font_add.php"><span><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('add_font', 'add font')))); ?></span></a></li>
                            </ul>
                        </li>
                        <li<?php if (ADMIN_SELECTED_PAGE == 'comment_manage') echo ' class="active"'; ?>><a href="<?php echo ADMIN_WEB_ROOT; ?>/comment_manage.php"><span><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('comments', 'comments')))); ?></span></a>
                            <ul>
                                <li><a href="<?php echo ADMIN_WEB_ROOT; ?>/comment_manage.php"><span><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('manage_comments', 'manage comments')))); ?></span></a></li>
                                <li><a href="<?php echo ADMIN_WEB_ROOT; ?>/comment_manage.php?filterByStatus=pending"><span><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('pending_comment_approval', 'pending comment approval')))); ?></span></a></li>
                            </ul>
                        </li>
                        <li<?php if (ADMIN_SELECTED_PAGE == 'users') echo ' class="active"'; ?>><a href="<?php echo ADMIN_WEB_ROOT; ?>/user_manage.php"><span><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('users', 'users')))); ?></span></a></li>
                        <li<?php if (ADMIN_SELECTED_PAGE == 'category_manage') echo ' class="active"'; ?>><a href="<?php echo ADMIN_WEB_ROOT; ?>/category_manage.php"><span><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('categories', 'categories')))); ?></span></a></li>
                        
                        <?php
                        // add any plugin navigation
                        pluginHelper::outputPluginAdminNav();
                        ?>

                        <li style="float: right;"><a href="logout.php"><span><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('logout', 'logout')))); ?></span></a></li>
                        <li<?php if (ADMIN_SELECTED_PAGE == 'configuration') echo ' class="active"'; ?> style="float: right;"><a href="#"><span><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('Configuration', 'Configuration')))); ?></span></a>
                            <ul>
                                <li><a href="<?php echo ADMIN_WEB_ROOT; ?>/setting_manage.php"><span><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('site_settings', 'site settings')))); ?></span></a></li>
                                <li><a href="<?php echo ADMIN_WEB_ROOT; ?>/translation_manage.php"><span><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('translations', 'translations')))); ?></span></a></li>
                                <li><a href="<?php echo ADMIN_WEB_ROOT; ?>/banned_ip_manage.php"><span><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('banned_ips', 'banned ips')))); ?></span></a></li>
                                <li><a href=""><span><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('system_tools', 'system tools')))); ?></span></a>
									<ul>
										<li><a href="<?php echo ADMIN_WEB_ROOT; ?>/log_file_viewer.php"><span><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('system_logs', 'system logs')))); ?></span></a></li>
										<li><a href="<?php echo ADMIN_WEB_ROOT; ?>/database_browser.php?username=&db=<?php echo _CONFIG_DB_NAME; ?>"><span><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('database_browser', 'database browser')))); ?></span></a></li>
										<li><a href="<?php echo ADMIN_WEB_ROOT; ?>/server_info.php"><span><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('server_info', 'server info')))); ?></span></a></li>
									</ul>
								</li>
                            </ul>
                        </li>
                        <li<?php if (ADMIN_SELECTED_PAGE == 'plugins') echo ' class="active"'; ?> style="float: right;"><a href="#"><span><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('plugins', 'Plugins')))); ?></span></a>
                            <ul>
                                <li><a href="<?php echo ADMIN_WEB_ROOT; ?>/plugin_manage.php"><span><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('manage_plugins', 'manage plugins')))); ?></span></a></li>
                                <li><a href="<?php echo ADMIN_WEB_ROOT; ?>/plugin_manage_add.php"><span><?php echo adminFunctions::makeSafe(UCWords(strtolower(adminFunctions::t('add_plugin', 'add plugin')))); ?></span></a></li>
                            </ul>
                        </li>
                    </ul>
                </nav>

                <div id="titlediv">
                    <div class="clearfix container" id="pattern">
                        <div class="row">
                            <div class="col_12">
                                <h1><?php echo adminFunctions::makeSafe(UCwords(ADMIN_PAGE_TITLE)); ?></h1>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="container" id="actualbody">
                    <div class="notificationHeader" id="notificationHeader"></div>