<?php

/* setup includes */
require_once('includes/master.inc.php');

/* require login */
if($Auth->loggedIn() == false)
{
    redirect(WEB_ROOT);
}

/* setup page */
define("PAGE_NAME", t("your_submitted_fonts_page_name", "Your Fonts"));
define("PAGE_KEY", "account_home");
define("PAGE_DESCRIPTION", t("your_submitted_fonts_meta_description"));
define("PAGE_KEYWORDS", t("your_submitted_fonts_meta_keywords"));

/* font preview template block */
require_once('_font_preview_block.inc.php');

/* header section */
require_once('_header.php');

// newest fonts
echo htmlHelpers::createPageTitleHTML(t("your_submitted_fonts", "Your Submitted Fonts"));

echo "<div class='pageMainContent'>";
$limitedRS = $db->getRows("SELECT * FROM font WHERE submittedUserId = ".(int)$Auth->id." ORDER BY fontName LIMIT 50");
$totalRows = COUNT($limitedRS);
if($totalRows > 0)
{
    foreach ($limitedRS AS $fontRow)
    {
        echo fontPreviewBlock::createHTMLBlock($fontRow);
    }
}
else
{
    echo t("you_have_not_submitted_any_fonts", "You have not submitted any fonts yet. You can submit new fonts by <a href='submit_font.".SITE_CONFIG_PAGE_EXTENSION."'>going here</a>.");
}
echo "</div>";

require_once('_footer.php');
