<?php

class fontPreviewBlock
{

    static function createHTMLBlock($fontData, $detailsPage = false)
    {
        $fontObj      = new font($fontData['id'], $fontData);
        $hasUserRated = $fontObj->hasUserIPRated(getUsersIPAddress());
        $Auth = Auth::getAuth();
        
        if($fontData['status'] != 'active')
        {
            $detailsPage = true;
        }

        $html = array();
        $html[] = " <div class='fontPreviewWrapper'>";
        $html[] = "		<div class='fontPreviewHeader'>";
        $html[] = "			<div class='fontPreviewHeaderInner'>";
        if($fontData['status'] == 'active')
        {
            $html[] = "				<div class='fontTotalDownloads'>";
            $html[] = "					<a href='" . font::createFontDownloadUrl($fontData['id'], $fontData['fontName']) . "'>";
            $html[] = (int) $fontData['totalDownloads'] . " ";
            if ($fontData['totalDownloads'] != 1)
            {
                $html[] = t("downloads");
            }
            else
            {
                $html[]   = t("download");
            }
            $html[]   = "</a>";
            $html[]   = "				</div>";
        }
        
        $catNames = $fontObj->getFontCategoryNames();
        if (COUNT($catNames))
        {
            $html[] = "<div class='fontTopCategories'>";
            $html[] = "Found in: ";
            $cats   = array();
            foreach ($catNames AS $catName)
            {
                $cats[] = "<a href='" . WEB_ROOT . "/c/" . $catName['categoryId'] . "/" . htmlHelpers::formatForUrl($catName['categoryName']) . "'>" . trim($catName['categoryName']) . "</a>";
            }
            $html[] = implode($cats, ", ");
            $html[] = "</div>";
        }
        $html[] = "				<div class='fontPreviewTitle'>";
        if ($detailsPage)
        {
            $html[] = "					<strong>" . $fontData['fontName'] . "</strong>";
        }
        else
        {
            $html[] = "					<a href='" . font::createFontDetailsUrl($fontData['id'], $fontData['fontName']) . "'>" . $fontData['fontName'] . "</a>";
        }
        if (strlen($fontData['fontDesigner']))
        {
            $html[] = "					by ";
            $html[] = "					<a href='" . WEB_ROOT . "/search." . SITE_CONFIG_PAGE_EXTENSION . "?d=1&q=" . urlencode(trim($fontData['fontDesigner'])) . "'>" . $fontData['fontDesigner'] . "</a>";
        }
        
        if($fontData['status'] != 'active')
        {
            $html[] = "&nbsp;(".$fontData['status']." ".strtolower(t("font", "font")).")";
        }
        $html[] = "				</div>";
        $html[] = "				<div class='clear'><!-- --></div>";
        $html[] = "			</div>";
        $html[] = "		</div>";
        if ($detailsPage)
        {
            $html[] = "		<div class='fontPreviewImageWrapperDefault' style='background: url(" . $fontObj->getPreviewUrl() . ") no-repeat left top;'>";
        }
        else
        {
            $html[] = "		<div id='fontPreviewImageWrapper_" . $fontData['id'] . "' class='fontPreviewImageWrapper' style='background: url(" . $fontObj->getPreviewUrl() . ") no-repeat left top;'>";
        }
        $html[] = "			<div class='rightSection'>";
        if($Auth->id == $fontData['submittedUserId'])
        {
            $hasUserRated = 1;
        }
        $html[] = "				" . htmlHelpers::createRatingBlock($fontData['id'], $hasUserRated, $fontData['fontRating']);
        $html[] = "				<div class='clear'><!-- --></div>";
        
        if($fontData['status'] == 'active')
        {
            $html[] = "				<div class='downloadButton responsiveHide'>";
            $html[] = "					<div id='queueButton" . (int)$fontData['id'] . "' class='downloadButtonElement' title=\"".t("add_to_download_queue", "Add to download queue")."\" onClick=\"toggleDownloadQueue(" . (int)$fontData['id'] . "); return false;\">";
            $html[] = "						<a href=\"#\" onClick=\"return false;\">";
            $html[] = "<img src='".SITE_IMAGE_PATH."/icons/download_queue_add.png' width='12' height='12'/>";
            $html[] = "                                         </a>";
            $html[] = "					</div>";
            $html[] = "				</div>";

            $html[] = "				<div class='downloadButton'>";
            $html[] = "					<div class='downloadButtonElement' onClick=\"window.location='" . font::createFontDownloadUrl($fontData['id'], $fontData['fontName']) . "';\">";
            $html[] = "						<a href='" . font::createFontDownloadUrl($fontData['id'], $fontData['fontName']) . "'>" . t("download_upper") . "</a>";
            $html[] = "					</div>";
            $html[] = "				</div>";

            if(!defined("HIDE_MORE_DETAILS"))
            {
                if ($detailsPage == false)
                {
                    $html[] = "				<div class='detailsButton'>";
                    $html[] = "					<div class='detailsButtonElement' onClick=\"window.location='" . font::createFontDetailsUrl($fontData['id'], $fontData['fontName']) . "';\">";
                    $html[] = "						<a href='" . font::createFontDetailsUrl($fontData['id'], $fontData['fontName']) . "'>" . t("details_upper", "MORE DETAILS") . "</a>";
                    $html[] = "					</div>";        
                    $html[] = "				</div>";
                }
            }
        }
        
        $html[] = "				<div class='clear'><!-- --></div>";
        $html[] = "			</div>";
        $html[] = "		</div>";
        $html[] = " </div>";
        /* js */
        $html[] = "	<script>";
        $html[] = "	YAHOO.util.Event.onAvailable(\"fontPreviewImageWrapper_" . $fontData['id'] . "\", function()";
        $html[] = "	{";
        $html[] = "		YAHOO.util.Event.on(\"fontPreviewImageWrapper_" . $fontData['id'] . "\", \"click\", loadFontDetails, {'eleId':" . $fontData['id'] . ", 'newPath':'" . font::createFontDetailsUrl($fontData['id'], $fontData['fontName']) . "'});";
        $html[] = "	});";
        $html[] = "	</script>";
        
        return implode("\n", $html);
    }

}
