<?php
	class systemUSER {
		public $mUserId;
	
		public $mFirstname;
		public $mLastname;
		public $mFullname;
		
		public $mFriendsCount = 0;
		public $mFollowerCount = 0;
		
		public $mMail = null;
		public $mResidence = null;
		public $mDetails = null;
		public $mWorkplace = null;
		
		public $mProfileHash = null;
		
		public $mProfilePicture = null;
		public $mProfileCover = null;
		public $mProfileGender = 0;
		
		public $mProfileSignIn = 0;
		
		public $mAdmin = false;
		public $mLostHash = null;
	
		public function __construct($mUserId = null) {
			if($mUserId !== null) {
				global $systemHandler;
				$systemExecution = $systemHandler->loadHandler("EXECUTION");
				$mRow = $systemExecution->runQuery("SELECT id, firstname, lastname, profile_hash, gender, signin_time, is_admin, mail, residence, details, workplace, lost_hash FROM web_user WHERE id = '%s'", $mUserId)->fetch_assoc();
				
				$this->mUserId = $mRow["id"];
				
				$this->mFirstname = $mRow["firstname"];
				$this->mLastname = $mRow["lastname"];
				$this->mProfileGender = $mRow["gender"];
				$this->mProfileSignIn = $mRow["signin_time"];
				$this->mFullname = vsprintf("%s %s", array($this->mFirstname, $this->mLastname));
				$this->mAdmin = $mRow["is_admin"] == 1;
				
				$this->mMail = $mRow["mail"];
				$this->mResidence = $mRow["residence"];
				$this->mDetails = $mRow["details"];
				$this->mWorkplace = $mRow["workplace"];
				
				$this->mLostHash = $mRow["lost_hash"];
				
				$this->mFriendsCount = $systemExecution->runQuery("SELECT COUNT(id) AS friendsCount FROM web_friends WHERE user_one_id = '%s' OR user_two_id = '%s'", array($this->mUserId, $this->mUserId))->fetch_object()->friendsCount;
				
				$this->mFollowerCount = 0;
				
				$this->mProfileHash = $mRow["profile_hash"];
				if($this->mProfileHash !== '0') {
					$this->mProfilePicture = vsprintf("system.gallery/system.profile.pictures/%s.png", $this->mProfileHash);
					$this->mProfileCover = @getimagesize(vsprintf("system.gallery/system.profile.covers/%s.png", $this->mProfileHash)) ? vsprintf("system.gallery/system.profile.covers/%s.png", $this->mProfileHash) : "system.assets/images/emptyCover.png";
				}
				else {
					$this->mProfilePicture = "system.assets/images/empty_man.png";
					$this->mProfileCover = "system.assets/images/emptyCover.png";
				}
			}
		}
		public function isFriend($mUserId = false) {
			global $systemHandler;
			$systemExecution = $systemHandler->loadHandler("EXECUTION");
			if(!$mUserId) return false;
			$uid = $systemHandler->loadHandler("USER")->mUserId;
			$result = $systemExecution->runQuery("SELECT count(id) FROM web_friends WHERE (user_one_id = '%i' AND user_two_id = '%i') or (user_two_id = '%i' AND user_one_id = '%i')", array($this->mUserId, $this->uid, $this->mUserId, $this->uid))->fetch_object();
			if($result == 0) return false;
			else return true;
		}
	}
?>