<?php
	class systemSMILIES {
		private $mSystemSmiliesCollection = array(":d" => "smile-big",
												  ":)" => "smile",
												  "♥" => "love",
												  "<3" => "love");
		
		public function initializeSmilies($mText, $mComment = false) {
			$mCachedSentence = null;
			$mTextParts = explode(' ', $mText);
			foreach($mTextParts as $mPart) {
				$mPart = trim(htmlspecialchars($mPart));
				if(array_key_exists(strtolower($mPart), $this->mSystemSmiliesCollection))
					$mCachedSentence .= $this->convertIntoHTML($this->mSystemSmiliesCollection[strtolower($mPart)], $mComment).' ';
				else {
					if(preg_match("/http:\/\/(www\.)*vimeo\.com\/.*/", $mPart)) {
						preg_match("/\/\/(www\.)?vimeo.com\/(\d+)($|\/)/", $mPart, $mMatches);
						$mId = $mMatches[2];
						$mCachedSentence .= "<div class=\"embed-responsive embed-responsive-16by9\"><iframe class=\"embed-responsive-item\" src=\"//player.vimeo.com/video/".$mId."\" width=\"WIDTH\" height=\"HEIGHT\" frameborder=\"0\" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe></div>";
					} else {
						$mCachedSentence .= filter_var(trim($mPart), FILTER_VALIDATE_URL) ? (preg_match('/http:\/\/(www\.)*youtube\.com\/.*/', $mPart) ? "<div class=\"embed-responsive embed-responsive-16by9\"><iframe class=\"embed-responsive-item\" src=\"".str_replace("watch?v=", "v/", $mPart)."\"></iframe></div>" : (preg_match('/https:\/\/(www\.)*youtube\.com\/.*/', $mPart) ? "<div class=\"embed-responsive embed-responsive-16by9\"><iframe class=\"embed-responsive-item\" src=\"".str_replace("watch?v=", "v/", $mPart)."\"></iframe></div>" : (preg_match('/https:\/\/(www\.)*soundcloud\.com\/.*/', $mPart) ? "<iframe width=\"100%\" height=\"166\" scrolling=\"no\" frameborder=\"no\" src=\"https://w.soundcloud.com/player/?url=".$mPart."&amp;color=ff5500&amp;auto_play=false&amp;hide_related=false&amp;show_comments=true&amp;show_user=true&amp;show_reposts=false\"></iframe>" : "<a href=\"".$mPart."\" target=\"_blank\">".$mPart."</a>"))) : (substr($mPart, 0, 14) == "spotify:track:" ? "<center><iframe src=\"https://embed.spotify.com/?uri=".$mPart."\" width=\"90%\" height=\"80\" frameborder=\"0\" allowtransparency=\"true\"></iframe></center>" : $mPart.' ');
					}
				}
			}
			return trim($mCachedSentence);
		}
		
		private function convertIntoHTML($mImage, $mComment = false) {
			return vsprintf("<img class=\"system-smiley ".($mComment ? "commentSize" : null)."\" src=\"system.smileys/%s.png\" />", $mImage);
		}
	}
?>