<?php
	error_reporting(E_ALL);
	ini_set("display_errors", 1);
	
	class systemCORE {
		private $mInactivePages = array("index", "page.policy");
		
		public function isAdmin() {
			global $systemHandler;
			$systemUser = $systemHandler->loadHandler("USER");
			
			if($systemHandler->loadHandler("SESSION")->aliveSession("USER"))
				return $systemUser->mAdmin;
			else 
				return false;
		}
	
		public function __construct() {
			if(!file_exists("system.engine/system.config.php") && !file_exists("../system.engine/system.config.php"))
				header("Location: system.install/");
			
			$this->initializeSystemFiles();
			
			global $systemHandler;
			$systemConfig = $systemHandler->loadHandler("CONFIG");
			$systemSession = $systemHandler->loadHandler("SESSION");
			
			$systemHandler->loadHandler("MYSQLI")->initializeConnection($systemConfig->mSQLInformation["s.HOST"], $systemConfig->mSQLInformation["s.USER"], $systemConfig->mSQLInformation["s.PASS"], $systemConfig->mSQLInformation["s.DATA"], $systemConfig->mSQLInformation["s.PORT"]);
			$systemConfig->loadConfiguration();
			
			if($systemSession->aliveSession("USER")) {
				$systemHandler->appendHandler("USER", new systemUSER($systemSession->loadSession("USER")));
				if(defined("CURRENT_PAGE"))
					if(in_array(CURRENT_PAGE, $this->mInactivePages))
						header("Location: page.timeline.php");
			} else {
				if(defined("CURRENT_PAGE"))
					if(!in_array(CURRENT_PAGE, $this->mInactivePages))
						header("Location: index.php");
			}
		}
		
		private function initializeSystemFiles() {
			$mExcludedFiles = array("core", "profile", "handler");
			require_once("system.handler.php");
			global $systemHandler;
			$systemHandler = new systemHANDLER();
			foreach(scandir(__DIR__) as $mFile) {
				$mFileParts = explode('.', $mFile);
				if($mFileParts[0] == "system") {
					if(!in_array($mFileParts[1], $mExcludedFiles)) {
						require_once($mFile);
						$mClassName = vsprintf("system%s", strtoupper($mFileParts[1]));
						$mClassCached = new $mClassName();
						$mClassIdentifier = strtoupper($mFileParts[1]);
						$systemHandler->appendHandler($mClassIdentifier, $mClassCached);
					}
				}
			}
			
			if(file_exists("system.language/lang.en.php"))
				require_once("system.language/lang.en.php");
			else
				require_once("../system.language/lang.en.php");
			
			$systemHandler->appendHandler("LANG", new systemLANG());
		}
		
		public function deleteContainerLike($mContainerId) {
			global $systemHandler;
			$systemExecution = $systemHandler->loadHandler("EXECUTION");
			
			$mSenderUser = $systemHandler->loadHandler("USER")->mUserId;
			$systemExecution->runQuery("DELETE FROM web_notifications WHERE container_id = '%s' AND sender_user = '%s'", array($mContainerId, $mSenderUser));
		}
		
		public function importContainerLike($mContainerId) {
			global $systemHandler;
			$systemExecution = $systemHandler->loadHandler("EXECUTION");
			
			$mSenderUser = $systemHandler->loadHandler("USER")->mUserId;
			$mNotificationType = 0;
			$mContainerId = $mContainerId;
			$mReceiverId = $systemExecution->runQuery("SELECT post_user_id FROM web_timeline WHERE id = '%s'", $mContainerId)->fetch_object()->post_user_id;
			
			if($mSenderUser !== $mReceiverId)
				$systemExecution->runQuery("INSERT INTO web_notifications (user_id, has_seen, submit_date, notification_type, sender_user, container_id, comment_id, picture_id) VALUES ('%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s')", array($mReceiverId, 0, time(), $mNotificationType, $mSenderUser, $mContainerId, 0, 0));
		}
		
		public function deleteCommentLike($mCommentId) {
			global $systemHandler;
			$systemExecution = $systemHandler->loadHandler("EXECUTION");
			
			$mSenderUser = $systemHandler->loadHandler("USER")->mUserId;
			$systemExecution->runQuery("DELETE FROM web_notifications WHERE comment_id = '%s' AND sender_user = '%s'", array($mCommentId, $mSenderUser));
		}
		
		public function importCommentLike($mCommentId) {
			global $systemHandler;
			$systemExecution = $systemHandler->loadHandler("EXECUTION");
			
			$mSenderUser = $systemHandler->loadHandler("USER")->mUserId;
			$mNotificationType = 0;
			$mCommentId = $mCommentId;
			$mReceiverId = $systemExecution->runQuery("SELECT user_id FROM web_comments WHERE id = '%s'", $mCommentId)->fetch_object()->user_id;
			
			if($mSenderUser !== $mReceiverId)
				$systemExecution->runQuery("INSERT INTO web_notifications (user_id, has_seen, submit_date, notification_type, sender_user, container_id, comment_id, picture_id) VALUES ('%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s')", array($mReceiverId, 0, time(), $mNotificationType, $mSenderUser, 0, $mCommentId, 0));
		}
		
		public function timeAgo($mTime) {
			global $systemHandler;
			$mType = $systemHandler->loadHandler("CONFIG")->mTimeStampType;
			
			$mCollection = $systemHandler->loadHandler("LANG")->mLangCollection["time"];
			
			switch($mType) {
				case 2: {
					$mPeriods = array($mCollection["second"], $mCollection["minute"], $mCollection["hour"], $mCollection["day"], $mCollection["week"], $mCollection["month"], $mCollection["year"], $mCollection["decade"]);
				   $mLengths = array("60","60","24","7","4.35","12","10");

				   $mNow = time();

					   $mDifference     = $mNow - $mTime;
					   $tense         = $mCollection["ago"];

				   for($j = 0; $mDifference >= $mLengths[$j] && $j < count($mLengths)-1; $j++) {
					   $mDifference /= $mLengths[$j];
				   }

				   $mDifference = round($mDifference);

				   if($mDifference != 1) {
					   $mPeriods[$j] .= $mCollection["time_addon"];
				   }

				   return "$mDifference $mPeriods[$j] ".$mCollection["ago"]." ";
				}
				
				case 1:
					return date("h:i a", $mTime);
				break;
				
				case 0:
					return date("H:i", $mTime);
				break;
			}
		}
	}
	
	// Initialize the mothership of elitenetwork
	$systemCore = new systemCORE();
	global $systemHandler;
	$l = $systemHandler->loadHandler("LANG");
?>