<?php
	if(!isset($systemCore))
		require_once("../system.engine/system.core.php");
	
	if(!$systemCore->isAdmin())
		header("Location: ../");
		
	$mActivePage = strtolower($mPagename);
?>
	<aside class="left-side sidebar-offcanvas">
		<!-- sidebar: style can be found in sidebar.less -->
		<section class="sidebar">
			<!-- Sidebar user panel -->
			<div class="user-panel">
				<div class="pull-left image">
					<img src="../<?php echo $u->mProfilePicture ?>" class="img-circle" alt="User Image" />
				</div>
				<div class="pull-left info">
					<p>Hello, <?php echo $u->mFirstname ?></p>
					<a href="../"><i class="fa fa-circle text-success"></i> <?php echo $systemHandler->loadHandler("CONFIG")->mSocialName ?></a>
				</div>
			</div>
			<!-- /.search form -->
			<!-- sidebar menu: : style can be found in sidebar.less -->
			<?php
				$mTimelineCount = $systemExecution->runQuery("SELECT COUNT(id) AS timelineCount FROM web_timeline", "")->fetch_object()->timelineCount;
				$mMembersCount = $systemExecution->runQuery("SELECT COUNT(id) AS membersCount FROM web_user", "")->fetch_object()->membersCount;
				$mReportsCount = $systemExecution->runQuery("SELECT COUNT(id) AS reportsCount FROM web_reports", "")->fetch_object()->reportsCount;
			?>
			<ul class="sidebar-menu">
				<li <?php echo $mActivePage == "dashboard" ? "class=\"active\"" : "" ?>>
					<a href="page.dashboard.php">
					<i class="fa fa-dashboard"></i> <span>Dashboard</span>
					</a>
				</li>
				
				<li <?php echo $mActivePage == "timeline" ? "class=\"active\"" : "" ?>>
					<a href="page.timeline.php">
					<i class="fa fa-th"></i> <span>Timeline</span> <small class="badge pull-right bg-blue"><?php echo $mTimelineCount; ?></small>
					</a>
				</li>
				<li <?php echo $mActivePage == "members" ? "class=\"active\"" : "" ?>>
					<a href="page.members.php">
					<i class="fa fa-user"></i> <span>Members</span> <small class="badge pull-right bg-green"><?php echo $mMembersCount; ?></small>
					</a>
				</li>
				<li <?php echo $mActivePage == "reports" ? "class=\"active\"" : "" ?>>
					<a href="page.reports.php">
					<i class="fa fa-bullhorn"></i> <span>Reports</span> <small class="badge pull-right bg-orange"><?php echo $mReportsCount; ?></small>
					</a>
				</li>
				<li class="treeview">
					<a href="javascript:;">
					<i class="fa fa-laptop"></i>
					<span>Settings</span>
					<i class="fa fa-angle-left pull-right"></i>
					</a>
					<ul class="treeview-menu">
						<li><a href="page.general.php"><i class="fa fa-angle-double-right"></i> General settings</a></li>
						<li><a href="page.advertisement.php"><i class="fa fa-angle-double-right"></i> Advertisement</a></li>
						<li><a href="page.policy.php"><i class="fa fa-angle-double-right"></i> Policy</a></li>
					</ul>
				</li>
			</ul>
		</section>
		<!-- /.sidebar -->
	</aside>