<?php
	require_once("../system.engine/system.core.php");
	
	if(!$systemCore->isAdmin())
		header("Location: ../");
		
	$u = &$systemHandler->loadHandler("USER");
	$systemExecution = &$systemHandler->loadHandler("EXECUTION");
		
	$mPagename = "Timeline";
	$mPagedesc = "Have a look of all timeline entries";
	
	if(isset($_GET["id"])) {
		$mId = $_GET["id"];
		if($systemExecution->runQuery("SELECT COUNT(id) AS timelineCount FROM web_timeline WHERE id = '%s'", $mId)->fetch_object()->timelineCount == 0)
			header("Location: page.timeline.php");
	}
?>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8">
		<title><?php echo $systemHandler->loadHandler("CONFIG")->mSocialName ?> :: <?php echo $mPagename.' - '.$mPagedesc ?></title>
		<meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
		<link href="//maxcdn.bootstrapcdn.com/bootstrap/3.3.1/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
		<link href="//cdnjs.cloudflare.com/ajax/libs/font-awesome/4.2.0/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
		<link href="//code.ionicframework.com/ionicons/1.5.2/css/ionicons.min.css" rel="stylesheet" type="text/css" />
		<link href="css/AdminLTE.css" rel="stylesheet" type="text/css" />
		<!--[if lt IE 9]>
		<script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
		<script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
		<![endif]-->
	</head>
	<body class="skin-blue">
		<?php include_once("tpl.header.php"); ?>
		<div class="wrapper row-offcanvas row-offcanvas-left">
			<?php include_once("tpl.sidebar.php"); ?>
			<aside class="right-side">
				<section class="content-header">
					<h1>
						<?php echo $mPagename; ?>
						<small><?php echo $mPagedesc; ?></small>
					</h1>
					<ol class="breadcrumb">
						<li><a href="page.dashboard.php"><i class="fa fa-dashboard"></i> Dashboard</a></li>
						<li><a href="javascript:;"><i class="fa fa-th"></i> Timeline</a></li>
					</ol>
				</section>
				<section class="content">
				
					<div class="row">
                        <div class="col-md-10 col-md-offset-1">
							<h2>Are you searching for something?</h2>
							<form method="POST" action="page.timeline.php">
								<input name="searchTimeline" type="text" placeholder="Submit any keyword you want to find results for.." class="form-control" />
								<input type="submit" class="btn btn-primary" value="Search" style="float: right; margin-top: 10px" />
							</form>
						</div>
                    </div>
						<hr class="col-md-10 col-md-offset-1" />
					<div class="row">
					<?php if(!isset($_GET["id"])) { ?>
						<?php
							if(!isset($_POST["searchTimeline"])) {
								$mQuery = $systemExecution->runQuery("SELECT * FROM web_timeline ORDER BY id DESC LIMIT 50", "");
						?>
							<div class="col-md-10 col-md-offset-1">
									<table class="table">
										<tr>
											<th>ID</th>
											<th>USER</th>
											<th>SHORT TEXT</th>
											<th>LOCATION</th>
											<th>PRIVACY</th>
											<th>HASHTAGS COUNT</th>
											<th>MENTIONS COUNT</th>
											<th>SUBMIT DATE</th>
											<th>IMAGE</th>
											<th>PROFILE ID</th>
											<th>ACTION</th>
										</tr>
										
										<?php while($mRow = $mQuery->fetch_assoc()) {
											$mUserData = $systemExecution->runQuery("SELECT firstname, lastname FROM web_user WHERE id = '%s'", $mRow["post_user_id"])->fetch_assoc();
											$mUsername = $mUserData["firstname"].' '.$mUserData["lastname"];
										?>
											<tr>
												<td><?php echo $mRow["id"]; ?></td>
												<td><?php echo $mUsername ?></td>
												<td><?php echo substr(htmlspecialchars($mRow["post_text"]), 0, 125); ?></td>
												<td><?php echo strlen($mRow["post_location"]) == 0 ? "-/-" : $mRow["post_location"]; ?></td>
												<td><center><i class="glyphicon glyphicon-<?php echo $mRow["post_privacy"] == 1 ? "globe" : ($mRow["post_privacy"] == 2 ? "user" : "lock"); ?>"></i> <?php echo $mRow["post_privacy"] == 1 ? "EVERYONE" : ($mRow["post_privacy"] == 2 ? "FRIENDS" : "ME"); ?></center></td>
												<td><?php echo strlen($mRow["post_hashtags_list"]) > 0 ? count(explode(',', $mRow["post_hashtags_list"])) : "-/-"; ?></td>
												<td><?php echo strlen($mRow["post_mentions_list"]) > 0 ? count(explode(',', $mRow["post_mentions_list"])) : "-/-"; ?></td>
												<td><?php echo $systemCore->timeAgo($mRow["post_submit_date"]); ?></td>
												<td><center><i class="glyphicon glyphicon-<?php echo $mRow["post_image_id"] == -1 ? "remove" : "ok"; ?>"></i></center></td>
												<td><?php echo $mRow["post_entry_location"] ?></td>
												<td><a href="page.timeline.php?id=<?php echo $mRow["id"]; ?>" class="btn btn-primary btn-xs btn-block"><i class="glyphicon glyphicon-search"></i></a></td>
											</tr>
										<?php } ?>
									</table>
								</div>
						<?php
							} else { 
								$mSearch = $_POST["searchTimeline"];
								$mQuery = $systemHandler->loadHandler("MYSQLI")->mConnection->query("SELECT * FROM web_timeline WHERE post_text LIKE '%".$systemHandler->loadHandler("MYSQLI")->mConnection->real_escape_string($mSearch)."%' OR post_location LIKE '%".$systemHandler->loadHandler("MYSQLI")->mConnection->real_escape_string($mSearch)."%' OR post_hashtags_list LIKE '%".$systemHandler->loadHandler("MYSQLI")->mConnection->real_escape_string($mSearch)."%' LIMIT 50");
								?>
								<div class="col-md-10 col-md-offset-1">
									<table class="table">
										<tr>
											<th>ID</th>
											<th>USER</th>
											<th>SHORT TEXT</th>
											<th>LOCATION</th>
											<th>PRIVACY</th>
											<th>HASHTAGS COUNT</th>
											<th>MENTIONS COUNT</th>
											<th>SUBMIT DATE</th>
											<th>IMAGE</th>
											<th>PROFILE ID</th>
											<th>ACTION</th>
										</tr>
										
										<?php while($mRow = $mQuery->fetch_assoc()) {
											$mUserData = $systemExecution->runQuery("SELECT firstname, lastname FROM web_user WHERE id = '%s'", $mRow["post_user_id"])->fetch_assoc();
											$mUsername = $mUserData["firstname"].' '.$mUserData["lastname"];
										?>
											<tr>
												<td><?php echo $mRow["id"]; ?></td>
												<td><?php echo $mUsername ?></td>
												<td><?php echo substr(htmlspecialchars($mRow["post_text"]), 0, 125); ?></td>
												<td><?php echo strlen($mRow["post_location"]) == 0 ? "-/-" : $mRow["post_location"]; ?></td>
												<td><center><i class="glyphicon glyphicon-<?php echo $mRow["post_privacy"] == 1 ? "globe" : ($mRow["post_privacy"] == 2 ? "user" : "lock"); ?>"></i> <?php echo $mRow["post_privacy"] == 1 ? "EVERYONE" : ($mRow["post_privacy"] == 2 ? "FRIENDS" : "ME"); ?></center></td>
												<td><?php echo strlen($mRow["post_hashtags_list"]) > 0 ? count(explode(',', $mRow["post_hashtags_list"])) : "-/-"; ?></td>
												<td><?php echo strlen($mRow["post_mentions_list"]) > 0 ? count(explode(',', $mRow["post_mentions_list"])) : "-/-"; ?></td>
												<td><?php echo $systemCore->timeAgo($mRow["post_submit_date"]); ?></td>
												<td><center><i class="glyphicon glyphicon-<?php echo $mRow["post_image_id"] == -1 ? "remove" : "ok"; ?>"></i></center></td>
												<td><?php echo $mRow["post_entry_location"] ?></td>
												<td><a href="page.timeline.php?id=<?php echo $mRow["id"]; ?>" class="btn btn-primary btn-xs btn-block"><i class="glyphicon glyphicon-search"></i></a></td>
											</tr>
										<?php } ?>
									</table>
								</div>
						<?php } ?>
					<?php
						} else {
					?>
						<div class="row">
							<div class="col-md-10 col-md-offset-1">
								<?php
									$mRow = $systemExecution->runQuery("SELECT * FROM web_timeline WHERE id = '%s'", $mId)->fetch_assoc();
									$mUserData = $systemExecution->runQuery("SELECT firstname, lastname FROM web_user WHERE id = '%s'", $mRow["post_user_id"])->fetch_assoc();
									$mUsername = $mUserData["firstname"].' '.$mUserData["lastname"];
								?>
								<center>
									<?php
										if($mRow["post_image_id"] !== "-1") {
											$mImageHash = $systemExecution->runQuery("SELECT image_hash FROM web_images WHERE id = '%s'", $mRow["post_image_id"])->fetch_object()->image_hash;
									?>
										<img class="thumbnail" src="../system.uploads/<?php echo $mImageHash; ?>" style="width: 128px; height: 128px" />
									<?php } ?>
									
									<table class="table">
										<tr>
											<th>ID</th>
											<th>USER</th>
											<th>SHORT TEXT</th>
											<th>LOCATION</th>
											<th>PRIVACY</th>
											<th>HASHTAGS</th>
											<th>MENTIONS</th>
											<th>SUBMIT DATE</th>
											<th>IMAGE</th>
											<th>PROFILE ID</th>
											<th>DELETE</th>
										</tr>
										
										<tr>
											<td><?php echo $mRow["id"]; ?></td>
											<td><?php echo $mUsername ?></td>
											<td><?php echo substr(htmlspecialchars($mRow["post_text"]), 0, 125); ?></td>
											<td><?php echo strlen($mRow["post_location"]) == 0 ? "-/-" : $mRow["post_location"]; ?></td>
											<td><center><i class="glyphicon glyphicon-<?php echo $mRow["post_privacy"] == 1 ? "globe" : ($mRow["post_privacy"] == 2 ? "user" : "lock"); ?>"></i> <?php echo $mRow["post_privacy"] == 1 ? "EVERYONE" : ($mRow["post_privacy"] == 2 ? "FRIENDS" : "ME"); ?></center></td>
											
											<td>
												<?php
													$mHashtags = explode(',', $mRow["post_hashtags_list"]);
													foreach($mHashtags as $mHashtag)
														echo '#'.$mHashtag."<br />";
												?>
											</td>
											
											<td>
												<?php
													$mMentions = explode(',', $mRow["post_mentions_list"]);
													if(strlen($mRow["post_mentions_list"]) > 0)
														foreach($mMentions as $mMention) {
															$mUserData = new systemUSER($mMention);
															echo $mUserData->mFullname."<br />";
														}
													else echo "-/-";
												?>
											</td>
											
											<td><?php echo $systemCore->timeAgo($mRow["post_submit_date"]); ?></td>
											<td><center><i class="glyphicon glyphicon-<?php echo $mRow["post_image_id"] == -1 ? "remove" : "ok"; ?>"></i></center></td>
											<td><?php echo $mRow["post_entry_location"] ?></td>
											<td><a href="javascript:;" data-parameter="<?php echo $mRow["id"]; ?>" data-event="remove-timeline" class="btn btn-danger btn-xs btn-block"><i class="glyphicon glyphicon-remove"></i></a></td>
										</tr>
									</table>
								</center>
							</div>
						</div>
					<?php } ?>
					</div>
				</section>
			</aside>
		</div>
		
		<script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.2/jquery.min.js"></script>
		<script src="//maxcdn.bootstrapcdn.com/bootstrap/3.3.1/js/bootstrap.min.js" type="text/javascript"></script>
		<script src="js/AdminLTE/app.js" type="text/javascript"></script>
		<script type="text/javascript">
			$("body").on("click", "[data-event=\"remove-timeline\"]", function () {
				var mId = $(this).attr("data-parameter");
				if (window.confirm("Are you sure?")) {
					$.ajax({
						url: "../system.ajax/ajax.handle.delete.timeline.php",
						type: "POST",
						dataType: "JSON",
						data: { timelineId: mId },
						success: function(ajaxResponse) {
							top.location = "page.timeline.php";
						}
					});
				}
			});
		</script>
	</body>
</html>