<?php
	require_once("../system.engine/system.core.php");
	
	if(!$systemCore->isAdmin())
		header("Location: ../");
		
	$u = &$systemHandler->loadHandler("USER");
	$systemExecution = &$systemHandler->loadHandler("EXECUTION");
		
	$mPagename = "Reports";
	$mPagedesc = "Manage reported stuff of your community";
?>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8">
		<title><?php echo $systemHandler->loadHandler("CONFIG")->mSocialName ?> :: <?php echo $mPagename.' - '.$mPagedesc ?></title>
		<meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
		<link href="//maxcdn.bootstrapcdn.com/bootstrap/3.3.1/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
		<link href="//cdnjs.cloudflare.com/ajax/libs/font-awesome/4.2.0/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
		<link href="//code.ionicframework.com/ionicons/1.5.2/css/ionicons.min.css" rel="stylesheet" type="text/css" />
		<link href="css/AdminLTE.css" rel="stylesheet" type="text/css" />
		<!--[if lt IE 9]>
		<script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
		<script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
		<![endif]-->
		<input type="hidden" value="<?php echo isset($mId) ? $mId : -1; ?>" id="userId" />
	</head>
	<body class="skin-blue">
		<?php include_once("tpl.header.php"); ?>
		<div class="wrapper row-offcanvas row-offcanvas-left">
			<?php include_once("tpl.sidebar.php"); ?>
			<aside class="right-side">
				<section class="content-header">
					<h1>
						<?php echo $mPagename; ?>
						<small><?php echo $mPagedesc; ?></small>
					</h1>
					<ol class="breadcrumb">
						<li><a href="page.dashboard.php"><i class="fa fa-dashboard"></i> Dashboard</a></li>
						<li><a href="javascript:;"><i class="fa fa-bullhorn"></i> Reports</a></li>
					</ol>
				</section>
				<section class="content">
					<div class="row">
						<div class="col-md-10 col-md-offset-1">
							<table class="table">
								<tr>
									<th>ID</th>
									<th>REPORT TYPE</th>
									<th>ELEMENT ID</th>
									<th>REPORTER ID</th>
									<th>REPORT TIME</th>
								</tr>
								
								<?php
									$mQuery = $systemExecution->runQuery("SELECT * FROM web_reports ORDER BY id DESC LIMIT 50", "");
									while($mRow = $mQuery->fetch_assoc()) {
										?>
											<tr>
												<td>
													<?php echo $mRow["id"]; ?>
												</td>
												
												<td>
													<?php echo $mRow["report_type"]; ?>
												</td>
												
												<td>
													<?php
														$mContainerId = 0;
														if($mRow["report_type"] == "container")
															$mContainerId = $mRow["report_id"];
															
														if($mContainerId !== 0) {
													?>
														<a class="btn btn-primary btn-block" href="page.timeline.php?id=<?php echo $mContainerId; ?>">
															<i class="glyphicon glyphicon-pencil"></i>
														</a>
													<?php } ?>
												</td>
												
												<td>
													<a class="btn btn-primary btn-block" href="page.members.php?id=<?php echo $mRow["report_user"]; ?>">
														<i class="glyphicon glyphicon-pencil"></i>
													</a>
												</td>
												
												<td>
													<?php echo $systemCore->timeAgo($mRow["report_time"]); ?>
												</td>
											</tr>
										<?php
									}
								?>
							</table>
						</div>
					</div>
				</section>
			</aside>
		</div>
		
		<script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.2/jquery.min.js"></script>
		<script src="//maxcdn.bootstrapcdn.com/bootstrap/3.3.1/js/bootstrap.min.js" type="text/javascript"></script>
		<script src="js/AdminLTE/app.js" type="text/javascript"></script>
		<script type="text/javascript">
			
		</script>
	</body>
</html>