<?php
	require_once("../system.engine/system.core.php");
	
	if(!$systemCore->isAdmin())
		header("Location: ../");
		
	$u = &$systemHandler->loadHandler("USER");
	$systemExecution = &$systemHandler->loadHandler("EXECUTION");
		
	$mPagename = "Advertisement";
	$mPagedesc = "Set advertisement or other HTML content to specified areas";
	
	$systemConfig = &$systemHandler->loadHandler("CONFIG");
	$mPrivileged = false;
	
	if(isset($_POST["termsofuse"]) && $mPrivileged) {
		$mTermsOfUse = $_POST["termsofuse"];
		$mDisclaimer = $_POST["disclaimer"];
		$mPrivacyPolicy = $_POST["privacypolicy"];
		$mAbout = $_POST["about"];
		
		$systemExecution->runQuery("UPDATE web_policy SET terms_of_use = '%s', disclaimer = '%s', privacy_policy = '%s', about = '%s'", array($mTermsOfUse, $mDisclaimer, $mPrivacyPolicy, $mAbout));
		header("Location: page.policy.php");
	}
?>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8">
		<title><?php echo $systemHandler->loadHandler("CONFIG")->mSocialName ?> :: <?php echo $mPagename.' - '.$mPagedesc ?></title>
		<meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
		<link href="//maxcdn.bootstrapcdn.com/bootstrap/3.3.1/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
		<link href="//cdnjs.cloudflare.com/ajax/libs/font-awesome/4.2.0/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
		<link href="//code.ionicframework.com/ionicons/1.5.2/css/ionicons.min.css" rel="stylesheet" type="text/css" />
		<link href="css/AdminLTE.css" rel="stylesheet" type="text/css" />
		<!--[if lt IE 9]>
		<script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
		<script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
		<![endif]-->
		<input type="hidden" value="<?php echo isset($mId) ? $mId : -1; ?>" id="userId" />
	</head>
	<body class="skin-blue">
		<?php include_once("tpl.header.php"); ?>
		<div class="wrapper row-offcanvas row-offcanvas-left">
			<?php include_once("tpl.sidebar.php"); ?>
			<aside class="right-side">
				<section class="content-header">
					<h1>
						<?php echo $mPagename; ?>
						<small><?php echo $mPagedesc; ?></small>
					</h1>
					<ol class="breadcrumb">
						<li><a href="page.dashboard.php"><i class="fa fa-dashboard"></i> Dashboard</a></li>
						<li><a href="javascript:;"><i class="fa fa-laptop"></i> Settings</a></li>
						<li><a href="javascript:;"><i class="fa fa-cog"></i> Advertisement</a></li>
					</ol>
				</section>
				<section class="content">
					<div class="row">
						<div class="col-md-6 col-md-offset-3">
							<form method="POST" action="page.policy.php">
								<table class="table">
									<tr>
										<th>
											Terms of Use
										</th>
										
										<td>
											<textarea class="form-control" name="termsofuse"><?php echo $systemConfig->mPolicy[0] ?></textarea>
										</td>
									</tr>
									
									<tr>
										<th>
											Disclaimer
										</th>
										
										<td>
											<textarea class="form-control" name="disclaimer"><?php echo $systemConfig->mPolicy[1] ?></textarea>
										</td>
									</tr>
									
									<tr>
										<th>
											Privacy policy
										</th>
										
										<td>
											<textarea class="form-control" name="privacypolicy"><?php echo $systemConfig->mPolicy[2] ?></textarea>
										</td>
									</tr>
									
									<tr>
										<th>
											About
										</th>
										
										<td>
											<textarea class="form-control" name="about"><?php echo $systemConfig->mPolicy[3] ?></textarea>
										</td>
									</tr>
									
									<tr>
										<th></th>
										
										<td>
											<input type="submit" class="btn btn-primary btn-block" value="Save changes" />
										</td>
									</tr>
								</table>
							</form>
						</div>
					</div>
				</section>
			</aside>
		</div>
		
		<script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.2/jquery.min.js"></script>
		<script src="//maxcdn.bootstrapcdn.com/bootstrap/3.3.1/js/bootstrap.min.js" type="text/javascript"></script>
		<script src="js/AdminLTE/app.js" type="text/javascript"></script>
		<script type="text/javascript">
			
		</script>
	</body>
</html>