<?php
	require_once("../system.engine/system.core.php");
	
	if(!$systemCore->isAdmin())
		header("Location: ../");
		
	$u = &$systemHandler->loadHandler("USER");
	$systemExecution = &$systemHandler->loadHandler("EXECUTION");
		
	$mPagename = "Members";
	$mPagedesc = "Manage your community members";
	
	if(isset($_GET["id"])) {
		$mId = $_GET["id"];
		if($systemExecution->runQuery("SELECT COUNT(id) AS userCount FROM web_user WHERE id = '%s'", $mId)->fetch_object()->userCount == 0)
			header("Location: page.members.php");
	}
?>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8">
		<title><?php echo $systemHandler->loadHandler("CONFIG")->mSocialName ?> :: <?php echo $mPagename.' - '.$mPagedesc ?></title>
		<meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
		<link href="//maxcdn.bootstrapcdn.com/bootstrap/3.3.1/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
		<link href="//cdnjs.cloudflare.com/ajax/libs/font-awesome/4.2.0/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
		<link href="//code.ionicframework.com/ionicons/1.5.2/css/ionicons.min.css" rel="stylesheet" type="text/css" />
		<link href="css/AdminLTE.css" rel="stylesheet" type="text/css" />
		<!--[if lt IE 9]>
		<script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
		<script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
		<![endif]-->
		<input type="hidden" value="<?php echo isset($mId) ? $mId : -1; ?>" id="userId" />
	</head>
	<body class="skin-blue">
		<?php include_once("tpl.header.php"); ?>
		<div class="wrapper row-offcanvas row-offcanvas-left">
			<?php include_once("tpl.sidebar.php"); ?>
			<aside class="right-side">
				<section class="content-header">
					<h1>
						<?php echo $mPagename; ?>
						<small><?php echo $mPagedesc; ?></small>
					</h1>
					<ol class="breadcrumb">
						<li><a href="page.dashboard.php"><i class="fa fa-dashboard"></i> Dashboard</a></li>
						<li><a href="javascript:;"><i class="fa fa-user"></i> Members</a></li>
					</ol>
				</section>
				<section class="content">
				
					<div class="row">
                        <div class="col-md-10 col-md-offset-1">
							<h2>Are you searching for someone?</h2>
							<form method="POST" action="page.members.php">
								<input name="searchUser" type="text" placeholder="Submit any keyword you want to find results for.." class="form-control" />
								<input type="submit" class="btn btn-primary" value="Search" style="float: right; margin-top: 10px" />
							</form>
						</div>
                    </div>
				
				<div class="row">
					<?php if(!isset($_GET["id"])) { ?>
						<?php
							if(!isset($_POST["searchUser"])) {
								$mQuery = $systemExecution->runQuery("SELECT * FROM web_user ORDER BY id DESC LIMIT 50", "");
						?>
							<div class="col-md-10 col-md-offset-1">
									<table class="table">
										<tr>
											<th>ID</th>
											<th>MAIL</th>
											<th>FIRSTNAME</th>
											<th>LASTNAME</th>
											<th>SIGNUP</th>
											<th>SIGNIN</th>
											<th>ACTION</th>
										</tr>
										
										<?php while($mRow = $mQuery->fetch_assoc()) {?>
											<tr>
												<td><?php echo $mRow["id"]; ?></td>
												<td><?php echo $mRow["mail"]; ?></td>
												<td><?php echo $mRow["firstname"]; ?></td>
												<td><?php echo $mRow["lastname"]; ?></td>
												<td><?php echo $systemCore->timeAgo($mRow["signup_time"]); ?></td>
												<td><?php echo $systemCore->timeAgo($mRow["signin_time"]); ?></td>
												<td><a href="page.members.php?id=<?php echo $mRow["id"]; ?>" class="btn btn-primary btn-xs btn-block"><i class="glyphicon glyphicon-search"></i></a></td>
											</tr>
										<?php } ?>
									</table>
								</div>
						<?php
							} else { 
								$mSearch = $_POST["searchUser"];
								$mQuery = $systemHandler->loadHandler("MYSQLI")->mConnection->query("SELECT * FROM web_user WHERE mail LIKE '%".$systemHandler->loadHandler("MYSQLI")->mConnection->real_escape_string($mSearch)."%' OR firstname LIKE '%".$systemHandler->loadHandler("MYSQLI")->mConnection->real_escape_string($mSearch)."%' OR lastname LIKE '%".$systemHandler->loadHandler("MYSQLI")->mConnection->real_escape_string($mSearch)."%' LIMIT 50");
								?>
								<div class="col-md-10 col-md-offset-1">
									<table class="table">
										<tr>
											<th>ID</th>
											<th>MAIL</th>
											<th>FIRSTNAME</th>
											<th>LASTNAME</th>
											<th>SIGNUP</th>
											<th>SIGNIN</th>
											<th>ACTION</th>
										</tr>
										
										<?php while($mRow = $mQuery->fetch_assoc()) {?>
											<tr>
												<td><?php echo $mRow["id"]; ?></td>
												<td><?php echo $mRow["mail"]; ?></td>
												<td><?php echo $mRow["firstname"]; ?></td>
												<td><?php echo $mRow["lastname"]; ?></td>
												<td><?php echo $systemCore->timeAgo($mRow["signup_time"]); ?></td>
												<td><?php echo $systemCore->timeAgo($mRow["signin_time"]); ?></td>
												<td><a href="page.members.php?id=<?php echo $mRow["id"]; ?>" class="btn btn-primary btn-xs btn-block"><i class="glyphicon glyphicon-search"></i></a></td>
											</tr>
										<?php } ?>
									</table>
								</div>
						<?php } ?>
					<?php
						} else {
					?>
						<div class="row">
							<div class="col-md-10 col-md-offset-1">
								<?php
									$mRow = $systemExecution->runQuery("SELECT * FROM web_user WHERE id = '%s'", $mId)->fetch_assoc();
								?>
								<center>
									<?php $mUser = new systemUSER($mRow["id"]); ?>
									<img class="thumbnail" src="../<?php echo $mUser->mProfilePicture; ?>" style="width: 128px; height: 128px" />
									<a class="btn btn-primary" id="resetImages">Reset profile images</a>
										
										<br /><br />
									
									<table class="table">
										<tr>
											<th>ID</th>
											<th>MAIL</th>
											<th>FIRSTNAME</th>
											<th>LASTNAME</th>
											<th>SIGNUP</th>
											<th>SIGNIN</th>
											<th>ACTION</th>
										</tr>
										
											<tr>
												<td><?php echo $mRow["id"]; ?></td>
												<td data-event="change-user" data-parameter="mail"><?php echo $mRow["mail"]; ?></td>
												<td data-event="change-user" data-parameter="firstname"><?php echo $mRow["firstname"]; ?></td>
												<td data-event="change-user" data-parameter="lastname"><?php echo $mRow["lastname"]; ?></td>
												<td><?php echo $systemCore->timeAgo($mRow["signup_time"]); ?></td>
												<td><?php echo $systemCore->timeAgo($mRow["signin_time"]); ?></td>
												<td><a href="../page.profile.php?profile-id=<?php echo $mRow["id"]; ?>" class="btn btn-primary btn-xs btn-block"><i class="glyphicon glyphicon-search"></i></a></td>
											</tr>
									</table>
								</center>
							</div>
						</div>
					<?php } ?>
					</div>
					
				</section>
			</aside>
		</div>
		
		<script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.2/jquery.min.js"></script>
		<script src="//maxcdn.bootstrapcdn.com/bootstrap/3.3.1/js/bootstrap.min.js" type="text/javascript"></script>
		<script src="js/AdminLTE/app.js" type="text/javascript"></script>
		<script type="text/javascript">
			$(document).ready(function () {
				$("body").on("click", "#resetImages", function () {
					$.ajax({
						url: "../system.ajax/ajax.handle.reset.profile.images.php",
						type: "POST",
						dataType: "JSON",
						data: { resetUser: $("#userId").val() },
						success: function(ajaxResponse) {
							alert("Images have been reseted!");
						}
					});
				});
			
				$("body").on("click", "[data-event=\"change-user\"]", function (mEvent) {
					mEvent.stopPropagation();
					var mCurrentVal = $(this).text();
					var mLocation = $(this).attr("data-parameter");
					$(this).html("<input type=\"text\" class=\"form-control\" data-location=\"" + mLocation + "\" data-event=\"save-user\" value=\"" + mCurrentVal + "\" />");
				});
				
				$("body").on("click", "[data-event=\"save-user\"]", function (mEvent) {
					mEvent.stopPropagation();
				});
				
				$("body").on("keyup", "[data-event=\"save-user\"]", function (mKey) {
					var mNewVal = $.trim($(this).val());
					var mLocation = $(this).attr("data-location");
					
					if(mKey.keyCode == 13) {
						$.ajax({
							url: "../system.ajax/ajax.handle.profile.settings.php",
							type: "POST",
							dataType: "JSON",
							data: { settingLocation: mLocation, settingValue: mNewVal, settingUser: $("#userId").val() },
							success: function(ajaxResponse) {
								$("[data-parameter=\"" + mLocation + "\"]").text(mNewVal);
							}
						});
					}
				});
			});
		</script>
	</body>
</html>