<?php
	require_once("../system.engine/system.core.php");
	
	if(!$systemCore->isAdmin())
		header("Location: ../");
		
	$u = &$systemHandler->loadHandler("USER");
	$systemExecution = &$systemHandler->loadHandler("EXECUTION");
	$systemConfig = &$systemHandler->loadHandler("CONFIG");
	
	$mPagename = "General settings";
	$mPagedesc = "Manage the main settings of your social network";
	$mPrivileged = false;
	
	if(isset($_POST["socialName"]) && $mPrivileged == true) {
		$mSocialName = $_POST["socialName"];
		$mCaptchaType = $_POST["captchaType"];
		$mTimestampType = $_POST["timestampType"];
		// $mChatType = $_POST["chatType"];
		$mCommentsDisplay = $_POST["commentsDisplay"];
		$mEmailRegistration = $_POST["emailRegistration"];
		
		$systemExecution->runQuery("UPDATE web_settings SET social_name = '%s', captcha = '%s', timestamp = '%s', comment_display = '%s', email_registration = '%s'", array($mSocialName, $mCaptchaType, $mTimestampType, $mCommentsDisplay, $mEmailRegistration)); // chat_type = '%s', 
		header("Location: page.general.php");
	} else
		echo "You can't modify general page settings or user settings in this demo.";
?>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8">
		<title><?php echo $systemHandler->loadHandler("CONFIG")->mSocialName ?> :: <?php echo $mPagename.' - '.$mPagedesc ?></title>
		<meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
		<link href="//maxcdn.bootstrapcdn.com/bootstrap/3.3.1/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
		<link href="//cdnjs.cloudflare.com/ajax/libs/font-awesome/4.2.0/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
		<link href="//code.ionicframework.com/ionicons/1.5.2/css/ionicons.min.css" rel="stylesheet" type="text/css" />
		<link href="css/AdminLTE.css" rel="stylesheet" type="text/css" />
		<!--[if lt IE 9]>
		<script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
		<script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
		<![endif]-->
		<input type="hidden" value="<?php echo isset($mId) ? $mId : -1; ?>" id="userId" />
	</head>
	<body class="skin-blue">
		<?php include_once("tpl.header.php"); ?>
		<div class="wrapper row-offcanvas row-offcanvas-left">
			<?php include_once("tpl.sidebar.php"); ?>
			<aside class="right-side">
				<section class="content-header">
					<h1>
						<?php echo $mPagename; ?>
						<small><?php echo $mPagedesc; ?></small>
					</h1>
					<ol class="breadcrumb">
						<li><a href="page.dashboard.php"><i class="fa fa-dashboard"></i> Dashboard</a></li>
						<li><a href="javascript:;"><i class="fa fa-laptop"></i> Settings</a></li>
						<li><a href="javascript:;"><i class="fa fa-cog"></i> General settings</a></li>
					</ol>
				</section>
				<section class="content">
					<div class="row">
						<div class="col-md-6 col-md-offset-3">
							<form method="POST" action="page.general.php">
								<table class="table">
									<tr>
										<th>Name of your social network</th>
										<td>
											<input type="text" class="form-control" value="<?php echo $systemConfig->mSocialName ?>" name="socialName" />
										</td>
									</tr>
									
									<tr>
										<th>Captcha</th>
										<td>
											<select class="form-control" name="captchaType">
												<option value="1" <?php echo $systemConfig->mCaptchaType == 1 ? "selected" : ""; ?>>Activated</option>
												<option value="0" <?php echo $systemConfig->mCaptchaType == 0 ? "selected" : ""; ?>>Deactivated</option>
											</select>
										</td>
									</tr>
									
									<tr>
										<th>Timestamp</th>
										<td>
											<select class="form-control" name="timestampType">
												<option value="2" <?php echo $systemConfig->mTimeStampType == 2 ? "selected" : ""; ?>>use 'ago 10 seconds' - Simple format</option>
												<option value="1" <?php echo $systemConfig->mTimeStampType == 1 ? "selected" : ""; ?>>PM/AM - American</option>
												<option value="0" <?php echo $systemConfig->mTimeStampType == 0 ? "selected" : ""; ?>>00:00 - European</option>
											</select>
										</td>
									</tr>
									
									<!-- <tr>
										<th>Chat type</th>
										<td>
											<select class="form-control" name="chatType">
												<option value="1" <?php echo $systemConfig->mChatType == 1 ? "selected" : ""; ?>>Standard - AJAX (Asynchronous javascript and xml)</option>
												<option value="0" <?php echo $systemConfig->mChatType == 0 ? "selected" : ""; ?>>Realtime - NODE.JS Server (! PLEASE START THE SERVER !)</option>
											</select>
										</td>
									</tr> -->
									
									<tr>
										<th>Number of comments displayed</th>
										<td>
											<select class="form-control" name="commentsDisplay">
												<option value="6" <?php echo $systemConfig->mCommentsDisplay == 6 ? "selected" : ""; ?>>Display 6 comments per post</option>
												<option value="3" <?php echo $systemConfig->mCommentsDisplay == 3 ? "selected" : ""; ?>>Display 3 comments per post</option>
												<option value="2" <?php echo $systemConfig->mCommentsDisplay == 2 ? "selected" : ""; ?>>Display 2 comments per post</option>
												<option value="1" <?php echo $systemConfig->mCommentsDisplay == 1 ? "selected" : ""; ?>>Display 1 comments per post</option>
											</select>
										</td>
									</tr>
									
									<tr>
										<th>Email at registration</th>
										<td>
											<select class="form-control" name="emailRegistration">
												<option value="1" <?php echo $systemConfig->mEmailRegistration == 1 ? "selected" : ""; ?>>Activated</option>
												<option value="0" <?php echo $systemConfig->mEmailRegistration == 0 ? "selected" : ""; ?>>Deactivated</option>
											</select>
										</td>
									</tr>
									
									<tr>
										<td></td>
										<td>
											<input type="submit" class="btn btn-block btn-success" value="Save the settings" />
										</td>
									</tr>
									
								</table>
							</form>
						</div>
					</div>
				</section>
			</aside>
		</div>
		
		<script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.2/jquery.min.js"></script>
		<script src="//maxcdn.bootstrapcdn.com/bootstrap/3.3.1/js/bootstrap.min.js" type="text/javascript"></script>
		<script src="js/AdminLTE/app.js" type="text/javascript"></script>
		<script type="text/javascript">
			
		</script>
	</body>
</html>