<?php
	require_once("../system.engine/system.core.php");
	
	if(!$systemCore->isAdmin())
		header("Location: ../");
		
	$u = &$systemHandler->loadHandler("USER");
	$systemExecution = &$systemHandler->loadHandler("EXECUTION");
		
	$mPagename = "Dashboard";
	$mPagedesc = "Have an overview about the social network";
	?>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8">
		<title><?php echo $systemHandler->loadHandler("CONFIG")->mSocialName ?> :: <?php echo $mPagename.' - '.$mPagedesc ?></title>
		<meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
		<link href="//maxcdn.bootstrapcdn.com/bootstrap/3.3.1/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
		<link href="//cdnjs.cloudflare.com/ajax/libs/font-awesome/4.2.0/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
		<link href="//code.ionicframework.com/ionicons/1.5.2/css/ionicons.min.css" rel="stylesheet" type="text/css" />
		<link href="css/AdminLTE.css" rel="stylesheet" type="text/css" />
		<!--[if lt IE 9]>
		<script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
		<script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
		<![endif]-->
	</head>
	<body class="skin-blue">
		<?php include_once("tpl.header.php"); ?>
		<div class="wrapper row-offcanvas row-offcanvas-left">
			<?php include_once("tpl.sidebar.php"); ?>
			<aside class="right-side">
				<section class="content-header">
					<h1>
						<?php echo $mPagename; ?>
						<small><?php echo $mPagedesc; ?></small>
					</h1>
					<ol class="breadcrumb">
						<li><a href="javascript:;"><i class="fa fa-dashboard"></i> Dashboard</a></li>
					</ol>
				</section>
				<section class="content">
				
					<div class="row">
                        <div class="col-lg-4 col-xs-6">
                            <div class="small-box bg-aqua">
                                <div class="inner">
                                    <h3>
                                        <?php echo $mTimelineCount ?>
                                    </h3>
                                    <p>
										Timeline entries
                                    </p>
                                </div>
                                <div class="icon">
                                    <i class="ion ion-clipboard"></i>
                                </div>
                                <a href="page.timeline.php" class="small-box-footer">
                                    Go to timeline entries <i class="fa fa-arrow-circle-right"></i>
                                </a>
                            </div>
                        </div>
						
                        <div class="col-lg-4 col-xs-6">
                            <!-- small box -->
                            <div class="small-box bg-green">
                                <div class="inner">
                                    <h3>
                                        <?php echo $mMembersCount ?>
                                    </h3>
                                    <p>
                                        Members
                                    </p>
                                </div>
                                <div class="icon">
                                    <i class="ion ion-person-add"></i>
                                </div>
                                <a href="page.members.php" class="small-box-footer">
                                    Go to members <i class="fa fa-arrow-circle-right"></i>
                                </a>
                            </div>
                        </div><!-- ./col -->
                        <div class="col-lg-4 col-xs-6">
                            <!-- small box -->
                            <div class="small-box bg-maroon">
                                <div class="inner">
                                    <h3>
                                        <?php echo $mReportsCount ?>
                                    </h3>
                                    <p>
                                        Reports
                                    </p>
                                </div>
                                <div class="icon">
                                    <i class="ion ion-flag"></i>
                                </div>
                                <a href="page.reports.php" class="small-box-footer">
									Go to reports <i class="fa fa-arrow-circle-right"></i>
                                </a>
                            </div>
                        </div>
                    </div>
					
					<div class="row">
                        <div class="col-lg-4 col-xs-6">
							<div class="box box-solid box-primary">
                                <div class="box-header">
                                    <h3 class="box-title">Latest 15 timeline entries</h3>
                                </div>
                                <div class="box-body">
									<table class="table">
										<tr>
											<th>#</th>
											<th>POSTER</th>
											<th>LIKES</th>
											<th>COMMENTS</th>
											<th>IMAGE</th>
											<th>ACTION</th>
										</tr>
										
										<?php
											$mTimelineQuery = $systemExecution->runQuery("SELECT id, post_user_id, post_image_id FROM web_timeline ORDER BY id DESC LIMIT 15", "");
											while($mRow = $mTimelineQuery->fetch_assoc()) {
												$mUserData = $systemExecution->runQuery("SELECT firstname, lastname FROM web_user WHERE id = '%s'", $mRow["post_user_id"])->fetch_assoc();
												$mUsername = $mUserData["firstname"].' '.$mUserData["lastname"];
												?>
													<tr>
														<td><?php echo $mRow["id"]; ?></td>
														<td><?php echo $mUsername; ?></td>
														<td><?php echo $systemExecution->runQuery("SELECT COUNT(id) AS likeCount FROM web_likes WHERE container_id = '%s'", $mRow["id"])->fetch_object()->likeCount; ?></td>
														<td><?php echo $systemExecution->runQuery("SELECT COUNT(id) AS commentCount FROM web_comments WHERE container_id = '%s'", $mRow["id"])->fetch_object()->commentCount; ?></td>
														<td><i class="glyphicon <?php echo $mRow["post_image_id"] == -1 ? "glyphicon-remove" : "glyphicon-ok"; ?>"></i></td>
														<td><a href="page.timeline.php?id=<?php echo $mRow["id"]; ?>" class="btn btn-primary btn-xs btn-block"><i class="glyphicon glyphicon-search"></i></a></td>
													</tr>
												<?php
											}
										?>
									</table>
                                </div>
                            </div>
						</div>
						
                        <div class="col-lg-4 col-xs-6">
							<div class="box box-solid box-success">
                                <div class="box-header">
                                    <h3 class="box-title">Latest 15 registrations</h3>
                                </div>
                                <div class="box-body">
									<table class="table">
										<tr>
											<th>#</th>
											<th>FIRSTNAME</th>
											<th>LASTNAME</th>
											<th>EMAIL</th>
											<th>ACTION</th>
										</tr>
										
										<?php
											$mMembersQuery = $systemExecution->runQuery("SELECT * FROM web_user ORDER BY id DESC LIMIT 15", "");
											while($mRow = $mMembersQuery->fetch_assoc()) {
												?>
													<tr>
														<td><?php echo $mRow["id"]; ?></td>
														<td><?php echo $mRow["firstname"]; ?></td>
														<td><?php echo $mRow["lastname"]; ?></td>
														<td><?php echo strlen($mRow["mail"]) > 23 ? substr($mRow["mail"], 0, 23).'..' : $mRow["mail"]; ?></td>
														<td><a href="page.members.php?id=<?php echo $mRow["id"]; ?>" class="btn btn-primary btn-xs btn-block"><i class="glyphicon glyphicon-search"></i></a></td>
													</tr>
												<?php
											}
										?>
									</table>
								</div>
							</div>
						</div>
						
                        <div class="col-lg-4 col-xs-6">
							<div class="box box-solid box-danger">
                                <div class="box-header" style="background-color: #85144b">
                                    <h3 class="box-title">Latest 15 reports</h3>
                                </div>
                                <div class="box-body">
									<table class="table">
										<tr>
											<th>#</th>
											<th>USER</th>
											<th>TIME</th>
											<th>TYPE</th>
											<th>ACTION</th>
										</tr>
										
										<?php
											$mReportsQuery = $systemExecution->runQuery("SELECT * FROM web_reports ORDER BY id DESC LIMIT 15", "");
											while($mRow = $mReportsQuery->fetch_assoc()) {
												$mUserData = $systemExecution->runQuery("SELECT firstname, lastname FROM web_user WHERE id = '%s'", $mRow["report_user"])->fetch_assoc();
												$mUsername = $mUserData["firstname"].' '.$mUserData["lastname"];
												?>
													<tr>
														<td><?php echo $mRow["id"]; ?></td>
														<td><?php echo $mUsername; ?></td>
														<td><?php echo $systemCore->timeAgo($mRow["report_time"]); ?></td>
														<td><?php echo $mRow["report_type"]; ?></td>
														<td><a href="page.reports.php?id=<?php echo $mRow["id"]; ?>" class="btn btn-primary btn-xs btn-block"><i class="glyphicon glyphicon-search"></i></a></td>
													</tr>
												<?php
											}
										?>
									</table>
								</div>
							</div>
						</div>
					</div>
					
				</section>
			</aside>
		</div>
		
		<script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.2/jquery.min.js"></script>
		<script src="//maxcdn.bootstrapcdn.com/bootstrap/3.3.1/js/bootstrap.min.js" type="text/javascript"></script>
		<script src="js/AdminLTE/app.js" type="text/javascript"></script>
	</body>
</html>