<?php
	define(CURRENT_PAGE, basename(__FILE__, ".php"));
	require_once("system.engine/system.core.php");
	$l->setPrefix(CURRENT_PAGE);
	
	$systemSmilies = &$systemHandler->loadHandler("SMILIES");
	$systemUser = &$systemHandler->loadHandler("USER");
?>
<!DOCTYPE html>
<html lang="en">
	<head>
		<meta charset="utf-8">
		<title><?php echo $systemHandler->loadHandler("CONFIG")->mSocialName ?> - <?php echo vsprintf($l->getValue("title"), $systemUser->mFullname); ?></title>
		<meta name="viewport" content="width=device-width, user-scalable=no" />
		<link href="system.assets/bootstrap/css/bootstrap.css" rel="stylesheet">
		<link href="system.assets/css/flat-ui.css" rel="stylesheet">
		<link href="system.assets/css/elitenetwork.css" rel="stylesheet">
		<link rel="shortcut icon" href="system.assets/images/favicon.ico">
		<link rel="stylesheet" href="system.assets/css/sweet-alert.css">
		<link rel="stylesheet" href="system.assets/css/bootstrap-flat-extras.css">
		<!--[if lt IE 9]>
		<script src="system.assets/js/html5shiv.js"></script>
		<script src="system.assets/js/respond.min.js"></script>
		<![endif]-->
	</head>
	<body>
		<?php include("system.template/tpl.header.php"); ?>
		<div class="row" id="rowBody">
			<div class="col-md-1 col-md-offset-3 hidden-xs hidden-sm">
				<center>
					<a href="page.profile.php?profile-id=<?php echo $systemUser->mUserId ?>">
						<img src="<?php echo $systemUser->mProfilePicture ?>" class="timelinePicture" />
							<a href="page.profile.php?profile-id=<?php echo $systemUser->mUserId ?>" class="btn btn-primary btn-xs btn-block" style="margin-top: 5px"><?php echo $l->getValue("gotoprofile"); ?> &raquo;</a>
						
						<?php if($systemUser->mAdmin) { ?>
							<a href="system.admin/" class="btn btn-warning btn-xs btn-block" style="margin-top: 5px"><?php echo $l->getValue("adminpanel"); ?> &raquo;</a>
						<?php } ?>
					</a>
					<div style="line-height: 10px; font-size: 10px; margin-top: 5px"><?php echo $l->getValue("lastsignin"); ?><br /><b><?php echo $systemCore->timeAgo($systemUser->mProfileSignIn); ?></b></div>
				</center>
			</div>
			
			<div class="col-md-5 col-md-offset-0 col-sm-12 col-xs-12">
				<form action="javascript:;" id="postImageUpload" method="post" enctype="multipart/form-data">
				
               <ul id="mobileTabs" class="nav nav-tabs visible-xs" role="tablist">
                  <li role="presentation" class="active"><a href="#mind" id="home-tab" role="tab" data-toggle="tab" aria-controls="mind" aria-expanded="true"><i class="glyphicon glyphicon-edit font14"></i></a></li>
                  <li role="presentation" class=""><a href="#location" role="tab" id="profile-tab" data-toggle="tab" aria-controls="location" aria-expanded="false"><i class="glyphicon glyphicon-map-marker font14"></i></a></li>
                  <li role="presentation" class=""><a href="#pictures" role="tab" id="profile-tab" data-toggle="tab" aria-controls="pictures" aria-expanded="false"><i class="glyphicon glyphicon-camera font14"></i></a></li>
                  <li role="presentation" class=""><a href="#misc" role="tab" id="profile-tab" data-toggle="tab" aria-controls="misc" aria-expanded="false"><i class="glyphicon glyphicon-plus font14"></i></a></li>
               </ul>
			   
               <ul id="desktopTabs" class="nav nav-tabs hidden-xs" role="tablist">
                  <li role="presentation" class="active"><a href="#mind" id="home-tab" role="tab" data-toggle="tab" aria-controls="mind" aria-expanded="true"><i class="glyphicon glyphicon-edit font14"></i> Status</a></li>
                  <li role="presentation" class=""><a href="#location" role="tab" id="profile-tab" data-toggle="tab" aria-controls="location" aria-expanded="false"><i class="glyphicon glyphicon-map-marker font14"></i> Location</a></li>
                  <li role="presentation" class=""><a href="#pictures" role="tab" id="profile-tab" data-toggle="tab" aria-controls="pictures" aria-expanded="false"><i class="glyphicon glyphicon-camera font14"></i> Pictures</a></li>
                  <li role="presentation" class=""><a href="#misc" role="tab" id="profile-tab" data-toggle="tab" aria-controls="misc" aria-expanded="false"><i class="glyphicon glyphicon-plus font14"></i> Share</a></li>
               </ul>
			   
               <div id="tabPostContainer" class="tab-content">
                  <div role="tabpanel" class="tab-pane fade active in" id="mind" aria-labelledby="home-tab">
                     <div class="row">
                        <div class="col-md-12">
                           <span class="lead" style="font-size: 14px; font-weight: 700; margin-top: 10px"><?php echo $l->getValue("mindquestion"); ?></span>
                           <textarea class="form-control" rows="4" id="postText"></textarea>
						   <div id="linkResult"></div>
                        </div>
                     </div>
                  </div>
                  <div role="tabpanel" class="tab-pane fade" id="location" aria-labelledby="profile-tab">
                     <div class="row">
                        <div class="col-md-12">
                           <span class="lead" style="font-size: 14px; font-weight: 700; margin-top: 10px"><?php echo $l->getValue("locationquestion"); ?></span>
                           <input type="text" class="form-control" placeholder="New York City" id="postLocation" />
                        </div>
                     </div>
                     <br />
                     <center>
                        <img style="max-width: 90%" src="http://maps.googleapis.com/maps/api/staticmap?center=New York City&zoom=12&size=1250x100&maptype=roadmap" class="thumbnail boxShadow hidden-xs" id="postLocationImg" />
                     </center>
                  </div>
                  <div role="tabpanel" class="tab-pane fade" id="pictures" aria-labelledby="profile-tab">
                     <div class="row">
                        <div class="col-md-3 col-xs-12">
                           <center><img class="postMediaContainer" src="system.assets/images/icons/svg/loop.svg" style="margin-bottom: 10px" /></center>
                        </div>
                        <div class="col-md-9 col-xs-12">
                           <div class="row">
                              <div class="col-md-12 col-xs-12">
                                 <span style="font-size: 14px; font-weight: 700; margin-top: 10px" class="lead"><?php echo $l->getValue("selectimage"); ?>:</span>
                                 <input class="form-control" type="file" name="fileToUpload" id="fileToUpload">
                                 <br />
                                 <span style="font-size: 14px; font-weight: 700; margin-top: 10px" class="lead"><?php echo $l->getValue("addtoalbum"); ?>:</span>
                                 <div class="xs">
                                    <select id="postAlbum" class="form-control select select-primary frecuency" data-toggle="select">
                                    <?php
                                       $mAlbumQuery = $systemHandler->loadHandler("EXECUTION")->runQuery("SELECT * FROM web_albums WHERE album_owner_id = '%s' ORDER BY id DESC", "{user.id}");
                                       while($mRow = $mAlbumQuery->fetch_assoc()) {
                                       	echo "<option value=\"".$mRow["id"]."\">".htmlspecialchars($mRow["album_name"])."</option>";
                                       }
                                       ?>
                                    </select>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
                  <div role="tabpanel" class="tab-pane fade" id="misc" aria-labelledby="profile-tab">
                     <div class="row">
                        <div class="col-md-12 col-xs-12">
                           <span class="lead" style="font-size: 14px; font-weight: 700; margin-top: 10px"><?php echo $l->getValue("locationquestion"); ?></span>
                           <input type="hidden" id="postPrivacy" value="2" />
                           <div class="btn-group" id="privacyButtons" data-toggle="buttons" style="width: 100%">
                              <label privacy-value="1" class="btn btn-primary" style="width: 33.3%">
                              <input type="radio" name="mPrivacyOptions" autocomplete="off"><i class="glyphicon glyphicon-globe"></i>	<span class="hidden-xs"><?php echo $l->getValue("everyone"); ?></span>
                              </label>
                              <label privacy-value="2" class="btn btn-primary active" style="width: 33.3%">
                              <input type="radio" name="mPrivacyOptions" autocomplete="off" checked><i class="glyphicon glyphicon-user"></i>  <span class="hidden-xs"><?php echo $l->getValue("friends"); ?></span>
                              </label>
                              <label privacy-value="3" class="btn btn-primary" style="width: 33.3%">
                              <input type="radio" name="mPrivacyOptions" autocomplete="off"><i class="glyphicon glyphicon-lock"></i> <span class="hidden-xs"><?php echo $l->getValue("onlyme"); ?></span>
                              </label>
                           </div>
                        </div>
                        <div class="col-md-12 col-xs-12" style="margin-top: 10px">
                           <span class="lead" style="font-size: 14px; font-weight: 700; margin-top: 10px"><?php echo $l->getValue("hashtagsquestion"); ?></span>
                           <input id="postHashtags" name="tagsinput" class="tagsinput form-control" value="" />
                        </div>
                        <div class="col-md-12 col-xs-12">
                           <span class="lead" style="font-size: 14px; font-weight: 700; margin-top: 10px"><?php echo $l->getValue("mentionquestion"); ?></span>
                           <input class="form-control" type="text" id="postMentions" />
                           <small><i><?php echo $l->getValue("onlyvalid"); ?></i></small>
                        </div>
                     </div>
                     <br />
                     <center id="postButtonType">
                        <a id="postSubmitA" class="btn btn-success btn-outline-rounded green"><?php echo $l->getValue("sharepost"); ?></a>
                     </center>
                  </div>
               </div>
            </form>
			</div>
		</div>
		
		<div class="row" style="z-index: 1">
			<div class="col-md-6 col-md-offset-3 col-xs-12 col-sm-10 col-sm-offset-1" style="z-index: 2">
				<ul class="timeline" id="containerTimeline" style="z-index: 3"></ul>
			</div>
		</div>
		
		<?php include_once("system.template/tpl.footer.php"); ?>
	</body>
</html>