<?php
	define(CURRENT_PAGE, basename(__FILE__, ".php"));
	require_once("system.engine/system.core.php");
	$l->setPrefix(CURRENT_PAGE);
	
	$systemSmilies = &$systemHandler->loadHandler("SMILIES");
	$systemSecurity = &$systemHandler->loadHandler("SECURITY");
	$systemExecution = &$systemHandler->loadHandler("EXECUTION");
	$systemSession = &$systemHandler->loadHandler("SESSION");
	$systemUser = &$systemHandler->loadHandler("USER");
	
	if(isset($_FILES["profilePicture"])) {
		$mCheck = getimagesize($_FILES["profilePicture"]["tmp_name"]);
		if($mCheck !== false) {
			$mUserHash = $systemHandler->loadHandler("HASH")->hashString($systemUser->mUserId);
			$mTargetFile = "system.gallery/system.profile.pictures/".$mUserHash.".png";
			if (move_uploaded_file($_FILES["profilePicture"]["tmp_name"], $mTargetFile)) {
				$systemExecution->runQuery("UPDATE web_user SET profile_hash = '%s' WHERE id = '%s'", array($mUserHash, $systemHandler->loadHandler("USER")->mUserId));
				header("Location: page.profile.php");
			}
		}
	}
	
	if(isset($_FILES["coverPicture"])) {
		$mCheck = getimagesize($_FILES["coverPicture"]["tmp_name"]);
		if($mCheck !== false) {
			$mUserHash = $systemHandler->loadHandler("HASH")->hashString($systemUser->mUserId);
			$mTargetFile = "system.gallery/system.profile.covers/".$mUserHash.".png";
			if (move_uploaded_file($_FILES["coverPicture"]["tmp_name"], $mTargetFile)) {
				$systemExecution->runQuery("UPDATE web_user SET profile_hash = '%s' WHERE id = '%s'", array($mUserHash, $systemHandler->loadHandler("USER")->mUserId));
				header("Location: page.profile.php");
			}
		}
	}
	
	$mProfileUserId = isset($_GET["profile-id"]) ? $systemSecurity->validateParams($_GET["profile-id"]) : -1;
	$mProfileUser = null;
	
	if($systemExecution->runQuery("SELECT COUNT(id) AS userCount FROM web_user WHERE id = '%s'", $mProfileUserId)->fetch_object()->userCount > 0)
		$mProfileUser = new systemUSER($mProfileUserId);
	else
		$mProfileUser = new systemUSER($systemSession->loadSession("USER"));
	
	$u = &$mProfileUser;
	?>
<!DOCTYPE html>
<html lang="en">
	<head>
		<meta charset="utf-8">
		<title><?php echo $systemHandler->loadHandler("CONFIG")->mSocialName ?> - <?php echo $u->mFullname ?></title>
		<meta name="viewport" content="width=device-width, user-scalable=no" />
		<link href="system.assets/bootstrap/css/bootstrap.css" rel="stylesheet">
		<link href="system.assets/css/flat-ui.css" rel="stylesheet">
		<link href="system.assets/css/elitenetwork.css" rel="stylesheet">
		<link rel="shortcut icon" href="system.assets/images/favicon.ico">
		<link rel="stylesheet" href="system.assets/css/sweet-alert.css">
		<link rel="stylesheet" href="system.assets/css/bootstrap-flat-extras.css">
		<!--[if lt IE 9]>
		<script src="system.assets/js/html5shiv.js"></script>
		<script src="system.assets/js/respond.min.js"></script>
		<![endif]-->
	</head>
	<body>
		<?php include("system.template/tpl.header.php"); ?>
		<div class="row" style="z-index: 1">
			<div class="col-sm-9 col-sm-offset-1 col-md-6 col-md-offset-3 col-xs-12" style="z-index: 2">
				<div style="background-image: url('<?php echo $u->mProfileCover ?>'); cursor: pointer" src="<?php echo $u->mProfileCover ?>" id="profileCoverContainer" data-event="display-fancy-image"></div>
				<div style="background-image: url('<?php echo $u->mProfilePicture ?>')" src="<?php echo $u->mProfilePicture ?>" id="profilePictureContainer"data-event="display-fancy-image"></div>
				<div id="profileNameContainer"><?php echo $u->mFullname ?></div>
				<div id="profileShadowContainer" style="cursor: pointer">
					<div id="profileEventButtons" class="hidden-xs" style="">
						<?php if($u->mUserId !== $systemUser->mUserId) { ?>
							<button type="button" class="btn btn-primary" data-event="add-friend" data-parameter="<?php echo $u->mUserId ?>">
								<i class="glyphicon glyphicon-time textIcon12"></i> <?php echo $l->getValue("loading"); ?>
							</button>
							
							<button data-location="open-chat-btn" data-event="initialize-chat" data-parameter="<?php echo $u->mUserId ?>" type="button" class="btn btn-primary"><i class="glyphicon glyphicon-comment textIcon12"></i> <?php echo $l->getValue("openchat"); ?></button>
						<?php } else { ?>
							<button data-event="change-pictures" type="button" class="btn btn-primary"><i class="glyphicon glyphicon-picture textIcon12"></i> <?php echo $l->getValue("changepictures"); ?></button>
						<?php } ?>
					</div>
				</div>
				<div id="profileElementsContainer">
					<div class="profileFilter">
						<ul>
							<li>
								<a href="javascript:;" id="initTimeline" class="current activeWell"><?php echo $l->getValue("timeline"); ?></a>
							</li>
							<li>
								<a href="javascript:;" id="initInfo" class="current"><?php echo $l->getValue("info"); ?></a>
							</li>
							<li>
								<a href="javascript:;" id="initGallery" class="current"><?php echo $l->getValue("gallery"); ?></a>
							</li>
							<li>
								<a href="javascript:;" id="initFriends" class="current"><?php echo $l->getValue("friends"); ?></a>
							</li>
						</ul>
					</div>
				</div>
				<?php
					if(strlen($systemHandler->loadHandler("CONFIG")->mAds[1]) > 0) {
						echo "<br />";
						echo $systemHandler->loadHandler("CONFIG")->mAds[1];
						echo "<br />";
					}
				?>
					<br />
				<div class="row" id="upperRow">
					<div class="col-md-12" style="padding: 0px">
						<?php
							if($systemExecution->runQuery("SELECT COUNT(id) AS friendsCount FROM web_friends WHERE (user_one_id = '%s' AND user_two_id = '%s') OR (user_one_id = '%s' AND user_two_id = '%s')", array($u->mUserId, $systemUser->mUserId, $systemUser->mUserId, $u->mUserId))->fetch_object()->friendsCount > 0 || $u->mUserId == $systemUser->mUserId) {
						?>
						<form action="javascript:;" id="postImageUpload" method="post" enctype="multipart/form-data">
				
               <ul id="mobileTabs" class="nav nav-tabs visible-xs" role="tablist">
                  <li role="presentation" class="active"><a href="#mind" id="home-tab" role="tab" data-toggle="tab" aria-controls="mind" aria-expanded="true"><i class="glyphicon glyphicon-edit font14"></i></a></li>
                  <li role="presentation" class=""><a href="#location" role="tab" id="profile-tab" data-toggle="tab" aria-controls="location" aria-expanded="false"><i class="glyphicon glyphicon-map-marker font14"></i></a></li>
                  <li role="presentation" class=""><a href="#pictures" role="tab" id="profile-tab" data-toggle="tab" aria-controls="pictures" aria-expanded="false"><i class="glyphicon glyphicon-camera font14"></i></a></li>
                  <li role="presentation" class=""><a href="#misc" role="tab" id="profile-tab" data-toggle="tab" aria-controls="misc" aria-expanded="false"><i class="glyphicon glyphicon-plus font14"></i></a></li>
               </ul>
			   
               <ul id="desktopTabs" class="nav nav-tabs hidden-xs" role="tablist">
                  <li role="presentation" class="active"><a href="#mind" id="home-tab" role="tab" data-toggle="tab" aria-controls="mind" aria-expanded="true"><i class="glyphicon glyphicon-edit font14"></i> Status</a></li>
                  <li role="presentation" class=""><a href="#location" role="tab" id="profile-tab" data-toggle="tab" aria-controls="location" aria-expanded="false"><i class="glyphicon glyphicon-map-marker font14"></i> Location</a></li>
                  <li role="presentation" class=""><a href="#pictures" role="tab" id="profile-tab" data-toggle="tab" aria-controls="pictures" aria-expanded="false"><i class="glyphicon glyphicon-camera font14"></i> Pictures</a></li>
                  <li role="presentation" class=""><a href="#misc" role="tab" id="profile-tab" data-toggle="tab" aria-controls="misc" aria-expanded="false"><i class="glyphicon glyphicon-plus font14"></i> Share</a></li>
               </ul>
			   
               <div id="tabPostContainer" class="tab-content">
                  <div role="tabpanel" class="tab-pane fade active in" id="mind" aria-labelledby="home-tab">
                     <div class="row">
                        <div class="col-md-12">
                           <span class="lead" style="font-size: 14px; font-weight: 700; margin-top: 10px"><?php echo $l->getValue("questionmind"); ?></span>
                           <textarea class="form-control" rows="4" id="postText"></textarea>
						   <div id="linkResult"></div>
                        </div>
                     </div>
                  </div>
                  <div role="tabpanel" class="tab-pane fade" id="location" aria-labelledby="profile-tab">
                     <div class="row">
                        <div class="col-md-12">
                           <span class="lead" style="font-size: 14px; font-weight: 700; margin-top: 10px"><?php echo $l->getValue("questionlocation"); ?></span>
                           <input type="text" class="form-control" placeholder="New York City" id="postLocation" />
                        </div>
                     </div>
                     <br />
                     <center>
                        <img style="max-width: 90%" src="http://maps.googleapis.com/maps/api/staticmap?center=New York City&zoom=12&size=1250x100&maptype=roadmap" class="thumbnail boxShadow hidden-xs" id="postLocationImg" />
                     </center>
                  </div>
                  <div role="tabpanel" class="tab-pane fade" id="pictures" aria-labelledby="profile-tab">
                     <div class="row">
                        <div class="col-md-3 col-xs-12">
                           <center><img class="postMediaContainer" src="system.assets/images/icons/svg/loop.svg" style="margin-bottom: 10px" /></center>
                        </div>
                        <div class="col-md-9 col-xs-12">
                           <div class="row">
                              <div class="col-md-12 col-xs-12">
                                 <span style="font-size: 14px; font-weight: 700; margin-top: 10px" class="lead"><?php echo $l->getValue("selectimage"); ?>:</span>
                                 <input class="form-control" type="file" name="fileToUpload" id="fileToUpload">
                                 <br />
                                 <span style="font-size: 14px; font-weight: 700; margin-top: 10px" class="lead"><?php echo $l->getValue("addtoalbum"); ?>:</span>
                                 <div class="xs">
                                    <select id="postAlbum" class="form-control select select-primary frecuency" data-toggle="select">
                                    <?php
                                       $mAlbumQuery = $systemHandler->loadHandler("EXECUTION")->runQuery("SELECT * FROM web_albums WHERE album_owner_id = '%s' ORDER BY id DESC", "{user.id}");
                                       while($mRow = $mAlbumQuery->fetch_assoc()) {
                                       	echo "<option value=\"".$mRow["id"]."\">".htmlspecialchars($mRow["album_name"])."</option>";
                                       }
                                       ?>
                                    </select>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
                  <div role="tabpanel" class="tab-pane fade" id="misc" aria-labelledby="profile-tab">
                     <div class="row">
                        <div class="col-md-12 col-xs-12">
                           <span class="lead" style="font-size: 14px; font-weight: 700; margin-top: 10px"><?php echo $l->getValue("questionlocation"); ?></span>
                           <input type="hidden" id="postPrivacy" value="2" />
                           <div class="btn-group" id="privacyButtons" data-toggle="buttons" style="width: 100%">
                              <label privacy-value="1" class="btn btn-primary" style="width: 33.3%">
                              <input type="radio" name="mPrivacyOptions" autocomplete="off"><i class="glyphicon glyphicon-globe"></i>	<span class="hidden-xs"><?php echo $l->getValue("everyone"); ?></span>
                              </label>
                              <label privacy-value="2" class="btn btn-primary active" style="width: 33.3%">
                              <input type="radio" name="mPrivacyOptions" autocomplete="off" checked><i class="glyphicon glyphicon-user"></i>  <span class="hidden-xs"><?php echo $l->getValue("friends"); ?></span>
                              </label>
                              <label privacy-value="3" class="btn btn-primary" style="width: 33.3%">
                              <input type="radio" name="mPrivacyOptions" autocomplete="off"><i class="glyphicon glyphicon-lock"></i> <span class="hidden-xs"><?php echo $l->getValue("onlyme"); ?></span>
                              </label>
                           </div>
                        </div>
                        <div class="col-md-12 col-xs-12" style="margin-top: 10px">
                           <span class="lead" style="font-size: 14px; font-weight: 700; margin-top: 10px"><?php echo $l->getValue("questionhashtags"); ?></span>
                           <input id="postHashtags" name="tagsinput" class="tagsinput form-control" value="" />
                        </div>
                        <div class="col-md-12 col-xs-12">
                           <span class="lead" style="font-size: 14px; font-weight: 700; margin-top: 10px"><?php echo $l->getValue("questionmentions"); ?></span>
                           <input class="form-control" type="text" id="postMentions" />
                           <small><i><?php echo $l->getValue("onlyvalid"); ?></i></small>
                        </div>
                     </div>
                     <br />
                     <center id="postButtonType">
                        <a id="postSubmitA" class="btn btn-success btn-outline-rounded green"><?php echo $l->getValue("sharepost"); ?></a>
                     </center>
                  </div>
               </div>
            </form>
						<?php } ?>
					</div>
				</div>
				<br />
				<div id="profileSwitchableController">
					<div id="timelinePosition"></div>
					<div id="profileGallery">
						<div class="panel panel-default">
							<div class="panel-body text-center">
								<div id="galleryHeader">
										<div class="galleryTitle">
											<i class="glyphicon glyphicon-camera font20"></i> <?php echo $l->getValue("pictures"); ?>
											<div class="galleryEvents" <?php echo $u->mUserId !== $systemUser->mUserId ? "style=\"display: none\"" : null; ?>>
												<div class="btn-group" role="group" aria-label="galleryEvents">
													<button id="createAlbum" type="button" class="btn btn-default"><i class="glyphicon glyphicon-plus font12"></i> <?php echo $l->getValue("createnewalbum"); ?></button>
													<button id="modifyAlbum" data-toggle="tooltip" data-placement="top" title="<?php echo $l->getValue("modify"); ?>" type="button" class="btn btn-default"><i class="glyphicon glyphicon-wrench"></i></button>
												</div>
											</div>
										</div>
									</div>
									
								<ul class="nav nav-pills hidden-xs" id="albumCollection" role="tablist">
									<?php
										$mGalleryQuery = $systemExecution->runQuery("SELECT * FROM web_albums WHERE album_owner_id = '%s'", $u->mUserId);
										$mCount = 0;
										$mCollection = array();
										while($mGalleryRow = $mGalleryQuery->fetch_assoc()) {
											$mCount++;
											$mCollection[$mGalleryRow["id"]] = $mGalleryRow["album_name"];
											echo "<li data-location=\"albumCollection-".$mGalleryRow["id"]."\" data-parameter=\"".$mGalleryRow["id"]."\" data-album-standard=\"".$mGalleryRow["album_is_standard"]."\" data-toggle=\"tooltip\" data-placement=\"top\" title=\"".$systemCore->timeAgo($mGalleryRow["album_date_created"])."\" data-parameter=\"".$mGalleryRow["id"]."\" class=\"galleryName ".($mCount == 1 ? "active" : null)."\" role=\"presentation\"><a href=\"javascript:;\" data-location=\"albumListName-".$mGalleryRow["id"]."\">".htmlspecialchars($mGalleryRow["album_name"])."</a>";
										}
										
										if($mCount == 0)
											echo "<center><h4>".$l->getValue("noalbums")."</h4></center>";
									?>
								</ul>
								<div id="galleryTime"></div>
								<center>
									<select id="selectAlbum" class="visible-xs">
										<?php
											foreach($mCollection as $mKey => $mValue)
												echo "<option data-parameter=\"".$mKey."\" class=\"galleryName\">".$mValue."</option>";
										?>
									</select>
								</center>
								<center>
									<div id="galleryContent"></div>
								</center>
							</div>
						</div>
					</div>
					
					<div id="profileInformation">
						<div class="panel panel-default">
							<div class="panel-body">
								<div id="galleryHeader">
									<div class="galleryTitle">
										<i class="glyphicon glyphicon-bookmark font20"></i> <?php echo $l->getValue("info"); ?>
										<?php if($u->mUserId == $systemUser->mUserId) { ?>
										<span style="float: right; font-size: 17px; opacity: 0.8"><i class="glyphicon glyphicon-info-sign font14"></i> Change info by clicking on displayed text</span>
										<?php } ?>
									</div>
								</div>
								
								<table class="table table-hover" id="infoTable">
									<tr>
										<th>
											<?php echo $l->getValue("workplace"); ?>
										</th>
										<td class="iconColumn"><i class="glyphicon glyphicon-briefcase"></i></td>
										<td class="profileColumn" data-parameter="workplace">
											<?php echo $u->mWorkplace ?>
										</td>
									</tr>
									<tr>
										<th>
											<?php echo $l->getValue("placeresidence"); ?>
										</th>
										<td class="iconColumn"><i class="glyphicon glyphicon-home"></i></td>
										<td class="profileColumn" data-parameter="residence">
											<i class="glyphicon glyphicon-map-marker font14"></i> <?php echo $u->mResidence ?>
											<img class="thumbnail" style="width: 100%; margin-top: 5px" src="http://maps.googleapis.com/maps/api/staticmap?center=<?php echo $u->mResidence ?>&zoom=13&size=800x100&maptype=roadmap" />
										</td>
									</tr>
									<tr>
										<th>
											<?php echo $l->getValue("detailsabout"); ?> <?php echo $u->mFirstname ?>
										</th>
										<td class="iconColumn"><i class="glyphicon glyphicon-bell"></i></td>
										<td class="profileColumn" data-parameter="details">
											<?php echo $u->mDetails ?>
										</td>
									</tr>
									<tr>
										<th>
											<?php echo $l->getValue("email"); ?>
										</th>
										<td class="iconColumn"><i class="glyphicon glyphicon-envelope"></i></td>
										<td class="profileColumn" data-parameter="mail">
											<?php echo $u->mMail ?>
										</td>
									</tr>
									<tr style="<?php echo $u->mUserId !== $systemHandler->loadHandler("USER")->mUserId ? "display: none" : null; ?>">
										<th>
											<?php echo $l->getValue("password"); ?><br /><i><small><?php echo $l->getValue("onlyyou"); ?></small></i>
										</th>
										<td class="iconColumn"><i class="glyphicon glyphicon-envelope"></i></td>
										<td class="profileColumn" data-parameter="pass">
											<a href="javascript:;" class="btn btn-block btn-primary"><?php echo $l->getValue("clickchangepass"); ?></a>
										</td>
									</tr>
								</table>
							</div>
						</div>
					</div>
					
					<div id="profileFriends" style="display: none">
						<div class="panel panel-default">
							<div class="panel-body">
								<div id="galleryHeader">
									<div class="galleryTitle">
										<i class="glyphicon glyphicon-user font20"></i> <?php echo $l->getValue("friends"); ?>
									</div>
								</div>
								
								<div id="friendsCollection">
									<center>
										<img src="system.assets/images/loader.gif" />
									</center>
								</div>
							</div>
						</div>
					</div>
					
				</div>
			</div>
		</div>
		
		<div id="createAlbumModal" class="modal fade">
			<div class="modal-dialog">
				<div class="modal-content">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						<h4 class="modal-title"><i class="glyphicon glyphicon-plus font12"></i> <?php echo $l->getValue("createnewalbum"); ?></h4>
					</div>
					<div class="modal-body">
						<input type="text" class="form-control" id="albumName" placeholder="Album name" />
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-default" data-dismiss="modal"><?php echo $l->getValue("close"); ?></button>
						<button id="submitNewAlbum" type="button" class="btn btn-primary"><?php echo $l->getValue("createnewalbum"); ?></button>
					</div>
				</div>
				<!-- /.modal-content -->
			</div>
			<!-- /.modal-dialog -->
		</div>
		
		<div class="modal fade" id="changeModal">
			<div class="modal-dialog">
				<div class="modal-content">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						<h4 class="modal-title"><?php echo $l->getValue("changeprofilepicture"); ?></h4>
					</div>
					<div class="modal-body">
						<div class="panel panel-default">
							<div class="panel-heading">
								<h3 class="panel-title"><?php echo $l->getValue("profilepicture"); ?></h3>
							</div>
							<div class="panel-body">
								<form action="page.profile.php" method="post" enctype="multipart/form-data">
									<?php echo $l->getValue("selectprofilepicture"); ?>:
									<input class="form-control" type="file" name="profilePicture" id="profilePicture">
									<input class="btn btn-primary uploadButton" type="submit" value="<?php echo $l->getValue("upload"); ?>" name="submit">
								</form>
							</div>
						</div>
							<hr />
						<div class="panel panel-default">
							<div class="panel-heading">
								<h3 class="panel-title"><?php echo $l->getValue("coverpicture"); ?></h3>
							</div>
							<div class="panel-body">
								<form action="page.profile.php" method="post" enctype="multipart/form-data">
									<?php echo $l->getValue("selectcoverpicture"); ?>:
									<input class="form-control" type="file" name="coverPicture" id="coverPicture">
									<input class="btn btn-primary uploadButton" type="submit" value="<?php echo $l->getValue("upload"); ?>" name="submit">
								</form>
							</div>
						</div>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-default" data-dismiss="modal"><?php echo $l->getValue("close"); ?></button>
					</div>
				</div>
				<!-- /.modal-content -->
			</div>
			<!-- /.modal-dialog -->
		</div>
		<!-- /.modal -->
		
		<div id="modifyAlbumModal" class="modal fade">
			<div class="modal-dialog">
				<div class="modal-content">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						<h4 class="modal-title"><i class="glyphicon glyphicon-pencil font12"></i> <?php echo $l->getValue("modifyalbums"); ?></h4>
					</div>
					<div class="modal-body">
						<ul class="list-group" style="max-height: 325px; overflow-y: auto; overflow-x: hidden">
							<?php
								$mAlbumQuery = $systemExecution->runQuery("SELECT * FROM web_albums WHERE album_owner_id = '%s'", $systemUser->mUserId);
								$mAlbumCount = $systemExecution->runQuery("SELECT COUNT(id) AS albumCount FROM web_albums WHERE album_owner_id = '%s'", $systemUser->mUserId)->fetch_object()->albumCount;
								while($mRow = $mAlbumQuery->fetch_assoc()) {
									echo "
									<li data-location=\"albumListRow-".$mRow["id"]."\" style=\"height: 55px\" class=\"list-group-item\">
										<span data-parameter=\"".$mRow["id"]."\" style=\"float: left\" class=\"modifyAlbumName\" data-location=\"modifyAlbumName-".$mRow["id"]."\" data-old-name=\"".htmlspecialchars($mRow["album_name"])."\">
											".htmlspecialchars($mRow["album_name"])."
										</span>
										<div style=\"float: right; ".($mRow["album_is_standard"] == "yes" ? "display: none" : "")."\" class=\"btn-group\" role=\"group\" aria-label=\"modifyAlbumButtons\">
											<button data-event=\"deleteAlbum\" data-parameter=\"".$mRow["id"]."\" type=\"button\" class=\"btn btn-danger\"><i class=\"glyphicon glyphicon-remove\"></i></button>
										</div>
									</li>";
								}
								
								if($mAlbumCount == 0)
									echo "<center>".$l->getValue("havengotalbums").".</center>";
							?>
						</ul>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-default" data-dismiss="modal"><?php echo $l->getValue("close"); ?></button>
					</div>
				</div>
				<!-- /.modal-content -->
			</div>
			<!-- /.modal-dialog -->
		</div>
		<!-- /.modal -->
		
		<?php include_once("system.template/tpl.footer.php"); ?>
	</body>
</html>