<?php defined("IN_DOCEBO") or die('Direct access is forbidden.');

/* ======================================================================== \
| 	DOCEBO - The E-Learning Suite											|
| 																			|
| 	Copyright (c) 2008 (Docebo)												|
| 	http://www.docebo.com													|
|   License 	http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt		|
\ ======================================================================== */

class FilterInput {


	public $tool = '';

	protected $htmlpurifier = NULL;

	protected $use_xss_clean = true;

	public function __construct() {}

	/**
	 * The function that follow are a modified version of the Khoana Input library.
	 *
	 * @author     Kohana Team
	 * @copyright  (c) 2007-2008 Kohana Team
	 * @license    http://kohanaphp.com/license.html
	 */

	public function sanitize() {

		// load the tool that we want to use in the xss filtering process
		switch($this->tool) {
			case "none" : {

				//only used for a god admin
			};break;
			case "htmlpurifier" : {

				//htmlpurifier  is the best class in order to clean and validate the user input
				//his major drawback is that require a lot of resource to operazte, so is better
				//to use it only if is reallt needed

				require_once _base_.'/addons/htmlpurifier/HTMLPurifier.standalone.php';
				$config = HTMLPurifier_Config::createDefault();
				$config->set('HTML', 'TidyLevel', 'none');
				$this->html_purifier = new HTMLPurifier($config);
			};break;
			case 'htmlawed' : {

				//another class aganist xss
				require_once _base_.'/addons/htmlawed/htmlawed.php';
			};break;
			case 'kses' :
			default: {

				//another class aganist xss
				require_once _base_.'/addons/kses/kses.php';
			};break;
		}

		if (is_array($_GET) AND count($_GET) > 0) {

			$_GET = $this->clean_input_data($_GET);
		}
		if (is_array($_POST) AND count($_POST) > 0) {

			$_POST = $this->clean_input_data($_POST);
		}
		if (is_array($_COOKIE) AND count($_COOKIE) > 0) {

			$_COOKIE = $this->clean_input_data($_COOKIE);
		}
		if (is_array($_FILES) AND count($_FILES) > 0) {

			//$_FILES = $this->clean_input_data($_FILES, true);
		}

	}

	/**
	 * This is a helper function. It escapes data and standardizes newline characters to '\n'.
	 *
	 * @param   unknown_type  string to clean
	 * @return  string
	 */
	protected function clean_input_data($str, $is_files_arr = false) {

		if (is_array($str)) {
			$new_array = array();
			foreach ($str as $key => $val) {
				if(!$is_files_arr || $key == 'tmp_name') $new_array[$this->clean_input_keys($key)] = $this->clean_input_data($val);
			}
			return $new_array;
		}

		if (get_magic_quotes_gpc()) {
			$str = stripslashes($str);
		}

		if ($this->use_xss_clean === TRUE) {
			$str = $this->xss_clean($str);
		}

		// Backward compatibility :(
        $str = addslashes($str);

		// Standardize newlines
		return str_replace(array("\r\n", "\r"), "\n", $str);
	}

	/**
	 * This is a helper function. To prevent malicious users
	 * from trying to exploit keys we make sure that keys are
	 * only named with alpha-numeric text and a few other items.
	 *
	 * @param   string  string to clean
	 * @return  string
	 */
	protected function clean_input_keys($str) {
		if ( ! preg_match('#^[&a-zA-Z0-9\.:_/-\s]+$#uD', $str)) {
			exit('Disallowed key characters in global data.'.$str);
		}

		return $str;
	}

	public function xss_clean($data)  {

		if (is_array($data)) {
			foreach ($data as $key => $val) {
				$data[$key] = $this->xss_clean($val);
			}
			return $data;
		}

		// It is a string
		$string = $data;

		// Do not clean empty strings
		if (trim($string) == '')
			return $string;

		switch ($this->tool) {
			case "none" : {

				// Only used for a god admin
			};break;
			case 'htmlpurifier' : {

				// Run HTMLPurifier
				$string = $this->html_purifier->purify($string);
			};break;
			case 'htmlawed' : {

				// Run htmLawed
				$string = htmlawed($string, array('safe'=>1));
			};break;
			case 'kses' :
			default : {

				// Run htmLawed
				$string = kses($string, $GLOBALS['allowed_html']);
			};break;
		}

		return $string;
	}

	/**
	 * End of khoana like functions.
	 */

}

?>