<?php
namespace SabaiApps\Directories\Component\WordPressContent\Helper;

use SabaiApps\Directories\Application;
use SabaiApps\Directories\Component\Form;

class PermalinkSettingsFormHelper
{
    public function help(Application $application, array $bundles, array $parents = [])
    {   
        $page_slugs = $application->getPlatform()->getPageSlugs();
        $form = $bundle_names = [];
        foreach (array_keys($bundles) as $key) {
            $bundle = $bundles[$key];
            if (!empty($bundle->info['parent'])
                || empty($bundle->info['public'])
                || (!$permalink = (array)$application->Entity_BundleTypeInfo($bundle, 'permalink'))
            ) continue;
            
            $current = isset($page_slugs[4][$bundle->name]) ? $page_slugs[4][$bundle->name] : [];
            if (isset($current['base'])) {
                $base = $current['base'];
            } else {
                if (is_array($permalink)
                    && isset($permalink['slug'])
                ) {
                    $base = strtolower($bundle->component) . '-' . $permalink['slug'];
                } else {
                    $base = str_replace(array('_', '--'), array('-', '-'), $bundle->type);
                }
            }
            $path = isset($current['path']) ? $current['path'] : '%slug%';
            
            if (!empty($bundle->info['is_taxonomy'])) {
                $paths = array('%slug%', '%parent_term%/%slug%');
            } else {
                $paths = array('%id%', '%slug%');
                if (!empty($bundle->info['taxonomies'])) {
                    foreach (array_keys($bundle->info['taxonomies']) as $taxonomy_type) {
                        $paths[] = '%' . $taxonomy_type . '%/%id%';
                        $paths[] = '%' . $taxonomy_type . '%/%slug%';
                    }
                }
            }
            $options = [];
            foreach ($paths as $_path) {
                $display_path = str_replace('/', ' / ', trim($_path, '/'));
                $selected = $_path === $path ? ' selected="selected"' : '';
                $options[] = '<option value="' . $_path . '"' . $selected . '>' . $display_path . '</option>';
            }
            $field_name_prefix = $application->Form_FieldName(array_merge($parents, array($bundle->name)));
            $form[$bundle->name] = array(
                'custom' => array(
                    '#type' => 'checkbox',
                    '#default_value' => !empty($current),
                    '#on_label' => __('On', 'directories'),
                    '#off_label' => __('Off', 'directories'),
                    '#horizontal' => true,
                    '#title' => $bundle->getLabel('singular'),
                    '#class' => 'drts-form-reveal-next',
                ),
                'url' => array(
                    '#type' => 'item',
                    '#markup' => '<div class="' . DRTS_BS_PREFIX . 'form-inline"><code>' . $application->SiteInfo('url') . '/</code>
<input class="' . DRTS_BS_PREFIX . 'form-control" name="' . $field_name_prefix . '[base]" type="text" size="20" value="' . $application->H($base) . '" />
<code>/</code>
<select class="' . DRTS_BS_PREFIX . 'form-control" name="' . $field_name_prefix . '[path]">' . implode(PHP_EOL, $options) . '</select></div>',
                    '#horizontal' => true,
                    '#states' => array(
                        'visible' => array(
                            'input[name="' . $field_name_prefix . '[custom]"]' => array('type' => 'checked', 'value' => true),
                        ),
                    ),
                ),
            );
            $bundle_names[] = $bundle->name;
        }
        if (!empty($form)) {
            if (count($form) === 1) {
                $form[$bundle->name]['custom']['#title'] = __('Enable custom permalink', 'directories');
                // Set on/off label settings to null to show Yes/No
                $form[$bundle->name]['custom']['#on_label'] = $form[$bundle->name]['custom']['#off_label'] = null;
            }
            $form += array(
                '#element_validate' => array(
                    array(array($this, '_validatePermalinkSettings'), array($application, isset($page_slugs[4]) ? $page_slugs[4] : []))
                ),
                '#submit' => array(
                    9 => array(
                        array(array($this, 'submitForm'), array($application,$bundle_names, $parents)),
                    ),
                ),
            );
        }
        
        return $form;
    }
    
    public function _validatePermalinkSettings(Form\Form $form, &$value, array $element, Application $application, array $current)
    {
        $current_lang = (string)$application->getPlatform()->getCurrentLanguage();
        $all_bases = [$current_lang => []];
        // Get currently configured base paths
        foreach ($current as $bundle_name => $permalink_setting) {
            $all_bases[$current_lang][$bundle_name] = $permalink_setting['base'];
        }
        // Overwrite those submitted
        foreach ($value as $bundle_name => $permalink_setting) {
            $all_bases[$current_lang][$bundle_name] = $permalink_setting['base'];
        }
        // Get from other languages
        foreach ($application->getPlatform()->getLanguages() as $lang) {
            if ($lang === $current_lang) continue;
            
            $pages_slugs = $application->getPlatform()->getPageSlugs($lang);
            if (!empty($pages_slugs[4])) {
                // Get currently configured base paths for this language
                foreach ($pages_slugs[4] as $bundle_name => $permalink_setting) {
                    $all_bases[$lang][$bundle_name] = $permalink_setting['base'];
                }
            }
        }
        
        foreach (array_keys($value) as $bundle_name) {
            $_value =& $value[$bundle_name];
            if (empty($_value['custom'])) return;
        
            $_value['base'] = trim($_value['base']);
            if (!strlen($_value['base'])) {
                $form->setError(__('Permalink URL base may not be empty', 'directories'), $element['#name'] . '[' . $bundle_name . '][url]');
            } elseif (!preg_match('#^[a-zA-Z0-9/_-]+$#', $_value['base'])) {
                $form->setError(__('Invalid permalink URL base: ' . $_value['base'], 'directories'), $element['#name'] . '[' . $bundle_name . '][url]');
            } else {
                $_all_bases = $all_bases;
                foreach (array_keys($_all_bases) as $lang) {
                    if ($lang === $current_lang) {
                        unset($_all_bases[$lang][$bundle_name]); // exclude self
                    }
                    if ($_bundle_name = array_search($_value['base'], $_all_bases[$lang])) {
                        $form->setError(
                            sprintf(
                                __('Permalink URL base %s is already in use by %s.', 'directories'),
                                $_value['base'],
                                $application->Entity_Bundle($_bundle_name)->getLabel('singular', $lang) . ($lang === $current_lang ? '' : ' (' . $lang . ')')
                            ),
                            $element['#name'] . '[' . $bundle_name . '][url]'
                        );
                    }
                }
            }
        }
    }
    
    public function submitForm(Form\Form $form, Application $application, array $bundleNames, array $parents)
    {
        $slugs = $application->System_Slugs();
        $page_slugs = $application->getPlatform()->getPageSlugs();
        foreach ($bundleNames as $bundle_name) {
            unset($page_slugs[4][$bundle_name]);
        }
        $values = $form->getValue($parents);
        foreach (array_keys($values) as $bundle_name) {
            if (!$bundle = $application->Entity_Bundle($bundle_name)) continue;
                
            $value = $values[$bundle_name];
            if (!empty($value['custom'])) {
                unset($value['custom']);
                $path = $value['path'] = trim($value['path'], '/');
                if ($path === '%id%') {
                    $regex = array(
                        array(
                            'regex' => preg_quote($value['base']) . '/([0-9]+)',
                            'type' => 'id',
                        ),
                    );
                } elseif ($path === '%slug%') {
                    $regex = array(
                        array(
                            'regex' => preg_quote($value['base']) . '/([^/]+)',
                            'type' => 'slug',
                        ),
                    );
                } else {
                    $type = strpos($path, '%id%') !== false ? 'id' : 'slug';
                    $tags = array('%slug%' => '([^/]+)', '%id%' => '([0-9]+)');
                    if (!empty($bundle->info['is_taxonomy'])) {
                        if (!empty($bundle->info['is_hierarchical'])) {
                            $tags['%parent_term%'] = '.+';
                        }
                    } else {
                        foreach (array_keys($bundle->info['taxonomies']) as $taxonomy_type) {
                            $tags['%' . $taxonomy_type . '%'] = array(
                                'regex' => '.+',
                                'taxonomy' => $taxonomy_type,
                            );
                        }
                    }
                    foreach ($tags as $tag => $tag_info) {
                        if (strpos($value['path'], $tag) === false) continue;
                    
                        if (!is_array($tag_info)) {
                            $replace = $tag_info;
                        } else {
                            $replace = $tag_info['regex'];
                            if (isset($tag_info['taxonomy'])) {
                                $value['taxonomies'][$tag] = $tag_info['taxonomy'];
                            }
                        }
                        $path = str_replace($tag, $replace, $path);
                    }
                    $regex = array(
                        array(
                            'regex' => preg_quote($value['base']) . ($type === 'id' ? '/([0-9]+)' : '/([^/]+)'), // for entities without taxonomies
                            'type' => $type,
                        ),
                    );
                    if ($path) {
                        $regex[] = array(
                            'regex' => preg_quote($value['base']) . '/' . ltrim(rtrim($path, '/'), '/'),
                            'type' => $type,
                        );
                    }
                }
                $permalink_slug = $bundle->group . '-' . $bundle->info['slug'];
                $page_slugs[4][$bundle->name] = array(
                    'component' => $bundle->component,
                    'slug' => $bundle->group . '-' . $bundle->info['slug'],
                    'parent' => isset($slugs[$permalink_slug]['parent']) ? $slugs[$permalink_slug]['parent'] : null,
                    'regex' => $regex,
                    empty($bundle->info['is_taxonomy']) ? 'post_type' : 'taxonomy' => $bundle->name,
                ) + $value;
            }
        }
        
        $application->getPlatform()->setPageSlugs($page_slugs);
    }
}