<?php
namespace SabaiApps\Directories\Component\WordPressContent\FieldWidget;

use SabaiApps\Directories\Component\Field;
use SabaiApps\Directories\Component\Entity;

class FileFieldWidget extends Field\Widget\AbstractWidget
{
    public static $txtExtensions = 'txt|asc|c|cc|h|srt';
    
    protected function _fieldWidgetInfo()
    {
        return array(
            'label' => __('File upload field', 'directories'),
            'field_types' => array('wp_file'),
            'accept_multiple' => true,
            'default_settings' => array(
                'max_file_size' => 2048,
                'allowed_extensions' => array(self::$txtExtensions, 'pdf', 'zip'),
            ),
        );
    }

    public function fieldWidgetSettingsForm($fieldType, Entity\Model\Bundle $bundle, array $settings, array $parents = [], array $rootParents = [])
    {
        $options = [];
        foreach (array_keys(get_allowed_mime_types()) as $ext) {
            if (strpos($ext, '|')) {
                if ($ext === self::$txtExtensions) {
                    $options[$ext] = 'txt';
                } else {
                    $options[$ext] = str_replace('|', ' / ', $ext);
                }
            } else {
                $options[$ext] = $ext;
            }
        }
        return array(
            'max_file_size' => array(
                '#type' => 'textfield',
                '#title' => __('Maximum file size', 'directories'),
                '#description' => __('The maximum file size of uploaded files in kilobytes. Leave this field blank for no limit.', 'directories'),
                '#size' => 7,
                '#integer' => true,
                '#field_suffix' => 'KB',
                '#default_value' => $settings['max_file_size'],
                '#weight' => 2,
            ),
            'allowed_extensions' => array(
                '#type' => 'checkboxes',
                '#title' => __('Allowed file extensions', 'directories'),
                '#default_value' => $settings['allowed_extensions'],
                '#required' => true,
                '#weight' => 1,
                '#options' => $options,
                '#columns' => 3,
            ),
        );
    }

    public function fieldWidgetForm(Field\IField $field, array $settings, $value = null, Entity\Type\IEntity $entity = null, array $parents = [], $language = null)
    {
        if (current_user_can('upload_files')) {
            $type =  'wp_media_manager';
            $extensions = $settings['allowed_extensions'];
        } else {
            $type = 'wp_upload';
            $extensions = [];
            foreach ($settings['allowed_extensions'] as $ext) {
                if (strpos($ext, '|')) {
                    if ($ext === self::$txtExtensions) {
                        $extensions[] = 'txt';
                    } else {
                        foreach (explode('|', $ext) as $_ext) {
                            $extensions[] = $_ext;
                        }
                    }
                } else {
                    $extensions[] = $ext;
                }
            } 
        }
        return array(
            '#type' => $type,
            '#allowed_extensions' => $extensions,
            '#max_file_size' => $settings['max_file_size'],
            '#multiple' => $field->getFieldMaxNumItems() !== 1,
            '#default_value' => $value,
            '#max_num_files' => $field->getFieldMaxNumItems(),
            '#sortable' => true,
        );
    }
}