<?php
namespace SabaiApps\Directories\Component\WordPressContent\FieldType;

use SabaiApps\Directories\Component\Field;
use SabaiApps\Directories\Component\Entity;
use SabaiApps\Directories\Application;

class FileFieldType extends Field\Type\AbstractType implements Field\Type\IHumanReadable
{
    public function fieldTypeSchema()
    {
        return array(
            'columns' => array(
                'attachment_id' => array(
                    'type' => Application::COLUMN_INTEGER,
                    'notnull' => true,
                    'unsigned' => true,
                    'was' => 'attachmend_id',
                    'default' => 0,
                ),
                'display_order' => array(
                    'type' => Application::COLUMN_INTEGER,
                    'notnull' => true,
                    'unsigned' => true,
                    'was' => 'display_order',
                    'default' => 0,
                    'length' => 4,
                ),
               'featured' => array(
                    'type' => Application::COLUMN_BOOLEAN,
                    'notnull' => true,
                    'unsigned' => true,
                    'was' => 'featured',
                    'default' => false,
               ),
            ),
            'indexes' => array(
                'attachmend_id' => array(
                    'fields' => array('attachment_id' => array('sorting' => 'ascending')),
                    'was' => 'attachmend_id',
                ),
                'display_order' => array(
                    'fields' => array(
                        'display_order' => array('sorting' => 'ascending'),
                    ),
                    'was' => 'display_order',
                ),
            ),
        );
    }
    
    public function fieldTypeOnLoad(Field\IField $field, array &$values, Entity\Type\IEntity $entity)
    {
        $_values = [];
        foreach ($values as $value) {
            $_values[$value['display_order']] = array(
                'attachment_id' => $value['attachment_id'],
                'featured' => !empty($value['featured'])
            );
        }
        ksort($_values);
        $values = array_values($_values);
    }
    
    public function fieldTypeOnSave(Field\IField $field, array $values)
    {
        $ret = [];
        $i = 0;
        foreach ($values as $value) {
            if (empty($value)) continue;
            
            $ret[] = array(
                'attachment_id' => $value,
                'display_order' => $i,
                'featured' => false,
            );
            ++$i;
        }
        return $ret;
    }
    
    public function fieldTypeIsModified($field, $valueToSave, $currentLoadedValue)
    {   
        $current = [];
        foreach ($currentLoadedValue as $key => $value) {
            $current[] = array('display_order' => $key, 'attachment_id' => $value);
        }
        return $current !== $valueToSave;
    }
    
    protected function _fieldTypeInfo()
    {
        return array(
            'label' => _x('File', 'field type', 'directories'),
            'default_widget' => $this->_name,
            'default_renderer' => $this->_name,
            'icon' => 'far fa-file-alt',
        );
    }
    
    public function fieldHumanReadableText(Field\IField $field, Entity\Type\IEntity $entity, $separator = null, $key = null)
    {
        if (!$values = $entity->getFieldValue($field->getFieldName())) return '';
        
        $ret = [];
        foreach ($values as $value) {
            if ($url = wp_get_attachment_url($value['attachment_id'])) {
                $ret[] = $url;
            }
        }
        return implode(isset($separator) ? $separator : PHP_EOL, $ret);
    }
}