<?php
namespace SabaiApps\Directories\Component\WordPressContent\FieldRenderer;

use SabaiApps\Directories\Component\Field;
use SabaiApps\Directories\Component\Entity;

class FileFieldRenderer extends Field\Renderer\AbstractFileRenderer
{    
    protected $_fieldTypes = array('wp_file');
        
    protected function _getFileLink(Field\IField $field, array $settings, $value, Entity\Type\IEntity $entity)
    {
        return wp_get_attachment_link($value['attachment_id'], 'thumbnail', false, true, get_the_title($value['attachment_id']));
    }
    
    protected function _getFileExtension(Field\IField $field, array $settings, $value, Entity\Type\IEntity $entity)
    {
        $file_path = get_attached_file($value['attachment_id']);
        $ext_and_mime_type = wp_check_filetype(basename($file_path));
        
        return $ext_and_mime_type['ext'];
    }
}