<?php
namespace SabaiApps\Directories\Component\View\Mode;

use SabaiApps\Directories\Application;
use SabaiApps\Directories\Component\Entity;

abstract class AbstractMode implements IMode
{
    protected $_application, $_name, $_info;

    public function __construct(Application $application, $name)
    {
        $this->_application = $application;
        $this->_name = $name;
    }
    
    public function __toString()
    {
        return $this->_name;
    }

    public function viewModeInfo($key = null)
    {
        if (!isset($this->_info)) {
            $this->_info = (array)$this->_viewModeInfo();
        }

        return isset($key) ? (isset($this->_info[$key]) ? $this->_info[$key] : null) : $this->_info;
    }
    
    public function viewModeSupports(Entity\Model\Bundle $bundle)
    {
        return !empty($bundle->info['public']);
    }
    
    public function viewModeSettingsForm(Entity\Model\Bundle $bundle, array $settings, array $parents = []){}
    
    public function viewModeNav(Entity\Model\Bundle $bundle, array $settings)
    {
        return [];
    }
    
    protected function _getImageSettingsForm(Entity\Model\Bundle $bundle, $prefix, array $settings, $required = false, array $parents = [])
    {
        if (!$fields = $this->_application->Entity_Field_options($bundle, 'Field\Type\IImage', '')) return [];

        return array(
            $prefix . 'image_field' => array(
                '#type' => 'select',
                '#title' => __('Image field', 'directories'),
                '#description' => __('Select the field used to display the image for each list item.', 'directories'),
                '#horizontal' => true,
                '#options' => $fields,
                '#default_value' => isset($settings[$prefix . 'image_field']) ? $settings[$prefix . 'image_field'] : null,
                '#required' => $required,
                '#empty_value' => '',
            ),
            $prefix . 'image_size' => array(
                '#title' => __('Image size', 'directories'),
                '#type' => 'select',
                '#options' => array(
                    'thumbnail' => __('Thumbnail', 'directories'),
                    'medium' => __('Medium size', 'directories'),
                    'large' => __('Large size', 'directories'),
                ),
                '#default_value' => $settings[$prefix . 'image_size'],
                '#horizontal' => true,
                '#states' => array(
                    'invisible' => array(
                        sprintf('select[name="%s"]', $this->_application->Form_FieldName(array_merge($parents, array($prefix . 'image_field')))) => array('value' => ''),
                    ),
                ),
            ),
        );
    }

    abstract protected function _viewModeInfo();
}