<?php
namespace SabaiApps\Directories\Component\Field\Type;

use SabaiApps\Directories\Component\Entity;
use SabaiApps\Directories\Component\Field\IField;

abstract class AbstractValueType extends AbstractType
{
    protected $_valueColumn = 'value';

    public function fieldTypeOnSave(IField $field, array $values)
    {
        $ret = [];
        foreach ($values as $value) {
            if (is_array($value)) {
                if (empty($value) || !isset($value[$this->_valueColumn])) {
                    continue;
                }
                $value = (string)$value[$this->_valueColumn];
            }
            $value = (string)$value;
            if (strlen($value) === 0) continue;

            $ret[][$this->_valueColumn] = $value;
        }

        return $ret;
    }

    public function fieldTypeOnLoad(IField $field, array &$values, Entity\Type\IEntity $entity)
    {
        foreach ($values as $key => $value) {
            $values[$key] = $value[$this->_valueColumn];
        }
    }
    
    public function fieldTypeIsModified($field, $valueToSave, $currentLoadedValue)
    {   
        $new = [];
        foreach ($valueToSave as $value) {
            $new[] = $value[$this->_valueColumn];
        }
        return $currentLoadedValue !== $new;
    }
}