<?php
namespace SabaiApps\Directories\Component\Entity\FieldType;

use SabaiApps\Directories\Component\Entity;
use SabaiApps\Directories\Component\Field;
use SabaiApps\Directories\Application;

class ReferenceFieldType extends Field\Type\AbstractType implements Field\Type\IQueryable
{
    protected function _fieldTypeInfo()
    {
        return array(
            'label' => _x('Reference', 'reference field type', 'directories'),
            'icon' => 'fas fa-sync-alt',
            'default_settings' => array(
                'bundle' => null,
            ),
        );
    }

    public function fieldTypeSchema()
    {
        return array(
            'columns' => array(
                'value' => array(
                    'type' => Application::COLUMN_INTEGER,
                    'notnull' => true,
                    'unsigned' => true,
                    'was' => 'value',
                    'default' => 0,
                ),
            ),
        );
    }

    public function fieldTypeSettingsForm(array $settings, Field\IField $field = null, array $parents = [])
    {
        $options = [];
        foreach ($this->_application->Entity_Bundles() as $bundle) {
            if (!empty($bundle->info['parent'])
                || !empty($bundle->info['is_taxonomy'])
            ) continue;

            $options[$bundle->name] = $bundle->getGroupLabel() . ' - ' . $bundle->getLabel('singular');
        }
        return [
            'bundle' => [
                '#type' => 'select',
                '#title' => __('Content Type', 'directories'),
                '#options' => $options,
                '#default_value' => $settings['bundle'],
            ],
        ];
    }

    public function fieldTypeOnSave(Field\IField $field, array $values, array $currentValues = null)
    {
        $ret = $entity_ids = [];
        foreach ($values as $weight => $value) {
            if (is_array($value)) {  // autocomplete field widget
                foreach ($value as $entity_id) {
                    if (empty($entity_id)) {
                        continue;
                    }
                    $entity_ids[$entity_id] = $entity_id;
                }
            } elseif (!empty($value)) {
                $entity_ids[$value] = $value;
            }
        }
        foreach ($entity_ids as $entity_id) {
            $ret[]['value'] = $entity_id;
        }
        return $ret;
    }

    public function fieldTypeOnLoad(Field\IField $field, array &$values, Entity\Type\IEntity $entity)
    {
        $entities = [];
        foreach ($values as $key => $value) {
            $entities[$value['value']] = $key;
        }
        $values = [];
        foreach ($this->_application
            ->Entity_Types_impl($field->Bundle->entitytype_name)
            ->entityTypeEntitiesByIds(array_keys($entities))
        as $entity) {
            $key = $entities[$entity->getId()];
            $values[$key] = $entity;
        }
        ksort($values); // re-order as it was saved
    }

    public function fieldTypeIsModified($field, $valueToSave, $currentLoadedValue)
    {
        $current_value = [];
        foreach ($currentLoadedValue as $entity) {
            $current_value[]['value'] = $entity->getId();
        }
        return $current_value !== $valueToSave;
    }

    public function fieldQueryableInfo(Field\IField $field)
    {
        return array(
            'example' => '1,5,13,0',
            'tip' => __('Enter IDs separeted with commas. Enter 0 for no matching items.', 'directories'),
        );
    }

    public function fieldQueryableQuery(Field\Query $query, $fieldName, $paramStr, Entity\Model\Bundle $bundle = null)
    {
        if (!$ids = $this->_queryableParams($paramStr)) return;

        $include = [];
        $include_null = false;
        foreach ($ids as $id) {
            if ($id == 0) {
                $include_null = true;
            } else {
                $include[] = $id;
            }
        }
        if (!empty($include)) {
            if ($include_null) {
                $query->startCriteriaGroup('OR')
                    ->fieldIsIn($fieldName, $include)
                    ->fieldIsNull($fieldName)
                    ->finishCriteriaGroup();
            } else {
                $query->fieldIsIn($fieldName, $include);
            }
        } else {
            if ($include_null) {
                $query->fieldIsNull($fieldName);
            }
        }
    }
}
