<?php
namespace SabaiApps\Directories\Component\Entity\Controller\Admin;

use SabaiApps\Directories\Context;
use SabaiApps\Directories\Component\System;
use SabaiApps\Directories\Component\Form;

class Edit extends System\Controller\Admin\AbstractSettings
{    
    protected function _getSettingsForm(Context $context, array &$formStorage)
    {
        if ($context->getRequest()->asBool('show_settings')) {
            return array(
                'settings' => array(
                    '#type' => 'markup',
                    '#markup' => '<pre>' . var_export($context->bundle->info, true) . '</pre>',
                ),
            );
        }
        
        // Add label settings
        $info = $this->Entity_BundleTypeInfo($context->bundle);
        $form = array(
            '#tabs' => array(
                'general' => array(
                    '#title' => __('General', 'directories'),
                    '#weight' => -1,
                ),
            ),
            '#tab_style' => 'pill_less_margin',
            'general' => array(
                '#tab' => 'general',
                '#tree' => false,
                'labels' => array(
                    '#title' => __('Label Settings', 'directories'),
                    '#weight' => 1,
                    'label' => array(
                        '#type' => 'textfield',
                        '#title' => __('Label', 'directories'),
                        '#default_value' => $context->bundle->getLabel(),
                        '#horizontal' => true,
                        '#placeholder' => $info['label'],
                        '#required' => true,
                        '#weight' => -2,
                    ),
                    'label_singular' => array(
                        '#type' => 'textfield',
                        '#title' => __('Singular label', 'directories'),
                        '#default_value' => $context->bundle->getLabel('singular'),
                        '#horizontal' => true,
                        '#placeholder' => $info['label_singular'],
                        '#required' => true,
                        '#weight' => -1,
                    ),
                    'label_add' => array(
                        '#type' => 'textfield',
                        '#title' => __('Add item label', 'directories'),
                        '#default_value' => $context->bundle->getLabel('add'),
                        '#horizontal' => true,
                        '#placeholder' => $info['label_add'],
                        '#required' => true,
                    ),
                    'label_all' => array(
                        '#type' => 'textfield',
                        '#title' => __('All items label', 'directories'),
                        '#default_value' => $context->bundle->getLabel('all'),
                        '#horizontal' => true,
                        '#placeholder' => $info['label_all'],
                        '#required' => true,
                    ),
                ),
            ),
        );
        if (isset($info['label_select'])) {
            $form['general']['labels']['label_select'] = array(
                '#type' => 'textfield',
                '#title' => __('Select item label', 'directories'),
                '#default_value' => $context->bundle->getLabel('select'),
                '#horizontal' => true,
                '#placeholder' => $info['label_select'],
                '#required' => true,
            );
        }
        if (isset($info['label_count'])) {
            $form['general']['labels'] += array(
                'label_count' => array(
                    '#type' => 'textfield',
                    '#title' => __('Item count label', 'directories'),
                    '#default_value' => $context->bundle->getLabel('count'),
                    '#horizontal' => true,
                    '#placeholder' => $info['label_count'],
                    '#required' => true,
                ),
                'label_count2' => array(
                    '#type' => 'textfield',
                    '#title' => __('Item count label (plural)', 'directories'),
                    '#default_value' => $context->bundle->getLabel('count2'),
                    '#horizontal' => true,
                    '#placeholder' => $info['label_count2'],
                    '#required' => true,
                ),
            );
        }
        if (!empty($info['public'])) {
            if (!empty($info['is_taxonomy'])
                || !empty($info['parent'])
            ) {
                $form['general']['labels'] += array(
                    'label_page' => array(
                        '#type' => 'textfield',
                        '#title' => __('Single item page label', 'directories'),
                        '#default_value' => $context->bundle->getLabel('page'),
                        '#horizontal' => true,
                        '#placeholder' => $info['label_page'],
                        '#required' => true,
                    ),
                );
            }
        }
        
        if (empty($context->bundle->info['is_taxonomy'])
            && !empty($context->bundle->info['public'])
        ) {
            $form['general']['seo'] = array(
                '#title' => __('SEO Settings', 'directories'),
                '#weight' => 50,
                'entity_schemaorg' => array('#tree' => true) + $this->Entity_SchemaOrg_settingsForm(
                    $context->bundle,
                    empty($context->bundle->info['entity_schemaorg']) ? [] : $context->bundle->info['entity_schemaorg'],
                    array('entity_schemaorg')
                ),
                'entity_opengraph' => array('#tree' => true) + $this->Entity_OpenGraph_settingsForm(
                    $context->bundle,
                    empty($context->bundle->info['entity_opengraph']) ? [] : $context->bundle->info['entity_opengraph'],
                    array('entity_opengraph')
                ),
            );
        }
        
        $submitted_values = $this->_getSubimttedValues($context, $formStorage);
        
        // Add bundle type specific settings
        $form[$context->bundle->type] = array('#tree' => false);
        $form[$context->bundle->type] += (array)$this->Entity_BundleTypes_impl($context->bundle->type)
            ->entityBundleTypeSettingsForm($context->bundle->info, [], $submitted_values);
        
        $form = $this->Filter('entity_bundle_settings_form', $form, array($context->bundle, $submitted_values));
        if (count($form['#tabs']) <= 1) $form['#tabs'] = [];
        
        return $form;
    }
    
    protected function _saveConfig(Context $context, array $values, Form\Form $form)
    {
        parent::_saveConfig($context, $values, $form);
        
        $context->bundle->setInfo($values)->commit();
        
        $this->Action('entity_admin_bundle_info_edited', array($context->bundle));
    }
}