<?php
namespace SabaiApps\Directories\Component\Display\Helper;

use SabaiApps\Directories\Application;
use SabaiApps\Directories\Exception;
use SabaiApps\Directories\Component\Entity;
use SabaiApps\Directories\Request;

class RenderHelper
{
    protected static $_count = 0, $_current = [], $_cssLoaded;

    public function help(Application $application, $bundle, $displayName, $var, array $attr = [], array $options = [])
    {
        if (!$bundle = $application->Entity_Bundle($bundle)) return'';

        if (is_array($displayName)) {
            $display = $displayName;
        } else {
            if (!$display = $application->Display_Display($bundle->name, $displayName)) return '';
        }

        $options += array(
            'pre_render' => false,
            'tag' => 'div',
            'element_tag' => 'div',
            'render_empty' => false,
            'render_empty_element' => false,
            'on_parent_page' => false,
            'globalize_elements' => false,
            'cache' => false,
            'html_as_array' => false,
            'wrap_js' => true,
        );

        if ($options['cache'] !== false
            && (false !== $cached = $application->getPlatform()->getCache($this->_getDisplayCacheId($display, $bundle, $var), 'content'))
        ) {
            return $cached;
        }

        switch ($display['type']) {
            case 'entity':
                if (!$var instanceof \SabaiApps\Directories\Component\Entity\Type\IEntity) return [];

                if ($options['pre_render'] && $display['pre_render']) {
                    $_var = array('entities' => array($var->getId() => $var), 'html' => &$display['html']);
                    $this->preRender($application, $display, $bundle, $_var);
                }
                $options['on_parent_page'] = $var->isOnParentPage();
                if ($display['name'] === 'detailed') {
                    $options['globalize_elements'] = true;
                    if (!isset($GLOBALS['drts_display_elements'])) {
                        $GLOBALS['drts_display_elements'] = [];
                    }
                }
                $attr['data-entity-id'] = $var->getId();
                break;

            case 'form':
            case 'filters':
                if (!$var instanceof \SabaiApps\Directories\Component\Form\Form) return [];
                break;

            default:
                return [];
        }

        ++self::$_count;
        array_push(self::$_current, array($bundle->name, $display['name']));

        // HTML
        $html = $states = [];
        foreach ($display['elements'] as $element) {
            if (!$rendered = $this->element(
                $application,
                $bundle,
                $element,
                $display,
                $var,
                $options,
                $states,
                null,
                $options['element_tag'],
                $options['render_empty_element']
            )) continue;

            $html[$element['id']] = $rendered;
        }
        if (empty($html) && !$options['render_empty']) {
            array_pop(self::$_current);
            if ($options['cache'] !== false) {
                $application->getPlatform()->setCache ('', $this->_getDisplayCacheId($display, $bundle, $var), null, 'content');
            }
            return '';
        }

        // Attributes
        $attr['data-display-type'] = $display['type'];
        $attr['data-display-name'] = $display['name'];
        // Add CSS class
        $class = 'drts-display ' . $display['class'];
        if ($application->getPlatform()->isRtl()) {
            $class .= ' drts-display-rtl';
        }
        if (isset($attr['class'])) {
            $attr['class'] .= ' ' . $class;
        } else {
            $attr['class'] = $class;
        }

        // JS
        $js = [];
        if (empty($display['is_amp'])) {
            if (!empty($states)) {
                if (Request::isXhr()) {
                    $js[] = 'jQuery(function($) {';
                } else {
                    $js[] = 'document.addEventListener("DOMContentLoaded", function(event) { var $ = jQuery;';
                }
                $js[] = sprintf(
                    '    var states = %s
    DRTS.states(states, "#%s");
    $(DRTS).on("clonefield.sabai", function(e, data) {
        DRTS.states(states, data.clone.closest("form"));
    });
});',
                    $application->JsonEncode($states),
                    $application->H($attr['id'])
                );
            }
        }

        // CSS
        if (!isset(self::$_cssLoaded)) {
            self::$_cssLoaded = [];
            // Load CSS stylesheets once
            $application->getPlatform()->addCssFile('display-display.min.css', 'drts-display-display', array('drts'));
        }
        if (!empty($display['css'])) {
            if (!isset(self::$_cssLoaded[$bundle->name][$display['type']][$display['name']])) {
                self::$_cssLoaded[$bundle->name][$display['type']][$display['name']] = true;

                $application->getPlatform()->addCss($display['css'], 'drts-display-display');
            }
        }

        // Let others modify output
        $ret = $application->Filter('display_render', array('html' => $html, 'js' => $js, 'attr' => $attr), array($display, $bundle, $var, $options));

        // Concatenate and wrap with tags
        if ($options['tag']) {
            $ret['html'] = '<' . $options['tag'] . $application->Attr($ret['attr']) . '>' . implode(PHP_EOL, $ret['html']) . '</' . $options['tag'] . '>';
        } else {
            if (empty($options['html_as_array'])) {
                $ret['html'] = implode(PHP_EOL, $ret['html']);
            }
        }
        if (!empty($ret['js'])) {
            $ret['js'] = implode(PHP_EOL, $ret['js']);
            $ret['js'] = $options['wrap_js'] && strlen($ret['js']) ? '<script type="text/javascript">' .  $ret['js'] . '</script>' : '';
        } else {
            $ret['js'] = '';
        }

        array_pop(self::$_current);

        // Cache?
        if ($options['cache'] !== false) {
            $application->getPlatform ()->setCache($ret, $this->_getDisplayCacheId($display, $bundle, $var), $options['cache']);
        }

        return $ret;
    }

    protected function _getDisplayCacheId(array $display, Entity\Model\Bundle $bundle, $var)
    {
        $ret = 'display_rendered_' . $bundle->name . '_' . $display['type'];
        if ($display['type'] === 'entity') {
            $ret .= '_' . $display['name'] . '_' . $var->getId();
        }
        return $ret;
    }

    protected function _getElementCacheId(array $display, Entity\Model\Bundle $bundle, $var, $elementId)
    {
        return $this->_getDisplayCacheId($display, $bundle, $var) . $elementId;
    }

    public function element(Application $application, Entity\Model\Bundle $bundle, array $element, array $display, $var, $options, array &$states, $parent = null, $tag = 'div', $renderEmpty = false)
    {
        if ($options['on_parent_page'] && !empty($element['visibility']['hide_on_parent'])) return;

        if (!empty($element['advanced']['cache'])
            && (false !== $cached = $application->getPlatform()->getCache($cache_id = $this->_getElementCacheId($display, $bundle, $var, $element['id']), 'content'))
        ) {
            return $cached;
        }

        try {
            $element_impl = $application->Display_Elements_impl($bundle, $element['name']);
            $rendered = $element_impl->displayElementRender($bundle, $element, $display, $var, $options, $states, $parent);
        } catch (Exception\IException $e) {
            $application->logError($e);
            return;
        }

        $heading = $attr = null;
        $style = '';
        $class = $element['class'];
        if (isset($element['advanced']['css_class'])) {
            $class .= ' ' . $element['advanced']['css_class'];
        }
        if (is_array($rendered)) {
            if (!empty($rendered['raw'])) {
                return $rendered['raw'];
            }
            if (isset($rendered['style'])) {
                $style = $rendered['style'];
            }
            if (isset($rendered['attr'])) {
                $attr = $rendered['attr'];
            }
            if (isset($rendered['class'])) {
                $class .= ' ' . $rendered['class'];
            }
            if (isset($rendered['heading'])) {
                $heading = $rendered['heading'];
            }
            $rendered = $rendered['html'];
        } else {
            $rendered = (string)$rendered;
        }

        // Filter rendered element
        $rendered = $application->Filter(
           'display_element_render',
            $rendered,
            array($bundle, $element['name'], $element['settings'], $display, $var, $options)
        );

        if (!strlen($rendered)) {
            if (!$renderEmpty) return;
        } else {
            if ($options['globalize_elements']
                && !empty($element['visibility']['globalize'])
            ) {
                $GLOBALS['drts_display_elements'][$bundle->name][$element['id']] = $rendered;
                // Remove from display?
                if (!empty($element['visibility']['globalize_remove'])) return;
            }
        }

        if (isset($element['heading']['label'])) {
            $heading = $application->Display_ElementLabelSettingsForm_label(
                $element['heading'],
                $element_impl->displayElementStringId('heading', $element['id'])
            );
        }
        if (isset($heading)
            && strlen($heading)
        ) {
            $rendered = '<div class="drts-display-element-header"><span>' . $heading . '</span></div>' . $rendered;
        }

        $attr = empty($attr) ? '' : $application->Attr($attr);
        $rendered = '<' . $tag . ' class="' . $class . '" style="' . $style . '" data-name="' . $element['name'] . '"' . $attr . '>' . $rendered . '</' . $tag . '>';

        // Cache?
        if (!empty($element['advanced']['cache'])) {
            if (!isset($cache_id)) $cache_id = $this->_getElementCacheId($display, $bundle, $var, $element['id']);
            $application->getPlatform()->setCache($rendered, $cache_id, $element['advanced']['cache'], 'content');
        }

        return $rendered;
    }

    public function preRender(Application $application, array $display, Entity\Model\Bundle $bundle, &$var)
    {
        foreach ($display['elements'] as $element) {
            if (empty($element['pre_render'])
                || (!$element_impl = $application->Display_Elements_impl($bundle, $element['name'], true))
            ) continue;

            // Skip if cached
            if (!empty($element['advanced']['cache'])
                && $display['type'] === 'entity'
            ) {
                $_var = $var;
                foreach (array_keys($var['entities']) as $entity_id) {
                    if (false !== $application->getPlatform()->getCache($this->_getElementCacheId($display, $bundle, $var['entities'][$entity_id], $element['id']), 'content')) {
                        unset($_var['entities'][$entity_id]);
                    }
                }
                if (!empty($_var['entities'])) {
                    $element_impl->displayElementPreRender($bundle, $element, $display['type'], $_var, self::$_count);
                }
            } else {
                $element_impl->displayElementPreRender($bundle, $element, $display['type'], $var, self::$_count);
            }
        }
    }

    public static function isRendering($bundleName = null, $displayName = null)
    {
        if (empty(self::$_current)) return false;

        if (isset($bundleName)) {
            $current = current(self::$_current);
            if ($bundleName !== $current[0]) return false;

            if (isset($displayName)) {
                if ($displayName !== $current[1]) return false;
            }
        }
        return true;
    }
}
