<?php
namespace SabaiApps\Directories\Component\System\Helper;

use SabaiApps\Directories\Application;
use SabaiApps\Directories\Component\Entity;
use SabaiApps\Directories\Component\Form;

class UtilHelper
{   
    public function iconSizeOptions(Application $application)
    {
        return $application->Filter(
            'system_icon_size_options',
            [
                'sm' => __('Small', 'directories'),
                '' => __('Medium', 'directories'),
            ]
        );
    }
    
    public function iconFieldOptions(Application $application, Entity\Model\Bundle $bundle)
    {
        $ret = [];
        if ($image_options = $this->fieldOptions($application, $bundle, 'entity_image')) {
            $ret['image'] = $image_options;
        }
        if ($icon_options = $this->fieldOptions($application, $bundle, 'entity_icon')) {
            $ret['icon'] = $icon_options;
        }

        return $ret;
    }
    
    public function fieldOptions(Application $application, Entity\Model\Bundle $bundle, $key)
    {
        $ret = [];
        if (($field_name = $application->Entity_BundleTypeInfo($bundle, $key))
            && ($field = $application->Entity_Field($bundle, $field_name))
        ) {
            $ret[$field_name] = $field->getFieldLabel() . ' (' . $field_name . ')';
        }

        return $ret;
    }
    
    public function iconSettingsForm(Application $application, Entity\Model\Bundle $bundle, array $settings, array $parents = [], $weight = null, $horizontal = true)
    {
        $icon_field_options = $application->System_Util_iconFieldOptions($bundle);
        $form = [
            'icon' => [
                '#type' => 'checkbox',
                '#title' => __('Show icon', 'directories'),
                '#default_value' => !empty($settings['icon']),
                '#weight' => isset($weight) ? $weight : null,
                '#horizontal' => $horizontal,
            ],
            'icon_settings' => [
                '#tree' => true,
                '#element_validate' => [
                    function (Form\Form $form, &$value) use ($icon_field_options) {
                        $value['is_image'] = isset($value['field']) && isset($icon_field_options['image'][$value['field']]);
                    }
                ],
                '#weight' => isset($weight) ? ++$weight : null,
                '#states' => [
                    'visible' => [
                        sprintf('input[name="%s"]', $application->Form_FieldName(array_merge($parents, ['icon']))) => [
                            'type' => 'checked', 
                            'value' => true,
                        ],
                    ],
                ],
                'size' => [
                    '#type' => 'select',
                    '#title' => __('Icon size', 'directories'),
                    '#default_value' => isset($settings['icon_settings']['size']) ? $settings['icon_settings']['size'] : null,
                    '#options' => $application->System_Util_iconSizeOptions(),
                    '#horizontal' => $horizontal,
                ],
                'field' => [
                    '#type' => 'select',
                    '#title' => __('Icon field', 'directories'),
                    '#default_value' => isset($settings['icon_settings']['field']) ? $settings['icon_settings']['field'] : null,
                    '#options' => (isset($icon_field_options['icon']) ? $icon_field_options['icon'] : [])
                        + (isset($icon_field_options['image']) ? $icon_field_options['image'] : [])
                        + ['' => __('Default', 'directories')],
                    '#horizontal' => $horizontal,
                ],
                'fallback' => [
                    '#type' => 'checkbox',
                    '#title' => __('Fallback to default icon', 'directories'),
                    '#default_value' => !empty($settings['icon_settings']['fallback']),
                    '#states' => [
                        'invisible' => [
                            sprintf('[name="%s"]', $application->Form_FieldName(array_merge($parents, ['icon_settings', 'field']))) => [
                                'value' => '',
                            ],
                        ],
                    ],
                    '#horizontal' => $horizontal,
                ],
            ],
        ];
        // Hide field option and set value to default if not fields to choose from
        if (empty($icon_field_options['icon']) && empty($icon_field_options['image'])) {
            $form['icon_settings']['field']['#type'] = 'hidden';
            $form['icon_settings']['field']['#value'] = '';
        }
        
        // Add color options
        $form['icon_settings']['color'] = [
           '#states' => [
                'visible' => [
                    sprintf('select[name="%s"]', $application->Form_FieldName(array_merge($parents, ['icon_settings', 'field']))) => [
                        'value' => isset($icon_field_options['icon']) ? array_merge([''], array_keys($icon_field_options['icon'])) : '',
                    ],
                ],
            ],
            'type' => [
                '#type' => 'select',
                '#title' => __('Icon color', 'directories'),
                '#default_value' => isset($settings['icon_settings']['color']['type']) ? $settings['icon_settings']['color']['type'] : '',
                '#options' => $application->System_Util_fieldOptions($bundle, 'entity_color') + [
                    '_custom' => __('Choose a color', 'directories'),
                    '' => __('Default', 'directories')
                ],
                '#horizontal' => $horizontal,
            ],
            'custom' => [
                '#type' => 'colorpicker',
                '#default_value' => isset($settings['icon_settings']['color']['custom']) ? $settings['icon_settings']['color']['custom'] : null,
                '#states' => [
                    'visible' => [
                        sprintf('select[name="%s"]', $application->Form_FieldName(array_merge($parents, ['icon_settings', 'color', 'type']))) => [
                            'value' => '_custom',
                        ],
                    ],
                ],
                '#horizontal' => $horizontal,
            ],
        ];
        
        return $form;
    }
    
    public function iconSettingsToPermalinkOptions(Application $application, array $iconSettings)
    {
        $options = [
            'icon' => empty($iconSettings['field']) ? true : $iconSettings['field'],
            'icon_is_image' => !empty($iconSettings['is_image']),
            'icon_size' => $iconSettings['size'],
            'icon_fallback' => !empty($iconSettings['fallback']),
        ];
        if (!empty($iconSettings['color']['type'])) {
            $options['icon_color'] = $iconSettings['color']['type'] === '_custom'
                ? $iconSettings['color']['custom']
                : $iconSettings['color']['type'];
        }
        return $options;
    }
    
    public function cacheSettingsForm(Application $applicatoin, $value = null)
    {
        $options = ['' => __('No cache', 'directories')];
        foreach ([1, 2, 5, 10, 30] as $min) {
            $options[$min * 60] = sprintf(_n('%d minute', '%d minutes', $min, 'directories'), $min);
        }
        foreach ([1, 2, 5, 10] as $hour) {
            $options[$hour * 3600] = sprintf(_n('%d hour', '%d hours', $hour, 'directories'), $hour);
        }
        foreach ([1, 2, 5, 10, 30] as $day) {
            $options[$day * 86400] = sprintf(_n('%d day', '%d days', $day, 'directories'), $day);
        }
            
        return [
            '#title' => __('Cache output', 'directories'),
            '#type' => 'select',
            '#options' => $options,
            '#default_value' => $value,
            '#horizontal' => true,
        ];
    }
    
    public function colorOptions(Application $application, $buttons = false, $includeLink = false)
    {
        $ret = [];
        $colors = ['primary', 'secondary', 'info' , 'success', 'warning', 'danger', 'light', 'dark'];
        if ($buttons) {
            $btn_class = DRTS_BS_PREFIX . 'btn';
            foreach ($colors as $value) {
                $ret[$value] = sprintf('<button class="%1$s %1$s-sm %1$s-%2$s" onclick="return false;"> </button>', $btn_class, $value);
                $ret['outline-' . $value] = sprintf('<button class="%1$s %1$s-sm %1$s-outline-%2$s" onclick="return false;"> </button>', $btn_class, $value);
            }
            if ($includeLink) {
                $ret['link'] = __('Link', 'directories');
            }
        } else {
            foreach ($colors as $value) {
                $ret[$value] = '<span class="' . DRTS_BS_PREFIX. 'badge ' . DRTS_BS_PREFIX . 'badge-' . $value . '">&nbsp;</span>';
            }
        }
        
        return $ret;
    }
    
        
    public function colorSettingsForm(Application $application, $value = null, array $parents = [], $title = null)
    {
        return [
            'type' => array(
                '#type' => 'select',
                '#title' => isset($title) ? $title : __('Color', 'directories'),
                '#default_value' => isset($value['type']) ? $value['type'] : null,
                '#options' => ['' => __('Default', 'directories'), 'custom' => __('Custom', 'directories')],
                '#horizontal' => true,
            ),
            'value' => [
                '#type' => 'colorpicker',
                '#default_value' => isset($value['value']) ? $value['value'] : null,
                '#horizontal' => true,
                '#states' => array(
                    'visible' => array(
                        sprintf('select[name="%s"]', $application->Form_FieldName(array_merge($parents, ['type']))) => array('value' => 'custom'),
                    ),
                ),
            ],
        ];
    }
}