<?php
namespace SabaiApps\Directories\Component\Form\Field;

use SabaiApps\Directories\Component\Form\Form;

class IconField extends AbstractField
{
    protected static $_elements;

    public function formFieldInit($name, array &$data, Form $form)
    {
        if ($data['#multiple'] = !empty($data['#multiple'])) {
            $data['#size'] = isset($data['#size']) ? $data['#size'] : ((10 < $count = count($data['#options'])) ? 10 : $count);
        }

        $data['#id'] = $form->getFieldId($name);

        if (!isset($data['#select2_allow_clear'])) {
            $data['#select2_allow_clear'] = true;
        }
        if (!empty($data['#max_selection'])) {
            $data['#select2_maximum_selection_length'] = $data['#max_selection'];
        }
        if (!isset($data['#select2_placeholder'])) {
            if (isset($data['#placeholder'])) {
                $data['#select2_placeholder'] = $data['#placeholder'];
            } elseif ($data['#multiple']) {
                $data['#select2_placeholder'] = '';
            } else {
                $data['#select2_placeholder'] = __('— Select —', 'directories');
            }
        }
        // default select2 options
        foreach (array('placeholder', 'allow_clear', 'close_on_select', 'maximum_selection_length') as $key) {
            if (isset($data['#select2_' . $key])) {
                $value = $data['#select2_' . $key];
                $data['#attributes']['data-' . str_replace('_', '-', $key)] = is_bool($value) ? ($value ? 'true' : false) : $value;
            }
        }

        // Load default items
        if (!empty($data['#default_value'])) {
            if (is_string($data['#default_value'])) {
                // Form was submitted previously
                $data['#default_value'] = explode(',', $data['#default_value']);
            } else {
                if (!is_array($data['#default_value'])) {
                    $data['#default_value'] = array($data['#default_value']);
                }
            }
            if (!$data['#multiple']) {
                $data['#default_value'] = array(array_pop($data['#default_value']));
            }
            if (!empty($data['#default_value'])) {
                $data['#attributes']['data-selected'] = implode(',', $data['#default_value']);
            }
        }

        if (!isset(self::$_elements)) {
            self::$_elements = [];
        }
        if (!isset(self::$_elements[$form->settings['#id']])) {
            self::$_elements[$form->settings['#id']] = [];
        }
        self::$_elements[$form->settings['#id']][$data['#id']] = $data['#id'];
        if (!isset($form->settings['#pre_render']['select2'])) {
            $form->settings['#pre_render']['select2'] = array($this, 'select2Callback');
        }
    }

    public function formFieldSubmit(&$value, array &$data, Form $form)
    {
        // Is it a required field?
        if (is_null($value)) {
            if ($form->isFieldRequired($data)) {
                $form->setError(isset($data['#required_error_message']) ? $data['#required_error_message'] : __('Selection is required for this field.', 'directories'), $data);
            }
            $value = $data['#multiple'] ? [] : null;

            return;
        }

        $new_value = (array)$value;

        if (empty($new_value) && $form->isFieldRequired($data)) {
            $form->setError(isset($data['#required_error_message']) ? $data['#required_error_message'] : __('Selection is required for this field.', 'directories'), $data);
            return;
        }

        if (!$data['#multiple']) {
            $value = isset($new_value[0]) ? $new_value[0] : null;
            return;
        }

        if (!empty($data['#max_selection']) && count($new_value) > $data['#max_selection']) {
            $form->setError(sprintf(__('Maximum of %d selections is allowed for this field.', 'directories'), $data['#max_selection']), $data);
            return;
        }
        $value = $new_value;
    }

    public function formFieldRender(array &$data, Form $form)
    {
        if ($data['#multiple']) {
            $data['#attributes']['multiple'] = 'multiple';
            $name = $data['#name'] . '[]';
            if (isset($data['#size']) && $data['#size'] > 1) {
                $data['#attributes']['size'] = $data['#size'];
            }
        } else {
            unset($data['#attributes']['multiple']);
            $name = $data['#name'];

            if (isset($values[0])) {
                $data['#attributes']['data-default-value'] = $values[0];
            }
        }

        if (isset($data['#iconset'])) {
            $data['#attributes']['data-iconset'] = $data['#iconset'];
        }

        $select = sprintf(
            '<select class="%sform-control %s" name="%s"%s></select>',
            DRTS_BS_PREFIX,
            isset($data['#attributes']['class']) ? $this->_application->H($data['#attributes']['class']) : '',
            $name,
            $this->_application->Attr($data['#attributes'], 'class')
        );

        $has_addon = false;
        $html = [];
        if (isset($data['#field_prefix'])) {
            if (empty($data['#field_prefix_no_addon'])) {
                $has_addon = true;
                $html[] = '<div class="' . DRTS_BS_PREFIX . 'input-group-prepend"><span class="' . DRTS_BS_PREFIX . 'input-group-text">' . $data['#field_prefix'] . '</span></div>';
            } else {
                $html[] = $data['#field_prefix'];
            }
        }
        $html[] = $select;
        if (isset($data['#field_suffix'])) {
            if (empty($data['#field_suffix_no_addon'])) {
                $has_addon = true;
                $html[] = '<div class="' . DRTS_BS_PREFIX . 'input-group-append"><span class="' . DRTS_BS_PREFIX . 'input-group-text">' . $data['#field_suffix'] . '</span></div>';
            } else {
                $html[] = $data['#field_suffix'];
            }
        }

        $this->_render($has_addon ? '<div class="' . DRTS_BS_PREFIX . 'input-group">' . implode(PHP_EOL, $html) . '</div>' : implode(PHP_EOL, $html), $data, $form);
    }

    public function select2Callback(Form $form)
    {
        $this->_application->Form_Scripts_select2();
        $this->_application->getPlatform()->addJsFile('form-field-icon.min.js', 'drts-form-field-icon', array('drts-form'));
        foreach (self::$_elements[$form->settings['#id']] as $id) {
            $form->settings['#js_ready'][] = sprintf('DRTS.Form.field.icon("#%s");', $id);
        }
    }
}
