<?php
namespace SabaiApps\Directories\Component\Payment\DashboardPanel;

use SabaiApps\Directories\Component\Dashboard;

class OrdersDashboardPanel extends Dashboard\Panel\AbstractPanel
{    
    protected function _dashboardPanelInfo()
    {   
        return array(
            'weight' => 10,
        );
    }
    
    public function dashboardPanelLabel()
    {
        return __('Orders', 'directories-payments');
    }
    
    protected function _dashboardPanelLinks()
    {
        if (!$this->_application->getComponent('Payment')->getPaymentComponent()) return;
        
        return array(
            'all' => array(
                'title' => __('All Orders', 'directories-payments'),
                'icon' => 'fas fa-history',
            )
        );
    }
    
    public function dashboardPanelContent($link, array $params)
    {
        return $this->_application->getPlatform()->render(
            $this->_application->getComponent('Dashboard')->getPanelUrl('payment_orders', $link, '/payment_orders', [], true)
        );
    }
}