<?php
namespace SabaiApps\Directories\Component\Payment\Controller;

use SabaiApps\Directories\Controller;
use SabaiApps\Directories\Context;

class PricingTable extends Controller
{
    protected function _doExecute(Context $context)
    {
        $settings = $this->_getSettings($context);
        $plans = $this->Payment_Plans($context->bundle->name, 'base');
        // Specific plans only?
        if (isset($settings['plans'])) {
            if (is_string($settings['plans'])) {
                $settings['plans'] = explode(',', trim($settings['plans']));
            }
            if (!empty($settings['plans'])) {
                $_plans = [];
                // Filter and sort as specified
                foreach ($settings['plans'] as $plan_id) {
                    if (isset($plans[$plan_id])) {
                        $_plans[$plan_id] = $plans[$plan_id];
                    }
                }
                $plans = $_plans;
            }
        }
        
        $max_feature_count = 0;
        $has_featured = false;
        foreach (array_keys($plans) as $plan_id) {
            $plan = $plans[$plan_id];
            $features = $this->Payment_Features_render($plan);
            $feature_count = count($features);
            if ($feature_count > $max_feature_count) {
                $max_feature_count = $feature_count;
            }
            if (!$has_featured) {
                $has_featured = $plan->paymentPlanIsFeatured();
            }
            $plans[$plan_id] = array(
                'title' => $plan->paymentPlanTitle(),
                'description' => $plan->paymentPlanDescription(),
                'price' => $plan->paymentPlanPrice(true),
                'featured' => $plan->paymentPlanIsFeatured(),
                'features' => $features,
                'order_url' => $this->Url(
                    '/' . $this->FrontendSubmit_AddEntitySlug($context->bundle->type),
                    array('bundle' => $context->bundle->name, 'plan' => $plan_id)
                ),
            );
        }
        $this->getPlatform()->addCssFile('payment-pricing-table.min.css', 'drts-payment-pricing-table', array('drts'), 'directories-payments');
        $context->addTemplate($this->getPlatform()->getAssetsDir('directories-payments') . '/templates/payment_pricing_table')
            ->setAttributes(array(
                'plans' => $plans,
                'max_feature_count' => $max_feature_count,
                'has_featured' => $has_featured,
            ) + $settings);
    }
    
    protected function _getSettings(Context $context)
    {   
        $settings = $context->settings ?: [];
        $settings += array(
            'plans' => null,
            'layout' => 'group',
            'color' => 'primary',
            'btn_text' => __('Choose Plan', 'directories-payments'),
        );
        $settings += array(
            'btn_color' => in_array($settings['color'], array('dark', 'light')) ? 'outline-secondary' : 'outline-' . $settings['color'],
            'featured_text_color' => in_array($settings['color'], array('dark', 'light')) ? 'secondary' : 'white',
            'featured_border_color' => $settings['color'],
            'featured_bg_color' => $settings['color'],
            'featured_btn_color' => in_array($settings['color'], array('dark', 'light')) ? 'outline-secondary' : 'outline-light',
        );
        if (!in_array($settings['layout'], array('group', 'deck'))) {
            $settings['layout'] = 'group';
        }
        
        return $settings;
    }
}