<?php
namespace SabaiApps\Directories\Component\Payment\Controller;

use SabaiApps\Directories\Component\FrontendSubmit;
use SabaiApps\Directories\Component\Form;
use SabaiApps\Directories\Context;

class OrderAddon extends FrontendSubmit\Controller\AbstractSubmitEntity
{
    protected function _getSteps(Context $context, array &$formStorage)
    {    
        if ($this->Payment_Util_hasPendingOrder($context->entity)) {
            $context->setError(
                __('There are currently one or more pending orders for the item selected.', 'directories-payments'),
                '/' . $this->getPlatform()->getSlug('Dashboard', 'dashboard')
            );
            return;
        }

        return array('select_plan' => array('order' => 3));
    }

    public function _getFormForStepSelectPlan(Context $context, array &$formStorage)
    {
        $form = $this->Payment_Plans_form($this->_getEntity($context, $formStorage), 'addon');
        if (empty($form['plan']['#options'])) {
            $this->_submitable = false;
        } else {
            $this->_submitable = true;
            $this->_submitButtons[] = array(
                '#btn_color' => 'primary',
                '#btn_label' => __('Add to cart', 'directories-payments'),
            );
        }
        return $form;
    }

    public function _submitFormForStepSelectPlan(Context $context, Form\Form $form)
    {
        if ((!$plan = $this->_getSelectedPlan($context, $form->storage))
            || (!$entity = $this->_getEntity($context, $form->storage))
        ) return false; // this should not happen

        $this->getComponent('Payment')->getPaymentComponent(true)
            ->paymentOnSubmit($entity, $plan, 'order_addon');
    }

    protected function _getSelectedPlan(Context $context, array $formStorage)
    {
        if (!empty($formStorage['values']['select_plan']['plan'])) {
            return $this->getComponent('Payment')->getPaymentComponent(true)
                ->paymentGetPlan($formStorage['values']['select_plan']['plan']);
        }
    }

    protected function _getEntity(Context $context, array $formStorage)
    {
        return $context->entity;
    }

    protected function _complete(Context $context, array $formStorage)
    {
        $context->setSuccess($this->getComponent('Payment')->getPaymentComponent(true)->paymentSuccessUrl());
    }
}
