<?php
namespace SabaiApps\Directories\Component\Location\Helper;

use SabaiApps\Directories\Application;

class ApiHelper
{
    /**
     * Loads GoogleMaps API
     * @param Application $application
     * @param array $options
     */
    public function load(Application $application, array $options = [])
    {
        $application->Map_Api_load($options);

        if (!empty($options['map'])) {
            $application->getPlatform()
                ->addJsFile('location-map.min.js', 'drts-location-map', array('drts-map-map'), 'directories-pro');
        }
        if (!empty($options['textfield'])) {
            $application->getPlatform()
                ->addJsFile('location-textfield.min.js', 'drts-location-textfield', array('drts'), 'directories-pro');
        }
        if (!empty($options['sticky'])) {
            $application->getPlatform()
                ->addJsFile('jquery.sticky.min.js', 'jquery-jsticky', 'jquery', 'directories-pro')
                ->loadImagesLoadedJs();
        }
    }
    
    public function countyCodeFormField(Application $application, $value = null, $title = null)
    {
        return array(
            '#title' => isset($title) ? $title : __('Country code', 'directories-pro'),
            '#description' => __('Enter one of the <a href="http://en.wikipedia.org/wiki/ISO_3166-1_alpha-2" target="_blank">two-letter country codes</a> to restrict location autocomplete suggestions to a specific country.', 'directories-pro'),
            '#description_no_escape' => true,
            '#type' => 'textfield',
            '#size' => 3,
            '#default_value' => $value,
            '#min_length' => 2,
            '#max_length' => 2,
        );
    }
}