'use strict';

(function($) {
  DRTS.Location = DRTS.Location || {};
  DRTS.Location.textfield = DRTS.Location.textfield || function(selector) {
    var $field = $(selector);
    if (!$field.length) return;

    var $input = $field.find('.drts-location-text-input'),
      $center = $field.find('.drts-location-text-center'),
      $viewport = $field.find('.drts-location-text-viewport'),
      $zoom = $field.find('.drts-location-text-zoom'),
      $radius = $field.find('.drts-location-text-radius'),
      radius_is_slider = $radius.hasClass('drts-location-text-radius-slider'),
      resetRadius = function resetRadius() {
        if (radius_is_slider) {
          $radius.data('ionRangeSlider').reset();
        } else {
          $radius.val('');
        }
      };

    if ($input.length) {
      var options = {
          suggest_place: typeof $field.data('suggest-place') === 'undefined' ? true : $field.data('suggest-place') || false,
          suggest_place_header: $field.data('suggest-place-header') || '',
          suggest_place_footer: $field.data('suggest-place-footer') || '',
          suggest_place_icon: $field.data('suggest-place-icon') || 'fas fa-map-pin',
          suggest_place_country: $field.data('suggest-place-country') || null,
          suggest_place_type: $field.data('suggest-place-type') || '(regions)',
          suggest_location: $field.data('suggest-location'),
          suggest_location_header: $field.data('suggest-location-header') || '',
          suggest_location_icon: $field.data('suggest-location-icon') || '',
          suggest_location_url: $field.data('suggest-location-url') || null,
          suggest_location_count: $field.data('suggest-location-count') || null,
          suggest_location_parents: $field.data('suggest-location-parents') || false,
          geolocation: typeof $field.data('geolocation') === 'undefined' ? true : $field.data('geolocation') || false
        },
        $term_id = $field.find('.drts-location-text-term-id'),
        $taxonomy = $field.find('.drts-location-text-taxonomy'),
        $clear = $field.find('.drts-clear').css('visibility', $input.val().length > 0 ? 'visible' : 'hidden'),
        geocoder,
        datasets = [];
      //if ($slider.length) {
      //    var radius_timeout = null;
      //    $input.focus(function(){
      //        if (!$term_id.val()) {                
      //            $slider.slideDown('fast');
      //        } else {
      //            $slider.slideUp('fast');
      //        }
      //        if (radius_timeout !== null) {
      //            clearTimeout(radius_timeout);
      //        }
      //        radius_timeout = setTimeout(function(){
      //            if ($input.is(':focus')) {
      //                $input.trigger('focus');
      //            } else {
      //                $slider.slideUp('fast');
      //            }
      //        }, 3000);
      //    });
      //    $slider.on('slidestart slidechange', function(e) {
      //        if (radius_timeout !== null) {
      //            clearTimeout(radius_timeout);
      //            radius_timeout = setTimeout(function(){$slider.slideUp('fast');}, e.type === 'slidestart' ? 10000 : 5000);
      //        }
      //    });
      //}

      if (options.suggest_location && options.suggest_location_url) {
        var taxonomy_templates = {},
          taxonomy_terms = new Bloodhound({
            datumTokenizer: Bloodhound.tokenizers.obj.whitespace('title', 'pt'),
            queryTokenizer: Bloodhound.tokenizers.whitespace,
            prefetch: {
              url: options.suggest_location_url
            }
          });
        if (options.suggest_location_header) {
          taxonomy_templates.header = '<h4>' + options.suggest_location_header + '</h4>';
        }
        taxonomy_templates.suggestion = function(item) {
          var title = item.title;
          if (options.suggest_location_count) {
            title += ' (' + (item.count || '0') + ')';
          }
          if (options.suggest_location_parents && item.pt) {
            title = item.pt.join(' -> ') + ' -> ' + title;
          }
          var div = $('<div/>').html($('<span />').text(title)),
            i;
          if (item.icon_src) {
            i = $('<img/>').attr('class', 'drts-icon drts-icon-sm').attr('src', item.icon_src);
          } else if (options.suggest_location_icon) {
            i = $('<i/>').attr('class', 'drts-icon drts-icon-sm ' + options.suggest_location_icon);
          }
          if (i) div.prepend(i);

          return div[0].outerHTML;
        };
        datasets.push({
          name: options.suggest_location,
          source: function source(q, sync, async) {
            if (q.length > 0) {
              taxonomy_terms.search(q, sync, async);
            }
          },
          display: 'title',
          templates: taxonomy_templates,
          limit: $field.data('suggest-location-num') || 100
        });
      }

      if (typeof google !== 'undefined' && google.maps) {
        if (options.suggest_place) {
          var autocomplete,
            location_templates = {},
            prediction_args;
          if (options.suggest_place_header) {
            location_templates.header = $('<h4/>').text(options.suggest_place_header)[0].outerHTML;
          }
          if (options.suggest_place_icon) {
            location_templates.suggestion = function(item) {
              var div = $('<div/>');
              div.append($('<i/>').attr('class', 'drts-icon drts-icon-sm ' + options.suggest_place_icon)).append($('<span/>').text(item.description));
              return div[0].outerHTML;
            };
          }
          if (options.suggest_place_footer) {
            location_templates.footer = $('<div/>').attr('class', 'tt-footer').css({
              'text-align': 'right',
              margin: '0 5px 3px'
            }).html(options.suggest_place_footer)[0].outerHTML;
          }

          datasets.push({
            name: 'place',
            display: 'description',
            templates: location_templates,
            source: function source(q, sync, async) {
              if (q === '') return;
              if (!autocomplete) autocomplete = new google.maps.places.AutocompleteService();
              if (!prediction_args) {
                prediction_args = {
                  types: [options.suggest_place_type],
                  componentRestrictions: {}
                };
                if (options.suggest_place_country) {
                  prediction_args.componentRestrictions.country = options.suggest_place_country;
                }
              }
              prediction_args.input = q;
              console.log(prediction_args);
              autocomplete.getPlacePredictions(prediction_args, function(predictions, status) {
                if (status === google.maps.places.PlacesServiceStatus.OK) {
                  async (predictions);
                }
              });
            }
          });
        }

        if (options.geolocation && navigator.geolocation && (document.location.protocol === 'https:' || document.location.hostname === 'localhost')) {
          var geolocate = function geolocate(trigger) {
            var success = false;
            $input.addClass('drts-ajax-loading');
            if (!geocoder) geocoder = new google.maps.Geocoder();
            navigator.geolocation.getCurrentPosition(function(pos) {
              $input.removeClass('drts-ajax-loading');
              success = true;
              geocoder.geocode({
                'latLng': new google.maps.LatLng(pos.coords.latitude, pos.coords.longitude)
              }, function(results, status) {
                if (status === google.maps.GeocoderStatus.OK) {
                  $input.val(results[0].formatted_address).typeahead('val', results[0].formatted_address);
                  $taxonomy.val('');
                  $term_id.val('');
                  $viewport.val('');
                  $zoom.val('');
                  if (!radius_is_slider) $radius.val(1);
                  $clear.css('visibility', $input.val().length > 0 ? 'visible' : 'hidden');
                  var center = results[0].geometry.location.lat() + ',' + results[0].geometry.location.lng();
                  if (center !== $center.val()) {
                    $center.val(center);
                    $input.trigger('change');
                  }
                }
              });
            }, function(error) {
              $input.removeClass('drts-ajax-loading');
              if (!success) {
                DRTS.flash(error.message, 'danger');
              }
              console.log(error.message + ' (' + error.code + ')');
            }, {
              enableHighAccuracy: true,
              timeout: 5000
            });
          };
          datasets.push({
            name: 'geolocate',
            source: function source(q, sync) {
              sync([{
                content: ''
              }]);
            },
            display: 'content',
            templates: {
              suggestion: function suggestion() {
                var i = $('<i/>').attr('class', 'drts-icon drts-icon-sm fas fa-location-arrow');
                return $('<div/>').html($('<span/>').text($field.data('geolocation-text') || 'Current location')).prepend(i)[0].outerHTML;
              }
            }
          });
        } else {
          $field.addClass('drts-location-no-geolocation');
        }
      } else {
        $field.addClass('drts-location-no-geolocation');
      }

      if (datasets.length) {
        $input.typeahead({
          highlight: true,
          minLength: 0 // needs to be 0 to show taxonoy options by default
        }, datasets);
        var geocoder_args;
        $input.on('typeahead:select', function(e, item, name) {
          $center.val('');
          $viewport.val('');
          $zoom.val('');
          if (!radius_is_slider) resetRadius();
          if (name === options.suggest_location) {
            $taxonomy.val(options.suggest_location);
            $term_id.val(item.id);
            $input.trigger('change');
          } else if (name === 'place') {
            $taxonomy.val('');
            $term_id.val('');
            if (typeof google !== 'undefined' && google.maps) {
              if (!geocoder) {
                geocoder = new google.maps.Geocoder();
              }
              if (!geocoder_args) {
                geocoder_args = options.suggest_place_country ? {
                  region: options.suggest_place_country
                } : {};
              }
              geocoder_args.address = $input.val();
              geocoder.geocode(geocoder_args, function(results, status) {
                switch (status) {
                  case google.maps.GeocoderStatus.OK:
                    $center.val(results[0].geometry.location.lat() + ',' + results[0].geometry.location.lng());
                    $input.trigger('change');
                    break;
                  case google.maps.GeocoderStatus.ZERO_RESULTS:
                    alert('Invalid location');
                    break;
                  default:
                    alert(status);
                }
              });
            }
          } else if (name === 'geolocate') {
            geolocate();
          }
          //$input.blur();
          $clear.css('visibility', $input.val().length > 0 ? 'visible' : 'hidden');
        }).on('keyup', function(e) {
          if (e.keyCode !== 13 && e.keyCode !== 27 && e.keyCode !== 32) {
            $taxonomy.val('');
            $term_id.val('');
            $center.val('');
            $viewport.val('');
            $zoom.val('');
            if (!radius_is_slider) resetRadius();
            $clear.css('visibility', $input.val().length > 0 ? 'visible' : 'hidden');
          }
        }).on('typeahead:open', function() {
          $input.closest('.twitter-typeahead').addClass('twitter-typeahead-open');
        }).on('typeahead:close', function() {
          $input.closest('.twitter-typeahead').removeClass('twitter-typeahead-open');
        });

        $clear.click(function() {
          $taxonomy.val('');
          $term_id.val('');
          $center.val('');
          $viewport.val('');
          $zoom.val('');
          if (!radius_is_slider) resetRadius();
          $clear.css('visibility', 'hidden');
          $input.typeahead('val', '').focus().trigger('change');
        });
      } else {
        $input.bind('keyup', function(e) {
          if (e.keyCode !== 13 && e.keyCode !== 27 && e.keyCode !== 32) {
            $clear.css('visibility', $input.val().length > 0 ? 'visible' : 'hidden');
          }
        });
        $clear.click(function() {
          $clear.css('visibility', 'hidden');
          $input.val('').focus().trigger('change');
        });
      }

      if (radius_is_slider) {
        $radius.on('change', function() {
          if ($zoom.val()) return; // current map view is being requested, so keep viewport and ignore radius

          $viewport.val('');
        });
      }
    }

    $field.on('entity_reset_form_field.sabai', function() {
      if ($input.length) {
        if (datasets.length) {
          $input.typeahead('val', '');
        } else {
          $input.val('');
        }
        $taxonomy.val('');
        $term_id.val('');
      }
      $center.val('');
      $viewport.val('');
      $zoom.val('');
      resetRadius();
    });
  };
})(jQuery);