<?php

    /**
     * ReduxFramework Barebones Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }
	load_theme_textdomain('capital', CAPITAL_FILEPATH . '/language');
    // This is your option name where all the Redux data is stored.
    $opt_name = "capital_options";

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => esc_html__( 'Theme Options', 'capital' ),
        'page_title'           => esc_html__( 'Theme Options', 'capital' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => true,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-portfolio',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => true,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => 57,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => '_options',
        // Page slug used to denote the panel
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!

        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'light',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    // ADMIN BAR LINKS -> Setup custom links in the admin bar menu as external items.
    $args['share_icons'][] = array(
        'url'   => 'https://www.facebook.com/imithemes',
        'title' => 'Like us on Facebook',
        'icon'  => 'el el-facebook'
    );
    $args['share_icons'][] = array(
        'url'   => 'https://twitter.com/imithemes',
        'title' => 'Follow us on Twitter',
        'icon'  => 'el el-twitter'
    );

    // Panel Intro text -> before the form
    if ( ! isset( $args['global_variable'] ) || $args['global_variable'] !== false ) {
        if ( ! empty( $args['global_variable'] ) ) {
            $v = $args['global_variable'];
        } else {
            $v = str_replace( '-', '_', $args['opt_name'] );
        }
    } else {
    }

    Redux::setArgs( $opt_name, $args );

    // Set the help sidebar
    $content = __( '<p>This is the sidebar content, HTML is allowed.</p>', 'capital' );
    Redux::setHelpSidebar( $opt_name, $content );

	load_theme_textdomain('capital', CAPITAL_FILEPATH . '/language');
	$defaultAdminLogo = get_template_directory_uri().'/images/logo-admin.png';
	$default_logo = get_template_directory_uri() . '/images/logo.png';
	$default_retina_logo = get_template_directory_uri() . '/images/logo@2x.png';

    // -> START Basic Fields
    Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-cogs',
    'icon_class' => 'icon-large',
    'title' => esc_html__('General', 'capital'),
    'fields' => array(
        array(
            'id' => 'enable_maintenance',
            'type' => 'switch',
            'title' => esc_html__('Enable Maintenance', 'capital'),
            'subtitle' => esc_html__('Enable the themes in maintenance mode.', 'capital'),
            "default" => false,
            'on' => esc_html__('Enabled', 'capital'),
            'off' => esc_html__('Disabled', 'capital'),
        ),
        array(
            'id' => 'enable_backtotop',
            'type' => 'switch',
            'title' => esc_html__('Enable Back To Top', 'capital'),
            'subtitle' => esc_html__('Enable the back to top button that appears in the bottom right corner of the screen.', 'capital'),
            "default" => 1,
        ),
        array(
            'id' => 'custom_admin_login_logo',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Custom admin login logo', 'capital'),
            'compiler' => 'true',
            'desc' => esc_html__('Upload a 254 x 95px image here to replace the default wordpress login logo.', 'capital'),
            'default' => array('url' => $defaultAdminLogo),
        ),
       array(
            'id' => 'space-before-head',
            'type' => 'ace_editor',
            'title' => esc_html__('Space before closing head tag', 'capital'),
            'subtitle' => esc_html__('Add your code before closing head tag', 'capital'),
			'default' => '',
        ),
       array(
            'id' => 'space-before-body',
            'type' => 'ace_editor',
            'title' => esc_html__('Space before closing body tag', 'capital'),
            'subtitle' => esc_html__('Add your code before closing body tag', 'capital'),
			'default' => '',
        ),
    )
));

Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-website',
    'icon_class' => 'icon-large',
    'title' => esc_html__('Responsive', 'capital'),
    'fields' => array(
        array(
            'id' => 'switch-responsive',
            'type' => 'switch',
            'title' => esc_html__('Enable Responsive', 'capital'),
            'subtitle' => esc_html__('Enable/Disable the responsive behaviour of the theme', 'capital'),
            "default" => 1,
        ),
    )
));

Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-screen',
    'icon_class' => 'icon-large',
    'title' => esc_html__('Layout', 'capital'),
    'fields' => array(
        array(
			'id'=>'site_width',
			'type' => 'text',
			'compiler'=>true,
			'title' => esc_html__('Site Width', 'capital'), 
			'subtitle' => esc_html__('Controls the overall site width. Without px, ex: 1170(Default). Recommended maximum width is 1170 to maintain the theme structure.', 'capital'),
			'default' => '1170',
		),
        array(
			'id'=>'site_layout',
			'type' => 'image_select',
			'compiler'=>true,
			'title' => esc_html__('Page Layout', 'capital'), 
			'subtitle' => esc_html__('Select the page layout type', 'capital'),
			'options' => array(
					'wide' => array('alt' => 'Wide', 'img' => get_template_directory_uri().'/images/wide.png'),
					'boxed' => array('alt' => 'Boxed', 'img' => get_template_directory_uri().'/images/boxed.png')
				),
			'default' => 'wide',
			),
		array(
			'id'=>'repeatable-bg-image',
			'type' => 'image_select',
			'required' => array('site_layout','equals','boxed'),
			'title' => esc_html__('Repeatable Background Images', 'capital'), 
			'subtitle' => esc_html__('Select image to set in background.', 'capital'),
			'options' => array(
				'pt1.png' => array('alt' => 'pt1', 'img' => get_template_directory_uri().'/images/patterns/pt1.png'),
				'pt2.png' => array('alt' => 'pt2', 'img' => get_template_directory_uri().'/images/patterns/pt2.png'),
				'pt3.png' => array('alt' => 'pt3', 'img' => get_template_directory_uri().'/images/patterns/pt3.png'),
				'pt4.png' => array('alt' => 'pt4', 'img' => get_template_directory_uri().'/images/patterns/pt4.png'),
				'pt5.png' => array('alt' => 'pt5', 'img' => get_template_directory_uri().'/images/patterns/pt5.png'),
				'pt6.png' => array('alt' => 'pt6', 'img' => get_template_directory_uri().'/images/patterns/pt6.png'),
				'pt7.png' => array('alt' => 'pt7', 'img' => get_template_directory_uri().'/images/patterns/pt7.png'),
				'pt8.png' => array('alt' => 'pt8', 'img' => get_template_directory_uri().'/images/patterns/pt8.png'),
				'pt9.png' => array('alt' => 'pt9', 'img' => get_template_directory_uri().'/images/patterns/pt9.png'),
				'pt10.png' => array('alt' => 'pt10', 'img' => get_template_directory_uri().'/images/patterns/pt10.png'),
				'pt11.jpg' => array('alt' => 'pt11', 'img' => get_template_directory_uri().'/images/patterns/pt11.png'),
				'pt12.jpg' => array('alt' => 'pt12', 'img' => get_template_directory_uri().'/images/patterns/pt12.png'),
				'pt13.jpg' => array('alt' => 'pt13', 'img' => get_template_directory_uri().'/images/patterns/pt13.png'),
				'pt14.jpg' => array('alt' => 'pt14', 'img' => get_template_directory_uri().'/images/patterns/pt14.png'),
				'pt15.jpg' => array('alt' => 'pt15', 'img' => get_template_directory_uri().'/images/patterns/pt15.png'),
				'pt16.png' => array('alt' => 'pt16', 'img' => get_template_directory_uri().'/images/patterns/pt16.png'),
				'pt17.png' => array('alt' => 'pt17', 'img' => get_template_directory_uri().'/images/patterns/pt17.png'),
				'pt18.png' => array('alt' => 'pt18', 'img' => get_template_directory_uri().'/images/patterns/pt18.png'),
				'pt19.png' => array('alt' => 'pt19', 'img' => get_template_directory_uri().'/images/patterns/pt19.png'),
				'pt20.png' => array('alt' => 'pt20', 'img' => get_template_directory_uri().'/images/patterns/pt20.png'),
				'pt21.png' => array('alt' => 'pt21', 'img' => get_template_directory_uri().'/images/patterns/pt21.png'),
				'pt22.png' => array('alt' => 'pt22', 'img' => get_template_directory_uri().'/images/patterns/pt22.png'),
				'pt23.png' => array('alt' => 'pt23', 'img' => get_template_directory_uri().'/images/patterns/pt23.png'),
				'pt24.png' => array('alt' => 'pt24', 'img' => get_template_directory_uri().'/images/patterns/pt24.png'),
				'pt25.png' => array('alt' => 'pt25', 'img' => get_template_directory_uri().'/images/patterns/pt25.png'),
				'pt26.png' => array('alt' => 'pt26', 'img' => get_template_directory_uri().'/images/patterns/pt26.png'),
				'pt27.png' => array('alt' => 'pt27', 'img' => get_template_directory_uri().'/images/patterns/pt27.png'),
				'pt28.png' => array('alt' => 'pt28', 'img' => get_template_directory_uri().'/images/patterns/pt28.png'),
				'pt29.png' => array('alt' => 'pt29', 'img' => get_template_directory_uri().'/images/patterns/pt29.png'),
				'pt30.png' => array('alt' => 'pt30', 'img' => get_template_directory_uri().'/images/patterns/pt30.png')
				)
			),	
		array(
			'id'=>'upload-repeatable-bg-image',
			'compiler'=>true,
			'required' => array('site_layout','equals','boxed'),
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Upload Repeatable Background Image', 'capital')
			),
		array(
			'id'=>'full-screen-bg-image',
			'compiler'=>true,
			'required' => array('site_layout','equals','boxed'),
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Upload Full Screen Background Image', 'capital')
		),	
    )
));

Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Content', 'capital'),
	'subsection' => true,
    'fields' => array(
		array(  'id' => 'content_background',
				'type' => 'background',
				'background-color'=> true,
				'compiler' => array('.content'),
				//'output' => array('.content'), Use this field to add inline css on page, above compiler argument should removed
				'title' => esc_html__('Content area Background', 'capital'),
    			'subtitle' => esc_html__('Background color or image for the content area. This works for both boxed or wide layouts.', 'capital'),
		),
		array(
			'id'       => 'content_padding',
			'type'     => 'spacing',
			'units'    => array('px'),
			'mode'	   => 'padding',
			'left'	   => false,
			'right'	   => false,
			'compiler'   => array('.content'),
			'title'    => esc_html__('Top and Bottom padding for content area', 'capital'),
			'subtitle' => esc_html__('Enter top and bottom padding for content area. Default is 50px/50px', 'capital'),
			'default'            => array(
			'padding-top'     => '60px',
			'padding-bottom'  => '60px',
			'units'          => 'px',
			),
		),
		array(
			'id'       => 'content_min_height',
			'type'     => 'text',
			'title'    => esc_html__('Minimum Height for Content area', 'capital'),
			'subtitle' => esc_html__('Enter minimum height for the page content area. DO NOT PUT px HERE. Default is 400', 'capital'),
			'default'  => '400'
		),
        array(
			'id'=>'content_wide_width',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('100% Content Width', 'capital'), 
			'subtitle' => esc_html__('Check this box to set the content area to 100% of the browser width. Uncheck to follow site width.', 'capital'),
			'default' => '0',
		),

	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-chevron-up',
    'title' => esc_html__('Header', 'capital'),
    'desc' => esc_html__('These are the options for the header.', 'capital'),
    'fields' => array(
		array(
    		'id' => 'header_layout',
    		'type' => 'image_select',
    		'compiler'=>true,
			'title' => esc_html__('Header Style','capital'), 
			'subtitle' => esc_html__('Select header style for your website', 'capital'),
    			'options' => array(
					'1' => array('title' => '', 'img' => get_template_directory_uri().'/images/headerlayouts/1.png'),
    				'2' => array('title' => '', 'img' => get_template_directory_uri().'/images/headerlayouts/2.png'),
    				'3' => array('title' => '', 'img' => get_template_directory_uri().'/images/headerlayouts/3.png'),
    				'4' => array('title' => '', 'img' => get_template_directory_uri().'/images/headerlayouts/4.png'),
    				'5' => array('title' => '', 'img' => get_template_directory_uri().'/images/headerlayouts/5.png'),
    				'6' => array('title' => '', 'img' => get_template_directory_uri().'/images/headerlayouts/6.png'),
    				'7' => array('title' => '', 'img' => get_template_directory_uri().'/images/headerlayouts/7.png'),
    				'8' => array('title' => '', 'img' => get_template_directory_uri().'/images/headerlayouts/8.png'),
    				'9' => array('title' => '', 'img' => get_template_directory_uri().'/images/headerlayouts/9.png'),
    				'10' => array('title' => '', 'img' => get_template_directory_uri().'/images/headerlayouts/10.png'),
    				'11' => array('title' => '', 'img' => get_template_directory_uri().'/images/headerlayouts/11.png')
    				),
    		'default' => '1'
    	),
		array(
			'id'      => 'header_left_blocks',
			'type'    => 'sorter',
			'title'   => 'Header left content',
			'subtitle'    => esc_html__('Drag/Drop the blocks to organize how you want the layout in the site header. Selected blocks here will appear at the left side of header, for right side see below. -- For header style 3, logo position is fixed at left and this section is for header right top. -- For header style 4, menu position is fixed at the bottom. -- For header style 5 and 6 menu is fixed at bottom along with optional search, cart. -- For header style 10 logo is fixed in the header center and menu at bottom.','capital'),
			'options' => array(
				'enabled'  => array(
					'logo' => esc_html__('Logo','capital'),
					'menu'     => esc_html__('Menu','capital'),
				),
				'disabled' => array(
					'featured-button1' => esc_html__('Featured Btn 1','capital'),
					'featured-button2' => esc_html__('Featured Btn 2','capital'),
					'featured-button3' => esc_html__('Featured Btn 3','capital'),
					'cart'     			=> esc_html__('Cart','capital'),
					'header-info1'     => esc_html__('Header Info 1','capital'),
					'header-info2'     => esc_html__('Header Info 2','capital'),
					'header-info3'     => esc_html__('Header Info 3','capital'),
					'social-icons'     => esc_html__('Social Icons','capital'),
					'widgets-opener'     => esc_html__('Widgets opener','capital'),
					'search'     => esc_html__('Search','capital'),
				)
			),
		),
		array(
			'id'      => 'header_right_blocks',
			'type'    => 'sorter',
			'title'   => 'Header right content',
			'subtitle'    => esc_html__('Drag/Drop the blocks to organize how you want the layout in the site header. Selected blocks here will appear at the right side of header, for left side see above. -- For header style 3, logo position is fixed at left and this section is for header right bottom. -- For header style 4, menu position is fixed at the bottom. -- For header style 5 and 6 menu is fixed at bottom along with optional search, cart. -- For header style 10 logo is fixed in the header center and menu at bottom.','capital'),
			'options' => array(
				'enabled'  => array(
					'search'     => esc_html__('Search','capital'),
					'cart'     => esc_html__('Cart','capital'),
				),
				'disabled' => array(
					'logo' => esc_html__('Logo','capital'),
					'menu'     => esc_html__('Menu','capital'),
					'featured-button1' => esc_html__('Featured Btn 1','capital'),
					'featured-button2' => esc_html__('Featured Btn 2','capital'),
					'featured-button3' => esc_html__('Featured Btn 3','capital'),
					'header-info1'     => esc_html__('Header Info 1','capital'),
					'header-info2'     => esc_html__('Header Info 2','capital'),
					'header-info3'     => esc_html__('Header Info 3','capital'),
					'social-icons'     => esc_html__('Social Icons','capital'),
					'widgets-opener'     => esc_html__('Widgets opener','capital'),
				)
			),
		),
		array(
			'id'   => 'obuttons_h56',
    		'type' => 'section',
			'indent' => true,
			'title' => esc_html__('Option buttons for Header style 5 and 6','capital')
		),
        array(
			'id'=>'header45_cart',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Show cart option', 'capital'), 
			'subtitle' => esc_html__('Check this to show cart option at the right of menu in header style 5 and 6.', 'capital'),
			'default' => 0,
		),
        array(
			'id'=>'header45_search',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Show search option', 'capital'), 
			'subtitle' => esc_html__('Check this to show search option at the right of menu in header style 5 and 6.', 'capital'),
			'default' => 0,
		),
		array(
			'id'        => 'sheader_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Site header style','capital'),
			'subtitle'  => esc_html__('Use this section to style the site header.','capital'),
			'position'  => 'start',
		),
        array(
			'id'=>'header_wide_width',
			'type' => 'checkbox',
			'compiler'=>true,
			'required' => array('header_layout','!=','11'),
			'title' => esc_html__('100% header width', 'capital'), 
			'subtitle' => esc_html__('Check this box to set the header area to 100% of the browser width. Uncheck to follow site width.', 'capital'),
			'default' => 0,
		),
        array(
			'id'=>'header_no_side_padding',
			'type' => 'checkbox',
			'compiler'=>true,
			'required' => array('header_wide_width','=','1'),
			'title' => esc_html__('No space on left/right', 'capital'), 
			'subtitle' => esc_html__('Check this box to set the header area to 100% of the browser width with no space on the sides.', 'capital'),
			'default' => 0,
		),
        array(
			'id'=>'header_position_float',
			'type' => 'button_set',
			'required' => array('header_layout','!=','11'),
			'title' => esc_html__('Header position', 'capital'), 
			'subtitle' => esc_html__('Use floated if you want the content below header to go underneath the header. Use normal for header to stay above the content part.', 'capital'),
			'default' => 0,
			'options' => array(
				0  => esc_html__('Normal','capital'),
				1  => esc_html__('Floated','capital'),
			)
		),
        array(
			'id'=>'header_no_bg_strict',
			'type' => 'checkbox',
			'compiler'=>true,
			'required' => array('header_layout','!=','11'),
			'required' => array('header_position_float','=',1),
			'title' => esc_html__('No background color/image', 'capital'), 
			'subtitle' => esc_html__('Check this box if you want to have your header transparent with no background. This will work only with floated header position.', 'capital'),
			'default' => 0,
		),
        array(
			'id'=>'header_no_box_shadow',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('No shadow', 'capital'), 
			'subtitle' => esc_html__('Check this box if you want to remove the shadow from the site header.', 'capital'),
			'default' => 0,
		),
		array(  'id' => 'header_background_alpha',
			'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'transparent' => true,
			'compiler' => array('background-color'=>'.site-header,.header-style2 .site-header, .header-style7 .site-header, .header-style9 .site-header'),
			'title' => esc_html__('Header background color', 'capital')
		),
		array(  'id' => 'header_background',
			'type' => 'background',
			'transparent' => false,
			'background-color' => false,
			'compiler' => array('.site-header,.header-style2 .site-header, .header-style7 .site-header, .header-style9 .site-header'),
			'title' => esc_html__('Header background image', 'capital')
		),
		array(
			'id'=>'sheader11_side',
			'type' => 'button_set',
			'compiler'=>true,
			'required' => array('header_layout','=','11'),
			'title' => esc_html__('Site header position', 'capital'), 
			'subtitle' => esc_html__('Choose to which side you would like to show header for Header style 11.', 'capital'),
			'options' => array(
					1 => esc_html__('Left','capital'),
					2 => esc_html__('Right','capital')
				),
			'default' => 1,
		),
		array(
			'id'=>'sheader11_width',
			'type' => 'dimensions',
			'compiler'=>true,
			'height' => false,
			'required' => array('header_layout','=','11'),
			'compiler' => array('.header-style11 .site-header'),
			'title' => esc_html__('Site header width', 'capital'), 
			'subtitle' => esc_html__('Enter value in pixels for the header (Header style 11).', 'capital'),
		),
		array(
			'id'=>'sheader11_padding',
			'type' => 'spacing',
			'compiler'=>true,
			'units' => array('px'),
			'mode' => 'padding',
			'required' => array('header_layout','=','11'),
			'compiler' => array('.header-style11 .site-header'),
			'title' => esc_html__('Site header spacing', 'capital'), 
			'subtitle' => esc_html__('Enter value in pixels for the header round side spacing (Header style 11).', 'capital'),
		),
		array(
			'id'        => 'sheader_style_end',
			'type'      => 'accordion',
			'position'  => 'end',
		),
		array(
			'id'        => 'shmenu_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Main menu style','capital'),
			'subtitle'  => esc_html__('Use this section to style the maine menu for the site header.','capital'),
			'position'  => 'start',
		),
		array(
			'id'=>'dd_menu_style',
			'type' => 'select',
			'compiler'=>true,
			'title' => esc_html__('Menu style', 'capital'), 
			'options' => array(
					'dd-style1' => esc_html__('Style 1','capital'),
					'dd-style2' => esc_html__('Style 2','capital'),
					'dd-style3' => esc_html__('Style 3','capital'),
				),
			'default' => 'dd-style1',
		),
		array(
			'id'   => 'shhmenu_opener_dimensions',
    		'type' => 'dimensions',
			'title' => esc_html__('Trigger icon dimensions','capital'),
			'compiler'   => array('.header-style9 .site-header .hidden-menu-opener'),
			'desc' => esc_html__('Keep width and height equal for a square icon box','capital'),
			'required'  => array('header_layout','=','9'),
		),
		array(
			'id'   => 'shhmenu_opener_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.header-style9 .site-header .hidden-menu-opener'),
			'required'  => array('header_layout','=','9'),
			'title' => esc_html__('Trigger icon background','capital'),
		),
		array(
			'id'   => 'shhmenu_opener_hover_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.header-style9 .site-header .hidden-menu-opener:hover'),
			'required'  => array('header_layout','=','9'),
			'title' => esc_html__('Trigger icon hover background','capital'),
		),
		array(
			'id'   => 'shhmenu_opener_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.header-style9 .site-header .hidden-menu-opener'),
			'required'  => array('header_layout','=','9'),
			'title' => esc_html__('Trigger icon border','capital'),
		),
		array(
			'id'   => 'shhmenu_opener_hover_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.header-style9 .site-header .hidden-menu-opener:hover'),
			'required'  => array('header_layout','=','9'),
			'title' => esc_html__('Trigger icon hover border','capital'),
		),
        array(
            'id' => 'shhmenu_opener_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Trigger icon font size', 'capital'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => false,
			'letter-spacing' => false,
			'text-transform' => false,
			'word-spacing' => false,
			'line-height' => false,
			'font-family' => false,
			'font-weight' => false,
			'preview' => false,
			'compiler'   => array('.header-style9 .site-header .hidden-menu-opener'),
			'required'  => array('header_layout','=','9'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'shhmenu_opener_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.header-style9 .site-header .hidden-menu-opener'),
			'title'    => esc_html__('Trigger icon link color', 'capital'),
			'required'  => array('header_layout','=','9'),
		),
		array(
			'id'   => 'hs9_menu_bg_color',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			),   
			'required'  => array('header_layout','=','9'),
			'compiler'   => array('background-color'=>'.overlay-wrapper.main-menu:before'),
			'title' => esc_html__('Overlay menu background color','capital'),
		),
		array(
			'id'   => 'hs9_menu_bg',
    		'type' => 'background',
			'background-color' => false,
			'transparent' => false,
			'required'  => array('header_layout','=','9'),
			'compiler'   => array('background-color'=>'.overlay-wrapper.main-menu:before'),
			'title' => esc_html__('Overlay menu background image','capital'),
		),
		array(
			'id'   => 'hs9_menu_close_dimensions',
    		'type' => 'dimensions',
			'required'  => array('header_layout','=','9'),
			'title' => esc_html__('Close button dimensions','capital'),
			'compiler'   => array('.overlay-wrapper.main-menu .overlay-wrapper-close'),
			'desc' => esc_html__('Keep width and height equal for a square button','capital')
		),
		array(
			'id'   => 'hs9_menu_close_bg',
    		'type' => 'background',
			'background-image' => false,
			'background-position' => false,
			'background-attachment' => false,
			'background-size' => false,
			'background-repeat' => false,
			'preview'   => false,
			'required'  => array('header_layout','=','9'),
			'compiler'   => array('.overlay-wrapper.main-menu .overlay-wrapper-close'),
			'title' => esc_html__('Close button background','capital'),
		),
		array(
			'id'   => 'hs9_menu_close_hover_bg',
    		'type' => 'background',
			'background-image' => false,
			'background-position' => false,
			'background-attachment' => false,
			'background-size' => false,
			'background-repeat' => false,
			'preview'   => false,
			'required'  => array('header_layout','=','9'),
			'compiler'   => array('.overlay-wrapper.main-menu .overlay-wrapper-close:hover'),
			'title' => esc_html__('Close button hover background','capital'),
		),
		array(
			'id'       => 'hs9_menu_close_link_color',
			'type'     => 'link_color',
			'visited'  => false,
			'required'  => array('header_layout','=','9'),
			'compiler'   => array('.overlay-wrapper.main-menu .overlay-wrapper-close'),
			'title'    => esc_html__('Close button color', 'capital'),
		),
        array(
            'id' 		=> 'hs9_menu_close_link_typography',
            'type'      => 'typography',
			'title'     => esc_html__('Close button font size', 'capital'),
			'required'  => array('header_layout','=','9'),
			'subsets' 	=> false,
			'color' 	=> false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => false,
			'letter-spacing' => false,
			'text-transform' => false,
			'word-spacing' => false,
			'line-height' => false,
			'font-family' => false,
			'font-weight' => false,
			'preview' => false,
			'compiler'   => array('.overlay-wrapper.main-menu .overlay-wrapper-close'),
			'units'       =>'px',
        ),
		array(
            'id' => 'hs4_menu_bg',
            'type' => 'color_rgba',
			'required' => array('header_layout','=','4'),
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler' => array('background' => '.header-style4 .full-width-menu'),
            'title' => esc_html__('Main nav background', 'capital'),
            'desc' => esc_html__('Set color for the full width menu in Header style 4.', 'capital'),
        ),
		array(
            'id' => 'hs5_menu_bg',
            'type' => 'color_rgba',
			'required' => array('header_layout','=','5'),
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler' => array('background' => '.header-style5 .full-width-menu'),
            'title' => esc_html__('Main nav background', 'capital'),
            'desc' => esc_html__('Set color for the full width menu in Header style 5.', 'capital'),
        ),
		array(
            'id' => 'hs6_menu_bg',
            'type' => 'color_rgba',
			'required' => array('header_layout','=','6'),
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler' => array('background' => '.header-style6 .full-width-menu'),
            'title' => esc_html__('Main nav background', 'capital'),
            'desc' => esc_html__('Set color for the full width menu in Header style 6.', 'capital'),
        ),
		array(
            'id' => 'hs10_menu_bg',
            'type' => 'color_rgba',
			'required' => array('header_layout','=','10'),
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler' => array('background' => '.header-style10 .fw-menu'),
            'title' => esc_html__('Main nav background', 'capital'),
            'desc' => esc_html__('Set color for the full width menu in Header style 10.', 'capital'),
        ),
		array(
			'id'       => 'main_nav_link_typo',
			'type'     => 'typography',
			'text-transform' => true,
			'word-spacing' => true,
			'letter-spacing' => true,
			'color' => false,
			'line-height' => false,
			'text-align' => false,
			'title'    => esc_html__('Main navigation links typography', 'capital'),
			'compiler'   => array('.dd-menu > li > a, .header-style9 .overlay-wrapper .dd-menu > li > a')
		),
		array(
            'id' => 'dd_style1_animated_border',
            'type' => 'color_rgba',
			'required' => array('dd_menu_style','=','dd-style1'),
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler' => array('background' => '.dd-menu > li > a:before'),
            'title' => esc_html__('Main nav links border bottom color', 'capital'),
            'desc' => esc_html__('Set color for the animated border which shows for the main links in the navigation.', 'capital'),
        ),
		array(
            'id' => 'dd_style3_main_hover_bg',
            'type' => 'color_rgba',
			'required' => array('dd_menu_style','=','dd-style3'),
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler' => array('background' => '.dd-style3.dd-menu > li:hover > a, .dd-style3.dd-menu > li.current-menu-item > a'),
            'title' => esc_html__('Main nav links hover bg color', 'capital'),
            'desc' => esc_html__('Set main navigation links hover background color.(For menu style 3)', 'capital'),
        ),
		array(
			'id'       => 'main_nav_link',
			'type'     => 'link_color',
			'title'    => esc_html__('Main navigation link color', 'capital'),
			'desc'     => esc_html__('Set the Main Navigation links color, hover, active.', 'capital'),
			'compiler'   => array('.dd-menu > li > a, .header-style2 .site-header .dd-menu > li > a, .header-style9 .overlay-wrapper .dd-menu > li > a'),
		),
		array(
			'id'       => 'main_nav_link_active',
			'type'     => 'link_color',
			'title'    => esc_html__('Main Navigation current menu link color', 'capital'),
			'desc'     => esc_html__('Set the Main Navigation links color for active page.', 'capital'),
			'compiler'   => array('.dd-menu > li.current-menu-item > a, .header-style9 .overlay-wrapper .dd-menu > li.current-menu-item > a'),
		),
        array(
            'id' => 'nav_directions_arrows',
            'type' => 'checkbox',
			'required' => array('header_layout','!=','11'),
            'title' => esc_html__('Direction arrows with menu label', 'capital'),
            'subtitle' => esc_html__('Uncheck to disable arrows that appear with menu text which is having dropdown. Check to enable.', 'capital'),
            "default" => 1,
        ),
        array(
            'id' => 'dd_dropshadow',
            'type' => 'checkbox',
			'required' => array('header_layout','!=','11'),
            'title' => esc_html__('Drop shadow for dropdown menus', 'capital'),
            'subtitle' => esc_html__('Uncheck to disable drop shadow for the dropdown menu blocks. Check to enable.', 'capital'),
            "default" => 1,
        ),
        array(
            'id' => 'dd_border_radius',
            'type' => 'checkbox',
			'required' => array('header_layout','!=','11'),
			'required' => array('dd_menu_style','=','dd-style2'),
            'title' => esc_html__('Rounded border', 'capital'),
            'subtitle' => esc_html__('Uncheck to disable rounded border style for the dropdown menu blocks. Check to enable.(Only for Dropdown menu style 2)', 'capital'),
            "default" => 1,
        ),
		array(
            'id' => 'dd_background',
            'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			),
			'compiler' => array('background-color' => '.dd-menu li ul,.dd-style2.dd-menu li ul,.dd-style3.dd-menu li ul','border-bottom-color' => '.dd-style2.dd-menu li ul:before'),
            'title' => esc_html__('Background color for dropdown menus', 'capital'),
            'desc' => esc_html__('Background color set for the dropdowns blocks of main navigation.', 'capital'),
        ),
		array(
			'id'       => 'dd_item_border',
			'type'     => 'border',
			'title'    => esc_html__('Dropdown links border bottom', 'capital'),
			'compiler'   => array('.dd-menu > li > ul > li > a, .dd-menu > li > ul > li > ul > li > a, .dd-menu > li > ul > li > ul > li > ul > li > a'),
			'top' 	   => false,
			'left' 	   => false,
			'right' 	   => false,
			'bottom' 	=> true
		),
		array(
			'id'       => 'dd_item_spacing',
			'type'     => 'spacing',
			'title'    => esc_html__('Dropdown links spacing', 'capital'),
			'compiler'   => array('.dd-menu > li > ul > li > a, .dd-menu > li > ul > li > ul > li > a, .dd-menu > li > ul > li > ul > li > ul > li > a'),
			'mode' 	   => 'padding',
			'units'    => array('px'),
		),
		array(
            'id' => 'dd_item_background',
            'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			),
			'compiler' => array('background' =>'.dd-style1.dd-menu > li > ul > li > a:hover, .dd-style1.dd-menu > li > ul > li > ul > li > a:hover, .dd-style1.dd-menu > li > ul > li > ul > li > ul > li > a:hover,.dd-style2.dd-menu > li > ul > li > a:hover, .dd-style2.dd-menu > li > ul > li > ul > li > a:hover, .dd-style2.dd-menu > li > ul > li > ul > li > ul > li > a:hover,.dd-style3.dd-menu > li > ul > li > a:hover, .dd-style3.dd-menu > li > ul > li > ul > li > a:hover, .dd-style3.dd-menu > li > ul > li > ul > li > ul > li > a:hover'),
            'title' => esc_html__('Background color for dropdown menus links hover', 'capital'),
        ),
		array(
			'id'       => 'dd_item_link_typo',
			'type'     => 'typography',
			'text-transform' => true,
			'word-spacing' => true,
			'letter-spacing' => true,
			'color' => false,
			'line-height' => false,
			'text-align' => false,
			'title'    => esc_html__('Dropdown Menu Links Typography', 'capital'),
			'compiler'   => array('.dd-style1.dd-menu > li > ul > li > a, .dd-style1.dd-menu > li > ul > li > ul > li > a, .dd-style1.dd-menu > li > ul > li > ul > li > ul > li > a, .dd-style1.dd-menu .megamenu-container ul li a,.dd-style2.dd-menu > li > ul > li > a, .dd-style2.dd-menu > li > ul > li > ul > li > a, .dd-style2.dd-menu > li > ul > li > ul > li > ul > li > a, .dd-style2.dd-menu .megamenu-container ul li a, .dd-style3.dd-menu > li > ul > li > a, .dd-style3.dd-menu > li > ul > li > ul > li > a, .dd-style3.dd-menu > li > ul > li > ul > li > ul > li > a, .dd-style3.dd-menu .megamenu-container ul li a, .header-style9 .overlay-wrapper .dd-menu > li > ul > li > a, .header-style9 .overlay-wrapper .dd-menu > li > ul > li > ul > li > a, .header-style9 .overlay-wrapper .dd-menu > li > ul > li > ul > li > ul > li > a')
		),
		array(
			'id'       => 'dd_item_link_color',
			'type'     => 'link_color',
			'title'    => esc_html__('Dropdown links color', 'capital'),
			'compiler'   => array('.dd-style1.dd-menu > li > ul > li > a, .dd-style1.dd-menu > li > ul > li > ul > li > a, .dd-style1.dd-menu > li > ul > li > ul > li > ul > li > a, .dd-style1.dd-menu .megamenu-container ul li a,.dd-style2.dd-menu > li > ul > li > a, .dd-style2.dd-menu > li > ul > li > ul > li > a, .dd-style2.dd-menu > li > ul > li > ul > li > ul > li > a, .dd-style2.dd-menu .megamenu-container ul li a, .dd-style3.dd-menu > li > ul > li > a, .dd-style3.dd-menu > li > ul > li > ul > li > a, .dd-style3.dd-menu > li > ul > li > ul > li > ul > li > a, .dd-style3.dd-menu .megamenu-container ul li a, .header-style9 .overlay-wrapper .dd-menu > li > ul > li > a, .header-style9 .overlay-wrapper .dd-menu > li > ul > li > ul > li > a, .header-style9 .overlay-wrapper .dd-menu > li > ul > li > ul > li > ul > li > a')
		),
		array(
            'id' => 'mm_background',
            'type' => 'background',
			'background-image' => false,
			'background-repeat' => false,
			'background-size' => false,
			'background-position' => false,
			'background-attachment' => false,
			'preview' => false,
			'transparent' => false,
			'compiler' => array('.dd-menu > li.megamenu > ul, .header-style3 .dd-menu > li.megamenu ul'),
            'title' => esc_html__('Megamenu Background color', 'capital'),
        ),
		array(
			'id'       => 'mm_title_typo',
			'type'     => 'typography',
			'text-transform' => true,
			'title'    => esc_html__('Megamenu Column Title Typography', 'capital'),
			'compiler'   => array('.dd-menu .megamenu-container .megamenu-sub-title, .dd-menu .megamenu-container .widget .widgettitle, .dd-menu .megamenu-container .widget .widget-title')
		),
		array(
			'id'       => 'mm_content_typo',
			'type'     => 'typography',
			'text-transform' => true,
			'title'    => esc_html__('Megamenu Content Typography', 'capital'),
			'compiler'   => array('.dd-menu .megamenu-container')
		),
		array(
			'id'        => 'shmenu_style_end',
			'type'      => 'accordion',
			'position'  => 'end',
		),
		array(
			'id'        => 'shhinfo_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Header info style','capital'),
			'subtitle'  => esc_html__('Use this section to style the header info for the site header.','capital'),
			'position'  => 'start',
		),
		array(
			'id'       => 'header_info_typo_header',
			'type'     => 'typography',
			'text-transform' => true,
			'word-spacing' => true,
			'letter-spacing' => true,
			'color' => true,
			'line-height' => true,
			'text-align' => true,
			'title'    => esc_html__('Typography', 'capital'),
			'desc'    => esc_html__('These options will affect the header info shown in the main header only.', 'capital'),
			'compiler'   => array('.site-header .header_info_text')
		),
		array(
			'id'       => 'header_info_header_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.site-header .header_info_text a'),
			'title'    => esc_html__('Links color', 'capital'),
			'desc'    => __('These options will affect the links in header info shown in the site header only.', 'capital'),
		),
		array(
			'id'       => 'header_info1_width',
			'type'     => 'dimensions',
			'height' => false,
			'title'    => esc_html__('Header info 1 maximum width', 'capital'),
			'units'  => 'px',
            'subtitle' => esc_html__('Set maximum width for the header info block 1 for the site header. For auto width leave empty.', 'capital'),
			'compiler'   => array('.site-header .header_info_text1'),
			'default'  => array(
				'width' => ''
			)
		),
		array(
			'id'       => 'header_info2_width',
			'type'     => 'dimensions',
			'height' => false,
			'title'    => esc_html__('Header info 2 maximum width', 'capital'),
			'units'  => 'px',
            'subtitle' => esc_html__('Set maximum width for the header info block 2 for the site header. For auto width leave empty.', 'capital'),
			'compiler'   => array('.site-header .header_info_text2'),
			'default'  => array(
				'width' => ''
			)
		),
		array(
			'id'       => 'header_info3_width',
			'type'     => 'dimensions',
			'height' => false,
			'title'    => esc_html__('Header info 3 maximum width', 'capital'),
			'units'  => 'px',
            'subtitle' => esc_html__('Set maximum width for the header info block 3 for the site header. For auto width leave empty.', 'capital'),
			'compiler'   => array('.site-header .header_info_text3'),
			'default'  => array(
				'width' => ''
			)
		),
		array(
			'id'        => 'shhinfo_style_end',
			'type'      => 'accordion',
			'position'  => 'end',
		),
		array(
			'id'        => 'shsocial_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Social icons style','capital'),
			'subtitle'  => esc_html__('Use this section to style the social icons for the site header.','capital'),
			'position'  => 'start',
		),
		array(
			'id'=>'header_social_custom_size',
			'type' => 'dimensions',
			'compiler'=>true,
			'compiler' => array('.site-header .header-social-container .imi-social-icons li a'),
			'title' => esc_html__('Custom size', 'capital'),
			'desc' => esc_html__('Keep the width and height fields filled with same values to keep the social icons boxes in square.', 'capital'),
		),
		array(
			'id'=>'header_social_custom_spacing',
			'type' => 'spacing',
			'mode' => 'margin',
			'units' => array('px'),
			'compiler'=>true,
			'compiler' => array('.site-header .header-social-container .imi-social-icons li'),
			'title' => esc_html__('Custom spacing', 'capital'),
			'desc' => esc_html__('Enter the margin from all sides for each social icon link.', 'capital'),
		),
		array(
			'id'=>'header_social_custom_typo',
			'type' => 'typography',
			'compiler'=>true,
			'font-family' => false,
			'preview' => false,
			'text-align' => false,
			'line-height' => false,
			'color' => false,
			'word-spacing' => false,
			'letter-spacing' => false,
			'font-weight' => false,
			'font-style' => false,
			'compiler' => array('.site-header .header-social-container .imi-social-icons li a'),
			'title' => esc_html__('Custom icon size', 'capital'),
		),
		array(
			'id'       => 'header_social_icon_color',
			'type'     => 'link_color',
			'visited'  => false,
			'required' => array('main_social_shape','=','imi-social-icons-plain'),
			'compiler'   => array('.site-header .header-social-container .imi-social-icons li a'),
			'title'    => esc_html__('Social Links Color', 'capital'),
		),
		array(
			'id'        => 'shsocial_style_end',
			'type'      => 'accordion',
			'position'  => 'end',
		),
		array(
			'id'        => 'shsearch_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Search module style','capital'),
			'subtitle'  => esc_html__('Use this section to style the search trigger icon link or search open form as selected in the "Search Form Style" option.','capital'),
			'position'  => 'start',
		),
		array(
			'id'   => 'shddsearch_trigger_dimensions',
    		'type' => 'dimensions',
			'required' => array('search_form_style','!=',1),
			'title' => esc_html__('Trigger icon dimensions','capital'),
			'compiler'   => array('.site-header .search-module-trigger, .header-style9 .site-header .search-module-trigger'),
			'desc' => esc_html__('Keep width and height equal for a square icon box','capital')
		),
		array(
			'id'   => 'shddsearch_trigger_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'required' => array('search_form_style','!=',1),
			'compiler'   => array('background-color'=>'.site-header .search-module-trigger, .header-style2 .site-header .search-module-trigger, .header-style9 .site-header .search-module-trigger'),
			'title' => esc_html__('Trigger icon background','capital'),
		),
		array(
			'id'   => 'shddsearch_trigger_hover_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'required' => array('search_form_style','!=',1),
			'compiler'   => array('background-color'=>'.site-header .search-module-trigger:hover, .header-style2 .site-header .search-module-trigger:hover, .header-style9 .site-header .search-module-trigger:hover'),
			'title' => esc_html__('Trigger icon hover background','capital'),
		),
		array(
			'id'   => 'shddsearch_trigger_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.site-header .search-module-trigger, .header-style2 .site-header .search-module-trigger, .header-style9 .site-header .search-module-trigger'),
			'required' => array('search_form_style','!=',1),
			'title' => esc_html__('Trigger icon border','capital'),
		),
		array(
			'id'   => 'shddsearch_trigger_hover_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.site-header .search-module-trigger:hover, .header-style2 .site-header .search-module-trigger:hover, .header-style9 .site-header .search-module-trigger:hover'),
			'required' => array('search_form_style','!=',1),
			'title' => esc_html__('Trigger icon hover border','capital'),
		),
        array(
            'id' => 'shddsearch_trigger_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Trigger icon font size', 'capital'),
			'required' => array('search_form_style','!=',1),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => false,
			'letter-spacing' => false,
			'text-transform' => false,
			'word-spacing' => false,
			'line-height' => false,
			'font-family' => false,
			'font-weight' => false,
			'preview' => false,
			'compiler'   => array('.site-header .search-module-trigger, .header-style2 .site-header .search-module-trigger, .header-style9 .site-header .search-module-trigger'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'shddsearch_trigger_links_color',
			'required' => array('search_form_style','!=',1),
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.site-header .search-module-trigger, .header-style2 .site-header .search-module-trigger, .header-style9 .site-header .search-module-trigger'),
			'title'    => esc_html__('Trigger icon link color', 'capital'),
		),
		array(
			'id'   => 'shddsearch_opened_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'required' => array('search_form_style','=',0),
			'compiler'   => array('background-color'=>'.site-header .search-module-opened'),
			'title' => esc_html__('Dropdown search form background','capital'),
		),
		array(
			'id'   => 'shddsearch_opened_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.site-header .search-module-opened'),
			'required' => array('search_form_style','=',0),
			'title' => esc_html__('Dropdown search form border','capital'),
		),
		array(
			'id'   => 'shddsearch_opened_border_top',
    		'type' => 'border',
			'top'  => true,
			'bottom'  => false,
			'left'  => false,
			'right'  => false,
			'compiler'   => array('.site-header .search-module-opened'),
			'required' => array('search_form_style','=',0),
			'title' => esc_html__('Dropdown search form border top','capital'),
		),
		array(
			'id'   => 'shopensearch_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'required' => array('search_form_style','=',1),
			'compiler'   => array('background-color'=>'.site-header .open-search-form .imi-searchform'),
			'title' => esc_html__('Search form background','capital'),
		),
		array(
			'id'   => 'shopensearch_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.site-header .open-search-form .imi-searchform'),
			'required' => array('search_form_style','=',1),
			'title' => esc_html__('Search form border','capital'),
		),
		array(
			'id'=>'shopensearch_dimensions',
			'type' => 'dimensions',
			'height' => false,
			'compiler'=>true,
			'compiler' => array('.site-header .open-search-form .imi-searchform input[type="text"]'),
			'title' => esc_html__('Search form width', 'capital'),
			'required' => array('search_form_style','=',1),
			'desc' => esc_html__('Enter width for the search form.', 'capital')
		),
		array(
			'id'=>'shopensearch_height',
			'type' => 'dimensions',
			'width' => false,
			'compiler'=>true,
			'compiler' => array('.site-header .open-search-form .imi-searchform input[type="text"],.site-header .open-search-form .imi-searchform .btn'),
			'title' => esc_html__('Search form height', 'capital'),
			'required' => array('search_form_style','=',1),
			'desc' => esc_html__('Enter height for the search form.', 'capital')
		),
        array(
            'id' => 'shopensearch_field_color',
            'type'        => 'typography',
			'title'       => esc_html__('Search form text typography', 'capital'),
			'required' => array('search_form_style','=',1),
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'word-spacing' => true,
			'line-height' => false,
			'font-family' => true,
			'font-weight' => true,
			'preview' => true,
			'compiler'   => array('.site-header .open-search-form .imi-searchform input[type="text"]'),
			'units'       =>'px',
        ),
        array(
            'id' => 'shopensearch_links_typo',
            'type'        => 'typography',
			'title'       => esc_html__('Search icon size', 'capital'),
			'required' => array('search_form_style','=',1),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => false,
			'letter-spacing' => false,
			'text-transform' => false,
			'word-spacing' => false,
			'line-height' => false,
			'font-family' => false,
			'font-weight' => false,
			'preview' => false,
			'compiler'   => array('.site-header .open-search-form .imi-searchform .btn'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'shopensearch_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'required' => array('search_form_style','=',1),
			'compiler'   => array('.site-header .open-search-form .imi-searchform .btn'),
			'title'    => esc_html__('Search icon color', 'capital'),
		),
		array(
			'id'        => 'shsearch_style_end',
			'type'      => 'accordion',
			'position'  => 'end'
		),
		array(
			'id'        => 'shcart_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Cart module style','capital'),
			'subtitle'  => esc_html__('Use this section to style the cart trigger icon link and cart block shown in the site header','capital'),
			'position'  => 'start',
		),
		array(
			'id'   => 'shcart_trigger_dimensions',
    		'type' => 'dimensions',
			'title' => esc_html__('Trigger icon dimensions','capital'),
			'compiler'   => array('.site-header .cart-module-trigger, .header-style2 .site-header .cart-module-trigger, .header-style9 .site-header .cart-module-trigger'),
			'desc' => esc_html__('Keep width and height equal for a square icon box','capital')
		),
		array(
			'id'   => 'shcart_trigger_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.site-header .cart-module-trigger, .header-style2 .site-header .cart-module-trigger, .header-style9 .site-header .cart-module-trigger'),
			'title' => esc_html__('Trigger icon background','capital'),
		),
		array(
			'id'   => 'shcart_trigger_hover_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.site-header .cart-module-trigger:hover, .header-style2 .site-header .cart-module-trigger:hover, .header-style9 .site-header .cart-module-trigger:hover'),
			'title' => esc_html__('Trigger icon hover background','capital'),
		),
		array(
			'id'   => 'shcart_trigger_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.site-header .cart-module-trigger, .header-style2 .site-header .cart-module-trigger, .header-style9 .site-header .cart-module-trigger'),
			'title' => esc_html__('Trigger icon border','capital'),
		),
		array(
			'id'   => 'shcart_trigger_hover_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.site-header .cart-module-trigger:hover, .header-style2 .site-header .cart-module-trigger:hover, .header-style9 .site-header .cart-module-trigger:hover'),
			'title' => esc_html__('Trigger icon hover border','capital'),
		),
        array(
            'id' => 'shcart_trigger_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Trigger icon font size', 'capital'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => false,
			'letter-spacing' => false,
			'text-transform' => false,
			'word-spacing' => false,
			'line-height' => false,
			'font-family' => false,
			'font-weight' => false,
			'preview' => false,
			'compiler'   => array('.site-header .cart-module-trigger, .header-style2 .site-header .cart-module-trigger, .header-style9 .site-header .cart-module-trigger'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'shcart_trigger_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.site-header .cart-module-trigger, .header-style2 .site-header .cart-module-trigger, .header-style9 .site-header .cart-module-trigger'),
			'title'    => esc_html__('Trigger icon link color', 'capital'),
		),
		array(
			'id'   => 'shcart_opened_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.site-header .cart-module-opened'),
			'title' => esc_html__('Open cart background','capital'),
		),
		array(
			'id'   => 'shcart_opened_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.site-header .cart-module-items'),
			'title' => esc_html__('Open cart border','capital'),
		),
		array(
			'id'   => 'shcart_opened_border_top',
    		'type' => 'border',
			'top'  => true,
			'bottom'  => false,
			'left'  => false,
			'right'  => false,
			'compiler'   => array('.site-header .cart-module-opened'),
			'title' => esc_html__('Open cart border top','capital'),
		),
		array(
			'id'       => 'shcart_items_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.site-header .cart-module-items > li > a'),
			'title'    => esc_html__('Cart items text color', 'capital'),
		),
        array(
            'id' => 'shcart_items_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Cart items typography', 'capital'),
			'subsets' 	  => false,
			'color' 		  => true,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'word-spacing' => true,
			'line-height' => true,
			'font-family' => true,
			'font-weight' => true,
			'preview' => true,
			'compiler'   => array('.site-header .cart-module-items > li'),
			'units'       =>'px',
        ),
		array(
			'id'   => 'shcart_opened_footer_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.site-header .cart-module-footer'),
			'title' => esc_html__('Open cart footer background','capital'),
		),
		array(
			'id'   => 'shcart_opened_footer_link_hover_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.site-header .cart-module-footer a.basic-link:hover'),
			'title' => esc_html__('Open cart footer links hover background','capital'),
		),
		array(
			'id'       => 'shcart_opened_footer_link_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.site-header .cart-module-footer a.basic-link'),
			'title'    => esc_html__('Open cart footer links color', 'capital'),
		),
        array(
            'id' => 'shcart_opened_footer_link_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Open cart footer links typography', 'capital'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'word-spacing' => true,
			'line-height' => true,
			'font-family' => true,
			'font-weight' => true,
			'preview' => true,
			'compiler'   => array('.site-header .cart-module-footer a.basic-link'),
			'units'       =>'px',
        ),
		array(
			'id'        => 'shcart_style_end',
			'type'      => 'accordion',
			'position'  => 'end'
		),
		array(
			'id'        => 'shwopener_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Overlay content opener button style','capital'),
			'subtitle'  => esc_html__('Use this section to style the overlay content trigger link shown in the topbar','capital'),
			'position'  => 'start',
		),
		array(
			'id'   => 'shwopener_trigger_dimensions',
    		'type' => 'dimensions',
			'title' => esc_html__('Trigger icon dimensions','capital'),
			'compiler'   => array('.site-header .topper-opener'),
			'desc' => esc_html__('Keep width and height equal for a square button box','capital')
		),
		array(
			'id'   => 'shwopener_trigger_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.site-header .topper-opener'),
			'title' => esc_html__('Trigger button background','capital'),
		),
		array(
			'id'   => 'shwopener_trigger_hover_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.site-header .topper-opener:hover'),
			'title' => esc_html__('Trigger button hover background','capital'),
		),
		array(
			'id'   => 'shwopener_trigger_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.site-header .topper-opener'),
			'title' => esc_html__('Trigger button border','capital'),
		),
		array(
			'id'   => 'shwopener_trigger_hover_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.site-header .topper-opener:hover'),
			'title' => esc_html__('Trigger button hover border','capital'),
		),
        array(
            'id' => 'shwopener_trigger_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Trigger button font size', 'capital'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'word-spacing' => true,
			'line-height' => false,
			'font-family' => true,
			'font-weight' => true,
			'preview' => true,
			'compiler'   => array('.site-header .topper-opener'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'shwopener_trigger_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.site-header .topper-opener'),
			'title'    => esc_html__('Trigger button text color', 'capital'),
		),
		array(
			'id'        => 'shwopener_style_end',
			'type'      => 'accordion',
			'position'  => 'end'
		)
	),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Featured Buttons', 'capital'),
	'desc'     => esc_html__('These are options to add highlighted buttons in to your site main header.', 'capital'),
	'subsection' => true,
    'fields' => array(
		array(
    		'id'   =>'divider_1',
    		'type' => 'section',
			'indent' => true,
			'title' => esc_html__('Button 1','capital')
		),
		array(
            'id' => 'feat_button_title1',
            'type' => 'text',
            'title' => esc_html__('Label', 'capital'),
            'subtitle' => esc_html__('Insert featured button 1 label', 'capital'),
            'desc' => esc_html__('Allowed HTML tags: span, u, i, b, br, strong, del, strike, em, img', 'capital'),
            'default' => esc_html__('Button','capital')
        ),
		array(
            'id' => 'feat_button_url1',
            'type' => 'text',
            'title' => esc_html__('URL', 'capital'),
            'subtitle' => esc_html__('Enter featured button 1 URL', 'capital'),
            'desc' => esc_html__('A valid URL is required to show the button.', 'capital'),
            'default' => ''
        ),
		array(
			'id'=>'feat_button_shape1',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Shape', 'capital'), 
			'options' => array(
					'fbtn-rounded' => esc_html__('Rounded','capital'),
					'fbtn-square' => esc_html__('Square','capital'),
					'fbtn-round' => esc_html__('Round','capital')
				),
			'default' => 'fbtn-rounded',
		),
		array(
			'id'=>'feat_button_size1',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Size', 'capital'), 
			'options' => array(
					'fbtn-xs' => esc_html__('Extra Small','capital'),
					'fbtn-sm' => esc_html__('Small','capital'),
					'fbtn-md' => esc_html__('Medium','capital'),
					'fbtn-lg' => esc_html__('Large','capital'),
					'fbtn-custom' => esc_html__('Custom','capital')
				),
			'default' => 'fbtn-md',
		),
		array(
			'id'=>'feat_button_size1_custom',
			'type' => 'dimensions',
			'compiler'=>true,
			'compiler' => array('.featured-buttons .fbtn1'),
			'title' => esc_html__('Custom size', 'capital'),
			'desc' => esc_html__('Enter width and height for the featured button custom size.', 'capital'),
			'required' => array('feat_button_size1','=','fbtn-custom')
		),
		array(         
			'id'   	=> 'feat_button_bg1_translucent',
			'type'	=> 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'  => array('background-color' => '.featured-buttons .fbtn1'),
			'title'   => esc_html__('Background color translucent', 'capital'),
		),
		array(         
			'id'   	=> 'feat_button_bg1',
			'type'	=> 'background',
			'preview' => false,
			'compiler'  => array('.featured-buttons .fbtn1'),
			'title'   => esc_html__('Background color/image', 'capital'),
		),
		array(         
			'id'   	=> 'feat_button_bg1_translucent_hover',
			'type'	=> 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'  => array('background-color' => '.featured-buttons .fbtn1:hover'),
			'title'   => esc_html__('Hover background color translucent', 'capital'),
		),
		array(         
			'id'   	=> 'feat_button_bg1_hover',
			'type'	=> 'background',
			'preview' => false,
			'compiler'  => array('.featured-buttons .fbtn1:hover'),
			'title'   => esc_html__('Background color/image', 'capital'),
		),
		array(
			'id'=>'feat_button_border1',
			'type' => 'border',
			'compiler'  => array('.featured-buttons .fbtn1'),
			'title' => esc_html__('Border', 'capital'), 
		),
		array(
			'id'=>'feat_button_border1_hover',
			'type' => 'border',
			'compiler'  => array('.featured-buttons .fbtn1:hover'),
			'title' => esc_html__('Hover Border', 'capital'), 
		),
		array(         
			'id'   	=> 'feat_button_color1',
			'type'	=> 'link_color',
			'compiler'  => array('.featured-buttons .fbtn1'),
			'title'   => esc_html__('Link color', 'capital'),
		),
		array(
			'id'=>'feat_button_typo1',
			'type' => 'typography',
			'line-height' => true,
			'color'  => false,
			'word-spacing'  => true,
			'letter-spacing'  => true,
			'text-transform'  => true,
			'text-align' => true,
			'compiler'  => array('.featured-buttons .fbtn.fbtn1'),
			'title' => esc_html__('Typography', 'capital'),
		),
		array(
    		'id'   =>'divider_2',
    		'type' => 'section',
			'indent' => true,
			'title' => esc_html__('Button 2','capital')
		),
		array(
            'id' => 'feat_button_title2',
            'type' => 'text',
            'title' => esc_html__('Label', 'capital'),
            'subtitle' => esc_html__('Insert featured button 2 label', 'capital'),
            'desc' => esc_html__('Allowed HTML tags: span, u, i, b, br, strong, del, strike, em, img', 'capital'),
            'default' =>  esc_html__('Button','capital')
        ),
		array(
            'id' => 'feat_button_url2',
            'type' => 'text',
            'title' => esc_html__('URL', 'capital'),
            'subtitle' => esc_html__('Enter featured button 2 URL', 'capital'),
            'desc' => esc_html__('A valid URL is required to show the button.', 'capital'),
            'default' => ''
        ),
		array(
			'id'=>'feat_button_shape2',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Shape', 'capital'), 
			'options' => array(
					'fbtn-rounded' => esc_html__('Rounded','capital'),
					'fbtn-square' => esc_html__('Square','capital'),
					'fbtn-round' => esc_html__('Round','capital')
				),
			'default' => 'fbtn-rounded',
		),
		array(
			'id'=>'feat_button_size2',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Size', 'capital'), 
			'options' => array(
					'fbtn-xs' => esc_html__('Extra Small','capital'),
					'fbtn-sm' => esc_html__('Small','capital'),
					'fbtn-md' => esc_html__('Medium','capital'),
					'fbtn-lg' => esc_html__('Large','capital'),
					'fbtn-custom' => esc_html__('Custom','capital')
				),
			'default' => 'fbtn-md',
		),
		array(
			'id'=>'feat_button_size2_custom',
			'type' => 'dimensions',
			'compiler'=>true,
			'compiler' => array('.featured-buttons .fbtn2'),
			'title' => esc_html__('Custom size', 'capital'),
			'desc' => esc_html__('Enter width and height for the featured button custom size.', 'capital'),
			'required' => array('feat_button_size2','=','fbtn-custom')
		),
		array(         
			'id'   	=> 'feat_button_bg2_translucent',
			'type'	=> 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'  => array('background-color' => '.featured-buttons .fbtn2'),
			'title'   => esc_html__('Background color translucent', 'capital'),
		),
		array(         
			'id'   	=> 'feat_button_bg2',
			'type'	=> 'background',
			'preview' => false,
			'compiler'  => array('.featured-buttons .fbtn2'),
			'title'   => esc_html__('Background color/image', 'capital'),
		),
		array(         
			'id'   	=> 'feat_button_bg2_translucent_hover',
			'type'	=> 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'  => array('background-color' => '.featured-buttons .fbtn2:hover'),
			'title'   => esc_html__('Hover background color translucent', 'capital'),
		),
		array(         
			'id'   	=> 'feat_button_bg2_hover',
			'type'	=> 'background',
			'preview' => false,
			'compiler'  => array('.featured-buttons .fbtn2:hover'),
			'title'   => esc_html__('Background color/image', 'capital'),
		),
		array(
			'id'=>'feat_button_border2',
			'type' => 'border',
			'compiler'  => array('.featured-buttons .fbtn2'),
			'title' => esc_html__('Border', 'capital'), 
		),
		array(
			'id'=>'feat_button_border2_hover',
			'type' => 'border',
			'compiler'  => array('.featured-buttons .fbtn2:hover'),
			'title' => esc_html__('Hover Border', 'capital'), 
		),
		array(         
			'id'   	=> 'feat_button_color2',
			'type'	=> 'link_color',
			'compiler'  => array('.featured-buttons .fbtn2'),
			'title'   => esc_html__('Link color', 'capital'),
		),
		array(
			'id'=>'feat_button_typo2',
			'type' => 'typography',
			'line-height' => false,
			'text-align'  => false,
			'color'  => false,
			'word-spacing'  => true,
			'letter-spacing'  => true,
			'text-transform'  => true,
			'compiler'  => array('.featured-buttons .fbtn.fbtn2'),
			'title' => esc_html__('Typography', 'capital'),
		),
		array(
    		'id'   =>'divider_3',
    		'type' => 'section',
			'indent' => true,
			'title' => esc_html__('Button 3','capital')
		),
		array(
            'id' => 'feat_button_title3',
            'type' => 'text',
            'title' => esc_html__('Label', 'capital'),
            'subtitle' => esc_html__('Insert featured button 3 label', 'capital'),
            'desc' => esc_html__('Allowed HTML tags: span, u, i, b, br, strong, del, strike, em, img', 'capital'),
            'default' => esc_html__('Button','capital')
        ),
		array(
            'id' => 'feat_button_url3',
            'type' => 'text',
            'title' => esc_html__('URL', 'capital'),
            'subtitle' => esc_html__('Enter featured button 3 URL', 'capital'),
            'desc' => esc_html__('A valid URL is required to show the button.', 'capital'),
            'default' => ''
        ),
		array(
			'id'=>'feat_button_shape3',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Shape', 'capital'), 
			'options' => array(
					'fbtn-rounded' => esc_html__('Rounded','capital'),
					'fbtn-square' => esc_html__('Square','capital'),
					'fbtn-round' => esc_html__('Round','capital')
				),
			'default' => 'fbtn-rounded',
		),
		array(
			'id'=>'feat_button_size3',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Size', 'capital'), 
			'options' => array(
					'fbtn-xs' => esc_html__('Extra Small','capital'),
					'fbtn-sm' => esc_html__('Small','capital'),
					'fbtn-md' => esc_html__('Medium','capital'),
					'fbtn-lg' => esc_html__('Large','capital'),
					'fbtn-custom' => esc_html__('Custom','capital')
				),
			'default' => 'fbtn-md',
		),
		array(
			'id'=>'feat_button_size3_custom',
			'type' => 'dimensions',
			'compiler'=>true,
			'compiler' => array('.featured-buttons .fbtn3'),
			'title' => esc_html__('Custom size', 'capital'),
			'desc' => esc_html__('Enter width and height for the featured button custom size.', 'capital'),
			'required' => array('feat_button_size3','=','fbtn-custom')
		),
		array(         
			'id'   	=> 'feat_button_bg3_translucent',
			'type'	=> 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'  => array('background-color' => '.featured-buttons .fbtn3'),
			'title'   => esc_html__('Background color translucent', 'capital'),
		),
		array(         
			'id'   	=> 'feat_button_bg3',
			'type'	=> 'background',
			'preview' => false,
			'compiler'  => array('.featured-buttons .fbtn3'),
			'title'   => esc_html__('Background color/image', 'capital'),
		),
		array(         
			'id'   	=> 'feat_button_bg3_translucent_hover',
			'type'	=> 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'  => array('background-color' => '.featured-buttons .fbtn3:hover'),
			'title'   => esc_html__('Hover background color translucent', 'capital'),
		),
		array(         
			'id'   	=> 'feat_button_bg3_hover',
			'type'	=> 'background',
			'preview' => false,
			'compiler'  => array('.featured-buttons .fbtn3:hover'),
			'title'   => esc_html__('Background color/image', 'capital'),
		),
		array(
			'id'=>'feat_button_border3',
			'type' => 'border',
			'compiler'  => array('.featured-buttons .fbtn3'),
			'title' => esc_html__('Border', 'capital'), 
		),
		array(
			'id'=>'feat_button_border3_hover',
			'type' => 'border',
			'compiler'  => array('.featured-buttons .fbtn3:hover'),
			'title' => esc_html__('Hover Border', 'capital'), 
		),
		array(         
			'id'   	=> 'feat_button_color3',
			'type'	=> 'link_color',
			'compiler'  => array('.featured-buttons .fbtn3'),
			'title'   => esc_html__('Link color', 'capital'),
		),
		array(
			'id'=>'feat_button_typo3',
			'type' => 'typography',
			'line-height' => false,
			'text-align'  => false,
			'color'  => false,
			'word-spacing'  => true,
			'letter-spacing'  => true,
			'text-transform'  => true,
			'compiler'  => array('.featured-buttons .fbtn.fbtn3'),
			'title' => esc_html__('Typography', 'capital'),
		),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Header Info', 'capital'),
	'subsection' => true,
    'fields' => array(
		array(
    		'id'   =>'info_divider_1',
    		'type' => 'section',
			'indent' => true,
			'title' => esc_html__('Header info 1','capital')
		),
		array(
            'id' => 'header_info_text1',
            'type' => 'textarea',
            'title' => esc_html__('Header Info 1', 'capital'),
            'subtitle' => esc_html__('HTML tags are allowed', 'capital'),
            'default' => ''
        ),
		array(
    		'id'   =>'info_divider_2',
    		'type' => 'section',
			'indent' => true,
			'title' => esc_html__('Header info 2','capital')
		),
		array(
            'id' => 'header_info_text2',
            'type' => 'textarea',
            'title' => esc_html__('Header Info 2', 'capital'),
            'subtitle' => esc_html__('HTML tags are allowed', 'capital'),
            'default' => ''
        ),
		array(
    		'id'   =>'info_divider_3',
    		'type' => 'section',
			'indent' => true,
			'title' => esc_html__('Header info 3','capital')
		),
		array(
            'id' => 'header_info_text3',
            'type' => 'textarea',
            'title' => esc_html__('Header Info 3', 'capital'),
            'subtitle' => esc_html__('HTML tags are allowed', 'capital'),
            'default' => ''
        ),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Social Links', 'capital'),
	'subsection' => true,
    'fields' => array(
        array(
			'id' => 'header_social_links',
			'type' => 'sortable',
			'label' => true,
			'compiler'=>true,
			'title' => esc_html__('Social Links', 'capital'),
			'desc' => esc_html__('Enter the social links and sort to activate and display according to sequence.', 'capital'),
			'options' => array(
				'fa-facebook' => 'facebook',
				'fa-twitter' => 'twitter',
				'fa-pinterest' => 'pinterest',
				'fa-google-plus' => 'google',
				'fa-youtube-play' => 'youtube',
				'fa-instagram' => 'instagram',
				'fa-vimeo' => 'vimeo',
				'fa-rss' => 'rss',
				'fa-dribbble' => 'dribbble',
				'fa-dropbox' => 'dropbox',
				'fa-bitbucket' => 'bitbucket',
				'fa-flickr' => 'flickr',
				'fa-foursquare' => 'foursquare',
				'fa-github' => 'github',
				'fa-gittip' => 'gittip',
				'fa-linkedin' => 'linkedin',
				'fa-pagelines' => 'pagelines',
				'fa-skype' => 'Enter Skype ID',
				'fa-tumblr' => 'tumblr',
				'fa-tripadvisor' => 'tripadvisor',
				'fa-vk' => 'vk',
				'fa-envelope' => 'Email Address'
			),
		),
		array(
			'id'=>'main_social_shape',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Shape', 'capital'), 
			'options' => array(
					'imi-social-icons-round' => esc_html__('Round','capital'),
					'imi-social-icons-rounded' => esc_html__('Rounded','capital'),
					'imi-social-icons-square' => esc_html__('Square','capital'),
					'imi-social-icons-plain' => esc_html__('Plain','capital')
				),
			'default' => 'imi-social-icons-round',
		),
		array(
			'id'=>'main_social_size',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Size', 'capital'), 
			'options' => array(
					'imi-social-icons-small' => esc_html__('Small','capital'),
					'imi-social-icons-medium' => esc_html__('Medium','capital'),
					'imi-social-icons-large' => esc_html__('Large','capital'),
					'imi-social-icons-xlarge' => esc_html__('Extra Large','capital'),
					'imi-social-icons-custom' => esc_html__('Custom','capital')
				),
			'default' => 'imi-social-icons-medium',
		),
		array(
			'id'=>'main_social_custom_size',
			'type' => 'dimensions',
			'compiler'=>true,
			'compiler' => array('.header-social-container .imi-social-icons li a'),
			'title' => esc_html__('Custom size', 'capital'),
			'desc' => esc_html__('Keep the width and height fields filled with same values to keep the social icons boxes in square.', 'capital'),
			'required' => array('main_social_size','=','imi-social-icons-custom')
		),
		array(
			'id'=>'main_social_custom_spacing',
			'type' => 'spacing',
			'mode' => 'margin',
			'units' => array('px'),
			'compiler'=>true,
			'compiler' => array('.header-social-container .imi-social-icons li'),
			'title' => esc_html__('Custom spacing', 'capital'),
			'desc' => esc_html__('Enter the margin from all sides for each social icon link.', 'capital'),
			'required' => array('main_social_size','=','imi-social-icons-custom')
		),
		array(
			'id'=>'main_social_custom_typo',
			'type' => 'typography',
			'compiler'=>true,
			'font-family' => false,
			'preview' => false,
			'text-align' => false,
			'line-height' => false,
			'color' => false,
			'word-spacing' => false,
			'letter-spacing' => false,
			'font-weight' => false,
			'font-style' => false,
			'compiler' => array('.header-social-container .imi-social-icons li a'),
			'title' => esc_html__('Custom icon size', 'capital'),
			'required' => array('main_social_size','=','imi-social-icons-custom')
		),
		array(
			'id'=>'main_social_style',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Style', 'capital'), 
			'options' => array(
					'imi-social-icons-bc' => esc_html__('Brand colors','capital'),
					'imi-social-icons-tc' => esc_html__('Theme primary color','capital'),
					'imi-social-icons-sc' => esc_html__('Theme secondary color','capital'),
					'imi-social-icons-gc' => esc_html__('Grayscale','capital')
				),
			'default' => 'imi-social-icons-bc',
		),
		array(
			'id'=>'main_social_hover_style',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Hover style', 'capital'), 
			'options' => array(
					'imi-social-icons-hover-bc' => esc_html__('Brand colors','capital'),
					'imi-social-icons-hover-tc' => esc_html__('Theme primary color','capital'),
					'imi-social-icons-hover-sc' => esc_html__('Theme secondary color','capital'),
					'imi-social-icons-hover-gc' => esc_html__('Grayscale','capital')
				),
			'default' => 'imi-social-icons-hover-sc',
		),
		array(
			'id'       => 'main_social_icon_color',
			'type'     => 'link_color',
			'visited'  => false,
			'required' => array('main_social_shape','=','imi-social-icons-plain'),
			'compiler'   => array('.header-social-container .imi-social-icons li a'),
			'title'    => esc_html__('Social Links Color', 'capital'),
		),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Overlay Content', 'capital'),
	'subsection' => true,
    'fields' => array(
        array(
            'id' => 'enable_topbar_opener',
            'type' => 'checkbox',
            'title' => esc_html__('Enable Overlay Content', 'capital'),
            'subtitle' => esc_html__('Enable/Disable overlay content area that opens up on click of a special button in the topbar/header.', 'capital'	
			),
            "default" => 1,
       	),
		array(
			'id'       => 'topbar_opener_link_text',
			'type'     => 'text',
			'required' => array('enable_topbar_opener','=',1),
			'title'    => esc_html__('Overlay content opener button text', 'capital'),
            'desc' => esc_html__('Allowed HTML tags: span, u, i, b, br, strong, del, strike, em, img', 'capital'),
			'subtitle'     => esc_html__('Enter text to show for button opener for the overlay content area.', 'capital'),
			'default'  => esc_html__('Our Locations','capital')
		),
		array(
			'id'=>'topbar_opener_position',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Overlay content block position', 'capital'), 
			'subtitle' => esc_html__('Choose where you would like to show the overlay content area', 'capital'),
			'options' => array(
					'widgets-at-left' => esc_html__('Left','capital'),
					'widgets-at-top' => esc_html__('Top','capital'),
					'widgets-at-right' => esc_html__('Right','capital')
				),
			'default' => 'widgets-at-top',
		),
        array(
            'id' => 'enable_topbar_opener_always',
            'type' => 'checkbox',
            'title' => esc_html__('Keep opened by default', 'capital'),
            'subtitle' => esc_html__('Check this to keep the overlay content open by default without the trigger button action.', 'capital'	
			),
            "default" => 0,
			'required' 		 => array('topbar_opener_position','=','widgets-at-top'),
       	),
		array(
			'id'       => 'topbar_opener_dimension',
			'type'     => 'dimensions',
			'title'    => esc_html__('Width of the Overlay content block', 'capital'),
			'compiler'   => array('.topper-container.widgets-at-right, .topper-container.widgets-at-left'),
			'height'    => false,
			'default' => array(
				'width' => '400px'
			),
			'required' 		 => array('topbar_opener_position','!=','widgets-at-top'),
		),
		array(  'id' => 'topbar_widgets_background',
			'type' => 'background',
			'background-color'=> true,
			'background-image'=> false,
			'background-repeat'=> false,
			'background-attachment'=> false,
			'background-size'=> false,
			'background-position'=> false,
			'preview'=> false,
			'compiler' => array('.topper-container'),
			'title' => esc_html__('Overlay content area background color', 'capital'),
			'subtitle' => esc_html__('Background color for the overlay content area', 'capital'),
		),
		array(
			'id'       	=> 'topbar_widgets_content',
			'type'     	=> 'select',
			'title'    	=> esc_html__('Overlay Content VC Section', 'capital'), 
			'desc'    	=> esc_html__('Select VC Section for overlay content area.', 'capital'),
			'data'  	=> 'posts',
			'args'  => array(
				'post_type'      => 'imi_custom_sidebar',
				'posts_per_page' => -1,
				'orderby'        => 'title',
				'order'          => 'ASC',
			),
		),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Search Form Style', 'capital'),
	'subsection' => true,
    'fields' => array(
		array(
			'id'=>'search_form_style',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Search form style for site header and topbar', 'capital'), 
			'options' => array(
					'0' => esc_html__('Dropdown form','capital'),
					'1' => esc_html__('Open form','capital'),
					'2' => esc_html__('Overlay form','capital')
				),
			'default' => '0',
		),
		array(
			'id'   => 'overlay_search_bg_color',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			),   
			'required' => array('search_form_style','=','2'),
			'compiler'   => array('background-color'=>'.overlay-search-form-wrapper:before'),
			'title' => esc_html__('Search form background color','capital'),
		),
		array(
			'id'   => 'overlay_search_bg',
    		'type' => 'background',
			'background-color' => false,
			'transparent' => false,
			'required' => array('search_form_style','=','2'),
			'compiler'   => array('background-color'=>'.overlay-search-form-wrapper:before'),
			'title' => esc_html__('Search form background image','capital'),
		),
		array(
			'id'   => 'overlay_search_border',
    		'type' => 'border',
			'top'  => false,
			'left'  => false,
			'right'  => false,
			'bottom'  => true,
			'compiler'   => array('.overlay-search-form-wrapper .imi-searchform'),
			'required' => array('search_form_style','=','2'),
			'title' => esc_html__('Search form border bottom','capital'),
		),
		array(
			'id'   => 'overlay_search_field_border',
    		'type' => 'color',
			'compiler'   => array('.overlay-search-form-wrapper .imi-searchform input[type="text"]'),
			'required' => array('search_form_style','=','2'),
			'title' => esc_html__('Search form text color','capital'),
		),
		array(
			'id'       => 'overlay_search_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'required' => array('search_form_style','=','2'),
			'compiler'   => array('.overlay-search-form-wrapper .imi-searchform .btn'),
			'title'    => esc_html__('Search icon color', 'capital'),
		),
		array(
			'id'   => 'overlay_search_close_dimensions',
    		'type' => 'dimensions',
			'required' => array('search_form_style','=','2'),
			'title' => esc_html__('Close button dimensions','capital'),
			'compiler'   => array('.overlay-search-form-wrapper .overlay-wrapper-close'),
			'desc' => esc_html__('Keep width and height equal for a square button','capital')
		),
		array(
			'id'   => 'overlay_search_close_bg',
    		'type' => 'background',
			'background-image' => false,
			'background-position' => false,
			'background-attachment' => false,
			'background-size' => false,
			'background-repeat' => false,
			'preview'   => false,
			'required' => array('search_form_style','=','2'),
			'compiler'   => array('.overlay-search-form-wrapper .overlay-wrapper-close'),
			'title' => esc_html__('Close button background','capital'),
		),
		array(
			'id'   => 'overlay_search_close_hover_bg',
    		'type' => 'background',
			'background-image' => false,
			'background-position' => false,
			'background-attachment' => false,
			'background-size' => false,
			'background-repeat' => false,
			'preview'   => false,
			'required' => array('search_form_style','=','2'),
			'compiler'   => array('.overlay-search-form-wrapper .overlay-wrapper-close:hover'),
			'title' => esc_html__('Close button hover background','capital'),
		),
		array(
			'id'       => 'overlay_search_close_link_color',
			'type'     => 'link_color',
			'visited'  => false,
			'required' => array('search_form_style','=','2'),
			'compiler'   => array('.overlay-search-form-wrapper .overlay-wrapper-close'),
			'title'    => esc_html__('Close button color', 'capital'),
		),
        array(
            'id' => 'overlay_search_close_link_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Close button font size', 'capital'),
			'required' => array('search_form_style','=','2'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => false,
			'letter-spacing' => false,
			'text-transform' => false,
			'word-spacing' => false,
			'line-height' => false,
			'font-family' => false,
			'font-weight' => false,
			'preview' => false,
			'compiler'   => array('.overlay-search-form-wrapper .overlay-wrapper-close'),
			'units'       =>'px',
        ),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
	'subsection' => true,
    'title' => esc_html__('Logo', 'capital'),
    'desc' => esc_html__('These are the options for the header.', 'capital'),
    'fields' => array(
        array(
            'id' => 'logo_upload',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Upload Logo', 'capital'),
            'subtitle' => esc_html__('Upload site logo to display in header.', 'capital'),
            'default' => array('url' => $default_logo,'height' => '23',),
        ),
        array(
            'id' => 'retina_logo_upload',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Upload Logo for Retina Devices', 'capital'),
            'desc' => esc_html__('Retina Display is a marketing term developed by Apple to refer to devices and monitors that have a resolution and pixel density so high &ndash; roughly 300 or more pixels per inch', 'capital'),
            'subtitle' => esc_html__('Upload site logo to display in header.', 'capital'),
            'default' => array('url' => $default_retina_logo),
        ),
		array(
			'id'             => 'logo_spacing',
			'type'           => 'spacing',
			'compiler'         => array('.site-logo'),
			'mode'           => 'padding',
			'units'          => array('px'),
			'units_extended' => 'false',
			'title'          => esc_html__('Logo Spacing', 'capital'),
			'subtitle'       => esc_html__('Set top, right, bottom, left spacing for the logo', 'capital'),
			'default' 		 => array(
								'padding-top' => '30px',
								'padding-bottom' => '30px'
							)
		),
		array(
			'id'   => 'logo_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			),   
			'compiler'   => array('background-color'=>'.site-logo'),
			'title' => esc_html__('Logo background','capital'),
		),
		array(
			'id'   => 'logo_border',
    		'type' => 'border',
			'all'  => false,
			'compiler'   => array('.site-logo'),
			'title' => esc_html__('Logo border','capital'),
		),
		array(
			'id'        => 'sticky_logo_section_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Sticky header logo','capital'),
			'subtitle'  => esc_html__('Use this section to upload a unique logo for your website sticky header.','capital'),
			'position'  => 'start',
		),
        array(
            'id' => 'sticky_logo_upload',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Upload Logo', 'capital'),
            'subtitle' => esc_html__('Upload site logo to display in sticky header.', 'capital'),
            'default' => '',
        ),
        array(
            'id' => 'sticky_retina_logo_upload',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Upload Logo for Retina Devices', 'capital'),
            'desc' => esc_html__('Retina Display is a marketing term developed by Apple to refer to devices and monitors that have a resolution and pixel density so high &ndash; roughly 300 or more pixels per inch', 'capital'),
            'subtitle' => esc_html__('Upload site logo to display in header.', 'capital'),
            'default' => '',
        ),
		array(
			'id'             => 'sticky_logo_spacing',
			'type'           => 'spacing',
			'compiler'         => array('.sticky-logo'),
			'mode'           => 'padding',
			'units'          => array('px'),
			'units_extended' => 'false',
			'title'          => esc_html__('Logo Spacing', 'capital'),
			'subtitle'       => esc_html__('Set top, right, bottom, left spacing for the logo', 'capital'),
		),
		array(
			'id'   => 'sticky_logo_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			),   
			'compiler'   => array('background-color'=>'.sticky-logo'),
			'title' => esc_html__('Logo background','capital'),
		),
		array(
			'id'   => 'sticky_logo_border',
    		'type' => 'border',
			'all'  => false,
			'compiler'   => array('.sticky-logo'),
			'title' => esc_html__('Logo border','capital'),
		),
		array(
			'id'        => 'sticky_logo_section_end',
			'type'      => 'accordion',
			'position'  => 'end',
		),
		array(
			'id'        => 'mobile_logo_section_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Mobile header logo','capital'),
			'subtitle'  => esc_html__('Use this section to upload a unique logo for your website header when viewed on a small screen device like mobile.','capital'),
			'position'  => 'start',
		),
        array(
            'id' => 'mobile_logo_upload',
            'type' => 'media',
			'required' => array('enable_mobile_header','=',1),
            'url' => true,
            'title' => esc_html__('Upload Logo', 'capital'),
            'subtitle' => esc_html__('Upload site logo to display in mobile header.', 'capital'),
            'default' => '',
        ),
        array(
            'id' => 'mobile_retina_logo_upload',
            'type' => 'media',
			'required' => array('enable_mobile_header','=',1),
            'url' => true,
            'title' => esc_html__('Upload Logo for Retina Devices', 'capital'),
            'desc' => esc_html__('Retina Display is a marketing term developed by Apple to refer to devices and monitors that have a resolution and pixel density so high &ndash; roughly 300 or more pixels per inch', 'capital'),
            'subtitle' => esc_html__('Upload site retina logo to display in mobile header.', 'capital'),
            'default' => '',
        ),
		array(
			'id'        => 'mobile_logo_section_end',
			'type'      => 'accordion',
			'position'  => 'end',
		),
	),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Topbar', 'capital'),
	'subsection' => true,
    'fields' => array(
        array(
            'id' => 'show_topbar',
            'type' => 'checkbox',
            'title' => esc_html__('Show Topbar', 'capital'),
            'subtitle' => esc_html__('Enable/Disable Topbar', 'capital'	
			),
            "default" => 1,
       	),
		array(
			'id'      => 'topbar_left_blocks',
			'type'    => 'sorter',
			'title'   => 'Topbar left content',
			'subtitle'    => esc_html__('Drag/Drop the blocks to organize how you want the layout in the site topbar. Selected blocks here will appear at the left side of topbar, for right side see below.','capital'),
			'options' => array(
				'enabled'  => array(
					'social-icons' => esc_html__('Social Icons','capital'),
				),
				'disabled' => array(
					'header-info1'   => esc_html__('Header Info 1','capital'),
					'header-info2'   => esc_html__('Header Info 2','capital'),
					'header-info3'   => esc_html__('Header Info 3','capital'),
					'featured-button1' => esc_html__('Featured Btn 1','capital'),
					'featured-button2' => esc_html__('Featured Btn 2','capital'),
					'featured-button3' => esc_html__('Featured Btn 3','capital'),
					'widgets-opener'     => esc_html__('Widgets Opener','capital'),
					'menu' => esc_html__('Top Menu','capital'),
					'search' => esc_html__('search','capital'),
					'cart' => esc_html__('Cart','capital')
				)
			),
		),
		array(
			'id'      => 'topbar_right_blocks',
			'type'    => 'sorter',
			'title'   => 'Topbar right content',
			'subtitle'    => esc_html__('Drag/Drop the blocks to organize how you want the layout in the site topbar. Selected blocks here will appear at the right side of topbar, for left side see above.','capital'),
			'options' => array(
				'enabled'  => array(
					'menu' => esc_html__('Top Menu','capital'),
				),
				'disabled' => array(
					'header-info1'   => esc_html__('Header Info 1','capital'),
					'header-info2'   => esc_html__('Header Info 2','capital'),
					'header-info3'   => esc_html__('Header Info 3','capital'),
					'featured-button1' => esc_html__('Featured Btn 1','capital'),
					'featured-button2' => esc_html__('Featured Btn 2','capital'),
					'featured-button3' => esc_html__('Featured Btn 3','capital'),
					'social-icons' 	 => esc_html__('Social Icons','capital'),
					'widgets-opener' => esc_html__('Widgets Opener','capital'),
					'search' 		 => esc_html__('search','capital'),
					'cart' 			 => esc_html__('Cart','capital')
				)
			),
		),
		array(
			'id'        => 'topbar_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Topbar style','capital'),
			'subtitle'  => esc_html__('Use this section to style the topbar of your website.','capital'),
			'position'  => 'start',
		),
        array(
			'id'=>'topbar_wide_width',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('100% Width', 'capital'), 
			'subtitle' => esc_html__('Check this box to set the topbar area to 100% of the browser width. Uncheck to follow site width.', 'capital'),
			'default' => '0',
		),
        array(
			'id'=>'topbar_no_side_padding',
			'type' => 'checkbox',
			'compiler'=>true,
			'required' => array('topbar_wide_width','=','1'),
			'title' => esc_html__('No space on left/right', 'capital'), 
			'subtitle' => esc_html__('Check this box to set the topbar area to 100% of the browser width with no space on the sides.', 'capital'),
			'default' => '0',
		),
		array(
			'id'       => 'topbar_max_height',
			'type'     => 'dimensions',
			'width' => false,
			'title'    => esc_html__('Topbar height', 'capital'),
			'units'  => 'px',
            'subtitle' => esc_html__('Set maximum height for the topbar. Default is 48px.', 'capital'),
			'compiler'   => array('.topbar, .topbar .header-equaler, .topbar .header-equaler > div > div, .topbar .topbar-blocks, .topbar .topbar-blocks > div > div, .topbar-additional-menu > ul > li > a'),
			'default'  => array(
				'height' => ''
			)
		),
		array(  'id' => 'topbar_background',
			'type' => 'background',
			'compiler' => array('.topbar'),
			'title' => esc_html__('Background color/image', 'capital'),
			'subtitle' => esc_html__('Background color/image for the topbar.', 'capital'),
		),
		array(
			'id'        => 'topbar_style_end',
			'type'      => 'accordion',
			'position'  => 'end',
		),
		array(
			'id'        => 'thinfo_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Header info style','capital'),
			'subtitle'  => esc_html__('Use this section to style the header info used for the topbar.','capital'),
			'position'  => 'start',
		),
		array(
			'id'       => 'header_info_typo_topbar',
			'type'     => 'typography',
			'text-transform' => true,
			'word-spacing' => true,
			'letter-spacing' => true,
			'color' => true,
			'line-height' => false,
			'text-align' => false,
			'title'    => __('Typography', 'capital'),
			'desc'    => __('These options will affect the header info shown in the site topbar only.', 'capital'),
			'compiler'   => array('.topbar .header_info_text')
		),
		array(
			'id'       => 'header_info_topbar_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.topbar .header_info_text a'),
			'title'    => esc_html__('Links color', 'capital'),
			'desc'    => __('These options will affect the links in header info shown in the site topbar only.', 'capital'),
		),
		array(
			'id'       => 'topbar_info1_width',
			'type'     => 'dimensions',
			'height' => false,
			'title'    => __('Header info 1 maximum width', 'capital'),
			'units'  => 'px',
            'subtitle' => esc_html__('Set maximum width for the header info block 1 for the site topbar. For auto width leave empty.', 'capital'),
			'compiler'   => array('.topbar .header_info_text1'),
			'default'  => array(
				'width' => ''
			)
		),
		array(
			'id'       => 'topbar_info2_width',
			'type'     => 'dimensions',
			'height' => false,
			'title'    => esc_html__('Header info 2 maximum width', 'capital'),
			'units'  => 'px',
            'subtitle' => esc_html__('Set maximum width for the header info block 2 for the site topbar. For auto width leave empty.', 'capital'),
			'compiler'   => array('.topbar .header_info_text2'),
			'default'  => array(
				'width' => ''
			)
		),
		array(
			'id'       => 'topbar_info3_width',
			'type'     => 'dimensions',
			'height' => false,
			'title'    => esc_html__('Header info 3 maximum width', 'capital'),
			'units'  => 'px',
            'subtitle' => esc_html__('Set maximum width for the header info block 3 for the site topbar. For auto width leave empty.', 'capital'),
			'compiler'   => array('.topbar .header_info_text3'),
			'default'  => array(
				'width' => ''
			)
		),
		array(
			'id'        => 'thinfo_style_end',
			'type'      => 'accordion',
			'position'  => 'end'
		),
		array(
			'id'        => 'tsicons_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Social icons style','capital'),
			'subtitle'  => esc_html__('Use this section to style the social icons used for the topbar.','capital'),
			'position'  => 'start',
		),
		array(
			'id'=>'topbar_social_custom_size',
			'type' => 'dimensions',
			'compiler'=>true,
			'compiler' => array('.topbar .header-social-container .imi-social-icons li a'),
			'title' => esc_html__('Custom size', 'capital'),
			'desc' => esc_html__('Keep the width and height fields filled with same values to keep the social icons boxes in square.', 'capital'),
		),
		array(
			'id'=>'topbar_social_custom_spacing',
			'type' => 'spacing',
			'mode' => 'margin',
			'units' => array('px'),
			'compiler'=>true,
			'compiler' => array('.topbar .header-social-container .imi-social-icons li'),
			'title' => esc_html__('Custom spacing', 'capital'),
			'desc' => esc_html__('Enter the margin from all sides for each social icon link.', 'capital'),
		),
		array(
			'id'=>'topbar_social_custom_typo',
			'type' => 'typography',
			'compiler'=>true,
			'font-family' => false,
			'preview' => false,
			'text-align' => false,
			'line-height' => false,
			'color' => false,
			'word-spacing' => false,
			'letter-spacing' => false,
			'font-weight' => false,
			'font-style' => false,
			'compiler' => array('.topbar .header-social-container .imi-social-icons li a'),
			'title' => esc_html__('Custom icon size', 'capital'),
		),
		array(
			'id'       => 'topbar_social_icon_color',
			'type'     => 'link_color',
			'visited'  => false,
			'required' => array('main_social_shape','=','imi-social-icons-plain'),
			'compiler'   => array('.topbar .header-social-container .imi-social-icons li a'),
			'title'    => esc_html__('Social Links Color', 'capital'),
		),
		array(
			'id'        => 'tsicons_style_end',
			'type'      => 'accordion',
			'position'  => 'end'
		),
		array(
			'id'        => 'tmenu_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Topbar Menu style','capital'),
			'subtitle'  => esc_html__('Use this section to style the menu used for the topbar. This is the menu you select for location "Topbar Menu" at Appearance => Menus','capital'),
			'position'  => 'start',
		),
        array(
            'id' => 'topbar_menu_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Typography', 'capital'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'word-spacing' => true,
			'text-transform' => true,
			'line-height' => false,
			'compiler'      => array('.topbar-additional-menu > ul > li a'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'topbar_menu_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.topbar-additional-menu > ul > li > a'),
			'title'    => esc_html__('Links Color', 'capital'),
		),
		array(
			'id'       => 'topbar_menu_links_border',
			'type'     => 'border',
			'right'  => false,
			'left'  => true,
			'top'  => false,
			'bottom'  => false,
			'compiler'   => array('.topbar-additional-menu > ul > li > a'),
			'title'    => esc_html__('Links sides border', 'capital'),
		),
		array(
			'id'       => 'topbar_menu_links_padding',
			'type'     => 'spacing',
			'mode'  => 'padding',
			'top'  => false,
			'bottom'  => false,
			'units'  => array('px'),
			'compiler'   => array('.topbar-additional-menu > ul > li a, .topbar-additional-menu > ul > li ul li a'),
			'title'    => esc_html__('Links inside spacing', 'capital'),
		),
		array(
			'id'       => 'topbar_menu_dd_bg',
			'type'     => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.topbar-additional-menu > ul > li ul'),
			'title'    => esc_html__('Dropdown background', 'capital'),
		),
        array(
            'id' => 'topbar_menu_dd_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Dropdown links typography', 'capital'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'word-spacing' => true,
			'line-height' => false,
			'compiler'      => array('.topbar-additional-menu > ul > li > ul > li a'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'topbar_menu_dd_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.topbar-additional-menu > ul > li > ul > li a'),
			'title'    => esc_html__('Dropdown links color', 'capital'),
		),
		array(
			'id'        => 'tmenu_style_end',
			'type'      => 'accordion',
			'position'  => 'end'
		),
		array(
			'id'        => 'tsearch_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Search module style','capital'),
			'subtitle'  => esc_html__('Use this section to style the search trigger icon link or search open form as selected in the "Search Form Style" option.','capital'),
			'position'  => 'start',
		),
		array(
			'id'   => 'tddsearch_trigger_dimensions',
    		'type' => 'dimensions',
			'required' => array('search_form_style','!=',1),
			'title' => esc_html__('Trigger icon dimensions','capital'),
			'compiler'   => array('.topbar .search-module-trigger'),
			'desc' => esc_html__('Keep width and height equal for a square icon box','capital')
		),
		array(
			'id'   => 'tddsearch_trigger_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'required' => array('search_form_style','!=',1),
			'compiler'   => array('background-color'=>'.topbar .search-module-trigger'),
			'title' => esc_html__('Trigger icon background','capital'),
		),
		array(
			'id'   => 'tddsearch_trigger_hover_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'required' => array('search_form_style','!=',1),
			'compiler'   => array('background-color'=>'.topbar .search-module-trigger:hover'),
			'title' => esc_html__('Trigger icon hover background','capital'),
		),
		array(
			'id'   => 'tddsearch_trigger_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.topbar .search-module-trigger'),
			'required' => array('search_form_style','!=',1),
			'title' => esc_html__('Trigger icon border','capital'),
		),
		array(
			'id'   => 'tddsearch_trigger_hover_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.topbar .search-module-trigger:hover'),
			'required' => array('search_form_style','!=',1),
			'title' => esc_html__('Trigger icon hover border','capital'),
		),
        array(
            'id' => 'tddsearch_trigger_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Trigger icon font size', 'capital'),
			'required' => array('search_form_style','!=',1),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => false,
			'letter-spacing' => false,
			'text-transform' => false,
			'word-spacing' => false,
			'line-height' => false,
			'font-family' => false,
			'font-weight' => false,
			'preview' => false,
			'compiler'   => array('.topbar .search-module-trigger'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'tddsearch_trigger_links_color',
			'required' => array('search_form_style','!=',1),
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.topbar .search-module-trigger'),
			'title'    => esc_html__('Trigger icon link color', 'capital'),
		),
		array(
			'id'   => 'tddsearch_opened_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'required' => array('search_form_style','=',0),
			'compiler'   => array('background-color'=>'.topbar .search-module-opened'),
			'title' => esc_html__('Dropdown search form background','capital'),
		),
		array(
			'id'   => 'tddsearch_opened_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.topbar .search-module-opened'),
			'required' => array('search_form_style','=',0),
			'title' => esc_html__('Dropdown search form border','capital'),
		),
		array(
			'id'   => 'tddsearch_opened_border_top',
    		'type' => 'border',
			'top'  => true,
			'bottom'  => false,
			'left'  => false,
			'right'  => false,
			'compiler'   => array('.topbar .search-module-opened'),
			'required' => array('search_form_style','=',0),
			'title' => esc_html__('Dropdown search form border top','capital'),
		),
		array(
			'id'   => 'topensearch_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'required' => array('search_form_style','=',1),
			'compiler'   => array('background-color'=>'.topbar .open-search-form .imi-searchform'),
			'title' => esc_html__('Search form background','capital'),
		),
		array(
			'id'   => 'topensearch_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.topbar .open-search-form .imi-searchform'),
			'required' => array('search_form_style','=',1),
			'title' => esc_html__('Search form border','capital'),
		),
		array(
			'id'=>'topensearch_dimensions',
			'type' => 'dimensions',
			'height' => false,
			'compiler'=>true,
			'compiler' => array('.topbar .open-search-form .imi-searchform input[type="text"]'),
			'title' => esc_html__('Search form width', 'capital'),
			'required' => array('search_form_style','=',1),
			'desc' => esc_html__('Enter width for the search form.', 'capital')
		),
		array(
			'id'=>'topensearch_height',
			'type' => 'dimensions',
			'width' => false,
			'compiler'=>true,
			'compiler' => array('.topbar .open-search-form .imi-searchform input[type="text"],.topbar .open-search-form .imi-searchform .btn'),
			'title' => esc_html__('Search form height', 'capital'),
			'required' => array('search_form_style','=',1),
			'desc' => esc_html__('Enter height for the search form.', 'capital')
		),
        array(
            'id' => 'topensearch_field_color',
            'type'        => 'typography',
			'title'       => esc_html__('Search form text typography', 'capital'),
			'required' => array('search_form_style','=',1),
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'word-spacing' => true,
			'line-height' => false,
			'font-family' => true,
			'font-weight' => true,
			'preview' => true,
			'compiler'   => array('.topbar .open-search-form .imi-searchform input[type="text"]'),
			'units'       =>'px',
        ),
        array(
            'id' => 'topensearch_links_typo',
            'type'        => 'typography',
			'title'       => esc_html__('Search icon size', 'capital'),
			'required' => array('search_form_style','=',1),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => false,
			'letter-spacing' => false,
			'text-transform' => false,
			'word-spacing' => false,
			'line-height' => false,
			'font-family' => false,
			'font-weight' => false,
			'preview' => false,
			'compiler'   => array('.topbar .open-search-form .imi-searchform .btn'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'topensearch_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'required' => array('search_form_style','=',1),
			'compiler'   => array('.topbar .open-search-form .imi-searchform .btn'),
			'title'    => esc_html__('Search icon color', 'capital'),
		),
		array(
			'id'        => 'tsearch_style_end',
			'type'      => 'accordion',
			'position'  => 'end'
		),
		array(
			'id'        => 'tcart_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Cart module style','capital'),
			'subtitle'  => esc_html__('Use this section to style the cart trigger icon link and cart block shown in the topbar','capital'),
			'position'  => 'start',
		),
		array(
			'id'   => 'tcart_trigger_dimensions',
    		'type' => 'dimensions',
			'title' => esc_html__('Trigger icon dimensions','capital'),
			'compiler'   => array('.topbar .cart-module-trigger'),
			'desc' => esc_html__('Keep width and height equal for a square icon box','capital')
		),
		array(
			'id'   => 'tcart_trigger_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.topbar .cart-module-trigger'),
			'title' => esc_html__('Trigger icon background','capital'),
		),
		array(
			'id'   => 'tcart_trigger_hover_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.topbar .cart-module-trigger:hover'),
			'title' => esc_html__('Trigger icon hover background','capital'),
		),
		array(
			'id'   => 'tcart_trigger_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.topbar .cart-module-trigger'),
			'title' => esc_html__('Trigger icon border','capital'),
		),
		array(
			'id'   => 'tcart_trigger_hover_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.topbar .cart-module-trigger:hover'),
			'title' => esc_html__('Trigger icon hover border','capital'),
		),
        array(
            'id' => 'tcart_trigger_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Trigger icon font size', 'capital'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => false,
			'letter-spacing' => false,
			'text-transform' => false,
			'word-spacing' => false,
			'line-height' => false,
			'font-family' => false,
			'font-weight' => false,
			'preview' => false,
			'compiler'   => array('.topbar .cart-module-trigger'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'tcart_trigger_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.topbar .cart-module-trigger'),
			'title'    => esc_html__('Trigger icon link color', 'capital'),
		),
		array(
			'id'   => 'tcart_opened_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.topbar .cart-module-opened'),
			'title' => esc_html__('Open cart background','capital'),
		),
		array(
			'id'   => 'tcart_opened_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.topbar .cart-module-items'),
			'title' => esc_html__('Open cart border','capital'),
		),
		array(
			'id'   => 'tcart_opened_border_top',
    		'type' => 'border',
			'top'  => true,
			'bottom'  => false,
			'left'  => false,
			'right'  => false,
			'compiler'   => array('.topbar .cart-module-opened'),
			'title' => esc_html__('Open cart border top','capital'),
		),
		array(
			'id'       => 'tcart_items_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.topbar .cart-module-items > li > a'),
			'title'    => esc_html__('Cart items text color', 'capital'),
		),
        array(
            'id' => 'tcart_items_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Cart items typography', 'capital'),
			'subsets' 	  => false,
			'color' 		  => true,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'word-spacing' => true,
			'line-height' => true,
			'font-family' => true,
			'font-weight' => true,
			'preview' => true,
			'compiler'   => array('.topbar .cart-module-items > li'),
			'units'       =>'px',
        ),
		array(
			'id'   => 'tcart_opened_footer_bg',
    		'type' => 'color_rgba',
			'compiler'   => array('background-color'=>'.topbar .cart-module-footer'),
			'title' => esc_html__('Open cart footer background','capital'),
		),
		array(
			'id'   => 'tcart_opened_footer_link_hover_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.topbar .cart-module-footer a.basic-link:hover'),
			'title' => esc_html__('Open cart footer links hover background','capital'),
		),
		array(
			'id'       => 'tcart_opened_footer_link_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.topbar .cart-module-footer a.basic-link'),
			'title'    => esc_html__('Open cart footer links color', 'capital'),
		),
        array(
            'id' => 'tcart_opened_footer_link_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Open cart footer links typography', 'capital'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'word-spacing' => true,
			'line-height' => true,
			'font-family' => true,
			'font-weight' => true,
			'preview' => true,
			'compiler'   => array('.topbar .cart-module-footer a.basic-link'),
			'units'       =>'px',
        ),
		array(
			'id'        => 'tcart_style_end',
			'type'      => 'accordion',
			'position'  => 'end'
		),
		array(
			'id'        => 'twopener_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Overlay content opener button style','capital'),
			'subtitle'  => esc_html__('Use this section to style the overlay content trigger link shown in the topbar','capital'),
			'position'  => 'start',
		),
		array(
			'id'   => 'twopener_trigger_dimensions',
    		'type' => 'dimensions',
			'title' => esc_html__('Trigger icon dimensions','capital'),
			'compiler'   => array('.topbar .topper-opener'),
			'desc' => esc_html__('Keep width and height equal for a square button box','capital')
		),
		array(
			'id'   => 'twopener_trigger_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.topbar .topper-opener'),
			'title' => esc_html__('Trigger button background','capital'),
		),
		array(
			'id'   => 'twopener_trigger_hover_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.topbar .topper-opener:hover'),
			'title' => esc_html__('Trigger button hover background','capital'),
		),
		array(
			'id'   => 'twopener_trigger_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.topbar .topper-opener'),
			'title' => esc_html__('Trigger button border','capital'),
		),
		array(
			'id'   => 'twopener_trigger_hover_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.topbar .topper-opener:hover'),
			'title' => esc_html__('Trigger button hover border','capital'),
		),
        array(
            'id' => 'twopener_trigger_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Trigger button font size', 'capital'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'word-spacing' => true,
			'line-height' => false,
			'font-family' => true,
			'font-weight' => true,
			'preview' => true,
			'compiler'   => array('.topbar .topper-opener'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'twopener_trigger_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.topbar .topper-opener'),
			'title'    => esc_html__('Trigger button text color', 'capital'),
		),
		array(
			'id'        => 'twopener_style_end',
			'type'      => 'accordion',
			'position'  => 'end'
		)
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Sticky Header', 'capital'),
	'subsection' => true,
    'fields' => array(
        array(
            'id' => 'enable_sticky_header',
            'type' => 'switch',
            'title' => esc_html__('Sticky Header', 'capital'),
            'subtitle' => esc_html__('Enable/Disable', 'capital'),
            "default" => 1,
        ),
		array(
			'id'      => 'sticky_header_left_blocks',
			'required' => array('enable_sticky_header','=',1),
			'type'    => 'sorter',
			'title'   => esc_html__('Sticky header left content','capital'),
			'subtitle'    => esc_html__('Drag/Drop the blocks to organize how you want the layout in the site sticky header. Selected blocks here will appear at the left side of sticky header, for right side see below.','capital'),
			'options' => array(
				'enabled'  => array(
					'logo' => esc_html__('Logo','capital'),
				),
				'disabled' => array(
					'menu'     => esc_html__('Menu','capital'),
					'cart'     => esc_html__('Cart','capital'),
					'search'   => esc_html__('Search','capital'),
					'featured-button1' => esc_html__('Featured Btn 1','capital'),
					'featured-button2' => esc_html__('Featured Btn 2','capital'),
					'featured-button3' => esc_html__('Featured Btn 3','capital'),
					'header-info1'     => esc_html__('Header Info 1','capital'),
					'header-info2'     => esc_html__('Header Info 2','capital'),
					'header-info3'     => esc_html__('Header Info 3','capital'),
					'social-icons'     => esc_html__('Social Icons','capital'),
					'widgets-opener'   => esc_html__('Widgets opener','capital')
				)
			),
		),
		array(
			'id'      => 'sticky_header_right_blocks',
			'required' => array('enable_sticky_header','=',1),
			'type'    => 'sorter',
			'title'   => 'Sticky header right content',
			'subtitle'    => esc_html__('Drag/Drop the blocks to organize how you want the layout in the site sticky header. Selected blocks here will appear at the right side of header, for left side see above.','capital'),
			'options' => array(
				'enabled'  => array(
					'menu' => esc_html__('Menu','capital'),
				),
				'disabled' => array(
					'search'     => esc_html__('Search','capital'),
					'cart'     => esc_html__('Cart','capital'),
					'logo' => 'Logo',
					'featured-button1' => esc_html__('Featured Btn 1','capital'),
					'featured-button2' => esc_html__('Featured Btn 2','capital'),
					'featured-button3' => esc_html__('Featured Btn 3','capital'),
					'header-info1'     => esc_html__('Header Info 1','capital'),
					'header-info2'     => esc_html__('Header Info 2','capital'),
					'header-info3'     => esc_html__('Header Info 3','capital'),
					'social-icons'     => esc_html__('Social Icons','capital'),
					'widgets-opener'   => esc_html__('Widgets opener','capital')
				)
			),
		),
		array(
			'id'        => 'stickyh_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Sticky header style','capital'),
			'subtitle'  => esc_html__('Use this section to style the sticky header of your website.','capital'),
			'position'  => 'start',
		),
        array(
			'id'=>'stickyh_wide_width',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('100% Width', 'capital'), 
			'subtitle' => esc_html__('Check this box to set the sticky header area to 100% of the browser width. Uncheck to follow site width.', 'capital'),
			'default' => '0',
		),
        array(
			'id'=>'stickyh_no_side_padding',
			'type' => 'checkbox',
			'compiler'=>true,
			'required' => array('stickyh_wide_width','=','1'),
			'title' => esc_html__('No space on left/right', 'capital'), 
			'subtitle' => esc_html__('Check this box to set the sticky header area to 100% of the browser width with no space on the sides.', 'capital'),
			'default' => '0',
		),
		array(
			'id'       => 'sticky_header_height',
			'type'     => 'dimensions',
			'width'	   => false,
			'units' 	=> array('px'),
			'compiler'   => array('.theme-sticky-header,.theme-sticky-header .header-equaler, .theme-sticky-header .header-equaler > div > div'),
			'required' => array('enable_sticky_header','=',1),
			'title'    => esc_html__('Sticky header height', 'capital'),
			'desc'     => esc_html__('Enter height for the sticky header, this is the maximum height of your site sticky header', 'capital'),
			'default'  => array(
						'height' => '75px',
						'units' 	=> 'px',
					  )
		),
		array(  'id' => 'sticky_header_background',
			'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'required' => array('enable_sticky_header','=',1),
			'compiler' => array('background-color' => '.theme-sticky-header'),
			'title' => esc_html__('Background', 'capital'),
			'subtitle' => esc_html__('Background color', 'capital'),
		),
		array(
			'id' => 'sticky_header_background_image',
			'type' => 'background',
			'transparent' => false,
			'background-color' => false,
			'compiler' => array('.theme-sticky-header'),
			'title' => esc_html__('Header background image', 'capital')
		),
		array(
			'id'        => 'stickyh_style_end',
			'type'      => 'accordion',
			'position'  => 'end',
		),
		array(
			'id'        => 'stickyh_hinfo_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Header info style','capital'),
			'subtitle'  => esc_html__('Use this section to style the header info used for the sticky header.','capital'),
			'position'  => 'start',
		),
		array(
			'id'       => 'stickyh_header_info_typo',
			'type'     => 'typography',
			'text-transform' => true,
			'word-spacing' => true,
			'letter-spacing' => true,
			'color' => true,
			'text-align' => false,
			'title'    => esc_html__('Typography', 'capital'),
			'desc'    => esc_html__('These options will affect the header info shown in the site sticky header only.', 'capital'),
			'compiler'   => array('.theme-sticky-header .header_info_text')
		),
		array(
			'id'       => 'header_info_stickyh_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.theme-sticky-header .header_info_text a'),
			'title'    => esc_html__('Links color', 'capital'),
			'desc'    => __('These options will affect the links in header info shown in the site sticky header only.', 'capital'),
		),
		array(
			'id'       => 'stickyh_info1_width',
			'type'     => 'dimensions',
			'height' => false,
			'title'    => esc_html__('Header info 1 maximum width', 'capital'),
			'units'  => 'px',
            'subtitle' => esc_html__('Set maximum width for the header info block 1 for the site sticky header. For auto width leave empty.', 'capital'),
			'compiler'   => array('.theme-sticky-header .header_info_text1'),
			'default'  => array(
				'width' => ''
			)
		),
		array(
			'id'       => 'stickyh_info2_width',
			'type'     => 'dimensions',
			'height' => false,
			'title'    => esc_html__('Header info 2 maximum width', 'capital'),
			'units'  => 'px',
            'subtitle' => esc_html__('Set maximum width for the header info block 2 for the site sticky header. For auto width leave empty.', 'capital'),
			'compiler'   => array('.theme-sticky-header .header_info_text2'),
			'default'  => array(
				'width' => ''
			)
		),
		array(
			'id'       => 'stickyh_info3_width',
			'type'     => 'dimensions',
			'height' => false,
			'title'    => esc_html__('Header info 3 maximum width', 'capital'),
			'units'  => 'px',
            'subtitle' => esc_html__('Set maximum width for the header info block 3 for the site sticky header. For auto width leave empty.', 'capital'),
			'compiler'   => array('.theme-sticky-header .header_info_text3'),
			'default'  => array(
				'width' => ''
			)
		),
		array(
			'id'        => 'stickyh_hinfo_style_end',
			'type'      => 'accordion',
			'position'  => 'end'
		),
		array(
			'id'        => 'stickyh_sicons_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Social icons style','capital'),
			'subtitle'  => esc_html__('Use this section to style the social icons used for the sticky header.','capital'),
			'position'  => 'start',
		),
		array(
			'id'=>'stickyh_social_custom_size',
			'type' => 'dimensions',
			'compiler'=>true,
			'compiler' => array('.theme-sticky-header .header-social-container .imi-social-icons li a'),
			'title' => esc_html__('Custom size', 'capital'),
			'desc' => esc_html__('Keep the width and height fields filled with same values to keep the social icons boxes in square.', 'capital'),
		),
		array(
			'id'=>'stickyh_social_custom_spacing',
			'type' => 'spacing',
			'mode' => 'margin',
			'units' => array('px'),
			'compiler'=>true,
			'compiler' => array('.theme-sticky-header .header-social-container .imi-social-icons li'),
			'title' => esc_html__('Custom spacing', 'capital'),
			'desc' => esc_html__('Enter the margin from all sides for each social icon link.', 'capital'),
		),
		array(
			'id'=>'stickyh_social_custom_typo',
			'type' => 'typography',
			'compiler'=>true,
			'font-family' => false,
			'preview' => false,
			'text-align' => false,
			'line-height' => false,
			'color' => false,
			'word-spacing' => false,
			'letter-spacing' => false,
			'font-weight' => false,
			'font-style' => false,
			'compiler' => array('.theme-sticky-header .header-social-container .imi-social-icons li a'),
			'title' => esc_html__('Custom icon size', 'capital'),
		),
		array(
			'id'       => 'stickyh_social_icon_color',
			'type'     => 'link_color',
			'visited'  => false,
			'required' => array('main_social_shape','=','imi-social-icons-plain'),
			'compiler'   => array('.theme-sticky-header .header-social-container .imi-social-icons li a'),
			'title'    => esc_html__('Social Links Color', 'capital'),
		),
		array(
			'id'        => 'stickyh_sicons_style_end',
			'type'      => 'accordion',
			'position'  => 'end'
		),
		array(
			'id'        => 'stickyh_menu_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Sticky header menu style','capital'),
			'subtitle'  => esc_html__('Use this section to style the menu used for the sticky header.','capital'),
			'position'  => 'start',
		),
        array(
            'id' => 'stickyh_menu_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Typography', 'capital'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'word-spacing' => true,
			'text-transform' => true,
			'line-height' => false,
			'compiler'      => array('.theme-sticky-header .sticky-menu > ul > li a'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'stickyh_menu_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.theme-sticky-header .sticky-menu > ul > li > a'),
			'title'    => esc_html__('Links Color', 'capital'),
		),
		array(
			'id'       => 'stickyh_menu_links_padding',
			'type'     => 'spacing',
			'mode'  => 'margin',
			'top'  => false,
			'bottom'  => false,
			'units'  => array('px'),
			'compiler'   => array('.theme-sticky-header .sticky-menu > ul > li'),
			'title'    => esc_html__('Links spacing', 'capital'),
		),
		array(
			'id'       => 'stickyh_menu_dd_bg',
			'type'     => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.theme-sticky-header .sticky-menu > ul > li ul','border-bottom-color' => '.theme-sticky-header .sticky-menu > ul li ul:before'),
			'title'    => esc_html__('Dropdown background', 'capital'),
		),
        array(
            'id' => 'stickyh_menu_dd_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Dropdown links typography', 'capital'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'word-spacing' => true,
			'line-height' => false,
			'compiler'      => array('.theme-sticky-header .sticky-menu > ul li ul li a, .theme-sticky-header .sticky-menu > ul li ul li ul li a,.theme-sticky-header .dd-menu .megamenu-container ul li a'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'stickyh_menu_dd_links_padding',
			'type'     => 'spacing',
			'mode'  => 'padding',
			'units'  => array('px'),
			'compiler'   => array('.theme-sticky-header .sticky-menu > ul li ul li a, .theme-sticky-header .sticky-menu > ul li ul li ul li a'),
			'title'    => esc_html__('Dropdown links spacing', 'capital'),
		),
		array(
			'id'       => 'stickyh_menu_dd_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.theme-sticky-header .sticky-menu > ul li ul li a, .theme-sticky-header .sticky-menu > ul li ul li ul li a,.theme-sticky-header .dd-menu .megamenu-container ul li a'),
			'title'    => esc_html__('Dropdown links color', 'capital'),
		),
		array(
			'id'        => 'stickyh_menu_style_end',
			'type'      => 'accordion',
			'position'  => 'end'
		),
		array(
			'id'        => 'stickyh_search_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Search module style','capital'),
			'subtitle'  => esc_html__('Use this section to style the search trigger icon link or search open form as selected in the "Search Form Style" option.','capital'),
			'position'  => 'start',
		),
		array(
			'id'   => 'stickyh_ddsearch_trigger_dimensions',
    		'type' => 'dimensions',
			'required' => array('search_form_style','!=',1),
			'title' => esc_html__('Trigger icon dimensions','capital'),
			'compiler'   => array('.theme-sticky-header .search-module-trigger'),
			'desc' => esc_html__('Keep width and height equal for a square icon box','capital')
		),
		array(
			'id'   => 'stickyh_ddsearch_trigger_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'required' => array('search_form_style','!=',1),
			'compiler'   => array('background-color'=>'.theme-sticky-header .search-module-trigger'),
			'title' => esc_html__('Trigger icon background','capital'),
		),
		array(
			'id'   => 'stickyh_ddsearch_trigger_hover_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'required' => array('search_form_style','!=',1),
			'compiler'   => array('background-color'=>'.theme-sticky-header .search-module-trigger:hover'),
			'title' => esc_html__('Trigger icon hover background','capital'),
		),
		array(
			'id'   => 'stickyh_ddsearch_trigger_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.theme-sticky-header .search-module-trigger'),
			'required' => array('search_form_style','!=',1),
			'title' => esc_html__('Trigger icon border','capital'),
		),
		array(
			'id'   => 'stickyh_ddsearch_trigger_hover_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.theme-sticky-header .search-module-trigger:hover'),
			'required' => array('search_form_style','!=',1),
			'title' => esc_html__('Trigger icon hover border','capital'),
		),
        array(
            'id' => 'stickyh_ddsearch_trigger_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Trigger icon font size', 'capital'),
			'required' => array('search_form_style','!=',1),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => false,
			'letter-spacing' => false,
			'text-transform' => false,
			'word-spacing' => false,
			'line-height' => false,
			'font-family' => false,
			'font-weight' => false,
			'preview' => false,
			'compiler'   => array('.theme-sticky-header .search-module-trigger'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'stickyh_ddsearch_trigger_links_color',
			'required' => array('search_form_style','!=',1),
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.theme-sticky-header .search-module-trigger'),
			'title'    => esc_html__('Trigger icon link color', 'capital'),
		),
		array(
			'id'   => 'stickyh_ddsearch_opened_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'required' => array('search_form_style','=',0),
			'compiler'   => array('background-color'=>'.theme-sticky-header .search-module-opened'),
			'title' => esc_html__('Dropdown search form background','capital'),
		),
		array(
			'id'   => 'stickyh_ddsearch_opened_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.theme-sticky-header .search-module-opened'),
			'required' => array('search_form_style','=',0),
			'title' => esc_html__('Dropdown search form border','capital'),
		),
		array(
			'id'   => 'stickyh_ddsearch_opened_border_top',
    		'type' => 'border',
			'top'  => true,
			'bottom'  => false,
			'left'  => false,
			'right'  => false,
			'compiler'   => array('.theme-sticky-header .search-module-opened'),
			'required' => array('search_form_style','=',0),
			'title' => esc_html__('Dropdown search form border top','capital'),
		),
		array(
			'id'   => 'stickyh_opensearch_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'required' => array('search_form_style','=',1),
			'compiler'   => array('background-color'=>'.theme-sticky-header .open-search-form .imi-searchform'),
			'title' => esc_html__('Search form background','capital'),
		),
		array(
			'id'   => 'stickyh_opensearch_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.theme-sticky-header .open-search-form .imi-searchform'),
			'required' => array('search_form_style','=',1),
			'title' => esc_html__('Search form border','capital'),
		),
		array(
			'id'=>'stickyh_opensearch_dimensions',
			'type' => 'dimensions',
			'height' => false,
			'compiler'=>true,
			'compiler' => array('.theme-sticky-header .open-search-form .imi-searchform input[type="text"]'),
			'title' => esc_html__('Search form width', 'capital'),
			'required' => array('search_form_style','=',1),
			'desc' => esc_html__('Enter width and height for the search form.', 'capital')
		),
		array(
			'id'=>'stickyh_opensearch_height',
			'type' => 'dimensions',
			'width' => false,
			'compiler'=>true,
			'compiler' => array('.theme-sticky-header .open-search-form .imi-searchform input[type="text"],.theme-sticky-header .open-search-form .imi-searchform .btn'),
			'title' => esc_html__('Search form height', 'capital'),
			'required' => array('search_form_style','=',1),
			'desc' => esc_html__('Enter height for the search form.', 'capital')
		),
        array(
            'id' => 'stickyh_opensearch_field_color',
            'type'        => 'typography',
			'title'       => esc_html__('Search form text typography', 'capital'),
			'required' => array('search_form_style','=',1),
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'word-spacing' => true,
			'line-height' => false,
			'font-family' => true,
			'font-weight' => true,
			'preview' => true,
			'compiler'   => array('.theme-sticky-header .open-search-form .imi-searchform input[type="text"]'),
			'units'       =>'px',
        ),
        array(
            'id' => 'stickyh_opensearch_links_typo',
            'type'        => 'typography',
			'title'       => esc_html__('Search icon size', 'capital'),
			'required' => array('search_form_style','=',1),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => false,
			'letter-spacing' => false,
			'text-transform' => false,
			'word-spacing' => false,
			'line-height' => false,
			'font-family' => false,
			'font-weight' => false,
			'preview' => false,
			'compiler'   => array('.theme-sticky-header .open-search-form .imi-searchform .btn'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'stickyh_opensearch_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'required' => array('search_form_style','=',1),
			'compiler'   => array('.theme-sticky-header .open-search-form .imi-searchform .btn'),
			'title'    => esc_html__('Search icon color', 'capital'),
		),
		array(
			'id'        => 'stickyh_search_style_end',
			'type'      => 'accordion',
			'position'  => 'end'
		),
		array(
			'id'        => 'stickyh_cart_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Cart module style','capital'),
			'subtitle'  => esc_html__('Use this section to style the cart trigger icon link and cart block shown in the topbar','capital'),
			'position'  => 'start',
		),
		array(
			'id'   => 'stickyh_cart_trigger_dimensions',
    		'type' => 'dimensions',
			'title' => esc_html__('Trigger icon dimensions','capital'),
			'compiler'   => array('.theme-sticky-header .cart-module-trigger'),
			'desc' => esc_html__('Keep width and height equal for a square icon box','capital')
		),
		array(
			'id'   => 'stickyh_cart_trigger_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.theme-sticky-header .cart-module-trigger'),
			'title' => esc_html__('Trigger icon background','capital'),
		),
		array(
			'id'   => 'stickyh_cart_trigger_hover_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.theme-sticky-header .cart-module-trigger:hover'),
			'title' => esc_html__('Trigger icon hover background','capital'),
		),
		array(
			'id'   => 'stickyh_cart_trigger_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.theme-sticky-header .cart-module-trigger'),
			'title' => esc_html__('Trigger icon border','capital'),
		),
		array(
			'id'   => 'stickyh_cart_trigger_hover_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.theme-sticky-header .cart-module-trigger:hover'),
			'title' => esc_html__('Trigger icon hover border','capital'),
		),
        array(
            'id' => 'stickyh_cart_trigger_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Trigger icon font size', 'capital'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => false,
			'letter-spacing' => false,
			'text-transform' => false,
			'word-spacing' => false,
			'line-height' => false,
			'font-family' => false,
			'font-weight' => false,
			'preview' => false,
			'compiler'   => array('.theme-sticky-header .cart-module-trigger'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'stickyh_cart_trigger_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.theme-sticky-header .cart-module-trigger'),
			'title'    => esc_html__('Trigger icon link color', 'capital'),
		),
		array(
			'id'   => 'stickyh_cart_opened_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.theme-sticky-header .cart-module-opened'),
			'title' => esc_html__('Open cart background','capital'),
		),
		array(
			'id'   => 'stickyh_cart_opened_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.theme-sticky-header .cart-module-items'),
			'title' => esc_html__('Open cart border','capital'),
		),
		array(
			'id'   => 'stickyh_cart_opened_border_top',
    		'type' => 'border',
			'top'  => true,
			'bottom'  => false,
			'left'  => false,
			'right'  => false,
			'compiler'   => array('.theme-sticky-header .cart-module-opened'),
			'title' => esc_html__('Open cart border top','capital'),
		),
		array(
			'id'       => 'stickyh_cart_items_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.theme-sticky-header .cart-module-items > li > a'),
			'title'    => esc_html__('Cart items text color', 'capital'),
		),
        array(
            'id' => 'stickyh_cart_items_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Cart items typography', 'capital'),
			'subsets' 	  => false,
			'color' 		  => true,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'word-spacing' => true,
			'line-height' => true,
			'font-family' => true,
			'font-weight' => true,
			'preview' => true,
			'compiler'   => array('.theme-sticky-header .cart-module-items > li'),
			'units'       =>'px',
        ),
		array(
			'id'   => 'stickyh_cart_opened_footer_bg',
    		'type' => 'color_rgba',
			'compiler'   => array('background-color'=>'.theme-sticky-header .cart-module-footer'),
			'title' => esc_html__('Open cart footer background','capital'),
		),
		array(
			'id'   => 'stickyh_cart_opened_footer_link_hover_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.theme-sticky-header .cart-module-footer a.basic-link:hover'),
			'title' => esc_html__('Open cart footer links hover background','capital'),
		),
		array(
			'id'       => 'stickyh_cart_opened_footer_link_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.theme-sticky-header .cart-module-footer a.basic-link'),
			'title'    => esc_html__('Open cart footer links color', 'capital'),
		),
        array(
            'id' => 'stickyh_cart_opened_footer_link_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Open cart footer links typography', 'capital'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'word-spacing' => true,
			'line-height' => true,
			'font-family' => true,
			'font-weight' => true,
			'preview' => true,
			'compiler'   => array('.theme-sticky-header .cart-module-footer a.basic-link'),
			'units'       =>'px',
        ),
		array(
			'id'        => 'stickyh_cart_style_end',
			'type'      => 'accordion',
			'position'  => 'end'
		),
		array(
			'id'        => 'stickyh_wopener_style_start',
			'type'      => 'accordion',
			'title'     => esc_html__('Overlay content opener button style','capital'),
			'subtitle'  => esc_html__('Use this section to style the overlay content trigger link shown in the sticky header','capital'),
			'position'  => 'start',
		),
		array(
			'id'   => 'stickyh_wopener_trigger_dimensions',
    		'type' => 'dimensions',
			'title' => esc_html__('Trigger icon dimensions','capital'),
			'compiler'   => array('.theme-sticky-header .topper-opener'),
			'desc' => esc_html__('Keep width and height equal for a square button box','capital')
		),
		array(
			'id'   => 'stickyh_wopener_trigger_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.theme-sticky-header .topper-opener'),
			'title' => esc_html__('Trigger button background','capital'),
		),
		array(
			'id'   => 'stickyh_wopener_trigger_hover_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.theme-sticky-header .topper-opener:hover'),
			'title' => esc_html__('Trigger button hover background','capital'),
		),
		array(
			'id'   => 'stickyh_wopener_trigger_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.theme-sticky-header .topper-opener'),
			'title' => esc_html__('Trigger button border','capital'),
		),
		array(
			'id'   => 'stickyh_wopener_trigger_hover_border',
    		'type' => 'border',
			'all'  => true,
			'compiler'   => array('.theme-sticky-header .topper-opener:hover'),
			'title' => esc_html__('Trigger button hover border','capital'),
		),
        array(
            'id' => 'stickyh_wopener_trigger_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Trigger button font size', 'capital'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'word-spacing' => true,
			'line-height' => false,
			'font-family' => true,
			'font-weight' => true,
			'preview' => true,
			'compiler'   => array('.theme-sticky-header .topper-opener'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'stickyh_wopener_trigger_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.theme-sticky-header .topper-opener'),
			'title'    => esc_html__('Trigger button text color', 'capital'),
		),
		array(
			'id'        => 'stickyh_wopener_style_end',
			'type'      => 'accordion',
			'position'  => 'end'
		)
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Mobile Header', 'capital'),
	'subsection' => true,
    'fields' => array(
        array(
            'id' => 'enable_mobile_header',
            'type' => 'switch',
            'title' => esc_html__('Mobile Header', 'capital'),
            'subtitle' => esc_html__('Enable/Disable', 'capital'),
            "default" => 1,
        ),
		array(
			'id'      => 'mobile_header_blocks',
			'required' => array('enable_mobile_header','=',1),
			'type'    => 'sorter',
			'title'   => 'Mobile header content',
			'class'   => 'custom-field-sorter',
			'subtitle'    => esc_html__('Drag/Drop the blocks to organize how you want the layout in the site mobile header.','capital'),
			'options' => array(
				'enabled'  => array(
					'logo-menu' 		=> esc_html__('Logo + Menu','capital'),
				),
				'disabled' => array(
					'topmenu'			=> esc_html__('Topbar Menu','capital'),
					'social-icons'     	=> esc_html__('Social Icons','capital'),
					'featured-button1' 	=> esc_html__('Featured Btn 1','capital'),
					'featured-button2' 	=> esc_html__('Featured Btn 2','capital'),
					'featured-button3' 	=> esc_html__('Featured Btn 3','capital'),
					'header-info1'     	=> esc_html__('Header Info 1','capital'),
					'header-info2'     	=> esc_html__('Header Info 2','capital'),
					'header-info3'     	=> esc_html__('Header Info 3','capital')
				)
			),
		),
        array(
			'id'=>'mobile_header_cart',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Show cart option', 'capital'), 
			'subtitle' => esc_html__('Check this to show cart option at the right of menu in mobile header.', 'capital'),
			'default' => 0,
		),
        array(
			'id'=>'mobile_header_search',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Show search option', 'capital'), 
			'subtitle' => esc_html__('Check this to show search option at the right of menu in mobile header.', 'capital'),
			'default' => 0,
		),
		array(
			'id' => 'mobile_header_background',
			'type' => 'background',
			'compiler' => array('.theme-mobile-header'),
			'title' => esc_html__('Mobile header background color/image', 'capital')
		),
		array(
			'id' => 'mobile_header_navbar_background',
			'type' => 'background',
			'compiler' => array('.theme-mobile-header .mobile-navbar'),
			'title' => esc_html__('Mobile header navbar background color/image', 'capital'),
			'subtitle' => esc_html__('Choose color or image for the navbar in mobile header. This is the space where your mobile logo, menuopener, search and cart icons will appear.', 'capital')
		),
		array(
			'id' => 'mobile_header_hinfo_background',
			'type' => 'background',
			'compiler' => array('.theme-mobile-header .header_info_text'),
			'title' => esc_html__('Mobile header header info background color/image', 'capital'),
			'subtitle' => esc_html__('Choose color or image for the header info rows in mobile header.', 'capital')
		),
		array(
			'id' => 'mobile_header_social_background',
			'type' => 'background',
			'compiler' => array('.theme-mobile-header .header-social-container'),
			'title' => esc_html__('Mobile header social icons row background color/image', 'capital'),
			'subtitle' => esc_html__('Choose color or image for the social icons row in mobile header.', 'capital')
		),
		array(
			'id' => 'mobile_header_topmenu_background',
			'type' => 'background',
			'compiler' => array('.theme-mobile-header .topbar-blocks'),
			'title' => esc_html__('Mobile header topbar menu row background color/image', 'capital'),
			'subtitle' => esc_html__('Choose color or image for the topbar menu row in mobile header.', 'capital')
		),
		array(
			'id' => 'mobile_header_separator',
			'type' => 'border',
			'compiler' => array('.theme-mobile-header .header-equaler, .theme-mobile-header .mobile-navbar, .theme-mobile-header .topbar-blocks'),
			'all' => false,
			'bottom' => false,
			'left' => false,
			'right' => false,
			'title' => esc_html__('Mobile header rows separator border', 'capital'),
			'subtitle' => esc_html__('Choose border properties for rows in mobile header.', 'capital')
		),
		array(
			'id' => 'mobile_header_row_spacing',
			'type' => 'spacing',
			'mode' => 'padding',
			'compiler' => array('.theme-mobile-header .header-equaler, .theme-mobile-header .mobile-navbar, .theme-mobile-header .topbar-blocks'),
			'units' => array('px'),
			'title' => esc_html__('Mobile header rows inside spacing', 'capital'),
			'subtitle' => esc_html__('Set inside padding for the rows in mobile header.', 'capital')
		),
        array(
            'id' => 'mobile_header_triggers_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Menu, search, cart icon links font size', 'capital'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => false,
			'letter-spacing' => false,
			'text-transform' => false,
			'word-spacing' => false,
			'line-height' => false,
			'font-family' => false,
			'font-weight' => false,
			'preview' => false,
			'compiler'   => array('.theme-mobile-header .cart-module-trigger, .theme-mobile-header .search-module-trigger, .theme-mobile-header .mmenu-toggle'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'mobile_header_triggers_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.theme-mobile-header .cart-module-trigger, .theme-mobile-header .search-module-trigger, .theme-mobile-header .mmenu-toggle'),
			'title'    => esc_html__('Menu, search, cart icon links color', 'capital'),
		),
		array(
			'id'       => 'mobile_logo_max_height',
			'type'     => 'dimensions',
			'width'  => false,
			'units'  => array('px'),
			'title'    => esc_html__('Mobile header logo maximum height', 'capital'),
			'subtitle'    => esc_html__('Set a maximum height for the logo image of mobile header.', 'capital'),
		),
        array(
            'id' => 'mobile_header_hinfo_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Header info typography for mobile header', 'capital'),
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'word-spacing' => true,
			'font-family' => true,
			'font-weight' => true,
			'preview' => true,
			'compiler'   => array('.theme-mobile-header .header_info_text'),
			'units'       =>'px',
        ),
		array(
			'id'=>'mobile_header_menu_btn_type',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Menu button', 'capital'), 
			'subtitle' => esc_html__('Choose how you want to show the menu opener button in mobile header.', 'capital'),
			'options' => array(
				0 => esc_html__('Icon','capital'),
				1 => esc_html__('Icon + Text','capital'),
				2 => esc_html__('Text','capital'),
			),
			'default' => 0,
		),
		array(
			'id'=>'mobile_header_menu_btn_text',
			'type' => 'text',
			'title' => esc_html__('Menu button text', 'capital'), 
			'subtitle' => esc_html__('Enter the text you want to show for the menu link in mobile header.', 'capital'),
			'required' => array('mobile_header_menu_btn_type','!=','0')
		),
		array(
			'id'   => 'mobile_header_menu_bg',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.theme-mobile-header .mobile-menu'),
			'title' => esc_html__('Mobile header menu background color','capital'),
		),
        array(
            'id' => 'mobile_header_menu_links_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Mobile menu links typography', 'capital'),
			'font-size'	  => true,
			'font-style'  => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'word-spacing' => true,
			'font-family' => true,
			'font-weight' => true,
			'preview' => true,
			'color'  => false,
			'compiler'   => array('.theme-mobile-header .mobile-menu li a'),
			'units'       =>'px',
        ),
        array(
            'id' => 'mobile_header_menu_links_spacing',
            'type'        => 'spacing',
			'title'       => esc_html__('Mobile menu links spacing', 'capital'),
			'mode'	  => 'padding',
			'units'       =>'px',
			'compiler'   => array('.theme-mobile-header .mobile-menu li a'),
        ),
		array(
			'id' => 'mobile_header_menu_links_separator',
			'type' => 'border',
			'compiler' => array('.theme-mobile-header .mobile-menu li a'),
			'all' => false,
			'top' => false,
			'left' => false,
			'right' => false,
			'title' => esc_html__('Mobile menu links separator border', 'capital'),
			'subtitle' => esc_html__('Choose border properties for menu links in mobile header.', 'capital')
		),
		array(
			'id'       => 'mobile_header_menu_links_color',
			'type'     => 'link_color',
			'visited'  => false,
			'compiler'   => array('.theme-mobile-header .mobile-menu li a'),
			'title'    => esc_html__('Mobile menu links color', 'capital'),
		),
        array(
            'id' => 'mobile_header_smenu_opener_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Submenu opener icon size and color', 'capital'),
			'subsets' 	  => false,
			'color' 		  => true,
			'text-align'	  => false,
			'font-size'	  => true,
			'font-style'  => false,
			'letter-spacing' => false,
			'text-transform' => false,
			'word-spacing' => false,
			'line-height' => false,
			'font-family' => false,
			'font-weight' => false,
			'preview' => false,
			'compiler'   => array('.theme-mobile-header .mobile-menu li.menu-item-has-children:after'),
			'units'       =>'px',
        ),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Inner page header', 'capital'),
	'subsection' => true,
    'fields' => array(
		array(
			'id'       => 'global_ph_settings_start',
			'type'     => 'accordion',
			'position' => 'start',
			'title'    => esc_html__('Inner page header global options', 'capital'),
		),
        array(
			'id'=>'inner_page_header_display',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Hide page header', 'capital'), 
			'subtitle' => esc_html__('Check this box to hide page header on the inner pages/posts/custom posts. This can be used as default for all inner pages and can override the individual page design options.', 'capital'),
			'default' => 0,
		),
		array(  
			'id' => 'inner_page_header_background',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'.page-banner'),
			'title' => esc_html__('Default Banner Color', 'capital'),
			'subtitle' => esc_html__('Background color for the inner pages/posts header.', 'capital'),
		),
		array(
			'id'=>'capital_default_banner',
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Default Banner Image', 'capital'),
			'subtitle' => esc_html__('Upload default banner image for the inner pages/posts header.', 'capital'),
            'default' => array('url' => ''),
		),
		array(
			'id'       => 'inner_page_header_min_height',
			'type'     => 'text',
			'title'    => esc_html__('Default Height', 'capital'),
			'subtitle' => esc_html__('Enter default height for the inner pages header. DO NOT PUT px HERE', 'capital'),
		),
		array(
			'id'       => 'inner_page_header_spacing',
			'type'     => 'spacing',
			'mode'     => 'padding',
			'left'     => false,
			'right'    => false,
			'top'     => true,
			'bottom'    => true,
			'units'   => array('px'),
			'compiler'   => array('.page-banner-text > div > div'),
			'title'    => esc_html__('Default spacing', 'capital'),
			'subtitle' => esc_html__('Enter top/bottom spacing for the inner pages header.', 'capital'),
		),
		array(
			'id'=>'inner_page_header_valign',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Title vertical align', 'capital'),
			'subtitle' => esc_html__('Choose title vertical alignment for the inner pages header.', 'capital'), 
			'options' => array(
					'top' => esc_html__('Top','capital'),
					'middle' => esc_html__('Middle','capital'),
					'bottom' => esc_html__('Bottom','capital')
				),
			'default' => 'middle',
		),
        array(
			'id'=>'inner_page_header_title',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Hide page title', 'capital'), 
			'subtitle' => esc_html__('Check this box to hide page title in the page banner. Uncheck to show. This can be used as default for all inner pages and can override the individual page design options.', 'capital'),
			'default' => 0,
		),
        array(
            'id' => 'inner_page_header_title_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Title typography', 'capital'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
            'font-weight' => true,
            'font-style' => true,
			'font-size'	  => true,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'compiler'      => array('.page-banner h1'),
			'units'       =>'px',
        ),
        array(
            'id' => 'inner_page_header_subtitle_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Subtitle typography', 'capital'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
            'font-weight' => true,
            'font-style' => true,
			'font-size'	  => true,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'compiler'      => array('.page-banner p'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'global_ph_settings_end',
			'type'     => 'accordion',
			'position' => 'end',
		),
		array(
			'id'       => 'posts_ph_settings_start',
			'type'     => 'accordion',
			'position' => 'start',
			'title'    => esc_html__('Inner page header options for posts', 'capital'),
		),
        array(
			'id'=>'inner_posts_header_display',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Hide page header', 'capital'), 
			'subtitle' => esc_html__('Check this box to hide page header for the blog posts. This can be used as default for all blog posts and can override the individual page design options.', 'capital'),
			'default' => 0,
		),
		array(
			'id'       => 'inner_posts_header_min_height',
			'type'     => 'dimensions',
			'width'    => false,
			'height'   => true,
			'compiler'   => array('.single-post .page-banner,.single-post .page-banner-text > div'),
			'title'    => esc_html__('Default Height', 'capital'),
			'subtitle' => esc_html__('Enter default height for the inner page header for blog posts.', 'capital'),
		),
		array(
			'id'       => 'inner_posts_header_spacing',
			'type'     => 'spacing',
			'mode'     => 'padding',
			'left'     => false,
			'right'    => false,
			'top'     => true,
			'bottom'    => true,
			'units'   => array('px'),
			'compiler'   => array('.single-post .page-banner-text > div > div'),
			'title'    => esc_html__('Default spacing', 'capital'),
			'subtitle' => esc_html__('Enter top/bottom spacing for the inner page header for blog posts.', 'capital'),
		),
		array(
			'id'=>'inner_posts_header_valign',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Title vertical align', 'capital'), 
			'options' => array(
					'top' => esc_html__('Top','capital'),
					'middle' => esc_html__('Middle','capital'),
					'bottom' => esc_html__('Bottom','capital')
				),
			'default' => 'middle',
		),
		array(  
			'id' => 'default_post_banner_color',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'body.single-post .page-banner'),
			'title' => esc_html__('Default Banner Color', 'capital'),
			'subtitle' => esc_html__('Background color for the blog posts header.', 'capital'),
		),
		array(
			'id'=>'default_post_banner',
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Default banner image', 'capital'),
			'subtitle' => esc_html__('Upload default banner image for the blog posts header.', 'capital'),
            'default' => array('url' => ''),
		),
        array(
			'id'=>'inner_posts_header_title',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Hide page title', 'capital'), 
			'subtitle' => esc_html__('Check this box to hide posts title in the page banner. Uncheck to show. This can be used as default for all blog posts and can override the individual page design options.', 'capital'),
			'default' => 0,
		),
        array(
            'id' => 'inner_posts_header_title_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Title typography', 'capital'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
            'font-weight' => true,
            'font-style' => true,
			'font-size'	  => true,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'compiler'      => array('body.single-post .page-banner h1'),
			'units'       =>'px',
        ),
        array(
            'id' => 'inner_posts_header_subtitle_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Subtitle typography', 'capital'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
            'font-weight' => true,
            'font-style' => true,
			'font-size'	  => true,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'compiler'      => array('body.singe-post .page-banner p'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'posts_ph_settings_end',
			'type'     => 'accordion',
			'position' => 'end',
		),
		array(
			'id'       => 'projects_ph_settings_start',
			'type'     => 'accordion',
			'position' => 'start',
			'title'    => esc_html__('Inner page header options for projects', 'capital'),
		),
        array(
			'id'=>'inner_projects_header_display',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Hide page header', 'capital'), 
			'subtitle' => esc_html__('Check this box to hide page header for the projects. This can be used as default for all projects and can override the individual page design options.', 'capital'),
			'default' => 0,
		),
		array(
			'id'       => 'inner_projects_header_min_height',
			'type'     => 'dimensions',
			'width'    => false,
			'height'   => true,
			'compiler'   => array('.single-imi_projects .page-banner,.single-imi_projects .page-banner-text > div'),
			'title'    => esc_html__('Default Height', 'capital'),
			'subtitle' => esc_html__('Enter default height for the inner page header for project posts.', 'capital'),
		),
		array(
			'id'       => 'inner_projects_header_spacing',
			'type'     => 'spacing',
			'mode'     => 'padding',
			'left'     => false,
			'right'    => false,
			'top'     => true,
			'bottom'    => true,
			'units'   => array('px'),
			'compiler'   => array('.single-imi_projects .page-banner-text > div > div'),
			'title'    => esc_html__('Default spacing', 'capital'),
			'subtitle' => esc_html__('Enter top/bottom spacing for the inner page header for project posts.', 'capital'),
		),
		array(
			'id'=>'inner_projects_header_valign',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Title vertical align', 'capital'), 
			'options' => array(
					'top' => esc_html__('Top','capital'),
					'middle' => esc_html__('Middle','capital'),
					'bottom' => esc_html__('Bottom','capital')
				),
			'default' => 'middle',
		),
		array(  
			'id' => 'default_projects_banner_color',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'body.single-imi_projects .page-banner'),
			'title' => esc_html__('Default Banner Color', 'capital'),
			'subtitle' => esc_html__('Background color for the projects header.', 'capital'),
		),
		array(
			'id'=>'default_project_banner',
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Default banner image', 'capital'),
			'subtitle' => esc_html__('Upload default banner image for the projects header.', 'capital'),
            'default' => array('url' => ''),
		),
        array(
			'id'=>'inner_projects_header_title',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Hide page title', 'capital'), 
			'subtitle' => esc_html__('Check this box to hide projects title in the page banner. Uncheck to show. This can be used as default for all projects and can override the individual page design options.', 'capital'),
			'default' => 0,
		),
        array(
            'id' => 'inner_projects_header_title_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Title typography', 'capital'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
            'font-weight' => true,
            'font-style' => true,
			'font-size'	  => true,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'compiler'      => array('body.single-imi_projects .page-banner h1'),
			'units'       =>'px',
        ),
        array(
            'id' => 'inner_projects_header_subtitle_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Subtitle typography', 'capital'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
            'font-weight' => true,
            'font-style' => true,
			'font-size'	  => true,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'compiler'      => array('body.single-imi_projects .page-banner p'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'projects_ph_settings_end',
			'type'     => 'accordion',
			'position' => 'end',
		),
		array(
			'id'       => 'services_ph_settings_start',
			'type'     => 'accordion',
			'position' => 'start',
			'title'    => esc_html__('Inner page header options for services', 'capital'),
		),
        array(
			'id'=>'inner_services_header_display',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Hide page header', 'capital'), 
			'subtitle' => esc_html__('Check this box to hide page header for the services. This can be used as default for all services and can override the individual page design options.', 'capital'),
			'default' => 0,
		),
		array(
			'id'       => 'inner_services_header_min_height',
			'type'     => 'dimensions',
			'width'    => false,
			'height'   => true,
			'compiler'   => array('.single-imi_services .page-banner,.single-imi_services .page-banner-text > div'),
			'title'    => esc_html__('Default Height', 'capital'),
			'subtitle' => esc_html__('Enter default height for the inner page header for service posts.', 'capital'),
		),
		array(
			'id'       => 'inner_services_header_spacing',
			'type'     => 'spacing',
			'mode'     => 'padding',
			'left'     => false,
			'right'    => false,
			'top'     => true,
			'bottom'    => true,
			'units'   => array('px'),
			'compiler'   => array('.single-imi_services .page-banner-text > div > div'),
			'title'    => esc_html__('Default spacing', 'capital'),
			'subtitle' => esc_html__('Enter top/bottom spacing for the inner page header for service posts.', 'capital'),
		),
		array(
			'id'=>'inner_services_header_valign',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Title vertical align', 'capital'), 
			'options' => array(
					'top' => esc_html__('Top','capital'),
					'middle' => esc_html__('Middle','capital'),
					'bottom' => esc_html__('Bottom','capital')
				),
			'default' => 'middle',
		),
		array(  
			'id' => 'default_services_banner_color',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'body.single-imi_services .page-banner'),
			'title' => esc_html__('Default Banner Color', 'capital'),
			'subtitle' => esc_html__('Background color for the services header.', 'capital'),
		),
		array(
			'id'=>'default_service_banner',
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Default Banner Image for Services', 'capital'),
			'subtitle' => esc_html__('Upload default banner image for the service posts header.', 'capital'),
            'default' => array('url' => ''),
		),
        array(
			'id'=>'inner_services_header_title',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Hide page title', 'capital'), 
			'subtitle' => esc_html__('Check this box to hide services title in the page banner. Uncheck to show. This can be used as default for all services and can override the individual page design options.', 'capital'),
			'default' => 0,
		),
        array(
            'id' => 'inner_services_header_title_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Title typography', 'capital'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
            'font-weight' => true,
            'font-style' => true,
			'font-size'	  => true,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'compiler'      => array('body.single-imi_services .page-banner h1'),
			'units'       =>'px',
        ),
        array(
            'id' => 'inner_services_header_subtitle_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Subtitle typography', 'capital'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
            'font-weight' => true,
            'font-style' => true,
			'font-size'	  => true,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'compiler'      => array('body.single-imi_services .page-banner p'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'services_ph_settings_end',
			'type'     => 'accordion',
			'position' => 'end',
		),
		array(
			'id'       => 'team_ph_settings_start',
			'type'     => 'accordion',
			'position' => 'start',
			'title'    => esc_html__('Inner page header options for team posts', 'capital'),
		),
        array(
			'id'=>'inner_team_header_display',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Hide page header', 'capital'), 
			'subtitle' => esc_html__('Check this box to hide page header for the team posts. This can be used as default for all team posts and can override the individual page design options.', 'capital'),
			'default' => 0,
		),
		array(
			'id'       => 'inner_team_header_min_height',
			'type'     => 'dimensions',
			'width'    => false,
			'height'   => true,
			'compiler'   => array('.single-imi_team .page-banner,.single-imi_team .page-banner-text > div'),
			'title'    => esc_html__('Default Height', 'capital'),
			'subtitle' => esc_html__('Enter default height for the inner page header for team posts.', 'capital'),
		),
		array(
			'id'       => 'inner_team_header_spacing',
			'type'     => 'spacing',
			'mode'     => 'padding',
			'left'     => false,
			'right'    => false,
			'top'     => true,
			'bottom'    => true,
			'units'   => array('px'),
			'compiler'   => array('.single-imi_team .page-banner-text > div > div'),
			'title'    => esc_html__('Default spacing', 'capital'),
			'subtitle' => esc_html__('Enter top/bottom spacing for the inner page header for team posts.', 'capital'),
		),
		array(
			'id'=>'inner_team_header_valign',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Title vertical align', 'capital'), 
			'options' => array(
					'top' => esc_html__('Top','capital'),
					'middle' => esc_html__('Middle','capital'),
					'bottom' => esc_html__('Bottom','capital')
				),
			'default' => 'middle',
		),
		array(  
			'id' => 'default_team_banner_color',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'body.single-imi_team .page-banner'),
			'title' => esc_html__('Default Banner Color', 'capital'),
			'subtitle' => esc_html__('Background color for the team posts header.', 'capital'),
		),
		array(
			'id'=>'default_team_banner',
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Default Banner Image for Team', 'capital'),
			'subtitle' => esc_html__('Upload default banner image for the team posts header.', 'capital'),
            'default' => array('url' => ''),
		),
        array(
			'id'=>'inner_team_header_title',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Hide page title', 'capital'), 
			'subtitle' => esc_html__('Check this box to hide team posts title in the page banner. Uncheck to show. This can be used as default for all team posts and can override the individual page design options.', 'capital'),
			'default' => 0,
		),
        array(
            'id' => 'inner_team_header_title_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Title typography', 'capital'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
            'font-weight' => true,
            'font-style' => true,
			'font-size'	  => true,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'compiler'      => array('body.single-imi_team .page-banner h1'),
			'units'       =>'px',
        ),
        array(
            'id' => 'inner_team_header_subtitle_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Subtitle typography', 'capital'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
            'font-weight' => true,
            'font-style' => true,
			'font-size'	  => true,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'compiler'      => array('body.single-imi_team .page-banner p'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'team_ph_settings_end',
			'type'     => 'accordion',
			'position' => 'end',
		),
		array(
			'id'       => 'products_ph_settings_start',
			'type'     => 'accordion',
			'position' => 'start',
			'title'    => esc_html__('Inner page header options for products', 'capital'),
		),
        array(
			'id'=>'inner_products_header_display',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Hide page header', 'capital'), 
			'subtitle' => esc_html__('Check this box to hide page header for the team posts. This can be used as default for all team posts and can override the individual page design options.', 'capital'),
			'default' => 0,
		),
		array(  
			'id' => 'default_products_banner_color',
    		'type' => 'color_rgba',
			'options'       => array(
				'show_input'                => true,
				'show_initial'              => true,
				'show_alpha'                => true,
				'show_palette'              => true,
				'show_palette_only'         => false,
				'show_selection_palette'    => true,
				'max_palette_size'          => 10,
				'allow_empty'               => true,
				'clickout_fires_change'     => false,
				'choose_text'               => 'Choose',
				'cancel_text'               => 'Cancel',
				'show_buttons'              => true,
				'use_extended_classes'      => true,
				'palette'                   => null,  // show default
				'input_text'                => 'Select Color'
			), 
			'compiler'   => array('background-color'=>'body.single-product .page-banner'),
			'title' => esc_html__('Default Banner Color', 'capital'),
			'subtitle' => esc_html__('Background color for the products header.', 'capital'),
		),
		array(
			'id'=>'default_product_banner',
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Default Banner Image for WooCommerce products', 'capital'),
			'subtitle' => esc_html__('Upload default banner image for the woocommerce product posts header.', 'capital'),
            'default' => array('url' => ''),
		),
        array(
			'id'=>'inner_products_header_title',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Hide page title', 'capital'), 
			'subtitle' => esc_html__('Check this box to hide products posts title in the page banner. Uncheck to show. This can be used as default for all products and can override the individual page design options.', 'capital'),
			'default' => 0,
		),
        array(
            'id' => 'inner_products_header_title_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Title typography', 'capital'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
            'font-weight' => true,
            'font-style' => true,
			'font-size'	  => true,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'compiler'      => array('body.single-product .page-banner h1'),
			'units'       =>'px',
        ),
        array(
            'id' => 'inner_products_header_subtitle_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Subtitle typography', 'capital'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
            'font-weight' => true,
            'font-style' => true,
			'font-size'	  => true,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'text-transform' => true,
			'compiler'      => array('body.single-product .page-banner p'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'products_ph_settings_end',
			'type'     => 'accordion',
			'position' => 'end',
		),
		array(
			'id'       => 'breadcrumb_ph_settings_start',
			'type'     => 'accordion',
			'position' => 'start',
			'title'    => esc_html__('Breadcrumbs styling', 'capital'),
		),
        array(
			'id'=>'breadcrumb_header_display',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Hide breadcrumb', 'capital'), 
			'subtitle' => esc_html__('Check this box to hide breadcrumbs from all inner pages. This can be used as default for all posts/pages and can override the individual page design options.', 'capital'),
			'default' => 0,
		),
        array(
            'id' => 'inner_page_header_breadcrumb_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Breadcrumb typography', 'capital'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => false,
            'font-weight' => true,
            'font-style' => true,
			'font-size'	  => true,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'compiler'      => array('.breadcrumb'),
			'units'       =>'px',
        ),
        array(
            'id' => 'inner_page_header_breadcrumb_links',
            'type'        => 'link_color',
			'title'       => esc_html__('Breadcrumb links color', 'capital'),
			'visited' => false,
			'compiler'      => array('.breadcrumb a'),
        ),
		array(
			'id'       => 'breadcrumb_ph_settings_end',
			'type'     => 'accordion',
			'position' => 'end',
		),
		array(
			'id'       => 'archives_ph_settings_start',
			'type'     => 'accordion',
			'position' => 'start',
			'title'    => esc_html__('Archive pages title', 'capital'),
		),
		array(
            'id' => 'project_archive_title',
            'type' => 'text',
            'title' => esc_html__('Title for projects archive', 'capital'),
            'subtitle' => esc_html__('Enter title of the archive page for the projects post type.', 'capital'),
            'default' => 'Projects'
        ),
		array(
            'id' => 'blog_archive_title',
            'type' => 'text',
            'title' => esc_html__('Title for blog archive', 'capital'),
            'subtitle' => esc_html__('Enter title of the archive page for the blog post type.', 'capital'),
            'default' => 'Blog'
        ),
		array(
            'id' => 'service_archive_title',
            'type' => 'text',
            'title' => esc_html__('Title for services archive', 'capital'),
            'subtitle' => esc_html__('Enter title of the archive page for the services post type.', 'capital'),
            'default' => 'Services'
        ),
		array(
            'id' => 'team_archive_title',
            'type' => 'text',
            'title' => esc_html__('Title for team archive', 'capital'),
            'subtitle' => esc_html__('Enter title of the archive page for the team post type.', 'capital'),
            'default' => 'Team'
        ),
		array(
            'id' => 'shop_archive_title',
            'type' => 'text',
            'title' => esc_html__('Title for shop archive', 'capital'),
            'subtitle' => esc_html__('Enter title of the archive page for the products/shop post type.', 'capital'),
            'default' => 'Shop'
        ),
		array(
			'id'       => 'archives_ph_settings_end',
			'type'     => 'accordion',
			'position' => 'end',
		),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-chevron-down',
    'title' => esc_html__('Footer', 'capital'),
    'desc' => esc_html__('These are the options for the footer.', 'capital'),
    'fields' => array(
		array(
			'id'       => 'footer_custom_sidebar_start',
			'type'     => 'accordion',
			'position' => 'start',
			'title'    => esc_html__('VC Section row', 'capital'),
		),
        array(
            'id' => 'enable_footer_custom_sidebar',
            'type' => 'checkbox',
            'title' => esc_html__('Enable footer VC Section area', 'capital'),
            'subtitle' => esc_html__('Check this box to enable footer VC Section area. Create VC Section using visual composer page builder.', 'capital'),
            "default" => 0,
        ),
		array(
			'id'       	=> 'footer_custom_sidebar',
			'type'     	=> 'select',
			'title'    	=> esc_html__('VC Section', 'capital'), 
			'desc'    	=> esc_html__('Select VC Section for your website footer.', 'capital'),
			'data'  	=> 'posts',
			'args'  => array(
				'post_type'      => 'imi_custom_sidebar',
				'posts_per_page' => -1,
				'orderby'        => 'title',
				'order'          => 'ASC',
			),
			'required' => array('enable_footer_custom_sidebar','=','1')
		),
		array(
			'id'       => 'footer_custom_sidebar_end',
			'type'     => 'accordion',
			'position' => 'end',
		),
		array(
			'id'       => 'footer_widgets_area_start',
			'type'     => 'accordion',
			'position' => 'start',
			'title'    => esc_html__('Widgets row', 'capital'),
		),
        array(
            'id' => 'enable_footer_widgets',
            'type' => 'checkbox',
            'title' => esc_html__('Enable footer widgets area', 'capital'),
            'subtitle' => esc_html__('Check this box to enable footer widgets area. Choose footer layout below.', 'capital'),
            "default" => 1,
        ),
        array(
            'id' => 'full_width_footer',
            'type' => 'checkbox',
            'title' => esc_html__('100% width', 'capital'),
            'subtitle' => esc_html__('Check this box to set footer width to 100% of the browser width. Uncheck to follow site width. Only works with wide layout mode.', 'capital'),
            "default" => 0,
        ),
        array(
			'id'=>'footer_top_no_side_padding',
			'type' => 'checkbox',
			'compiler'=>true,
			'required' => array('full_width_footer','=','1'),
			'title' => esc_html__('No space on left/right', 'capital'), 
			'subtitle' => esc_html__('Check this box to set the footer widgets area to 100% of the browser width with no space on the sides.', 'capital'),
			'default' => 0,
		),
		array(
			'id'=>'footer_top_skin',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Skin', 'capital'), 
			'options' => array(
					'footer-dark-skin' => esc_html__('Dark','capital'),
					'footer-light-skin' => esc_html__('Light','capital')
				),
			'default' => 'footer-dark-skin',
		),
		array(
    		'id' => 'footer_layout',
    		'type' => 'image_select',
    		'compiler'=>true,
			'title' => esc_html__('Footer layout', 'capital'), 
			'subtitle' => esc_html__('Select the footer widgeted area layout', 'capital'),
    			'options' => array(
					1 => array('title' => '', 'img' => get_template_directory_uri().'/images/footerColumns/footer-1.png'),
    				2 => array('title' => '', 'img' => get_template_directory_uri().'/images/footerColumns/footer-2.png'),
    				3 => array('title' => '', 'img' => get_template_directory_uri().'/images/footerColumns/footer-3.png'),
    				4 => array('title' => '', 'img' => get_template_directory_uri().'/images/footerColumns/footer-4.png')
    							),
    		'default' => 4,
    	),
		array( 
			'id' => 'footer_background',
			'type' => 'background',
			'background-color'=> true,
			'compiler' => array('.site-footer.site-footer-top'),
			'title' => esc_html__('Background', 'capital'),
    		'subtitle' => esc_html__('Background color or image for the footer widgets area.', 'capital'),
		),
		array(
			'id'       => 'footer_top_spacing',
			'type'     => 'spacing',
			'left' => false,
			'right' => false,
			'title'    => esc_html__('Top/Bottom padding', 'capital'),
            'desc' => esc_html__('Enter top and bottom spacing for the footer widgets area.', 'capital'),
			'mode' 	   => 'padding',
			'compiler' => array('.site-footer-top'),
			'units'    => array('px'),
		),
        array(
			'id'          => 'tfooter_border',
			'type'        => 'border',
			'title'       => esc_html__('Border top/bottom', 'capital'),
			'left' => false,
			'right' => false,
			'bottom' => true,
			'top' => true,
			'all' => false,
			'compiler'      => array('.site-footer-top'),
		),
        array(
			'id'          => 'widgettitle_typo',
			'type'        => 'typography',
			'text-transform' => true,
			'word-spacing' => true,
			'letter-spacing' => true,
			'title'       => esc_html__('Footer widgets title typography', 'capital'),
			'compiler'      => array('.footer_widget .footer-widgettitle'),
		),
        array(
			'id'          => 'tfwidget_typo',
			'type'        => 'typography',
			'text-transform' => true,
			'word-spacing' => true,
			'letter-spacing' => true,
			'title'       => esc_html__('Footer widgets area text typography', 'capital'),
			'compiler'      => array('.site-footer-top .footer_widget'),
		),
        array(
			'id'          => 'tfooter_link_color',
			'type'        => 'link_color',
			'title'       => esc_html__('Footer widgets area links color', 'capital'),
			'compiler'      => array('.body .site-footer-top .footer_widget a'),
		),
		array(
			'id'       => 'footer_widgets_area_end',
			'type'     => 'accordion',
			'position' => 'end',
		),
		array(
			'id'       => 'footer_copyrights_area_start',
			'type'     => 'accordion',
			'position' => 'start',
			'title'    => esc_html__('Copyrights row', 'capital'),
		),
        array(
            'id' => 'footer_bottom_enable',
            'type' => 'checkbox',
            'title' => esc_html__('Enable Footer copyrights area', 'capital'),
            'desc' => esc_html__('Uncheck to disable footer copyrights area that comes below the footer widgets area.', 'capital'),
			'default' => 1
        ),
		array(
			'id'=>'footer_bottom_skin',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Skin', 'capital'), 
			'options' => array(
					'footer-dark-skin' => esc_html__('Dark','capital'),
					'footer-light-skin' => esc_html__('Light','capital')
				),
			'default' => 'footer-dark-skin',
		),
        array(
            'id' => 'full_width_footer_bottom',
            'type' => 'checkbox',
            'title' => esc_html__('100% width', 'capital'),
            'subtitle' => esc_html__('Check this box to set footer copyrights area width to 100% of the browser width. Uncheck to follow site width. Only works with wide layout mode.', 'capital'),
            "default" => 0,
        ),
        array(
			'id'=>'footer_bottom_no_side_padding',
			'type' => 'checkbox',
			'compiler'=>true,
			'required' => array('full_width_footer_bottom','=','1'),
			'title' => esc_html__('No space on left/right', 'capital'), 
			'subtitle' => esc_html__('Check this box to set the footer copyrights area to 100% of the browser width with no space on the sides.', 'capital'),
			'default' => 0,
		),
        array(
			'id'          => 'bfooter_bg',
			'type'        => 'background',
			'title'       => esc_html__('Background', 'capital'),
			'compiler'      => array('.footer-light-skin.site-footer-bottom,.footer-dark-skin.site-footer-bottom'),
		),
		array(
			'id'       => 'footer_bottom_spacing',
			'type'     => 'spacing',
			'left' => false,
			'right' => false,
			'title'    => esc_html__('Top/Bottom padding', 'capital'),
            'desc' => esc_html__('Enter top and bottom spacing for the footer copyrights area. DO NOT ENTER px HERE.', 'capital'),
			'mode' 	   => 'padding',
			'compiler' => array('.site-footer-bottom'),
			'units'    => array('px'),
		),
        array(
			'id'          => 'bfooter_border',
			'type'        => 'border',
			'title'       => esc_html__('Border top/bottom', 'capital'),
			'left' => false,
			'right' => false,
			'bottom' => true,
			'top' => true,
			'all' => false,
			'compiler'      => array('.site-footer-bottom'),
		),
        array(
            'id' => 'footer_copyright_text',
            'type' => 'text',
            'title' => esc_html__('Footer Copyright Text', 'capital'),
            'subtitle' => esc_html__(' Enter Copyright Text', 'capital'),
            'default' => esc_html__('All Rights Reserved', 'capital')
        ),
        array(
			'id'          => 'bfwidget_typo',
			'type'        => 'typography',
			'text-transform' => true,
			'title'       => esc_html__('Footer copyrights area text typography', 'capital'),
			'compiler'      => array('.site-footer-bottom p, .footer-dark-skin.site-footer-bottom p'),
		),
        array(
			'id'          => 'bfooter_link_color',
			'type'        => 'link_color',
			'title'       => esc_html__('Footer copyrights area links color', 'capital'),
			'compiler'      => array('.body .site-footer-bottom a, .body .footer-dark-skin.site-footer-bottom a'),
		),
		array(
			'id'=>'footer_bottom_cont_type',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Copyrights footer right', 'capital'), 
			'subtitle' => esc_html__('Choose what to display at the right corner of copyrights footer area.', 'capital'),
			'desc'     => esc_html__('If menu option is chosen then you can set a Menu for location "Footer Menu" at Appearance > Menus','capital'),
			'options' => array(
				0 => esc_html__('Menu','capital'),
				1 => esc_html__('Social Icons','capital'),
				2 => esc_html__('None','capital'),
			),
			'default' => '0',
		),
		array(
			'id' => 'footer_social_links',
			'type' => 'sortable',
			'label' => true,
			'compiler'=>true,
			'required' => array('footer_bottom_cont_type','=','1'),
			'title' => esc_html__('Social Links', 'capital'),
			'desc' => esc_html__('Insert Social URL in their respective fields and sort as your desired order.', 'capital'),
			'options' => array(
				'fa-facebook' => 'facebook',
				'fa-twitter' => 'twitter',
				'fa-pinterest' => 'pinterest',
				'fa-google-plus' => 'google',
				'fa-youtube' => 'youtube',
				'fa-instagram' => 'instagram',
				'fa-vimeo' => 'vimeo',
				'fa-rss' => 'rss',
				'fa-dribbble' => 'dribbble',
				'fa-dropbox' => 'dropbox',
				'fa-bitbucket' => 'bitbucket',
				'fa-flickr' => 'flickr',
				'fa-foursquare' => 'foursquare',
				'fa-github' => 'github',
				'fa-gittip' => 'gittip',
				'fa-linkedin' => 'linkedin',
				'fa-pagelines' => 'pagelines',
				'fa-skype' => 'Enter Skype ID',
				'fa-tumblr' => 'tumblr',
				'fa-tripadvisor' => 'tripadvisor',
				'fa-vk' => 'vk',
				'fa-envelope' => 'Email Address'
			),
		),
		array(
			'id'=>'footer_social_shape',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Shape', 'capital'), 
			'options' => array(
					'imi-social-icons-round' => esc_html__('Round','capital'),
					'imi-social-icons-rounded' => esc_html__('Rounded','capital'),
					'imi-social-icons-square' => esc_html__('Square','capital'),
					'imi-social-icons-plain' => esc_html__('Plain','capital')
				),
			'default' => 'imi-social-icons-round',
			'required' => array('footer_bottom_cont_type','=','1'),
		),
		array(
			'id'=>'footer_social_size',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Size', 'capital'), 
			'options' => array(
					'imi-social-icons-small' => esc_html__('Small','capital'),
					'imi-social-icons-medium' => esc_html__('Medium','capital'),
					'imi-social-icons-large' => esc_html__('Large','capital'),
					'imi-social-icons-xlarge' => esc_html__('Extra Large','capital'),
					'imi-social-icons-custom' => esc_html__('Custom','capital')
				),
			'default' => 'imi-social-icons-small',
			'required' => array('footer_bottom_cont_type','=','1'),
		),
		array(
			'id'=>'footer_social_custom_size',
			'type' => 'dimensions',
			'compiler'=>true,
			'compiler' => array('.site-footer-bottom .imi-social-icons li a'),
			'title' => esc_html__('Custom size', 'capital'),
			'desc' => esc_html__('Keep the width and height fields filled with same values to keep the social icons boxes in square.', 'capital'),
			'required' => array('footer_bottom_cont_type','=','1'),
			'required' => array('footer_social_size','=','imi-social-icons-custom'),
		),
		array(
			'id'=>'footer_social_custom_spacing',
			'type' => 'spacing',
			'mode' => 'margin',
			'units' => array('px'),
			'compiler'=>true,
			'compiler' => array('.site-footer-bottom .imi-social-icons li'),
			'title' => esc_html__('Custom spacing', 'capital'),
			'desc' => esc_html__('Enter the margin from all sides for each social icon link.', 'capital'),
			'required' => array('footer_bottom_cont_type','=','1'),
			'required' => array('footer_social_size','=','imi-social-icons-custom'),
		),
		array(
			'id'=>'footer_social_custom_typo',
			'type' => 'typography',
			'compiler'=>true,
			'font-family' => false,
			'preview' => false,
			'text-align' => false,
			'line-height' => false,
			'color' => false,
			'word-spacing' => false,
			'letter-spacing' => false,
			'font-weight' => false,
			'font-style' => false,
			'compiler' => array('.site-footer-bottom .imi-social-icons li a'),
			'title' => esc_html__('Custom icon size', 'capital'),
			'required' => array('footer_bottom_cont_type','=','1'),
			'required' => array('footer_social_size','=','imi-social-icons-custom'),
		),
		array(
			'id'=>'footer_social_style',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Footer social icons style', 'capital'), 
			'options' => array(
					'imi-social-icons-bc' => esc_html__('Brand colors','capital'),
					'imi-social-icons-tc' => esc_html__('Theme primary color','capital'),
					'imi-social-icons-sc' => esc_html__('Theme secondary color','capital'),
					'imi-social-icons-gc' => esc_html__('Grayscale','capital')
				),
			'default' => 'imi-social-icons-sc',
			'required' => array('footer_bottom_cont_type','=','1'),
		),
		array(
			'id'=>'footer_social_hover_style',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Footer social icons hover style', 'capital'), 
			'options' => array(
					'imi-social-icons-hover-bc' => esc_html__('Brand colors','capital'),
					'imi-social-icons-hover-tc' => esc_html__('Theme primary color','capital'),
					'imi-social-icons-hover-sc' => esc_html__('Theme secondary color','capital'),
					'imi-social-icons-hover-gc' => esc_html__('Grayscale','capital')
				),
			'default' => 'imi-social-icons-hover-gc',
			'required' => array('footer_bottom_cont_type','=','1'),
		),
		array(
			'id'       => 'footer_social_icon_color',
			'type'     => 'link_color',
			'visited'  => false,
			'required' => array('footer_bottom_cont_type','=','1'),
			'required' => array('footer_social_shape','=','imi-social-icons-plain'),
			'compiler'   => array('.site-footer-bottom .imi-social-icons li a'),
			'title'    => esc_html__('Social Links Color', 'capital'),
		),
		array(
			'id'       => 'footer_copyrights_area_end',
			'type'     => 'accordion',
			'position' => 'end',
		),
    ),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-lines',
    'title' => esc_html__('Sidebars', 'capital'),
    'fields' => array(
        array(
    		'id' => 'sidebar_position',
    		'type' => 'image_select',
    		'compiler'=>true,
			'title' => esc_html__('Sidebar position','capital'), 
			'subtitle' => esc_html__('Select the Global Sidebar Position. Can be overridden by page sidebar settings.', 'capital'),
    			'options' => array(
    				'2' => array('title' => 'Left', 'img' => get_template_directory_uri().'/images/2cl.png'),
					'1' => array('title' => 'Right', 'img' => get_template_directory_uri().'/images/2cr.png')
    				),
    		'default' => '1'
    	),
		array(
			'id'       => 'page_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Pages Sidebar', 'capital'), 
			'desc'     => esc_html__('Select sidebar that will display on all pages.', 'capital'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'blog_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Blog Posts Sidebar', 'capital'), 
			'desc'     => esc_html__('Select sidebar that will display on all single posts.', 'capital'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'blog_archive_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Blog Posts Archive/Category Pages Sidebar', 'capital'), 
			'desc'     => esc_html__('Select sidebar that will display on all blog posts category/archive pages.', 'capital'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'project_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Project Posts Sidebar', 'capital'), 
			'desc'     => esc_html__('Select sidebar that will display on all single project pages.', 'capital'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'project_archive_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Project Posts Archive/Category Projects Sidebar', 'capital'), 
			'desc'     => esc_html__('Select sidebar that will display on all project posts category pages.', 'capital'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'service_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Service Posts Sidebar', 'capital'), 
			'desc'     => esc_html__('Select sidebar that will display on all single service pages.', 'capital'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'service_archive_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Service Posts Archive/Category Pages Sidebar', 'capital'), 
			'desc'     => esc_html__('Select sidebar that will display on all service posts category pages.', 'capital'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'team_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Team Posts Sidebar', 'capital'), 
			'desc'     => esc_html__('Select sidebar that will display on all team posts.', 'capital'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'team_archive_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Team Posts Archive/Category Pages Sidebar', 'capital'), 
			'desc'     => esc_html__('Select sidebar that will display on all team posts category pages.', 'capital'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'search_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Search Page Sidebar', 'capital'), 
			'desc'     => esc_html__('Select sidebar for search results page.', 'capital'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'product_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Shop page Sidebar', 'capital'), 
			'desc'     => esc_html__('Select sidebar for Woocommerce default shop and products archive/category pages.', 'capital'),
			'data'  => 'sidebars',
			'default'  => '',
		),
	),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-brush',
    'title' => esc_html__('Color Scheme', 'capital'),
    'fields' => array(
		array(
			'id'=>'theme_color_type',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Color scheme', 'capital'), 
			'options' => array(
					'0' => esc_html__('Pre-Defined Color Schemes','capital'),
					'1' => esc_html__('Custom Color','capital')
				),
			'default' => '0',
		),
        array(
            'id' => 'theme_color_scheme',
            'type' => 'select',
			'required' => array('theme_color_type','equals','0'),
            'title' => esc_html__('Theme Color Scheme', 'capital'),
            'subtitle' => esc_html__('Select from pre built color schemes.', 'capital'),
            'options' => array('color1.css' => 'color1.css', 'color2.css' => 'color2.css', 'color3.css' => 'color3.css', 'color4.css' => 'color4.css', 'color5.css' => 'color5.css', 'color6.css' => 'color6.css', 'color7.css' => 'color7.css', 'color8.css' => 'color8.css', 'color9.css' => 'color9.css', 'color10.css' => 'color10.css'),
            'default' => 'color1.css',
        ),
		array(
			'id'=>'primary_theme_color',
			'type' => 'color',
			'required' => array('theme_color_type','equals','1'),
			'title' => esc_html__('Primary theme color', 'capital'), 
			'validate' => 'color',
			'transparent' => false,
		),
		array(
			'id'=>'secondary_theme_color',
			'type' => 'color',
			'required' => array('theme_color_type','equals','1'),
			'title' => esc_html__('Secondary theme color', 'capital'), 
			'validate' => 'color',
			'transparent' => false,
		),
    ),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-font',
    'title' => esc_html__('Typography', 'capital'),
    'subtitle' => esc_html__('Global Font Family Sets', 'capital'),
	'desc' => esc_html__('These options are as per the design which consists of 3 fonts. For more advanced typography options see Sub Sections below this in Left Sidebar. Make sure you set these options only if you have knowledge about every property to avoid disturbing the whole layout. If something went wrong just reset this section to reset all fields in Typography Options or click the small cross signs in each select field/delete text from input fields to reset them.', 'capital'),
    'fields' => array(
        array(
            'id' => 'heading_font_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Heading font', 'capital'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => false,
			'text-align'	  => false,
            'font-weight' => true,
            'font-style' => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'letter-spacing' => false,
			'compiler'      => array('h1,h2,h3,h4,h5,h6, .project-filter-nav.plain-filters > li, .basic-link,.btn-default, .btn-primary, .btn-success, .btn-info, .btn-warning, .btn-danger, input[type="button"], input[type="submit"], button, .button,.vc_general.vc_btn3,.featured-buttons .fbtn'),
			'units'       =>'px',
            'subtitle' => esc_html__('Choose font style Headings', 'capital'),
            'default' => array(
            	'font-family' => 'Oswald',
				'font-weight' => '400',
            ),
        ),
        array(
            'id' => 'body_font_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Body/Primary font', 'capital'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => false,
			'text-align'	  => false,
            'font-weight' => true,
            'font-style' => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'letter-spacing' => false,
			'compiler'      => array('body'),
			'units'       =>'px',
	    	'subtitle' => esc_html__('Choose font style Body text.', 'capital'),
            'default' => array(
             	'font-family' => 'Open Sans',
             	'font-weight' => '400',
              ),
        ),
    ),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('More Options', 'capital'),
	'subsection' => true,
    'fields' => array(
        array(
            'id' => 'body_tag_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Body', 'capital'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => true,
			'font-style' 	  => true,
			'text-align'	  => false,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'compiler'      => array('body'),
			'units'       =>'px',
            'subtitle' => esc_html__('Typography options for body text', 'capital'),
        ),
        array(
            'id' => 'h1_tag_typography',
            'type'        => 'typography',
			'title'       => esc_html__('H1 Title', 'capital'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => true,
			'font-style' 	  => true,
			'text-align'	  => false,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'compiler'      => array('h1'),
			'units'       =>'px',
            'subtitle' => esc_html__('Typography options for H1 title', 'capital'),
        ),
        array(
            'id' => 'h2_tag_typography',
            'type'        => 'typography',
			'title'       => esc_html__('H2 Title', 'capital'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => true,
			'font-style' 	  => true,
			'text-align'	  => false,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'compiler'      => array('h2'),
			'units'       =>'px',
            'subtitle' => esc_html__('Typography options for H2 title', 'capital'),
        ),
        array(
            'id' => 'h3_tag_typography',
            'type'        => 'typography',
			'title'       => esc_html__('H3 Title', 'capital'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => true,
			'font-style' 	  => true,
			'text-align'	  => false,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'compiler'      => array('h3'),
			'units'       =>'px',
            'subtitle' => esc_html__('Typography options for H3 title', 'capital'),
        ),
        array(
            'id' => 'h4_tag_typography',
            'type'        => 'typography',
			'title'       => esc_html__('H4 Title', 'capital'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => true,
			'font-style' 	  => true,
			'text-align'	  => false,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'compiler'      => array('h4,.services-list li h4,.blog-posts .post h4,.team-item h4,.services-list li h4'),
			'units'       =>'px',
            'subtitle' => esc_html__('Typography options for H4 title', 'capital'),
        ),
        array(
            'id' => 'h5_tag_typography',
            'type'        => 'typography',
			'title'       => esc_html__('H5 Title', 'capital'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => true,
			'font-style' 	  => true,
			'text-align'	  => false,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'compiler'      => array('h5'),
			'units'       =>'px',
            'subtitle' => esc_html__('Typography options for H5 title', 'capital'),
        ),
        array(
            'id' => 'h6_tag_typography',
            'type'        => 'typography',
			'title'       => esc_html__('H6 Title', 'capital'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => true,
			'font-style' 	  => true,
			'text-align'	  => false,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'compiler'      => array('h6'),
			'units'       =>'px',
            'subtitle' => esc_html__('Typography options for H6 title', 'capital'),
        ),
        array(
            'id' => 'buttons_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Button', 'capital'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => true,
			'font-style' 	  => true,
			'text-align'	  => false,
            'word-spacing'=>true,
			'line-height' => false,
			'letter-spacing' => true,
			'compiler'      => array('.btn-default, .btn-primary, .btn-success, .btn-info, .btn-warning, .btn-danger, input[type="button"], input[type="submit"], button, .button,.vc_general.vc_btn3'),
			'units'       =>'px',
            'subtitle' => esc_html__('Typography options for buttons', 'capital'),
        ),
	),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Additional Styles', 'capital'),
    'desc' => esc_html__('Choose and select font families and styles for Google Fonts that are not loaded with the primary typography options. For example add different weight and style for a same font family you choose for your Typography options above.', 'capital'),
	'subsection' => true,
    'fields' => array(
        array(
            'id' => 'nowhere_font1',
            'type'        => 'typography',
			'title'       => esc_html__('Additional Font family and style 1', 'capital'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => false,
			'font-style' 	  => true,
			'font-weight' 	  => true,
			'text-align'	  => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'color'	  => false,
			'letter-spacing' => false,
			'compiler'      => array('.nowhere-font'),
			'units'       =>'px',
            'default' => array(
            	'font-family' => 'Open Sans',
				'font-style' => 'italic',
				'font-weight' => '400',
               ),
        ),
        array(
            'id' => 'nowhere_font2',
            'type'        => 'typography',
			'title'       => esc_html__('Additional Font family and style 2', 'capital'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => false,
			'font-style' 	  => true,
			'text-align'	  => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'color'	  => false,
			'letter-spacing' => false,
			'compiler'      => array('.nowhere-font'),
			'units'       =>'px',
            'default' => array(
            	'font-family' => 'Oswald',
				'font-weight' => '700',
				'font-style' => 'italic',
            ),
        ),
        array(
            'id' => 'nowhere_font3',
            'type'        => 'typography',
			'title'       => esc_html__('Additional Font family and style 3', 'capital'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => false,
			'font-style' 	  => true,
			'text-align'	  => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'color'	  => false,
			'letter-spacing' => false,
			'compiler'      => array('.nowhere-font'),
			'units'       =>'px',
            'default' => array(
            	'font-family' => 'Open Sans',
				'font-style' => 'italic',
				'font-weight' => '700',
               ),
        ),
        array(
            'id' => 'nowhere_font4',
            'type'        => 'typography',
			'title'       => esc_html__('Additional Font family and style 4', 'capital'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => false,
			'font-style' 	  => true,
			'text-align'	  => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'color'	  => false,
			'letter-spacing' => false,
			'compiler'      => array('.nowhere-font'),
			'units'       =>'px',
            'default' => array(
            	'font-family' => 'Open Sans',
				'font-weight' => '700',
               ),
        ),
        array(
            'id' => 'nowhere_font5',
            'type'        => 'typography',
			'title'       => esc_html__('Additional Font family and style 5', 'capital'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => false,
			'font-style' 	  => true,
			'text-align'	  => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'color'	  => false,
			'letter-spacing' => false,
			'compiler'      => array('.nowhere-font'),
			'units'       =>'px',
            'default' => array(
            	'font-family' => 'Oswald',
				'font-weight' => '400',
				'font-style' => 'italic',
            ),
        ),
        array(
            'id' => 'nowhere_font6',
            'type'        => 'typography',
			'title'       => esc_html__('Additional Font family and style 6', 'capital'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => false,
			'font-style' 	  => true,
			'text-align'	  => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'color'	  => false,
			'letter-spacing' => false,
			'compiler'      => array('.nowhere-font'),
			'units'       =>'px',
            'default' => array(
            	'font-family' => 'Oswald',
				'font-weight' => '700',
            ),
        ),
        array(
            'id' => 'nowhere_font7',
            'type'        => 'typography',
			'title'       => esc_html__('Additional Font family and style 7', 'capital'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => false,
			'font-style' 	  => true,
			'text-align'	  => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'color'	  => false,
			'letter-spacing' => false,
			'compiler'      => array('.nowhere-font'),
			'units'       =>'px',
            'default' => array(
            	'font-family' => 'Open Sans',
				'font-weight' => '300',
            ),
        ),
	),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-edit',
    'title' => esc_html__('Blog', 'capital'),
	'desc' => esc_html__('These options are the options for posts page set at Settings > Reading which use index.php template.', 'capital'),
    'fields' => array(
		array(
            'id' => 'blog_content_type',
            'type' => 'select',
            'title' => esc_html__('Posts content type', 'capital'),
            'subtitle' => esc_html__('If content is chosen then the full content of posts will be shown until the MORE tag which can be inserted in the post content.', 'capital'),
            'options' => array(0 => 'Content', 1 => 'Excerpt'),
            'default' => 1,
        ),
		array(
			'id'       => 'blog_excerpt_words',
			'type'     => 'text',
			'required' => array('blog_content_type','equals',1),
			'title'    => esc_html__('Number of words to show as excerpt', 'capital'),
			'default' => 40
		),
		array(
			'id'       => 'blog_author_meta',
			'type'     => 'checkbox',
			'title'    => esc_html__('Show post author name/link?', 'capital'),
			'default' => 1
		),
		array(
			'id'       => 'blog_date_meta',
			'type'     => 'checkbox',
			'title'    => esc_html__('Show post publish date?', 'capital'),
			'default' => 1
		),
		array(
			'id'       => 'blog_cats_meta',
			'type'     => 'checkbox',
			'title'    => esc_html__('Show post categories?', 'capital'),
			'default' => 1
		),
		array(
			'id'       => 'blog_comments_meta',
			'type'     => 'checkbox',
			'title'    => esc_html__('Show post comments count?', 'capital'),
			'default' => 1
		),
		array(
			'id'       => 'blog_read_more_btn',
			'type'     => 'checkbox',
			'title'    => esc_html__('Show read more button?', 'capital'),
			'default' => 1
		),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
	'subsection' => true,
    'title' => esc_html__('Single Post', 'capital'),
	'desc' => esc_html__('These options are the options for single post page template which use single.php template.', 'capital'),
    'fields' => array(
		array(
			'id'       => 'blog_post_author_meta',
			'type'     => 'checkbox',
			'title'    => esc_html__('Show post author name/link?', 'capital'),
			'default' => 1
		),
		array(
			'id'       => 'blog_post_date_meta',
			'type'     => 'checkbox',
			'title'    => esc_html__('Show post publish date?', 'capital'),
			'default' => 1
		),
		array(
			'id'       => 'blog_post_cats_meta',
			'type'     => 'checkbox',
			'title'    => esc_html__('Show post categories?', 'capital'),
			'default' => 1
		),
		array(
			'id'       => 'blog_post_thumbnail',
			'type'     => 'checkbox',
			'title'    => esc_html__('Show post media?', 'capital'),
			'default' => 1
		),
		array(
			'id'       => 'blog_post_comments_meta',
			'type'     => 'checkbox',
			'title'    => esc_html__('Show post comments count?', 'capital'),
			'default' => 1
		),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-error',
    'title' => esc_html__('404 Page', 'capital'),
    'fields' => array(
		array(
			'id'=>'page_404_banner',
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Page header image', 'capital'),
			'subtitle' => esc_html__('Upload image to show on the page header of the 404 error page.', 'capital'),
            'default' => array('url' => ''),
		),
		array(
			'id'       => 'page_404_banner_height',
			'type'     => 'dimensions',
			'title'    => esc_html__('Page header height', 'capital'),
			'compiler'   => array('.error404 .page-banner-text div'),
			'width' => false,
			'default' => array(
				'height' => '200px',
				'unit' => 'px',
			)
		),
		array(
            'id' => 'page_404_title',
            'type' => 'text',
            'title' => esc_html__('Page title', 'capital'),
            'desc' => esc_html__('Enter title for 404 error page. Default is 404 Error.', 'capital'),
        ),
		array(
            'id' => 'page_404_title_color',
            'type' => 'color',
			'compiler' => array('.error404 .page-banner-text h1'),
            'title' => esc_html__('Page title color', 'capital'),
        ),
		array(
            'id' => 'page_404_content',
            'type' => 'editor',
            'title' => esc_html__('Page content', 'capital'),
            'desc' => esc_html__('Enter text/html content for 404 error page.', 'capital'),
        ),
    ),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-css',
    'title' => esc_html__('Custom JS', 'capital'),
    'fields' => array(
        array(
            'id' => 'custom_js',
            'type' => 'ace_editor',
            //'required' => array('layout','equals','1'),	
            'title' => esc_html__('JS Code', 'capital'),
            'subtitle' => esc_html__('Paste your JS code here.', 'capital'),
            'mode' => 'javascript',
            'theme' => 'chrome',
            'desc' => '',
            'default' => ""
        )
    ),
));
Redux::setSection( $opt_name, array(
	  'title' => esc_html__('Import / Export', 'capital'),
	  'desc' => esc_html__('Import and Export your Theme Framework settings from file, text or URL.', 'capital'),
	  'icon' => 'el-icon-download',
	  'fields' => array(
		  array(
			  'id' => 'opt-import-export',
			  'type' => 'import_export',
			 'title' => esc_html__('Import Export','capital'),
			  'subtitle' => esc_html__('Save and restore your Theme options','capital'),
			  'full_width' => false,
		  ),
	  ),
));
add_filter('redux/options/' . $opt_name . '/compiler', 'capital_compiler_action', 10, 3);
if ( ! function_exists( 'capital_compiler_action' ) ) {
        function capital_compiler_action( $options, $css, $changed_values ) {
            global $wp_filesystem;

    $blog_id = get_current_blog_id();
    $filename = CAPITAL_FILEPATH . '/css/custom-option_'.$blog_id.'.css';
					//var_dump($filename);
    if( empty( $wp_filesystem ) ) {
        require_once ABSPATH .'/wp-admin/includes/file.php';
        WP_Filesystem();
    }

    if( $wp_filesystem ) {
        $wp_filesystem->put_contents(
            $filename,
            $css,
            FS_CHMOD_FILE // predefined mode settings for WP files
        );
    }
        }
    }

/*
* <--- END SECTIONS
*/