<?php
require dirname(__FILE__).'/lib/option-class.php';
require APP_PATH.'/lib/error-handler-class.php';
$error_handler = new Error_Handler();
$error_handler->register();
require APP_PATH.'/lib/utility-class.php';
require APP_PATH.'/lib/file-upload-class.php';
require APP_PATH.'/lib/bootstrap-portlet-class.php';

class ZooZoo_Builder {
    private $project;
    private $file;
    private $file_upload;
    public function __construct(){
        $this->project = new Option('zoozoo-builder');
        $this->file_upload = new File_Upload(); 
    }
    
    public function project_list(){
        header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
        header("Cache-Control: post-check=0, pre-check=0", false);
        header("Pragma: no-cache");
        
        echo json_encode($this->_projects());
    }
    
    public function new_project(){
        $project = array();
        $project['id'] = uniqid().rand(1,1000);
        $project['project_name'] = $_POST['project-name'];
        $project['project_theme'] = $_POST['project-theme'];
        $project['project_created_date'] = time();
        $projects = $this->_projects();
        $projects[$project['id']] = $project;
        $this->project->projects = $projects;
        $this->file = new Option($project['id']);

        header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
        header("Cache-Control: post-check=0, pre-check=0", false);
        header("Pragma: no-cache");
        
        echo json_encode($projects);
    }
    
    public function update_project(){
        $project = array();
        $project['id'] = $_POST['project-id'];
        $projects = $this->_projects();
        if (!empty($projects) && isset($projects[$project['id']])){
            $project = $projects[$project['id']];
            $project['project_name'] = $_POST['project-name'];
            $project['project_updated_date'] = time();
            $projects[$project['id']] = $project;
        }
        $this->project->projects = $projects;
        header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
        header("Cache-Control: post-check=0, pre-check=0", false);
        header("Pragma: no-cache");
        
        echo json_encode($project);
    }
    
    public function delete_project(){
        $project = array();
        $project['id'] = $_GET['project-id'];
        $projects = $this->_projects();
        if (!empty($projects) && isset($projects[$project['id']])){
            $project = $projects[$project['id']];
            unset($projects[$project['id']]);
            $this->file = new Option($project['id']);
            $this->file->remove();
        }
        
        $this->project->projects = $projects;
        header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
        header("Cache-Control: post-check=0, pre-check=0", false);
        header("Pragma: no-cache");
        
        echo json_encode($project);
    }
    
    public function get_project(){
        $project = array();
        $project['id'] = $_GET['project-id'];
        $projects = $this->_projects();
        if (!empty($projects) && isset($projects[$project['id']])){
            $project = $projects[$project['id']];
            $project['project_theme'] = (!empty($project['project_theme']))?$project['project_theme']:'';
            if (is_file(APP_PATH.'/themes/'.$project['project_theme'].'/config.php')){
                global $themes;
                require APP_PATH.'/themes/'.$project['project_theme'].'/config.php';
                $project['project_theme_name'] = (!empty($themes[$project['project_theme']]))?$themes[$project['project_theme']]:'';
            }

        }
        header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
        header("Cache-Control: post-check=0, pre-check=0", false);
        header("Pragma: no-cache");
        
        echo json_encode($project);
    }
    
    public function download_project(){
        ini_set('max_execution_time', 0);
        $html_content = '';
        $file = array();
        $project = array();
        $project['id'] = $_GET['project-id'];
        $projects = $this->_projects();
        $file_name = rand(1,1000).'.zip';
        if (!empty($projects) && isset($projects[$project['id']])){
            $project = $projects[$project['id']];
            $this->file = new Option($project['id']);
            $files = $this->file->files;
            $ary_files = array();
            if (!empty($files) && is_array($files)){
                foreach ($files as $id => $file){
                    $ary_files[$file['file_name']]['content'] = (isset($file['file_html_content']))?$file['file_html_content']:'';
                    $ary_files[$file['file_name']]['settings'] = (isset($file['settings']))?$file['settings']:array();
                    
                    $portlets = json_decode($file['portlets'],true);
                    if (!empty($portlets) && is_array($portlets)){
                        foreach ($portlets as $id => $porlet){
                            $ary_files[$file['file_name']]['plugins'][$porlet['portlet_type']] = $porlet['portlet_type'];
                        }
                    }
                }
            }
            $project_theme = (!empty($project['project_theme']))?$project['project_theme']:'';
            $file_name = sha1($project['project_name']).rand(1,1000);
            $this->create_zip_file($project_theme,$ary_files,$file_name,$project['project_theme']);
            
        }
        
        if (is_file ( APP_PATH. '/data/'.$file_name.'.zip' )) {
            $this->set_cookie_token('download_token', $_GET['download-token']);
            header ( 'Content-Type: application/zip' );
            header ( 'Content-disposition: attachment; filename='.preg_replace('!\s+!', '-', strtolower($project['project_name'])).'.zip' );
            header ( 'Content-Length: ' . filesize ( APP_PATH. '/data/'.$file_name.'.zip' ) );
            readfile ( APP_PATH. '/data/'.$file_name.'.zip' );
            if (is_file(APP_PATH. '/data/'.$file_name.'.zip')){
                unlink ( APP_PATH. '/data/'.$file_name.'.zip' );
            }
        }
    }
    
    private function set_cookie_token($cookieName, $cookieValue) {
        setcookie($cookieName, $cookieValue, 1893456000,'/',$_SERVER ['HTTP_HOST']);
    }
    
    public function file_list(){
        header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
        header("Cache-Control: post-check=0, pre-check=0", false);
        header("Pragma: no-cache");
        
        echo json_encode($this->_file_list($_GET['project-id']));
    }
    
    public function _file_list($project_id){
        $files = array();
        $project = array();
        $project['id'] = $project_id;
        $projects = $this->_projects();
        if (!empty($projects) && isset($projects[$project['id']])){
            $this->file = new Option($project['id']);
            $rs = $this->file->files;
            $rs = (is_array($rs))?$rs:array();
            foreach ($rs as $k => $v){
                $files[$k] = array(
                        'id' => $v['id'],
                        'file_name' => $v['file_name']
                );
            }
        }
        
        return $files;
    }
    
    public function new_file(){
        $project = array();
        $project['id'] = $_POST['project-id'];
        $projects = $this->_projects();
        if (!empty($projects) && isset($projects[$project['id']])){
            $project = $projects[$project['id']];
            $this->file = new Option($project['id']);
            $file = array();
            $file['id'] = uniqid().rand(1,1000);
            $file['file_name'] = $_POST['file-name'];
            $file['file_creted_date'] = time();
            
            $files = $this->file->files;
            $files = (is_array($files))?$files:array();
            if (!empty($_GET['template-file']) && $_GET['template-file'] != 'empty'){
                if (is_file(APP_PATH.'/themes/'.$project['project_theme'].'/templates/html-file/'.$_GET['template-file'].'/'.$_GET['template-file'].'.php')){
                    $data = file_get_contents(APP_PATH.'/themes/'.$project['project_theme'].'/templates/html-file/'.$_GET['template-file'].'/'.$_GET['template-file'].'.php');
                    $data = str_replace("<?php exit; ?>\n", "", $data);
                    $value = false;
                    if (!empty($data)){
                        $data = json_decode($data,true);
                        if (is_array($data)){
                            $file['portlets'] = $data['portlets'];
                            $file['file_html_content'] = $data['file_html_content'];
                        }
                    }
                }
            }
            
            $files[$file['id']] = $file;
            $this->file->files = $files;
        }
        
        header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
        header("Cache-Control: post-check=0, pre-check=0", false);
        header("Pragma: no-cache");
        
        echo json_encode($project);
    }
    
    public function copy_file(){
        $file = array();
        $project = array();
        $project['id'] = $_POST['project-id'];
        $projects = $this->_projects();
        if (!empty($projects) && isset($projects[$project['id']])){
            $project = $projects[$project['id']];
            $this->file = new Option($project['id']);
            $file = array();
            $file['id'] = $_POST['file-id'];
            $files = $this->file->files;
            $files = (is_array($files))?$files:array();
            if (!empty($files) && isset($files[$file['id']])){
                $file = $files[$file['id']];
                $file['id'] = uniqid().rand(1,1000);
                $file['file_name'] = $_POST['file-name'];
                $file['file_creted_date'] = time();
                unset($file['file_updated_date']);
                $files[$file['id']] = $file;
                $this->file->files = $files;
            }else{
                $file = array();
            }
        }
        header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
        header("Cache-Control: post-check=0, pre-check=0", false);
        header("Pragma: no-cache");
        
        echo json_encode($project);
    }
    
    public function update_file(){
        $project = array();
        $project['id'] = $_POST['project-id'];
        $projects = $this->_projects();
        if (!empty($projects) && isset($projects[$project['id']])){
            $project = $projects[$project['id']];
            $this->file = new Option($project['id']);
            $project_theme = $project['project_theme'];
            $file = array();
            $file['id'] = $_POST['file-id'];
            $files = $this->file->files;
            $files = (is_array($files))?$files:array();
            if (!empty($files) && isset($files[$file['id']])){
                $file = $files[$file['id']];
                $file['portlets'] = $_POST['portlets'];
                $portlets = json_decode($file['portlets'],true);
                $portlets = (!empty($portlets) && is_array($portlets))?$portlets:array();
                $file['file_html_content'] = $this->build_html_file($portlets,$project_theme);
                $file['file_updated_date'] = time();
                $files[$file['id']] = $file;
                
                /*$temp_data = array();
                $temp_data['portlets'] = $file['portlets'];
                $temp_data['file_html_content'] = $file['file_html_content'];
                error_log(json_encode($temp_data),3,APP_PATH.'/data/debug.log');
                error_log("\n\n",3,APP_PATH.'/data/debug.log');*/
                
                $this->file->files = $files;
            }
        }
        header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
        header("Cache-Control: post-check=0, pre-check=0", false);
        header("Pragma: no-cache");
        
        echo json_encode($file);
    }
    
    public function update_file_content(){
        $project = array();
        $project['id'] = $_POST['project-id'];
        $projects = $this->_projects();
        if (!empty($projects) && isset($projects[$project['id']])){
            $project = $projects[$project['id']];
            $this->file = new Option($project['id']);
            $project_theme = $project['project_theme'];
            $file = array();
            $file['id'] = $_POST['file-id'];
            $files = $this->file->files;
            $files = (is_array($files))?$files:array();
            if (!empty($files) && isset($files[$file['id']])){
                $file = $files[$file['id']];
                if (!empty($_POST['file_html_content'])){
                    $file['file_html_content'] = $_POST['file_html_content'];
                }
                $files[$file['id']] = $file;
                $this->file->files = $files;
            }
        }
        header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
        header("Cache-Control: post-check=0, pre-check=0", false);
        header("Pragma: no-cache");
        
        echo json_encode($file);
    }
    
    private function create_zip_file($project_theme,$files = array(),$zip_file_name,$project_name){
        global $global_plugin;
        $global_plugin = true;
        $zip_file_name = trim($zip_file_name);
        if (empty($zip_file_name)) return;
        $rootPath = realpath(APP_PATH. '/themes/'.$project_theme);
        
        if (is_file(APP_PATH.'/themes/'.$project_theme.'/config.php')){
            require APP_PATH.'/themes/'.$project_theme.'/config.php';
        }
        
        // Initialize archive object
        $zip = new ZipArchive();
        $zip->open(APP_PATH. '/data/'.$zip_file_name.'.zip', ZipArchive::CREATE | ZipArchive::OVERWRITE);
        
        $objects = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($rootPath),RecursiveIteratorIterator::LEAVES_ONLY);
        
        foreach ($objects as $name => $object){
            // Skip directories (they would be added automatically)
            if (!$object->isDir()){
                // Get real and relative path for current file
                $filePath = $object->getRealPath();
                $relativePath = substr($filePath, strlen($rootPath) + 1);
                $theme_portlets['config.php'] = 'config.php';
                $theme_portlets['portlets.php'] = 'portlets.php';
                $theme_portlets['template.php'] = 'template.php';
                $theme_portlets['iframe.php'] = 'iframe.php';
                $theme_portlets['iframe-style.css'] = 'iframe-style.css';
                $theme_portlets['abstract-portlet.js'] = 'abstract-portlet.js';
                if (strpos($relativePath, 'plugins') === 0 || strpos($relativePath, 'templates') === 0) continue;
                if (!in_array($object->getFilename(), $theme_portlets)){
                    // Add current file to archive
                    $zip->addFile($filePath, $relativePath);
                }
            }
        }
        
        // Copy plugin assets
        if (is_dir (APP_PATH.'/plugins' ) && $global_plugin == true) {
            if ($handle = @opendir ( APP_PATH.'/plugins' )) {
                while ( $file = readdir ( $handle ) ) {
                    if ((is_dir ( APP_PATH.'/plugins' . '/' . $file )) && ($file != '.') && ($file != '..') && ($file != '.svn')) {
                        if (is_dir(APP_PATH.'/plugins' . '/' . $file . '/assets')){
                            $objects = new RecursiveIteratorIterator(new RecursiveDirectoryIterator(APP_PATH.'/plugins' . '/' . $file . '/assets'),RecursiveIteratorIterator::LEAVES_ONLY);
                            foreach ($objects as $name => $object){
                                // Skip directories (they would be added automatically)
                                if (!$object->isDir()){
                                    // Get real and relative path for current file
                                    $filePath = $object->getRealPath();
                                    $relativePath = 'media/'.substr($filePath, strlen(APP_PATH) + 1);
                                    // Add current file to archive
                                    $zip->addFile($filePath, $relativePath);
                                }
                            }
                        }
                    }
                }
                closedir ( $handle );
            }
        }
        
        // Copy theme plugin assets
        $_theme_path = APP_PATH.'/themes' . '/' . $project_theme . '/plugins';
        if ($handle1 = @opendir ( $_theme_path )) {
            while ( $plugin = readdir ( $handle1 ) ) {
                if ((is_dir ( $_theme_path. '/' . $plugin )) && ($plugin != '.') && ($plugin != '..') && ($plugin != '.svn')) {
                    if (is_dir($_theme_path. '/' . $plugin . '/assets')){
                        $objects = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($_theme_path. '/' . $plugin . '/assets'),RecursiveIteratorIterator::LEAVES_ONLY);
                        foreach ($objects as $name => $object){
                            // Skip directories (they would be added automatically)
                            if (!$object->isDir()){
                                // Get real and relative path for current file
                                $filePath = $object->getRealPath();
                                $relativePath = 'media/'.substr($filePath, strlen(APP_PATH.'/themes' . '/' . $project_theme) + 1);
                                // Add current file to archive
                                $zip->addFile($filePath, $relativePath);
                            }
                        }
                    }
                }
            }
            closedir ( $handle1 );
        }
        
        $images = array();
        foreach ($files as $file_name => $file){
            $plugins = (!empty($file['plugins']) && is_array($file['plugins']))?$file['plugins']:array();
            $rootPath = APP_PATH;
            ob_start();
            if (is_file(APP_PATH.'/themes' . '/' . $project_theme .'/template.php')){
                require APP_PATH.'/themes' . '/' . $project_theme .'/template.php';
            }else{
                require APP_PATH.'/lib/builder/template.php';
            }
            $tempalte_content = ob_get_contents();
            ob_get_clean();
            
            $settings = $file['settings'];
            $file_content = $file['content'];
            // image tag
            $file_content = $this->get_image_link('/<\s*img[^>]*src\s*=\s*["\']?([^"\']*)/i', $file_content, $rootPath, $images);
            
            //data-image-src
            $file_content = $this->get_image_link('/<\s*[^>]*data-image-src\s*=\s*["\']?([^"\']*)/i', $file_content, $rootPath, $images);
            
            // background-image style
            $file_content = $this->get_image_link('/background-image\s*:\s*url\(["\']?([^"\']*)["\']?\)/i', $file_content, $rootPath, $images);
            // background style
            $file_content = $this->get_image_link('/background\s*:\s*url\(["\']?([^"\']*)["\']?\)/i', $file_content, $rootPath, $images);
            
            $file_content = str_replace('{{file_content}}', $file_content, $tempalte_content);
            $file_content = str_replace('{{theme_relative_path}}','', $file_content);
            $file_content = str_replace('{{media_relative_path}}','media/', $file_content);
            if (empty($settings['title'])){
                $file_content = str_replace('{{page-title}}',$project_name.'-'.$file_name, $file_content);
            }else{
                $file_content = str_replace('{{page-title}}',$settings['title'], $file_content);
            }
            
            if (empty($settings['background_color'])){
                $file_content = str_replace('{{body}}','<body>', $file_content);
            }else{
                $file_content = str_replace('{{body}}','<body style="background-color:'.$settings['background_color'].';">', $file_content);
            }
            if (!empty($settings['meta_keywords'])){
                $file_content = str_replace('{{meta-keywords}}',$settings['meta_keywords'], $file_content);
            }else{
                $file_content = str_replace('{{meta-keywords}}','', $file_content);
            }
            if (!empty($settings['meta_description'])){
                $file_content = str_replace('{{meta-description}}',$settings['meta_description'], $file_content);
            }else{
                $file_content = str_replace('{{meta-description}}','', $file_content);
            }
            
            $zip->addFromString ($file_name.'.html' , $file_content);
        }
        

        //Add image to zip file
        if (!empty($images)){
            foreach ($images as $image_name => $image){
                if ($this->is_url($image)){
                    $zip->addFromString ('images/'.$image_name , $this->file_get_contents($image));
                }else {
                    $image = APP_PATH.'/'.ltrim($image,'/');
                    if (is_file($image)){
                        $image_relative_path = substr($image, strlen($rootPath) + 1);
                        $zip->addFile($image, $image_relative_path);
                    }
                }
            }
        }
        
        // Zip archive will be created only after closing object
        $zip->close();
    }
    
    private function get_image_link($regex, $file_content, $rootPath, & $images){
        $matches = array();
        preg_match_all($regex, $file_content, $matches);
        if (!empty($matches) && !empty($matches[1])){
            foreach ($matches[1] as $k => $v){
                $v = str_replace(array('"',"'"), array('',''), html_entity_decode($v,ENT_QUOTES));
                $image_name = basename($v);
                while (array_key_exists($image_name, $images)) {
                    $image_name = rand(1,100).$image_name;
                }
                $images[$image_name] = $v;
                if ($this->is_url($v)){
                    $matches[1][$k] = str_replace($v, 'images/'.$image_name, $matches[0][$k]);
                }else{
                    $matches[1][$k] = str_replace($v, substr(APP_PATH.'/'.ltrim($v,'/'), strlen($rootPath) + 1), $matches[0][$k]);
                }
                
                $search = array('\\', '(',')','.','*','+','[',']','{','}','^',':','$','|','?');
                $replace = array('\\\\','\(','\)','\.','\*','\+','\[','\]','\{','\}','\^','\:','\$','\|','\?');
                $matches[0][$k] = '|'.str_replace($search, $replace, $matches[0][$k]).'|';
            }
        }
        
        //return str_replace($matches[0], $matches[1], $file_content);
        return preg_replace($matches[0], $matches[1], $file_content,1);
    }
    
    private function is_url($url){
        $regex = '#((https?|ftp)://(\S*?\.\S*?))([\s)\[\]{},;"\':<]|\.\s|$)#i';
        if (preg_match($regex, $url)) {
            return true;
        }else{
            return false;
        }
    }
    
    private function file_get_contents($url) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_AUTOREFERER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);       
        $data = curl_exec($ch);
        curl_close($ch);
        return $data;
    }
    
    
    
    public function edit_file(){
        $project = array();
        $project['id'] = $_POST['project-id'];
        $projects = $this->_projects();
        if (!empty($projects) && isset($projects[$project['id']])){
            $project= $projects[$project['id']];
            $this->file = new Option($project['id']);
            $file = array();
            $file['id'] = $_POST['file-id'];
            $files = $this->file->files;
            $files = (is_array($files))?$files:array();
            if (!empty($files) && isset($files[$file['id']])){
                $file = $files[$file['id']];
                $file['file_name'] = $_POST['file-name'];
                $file['file_updated_date'] = time();
                $files[$file['id']] = $file;
                $this->file->files = $files;
            }
        }
        header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
        header("Cache-Control: post-check=0, pre-check=0", false);
        header("Pragma: no-cache");
        
        echo json_encode($project);
    }
    
    public function get_file(){
        $file = array();
        $project = array();
        $project['id'] = $_GET['project-id'];
        $projects = $this->_projects();
        if (!empty($projects) && isset($projects[$project['id']])){
            $this->file = new Option($project['id']);
            $file = array();
            $file['id'] = $_GET['file-id'];
            $files = $this->file->files;
            $files = (is_array($files))?$files:array();
            if (!empty($files) && isset($files[$file['id']])){
                $file = $files[$file['id']];
            }else{
                $file = array();
            }
        }
        header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
        header("Cache-Control: post-check=0, pre-check=0", false);
        header("Pragma: no-cache");
        
        echo json_encode($file);
    }
    
    public function delete_file(){
        $file = array();
        $project = array();
        $project['id'] = $_GET['project-id'];
        $projects = $this->_projects();
        if (!empty($projects) && isset($projects[$project['id']])){
            $project = $projects[$project['id']];
            $this->file = new Option($project['id']);
            $file = array();
            $file['id'] = $_GET['file-id'];
            $files = $this->file->files;
            $files = (is_array($files))?$files:array();
            if (!empty($files) && isset($files[$file['id']])){
                unset($files[$file['id']]);
                $this->file->files = $files;
            }else{
                $file = array();
            }
        }
        header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
        header("Cache-Control: post-check=0, pre-check=0", false);
        header("Pragma: no-cache");
        
        echo json_encode($project);
    }
    
    public function preview(){
        $html_content = '';
        $file = array();
        $project = array();
        $project['id'] = $_GET['project-id'];
        $projects = $this->_projects();
        $file_name = rand(1,1000).'.zip';
        if (!empty($projects) && isset($projects[$project['id']])){
            $project = $projects[$project['id']];
            $project_theme = (!empty($project['project_theme']))?$project['project_theme']:'';
            $this->file = new Option($project['id']);
            $file = array();
            $file['id'] = $_GET['file-id'];
            $files = $this->file->files;
            $files = (is_array($files))?$files:array();
            if (!empty($files) && isset($files[$file['id']])){
                $file = $files[$file['id']];
                $html_content = (!empty($file['file_html_content']))?$file['file_html_content']:'';
                ob_start();
                if (is_file(APP_PATH.'/themes/'.$project_theme.'/config.php')){
                    require APP_PATH.'/themes/'.$project_theme.'/config.php';
                }
                if (is_file(APP_PATH.'/themes/'.$project_theme.'/template.php')){
                    require APP_PATH.'/themes/'.$project_theme.'/template.php';
                }else{
                    require APP_PATH.'/lib/builder/template.php';
                }
                $tempalte_content = ob_get_contents();
                ob_get_clean();
                $html_content = str_replace('{{file_content}}', $html_content, $tempalte_content);
                $html_content = str_replace('{{theme_relative_path}}','themes/'.$project_theme.'/', $html_content);
                //$html_content = str_replace('{{page-title}}',$project['project_theme'].'-'.$file['file_name'], $html_content);
                $html_content = str_replace('{{media_relative_path}}', '', $html_content);
                
                $settings = (isset($file['settings']))?$file['settings']:array();
                if (empty($settings['title'])){
                    $html_content = str_replace('{{page-title}}',$project['project_theme'].'-'.$file['file_name'], $html_content);
                }else{
                    $html_content = str_replace('{{page-title}}',$settings['title'], $html_content);
                }
                
                if (empty($settings['background_color'])){
                    $html_content = str_replace('{{body}}','<body>', $html_content);
                }else{
                    $html_content = str_replace('{{body}}','<body style="background-color:'.$settings['background_color'].';">', $html_content);
                }
                if (!empty($settings['meta_keywords'])){
                    $html_content = str_replace('{{meta-keywords}}',$settings['meta_keywords'], $html_content);
                }else{
                    $html_content = str_replace('{{meta-keywords}}','', $html_content);
                }
                if (!empty($settings['meta_description'])){
                    $html_content = str_replace('{{meta-description}}',$settings['meta_description'], $html_content);
                }else{
                    $html_content = str_replace('{{meta-description}}','', $html_content);
                }
            }
        }
        
       return $html_content;
    }
    
    private function _projects(){
        $projects = $this->project->projects;
        $projects = (is_array($projects))?$projects:array();
        
        return $projects;
    }
    
    public function download_file(){
        ini_set('max_execution_time', 0);
        $html_content = '';
        $file = array();
        $project = array();
        $project['id'] = $_GET['project-id'];
        $projects = $this->_projects();
        $file_name = rand(1,1000).'.zip';
        if (!empty($projects) && isset($projects[$project['id']])){
            $project = $projects[$project['id']];
            $this->file = new Option($project['id']);
            $file = array();
            $file['id'] = $_GET['file-id'];
            $files = $this->file->files;
            $files = (is_array($files))?$files:array();
            if (!empty($files) && isset($files[$file['id']])){
                $file = $files[$file['id']];
                $ary_files = array();
                $ary_files[$file['file_name']]['content'] = (isset($file['file_html_content']))?$file['file_html_content']:'';
                $ary_files[$file['file_name']]['settings'] = (isset($file['settings']))?$file['settings']:array();
                $file_name = sha1($project['project_name']).rand(1,1000);
                
                $portlets = json_decode($file['portlets'],true);
                if (!empty($portlets) && is_array($portlets)){
                    foreach ($portlets as $id => $porlet){
                        $ary_files[$file['file_name']]['plugins'][$porlet['portlet_type']] = $porlet['portlet_type'];
                    }
                }
                
                $project_theme = (!empty($project['project_theme']))?$project['project_theme']:'';
                $this->create_zip_file($project_theme,$ary_files,$file_name,$project['project_name']);
            }
        }
        
        if (is_file ( APP_PATH. '/data/'.$file_name.'.zip' )) {
            $this->set_cookie_token('download_token', $_GET['download-token']);
            header ( 'Content-Type: application/zip' );
            header ( 'Content-disposition: attachment; filename='.preg_replace('!\s+!', '-', strtolower($project['project_name'])).'.zip' );
            header ( 'Content-Length: ' . filesize ( APP_PATH. '/data/'.$file_name.'.zip' ) );
            readfile ( APP_PATH. '/data/'.$file_name.'.zip' );
            if (is_file(APP_PATH. '/data/'.$file_name.'.zip')){
                unlink ( APP_PATH. '/data/'.$file_name.'.zip' );
            }
        }
    }
    
    public function build_html_file(& $portlets,$project_theme,$sortable_id = 'bootstrap-builder-container'){
        $html_content = '';
        foreach ($portlets as $portlet_id => $portlet){
            if ($portlet['sortable_id'] == $sortable_id){
                $portlet_file = APP_PATH.'/plugins/'.$portlet['portlet_type'].'/'.$portlet['portlet_type'].'-portlet.php';
                $theme_portlet_file = APP_PATH.'/themes/'.$project_theme.'/plugins/'.$portlet['portlet_type'].'/'.$portlet['portlet_type'].'-portlet.php';
                
                $portlet_class_ary = explode('-', strtolower($portlet['portlet_type']));
                $portlet_class = '';
                foreach ($portlet_class_ary as $v){
                    $portlet_class .= ucfirst($v).'_';
                }
                $portlet_class .= 'Portlet';
                if (is_file($theme_portlet_file) && is_readable($theme_portlet_file)){
                    if (!class_exists($portlet_class)){
                        
                        require $theme_portlet_file;
                    }
                    
                    if (class_exists($portlet_class)){
                        $portlet_object = new $portlet_class($portlets, $portlet,$portlet_id,$this);
                    }else{
                        $portlet_object = new Bootstrap_Portlet($portlets, $portlet,$portlet_id,$this);
                    }
                }else if (is_file($portlet_file) && is_readable($portlet_file)){
                    if (!class_exists($portlet_class)){
                        
                        require $portlet_file;
                    }
                    
                    if (class_exists($portlet_class)){
                        $portlet_object = new $portlet_class($portlets, $portlet,$portlet_id,$this);
                    }else{
                        $portlet_object = new Bootstrap_Portlet($portlets, $portlet,$portlet_id,$this);
                    }
                }else{
                    $portlet_object = new Bootstrap_Portlet($portlets, $portlet,$portlet_id,$this);
                }
                $portlet_object->project_theme = $project_theme;
                
                $html_content .= $portlet_object->to_html();
            }
        }
        
        return $html_content;
    }
    
    public function load_plugin($project_theme, $portlet_type, $portlet_id, $method){
        header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
        header("Cache-Control: post-check=0, pre-check=0", false);
        header("Pragma: no-cache");
        $method = trim($method);
        $portlet_file = APP_PATH.'/plugins/'.$portlet_type.'/'.$portlet_type.'-portlet.php';
        if (is_file(APP_PATH.'/themes/'.$project_theme.'/plugins/'.$portlet_type.'/'.$portlet_type.'-portlet.php')){
            $portlet_file = APP_PATH.'/themes/'.$project_theme.'/plugins/'.$portlet_type.'/'.$portlet_type.'-portlet.php';
        }
        if (is_file($portlet_file)){
            $portlet_class_ary = explode('-', strtolower($portlet_type));
            $portlet_class = '';
            foreach ($portlet_class_ary as $v){
                $portlet_class .= ucfirst($v).'_';
            }
            $portlet_class .= 'Portlet';
            if (!class_exists($portlet_class)){
                require $portlet_file;
            }
            
            if (class_exists($portlet_class)){
                $portlets = array();
                $portlet = array();
                $portlet_object = new $portlet_class($portlets, $portlet,$portlet_id,$this);
                if (!empty($method) && method_exists($portlet_object, $method) && is_callable(array($portlet_object, $method)) && $method != 'to_html' ){
                    $portlet_object->{$method}();
                }
            }
        }
    }
    
    public function portlet_copies(){
        if (!empty($_POST['portlets']) && !empty($_GET['project-theme'])){
            $project_theme = $_GET['project-theme'];
            $portlets = json_decode($_POST['portlets'],true);
            $portlets = (!empty($portlets) && is_array($portlets))?$portlets:array();
            foreach ($portlets as $id => $portlet){
                if (!empty($portlet['old_portlet_id'])){
                    $portlet_id = $_GET['portlet-id'] = $portlet['old_portlet_id']; 
                    $_GET['new-portlet-id'] = $portlet['portlet_id'];
                    $portlet_type = $portlet['portlet_type'];
                    
                    $portlet_file = APP_PATH.'/plugins/'.$portlet_type.'/'.$portlet_type.'-portlet.php';
                    if (is_file(APP_PATH.'/themes/'.$project_theme.'/plugins/'.$portlet_type.'/'.$portlet_type.'-portlet.php')){
                        $portlet_file = APP_PATH.'/themes/'.$project_theme.'/plugins/'.$portlet_type.'/'.$portlet_type.'-portlet.php';
                    }
                    if (is_file($portlet_file)){
                        $portlet_class_ary = explode('-', strtolower($portlet_type));
                        $portlet_class = '';
                        foreach ($portlet_class_ary as $v){
                            $portlet_class .= ucfirst($v).'_';
                        }
                        $portlet_class .= 'Portlet';
                        if (!class_exists($portlet_class)){
                            require $portlet_file;
                        }
                    
                        if (class_exists($portlet_class)){
                            $portlets = array();
                            $portlet = array();
                            $portlet_object = new $portlet_class($portlets, $portlet,$portlet_id,$this);
                            $method = 'portlet_copy';
                            if (!empty($method) && method_exists($portlet_object, $method) && is_callable(array($portlet_object, $method)) && $method != 'to_html' ){
                                $portlet_object->{$method}();
                            }
                        }
                    }
                }
            }
        }
    }
    
    public function upload_image(){
        $var = array();
        $var['image_file'] = '';
        $field_name = (!empty($_GET['field-name']))?$_GET['field-name']:'image-file';
        $errors = $this->file_upload->upload($field_name, $field_name, '');
        if (empty($errors)){
            if (is_array($_POST[$field_name])){
                $var[str_replace('-', '_', $field_name)] = 'data/images/'.ltrim($_POST[$field_name][0],'/');
            }else{
                $var[str_replace('-', '_', $field_name)] = 'data/images/'.ltrim($_POST[$field_name],'/');
            }
        }
        
        header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
        header("Cache-Control: post-check=0, pre-check=0", false);
        header("Pragma: no-cache");
        
        echo json_encode($var); 
    }
    
    public function theme_list(){
        global $themes;
        $themes = array();
        if (is_dir ( APP_PATH.'/themes' )) {
            if ($handle = @opendir ( APP_PATH.'/themes' )) {
                while ( $file = readdir ( $handle ) ) {
                    if ((is_dir ( APP_PATH.'/themes' . '/' . $file )) && ($file != '.') && ($file != '..') && ($file != '.svn')) {
                        if (is_file ( APP_PATH.'/themes' . '/' . $file . '/config.php' )) {
                            require_once APP_PATH.'/themes' . '/' . $file . '/config.php';
                        }
                    }
                }
                closedir ( $handle );
            }
        }
        header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
        header("Cache-Control: post-check=0, pre-check=0", false);
        header("Pragma: no-cache");
        
        echo json_encode($themes);
    }
    
    public function template_file_list(){
        $project = array();
        $project['id'] = $_GET['project-id'];
        $projects = $this->_projects();
        $project_theme = '';
        if (!empty($projects) && isset($projects[$project['id']])){
            $project_theme = $projects[$project['id']]['project_theme'];
        }
        $templates = array();
        if (trim($project_theme) != '') {
            if (is_dir ( APP_PATH.'/themes/'.$project_theme.'/templates/html-file')) {
                if ($handle = @opendir ( APP_PATH.'/themes/'.$project_theme.'/templates/html-file' )) {
                    while ( $file = readdir ( $handle ) ) {
                        if ((is_dir ( APP_PATH.'/themes/'.$project_theme.'/templates/html-file/' . $file )) && ($file != '.') && ($file != '..') && ($file != '.svn')) {
                            if (is_file(APP_PATH.'/themes/'.$project_theme.'/templates/html-file/' . $file .'/'. $file .'.php')){
                                $template = array();
                                $template['file'] = 'themes/'.$project_theme.'/templates/html-file/' . $file .'/'. $file .'.php';
                                $name = explode('-', $file);
                                $name = ucfirst(implode(' ', $name));
                                $template['name'] = $name;
                                if (is_file(APP_PATH.'/themes/'.$project_theme.'/templates/html-file/' . $file .'/thumbnail.png')){
                                    $template['thumbnail'] = 'themes/'.$project_theme.'/templates/html-file/' . $file .'/thumbnail.png';
                                }
                                $templates[$file] = $template;
                            }
                        }
                    }
                    closedir ( $handle );
                }
            }   
        }
        
        return $templates;
    }
    
    public function save_file_setting(){
        $project = array();
        $file = array();
        $project['id'] = $_POST['project-id'];
        $projects = $this->_projects();
        if (!empty($projects) && isset($projects[$project['id']])){
            $project = $projects[$project['id']];
            $this->file = new Option($project['id']);
            $project_theme = $project['project_theme'];
            $file['id'] = $_POST['file-id'];
            $files = $this->file->files;
            $files = (is_array($files))?$files:array();
            if (!empty($files) && isset($files[$file['id']])){
                $file = $files[$file['id']];
                if (!empty($_POST['settings'])){
                    $file['settings'] = $_POST['settings']; 
                    $files[$file['id']] = $file;
                    $this->file->files = $files;
                }
            }
        }
        header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
        header("Cache-Control: post-check=0, pre-check=0", false);
        header("Pragma: no-cache");
        
        echo json_encode($file);
    }
    
    public function load_portlet_data(){
        $project_theme = !empty($_GET['project-theme'])?$_GET['project-theme']:'';
        $plugin =  !empty($_GET['plugin'])?$_GET['plugin']:'';
        
        $portlet_data_file = APP_PATH. '/plugins/'.$plugin.'/data/default.php';
        
        if (is_file(APP_PATH.'/themes/'.$project_theme.'/plugins/'.$plugin.'/data/default.php')){
            $portlet_data_file = APP_PATH.'/themes/'.$project_theme.'/plugins/'.$plugin.'/data/default.php';
        }
        $data = '{}';
        if (is_file($portlet_data_file)){
            $data = file_get_contents($portlet_data_file);
            $data = str_replace("<?php exit; ?>\n", "", $data);
            header('Content-Type: application/json');
        }
        
        header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
        header("Cache-Control: post-check=0, pre-check=0", false);
        header("Pragma: no-cache");
        
        echo $data;
    }
    
    public function execute(){
        $action = (!empty($_GET['action']))?$_GET['action']:null;
        if ($action === null){
            $action = (!empty($_POST['action']))?$_POST['action']:null;
        }
        switch ($action){
            case 'theme-list':
                $this->theme_list();
                break;
            case 'project-list':
                $this->project_list();
                break;
            case 'new-project':
                $this->new_project();
                break;
            case 'update-project':
                $this->update_project();
                break;
            case 'get-project':
                $this->get_project();
                break;
            case 'delete-project':
                $this->delete_project();
                break;
            case 'download-project':
                $this->download_project();
                break;
            case 'file-list':
                $this->file_list();
                break;
            case 'new-file':
                $this->new_file();
                break;
            case 'copy-file':
                $this->copy_file();
                break;
            case 'update-file':
                $this->update_file();
                break;
            case 'edit-file':
                $this->edit_file();
                break;
            case 'get-file':
                $this->get_file();
                break;
            case 'download-file':
                $this->download_file();
                break;
            case 'delete-file':
                $this->delete_file();
                break;
            case 'template-file-list':
                header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
                header("Cache-Control: post-check=0, pre-check=0", false);
                header("Pragma: no-cache");
                
                echo json_encode($this->template_file_list());
                break;
            case 'preview':
                header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
                header("Cache-Control: post-check=0, pre-check=0", false);
                header("Pragma: no-cache");
                
                echo  $this->preview();
echo <<<SCRIPT
<script>
    $(document).ready(function(){
        $("a").click(function(e) {
            e.preventDefault();
        });
    });
</script>
SCRIPT;
                break;
            case 'upload-image':
                $this->upload_image();
                break;
            case 'load-plugin-file':
                $project_theme = !empty($_GET['project-theme'])?$_GET['project-theme']:'';
                $plugin =  !empty($_GET['plugin'])?$_GET['plugin']:'';
                $file =  !empty($_GET['file'])?$_GET['file']:'';
                if (is_file(dirname(__FILE__).'/themes/'.$project_theme.'/plugins/'.$plugin.'/'.$file)){
                    echo file_get_contents(dirname(__FILE__).'/themes/'.$project_theme.'/plugins/'.$plugin.'/'.$file);
                }else if (is_file(dirname(__FILE__).'/plugins/'.$plugin.'/'.$file)){
                    echo file_get_contents(dirname(__FILE__).'/plugins/'.$plugin.'/'.$file);
                }
                break;
            case 'load-template-block':
                $url =  !empty($_POST['url'])?$_POST['url']:'';
                if (is_file(dirname(__FILE__).'/'.$url)){
                    $data = file_get_contents(dirname(__FILE__).'/'.$url);
                    $data = str_replace("<?php exit; ?>\n", "", $data);
                    header('Content-Type: application/json');
                    echo $data;
                }
                break;
            case 'iframe-builder':
                $project = array();
                $project['id'] = $_GET['project-id'];
                $projects = $this->_projects();
                $iframe_builder = APP_PATH.'/lib/builder/iframe.php';
                if (!empty($projects) && isset($projects[$project['id']])){
                    $project = $projects[$project['id']];
                    if (is_file(APP_PATH.'/themes/'.$project['project_theme'].'/iframe.php')){
                        $iframe_builder = APP_PATH.'/themes/'.$project['project_theme'].'/iframe.php';
                    }
                }
                
                require $iframe_builder;
                break;
            case 'portlet-components':
                global $global_plugin;
                $global_plugin = true;
                $project_theme = (!empty($_GET['project-theme']))?$_GET['project-theme']:'';
                if (is_file(APP_PATH.'/themes/'.$project_theme.'/config.php')){
                    require APP_PATH.'/themes/'.$project_theme.'/config.php';
                    require APP_PATH.'/lib/utility-class.php';
                }else{
                    exit;
                }
                $utility = new Utility();
                
                $plugins = array();
                if ($global_plugin == true){
                    $utility->load_plugins (APP_PATH.'/plugins', $plugins);
                }
                $utility->load_plugins (APP_PATH.'/themes/'.$project_theme.'/plugins', $plugins);
                $template_block = $utility->get_template_blocks($project_theme);
                
                $portlet_components = APP_PATH.'/lib/builder/portlets.php';
                if (is_file(APP_PATH.'/themes/'.$project_theme.'/portlets.php')){
                    $portlet_components = APP_PATH.'/themes/'.$project_theme.'/portlets.php';
                }
                
                require $portlet_components;
                break;
            case 'save-file-setting':
                $this->save_file_setting();
                break;
            case 'update-file-content':
                $this->update_file_content();
                break;
            case 'load-plugin':
                $project_theme = (!empty($_GET['project-theme']))?$_GET['project-theme']:'';
                $portlet_type = (!empty($_GET['plugin']))?$_GET['plugin']:'';
                $portlet_id = (!empty($_GET['portlet-id']))?$_GET['portlet-id']:'';
                $method = (!empty($_GET['method']))?$_GET['method']:'';
                $this->load_plugin($project_theme, $portlet_type, $portlet_id, $method);
                break;
            case 'portlet-copies':
                $this->portlet_copies();
                break;
            case 'load-portlet-data':
                $this->load_portlet_data();
                break;
                
        }
    }
    
}

function stripslashes_array($array) {
    return is_array ( $array ) ? array_map ('stripslashes_array', $array ) : stripslashes ( $array );
}

if (get_magic_quotes_gpc ()) {
    $_GET = stripslashes_array ( $_GET );
    $_POST = stripslashes_array ( $_POST );
    $_COOKIE = stripslashes_array ( $_COOKIE );
    $_REQUEST = stripslashes_array ( $_REQUEST );
}

$builder = new ZooZoo_Builder();
$builder->execute();

