/*
 * portlet: video
 * portlet-type: video 
 * portlet-group: media
 * portlet-name: <i class="fa fa-file-video-o" ></i> Video
 * portlet-image: assets/images/no-image.png
 */
Video_Portlet_Class = function(){
	this.toolbar_name = 'Video';
}
$.extend(Video_Portlet_Class.prototype, Abstract_Portlet_Class.prototype);
Video_Portlet_Class.prototype.advance_render = function(portlet_id,content){
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
	var div = $('<div></div>');
	var css = {};
	if (portlet.style != undefined && $.isEmptyObject(portlet.style) == false){
		$.each( portlet.style, function( name, value ) {
			if ($.trim(value) != ''){
				if (name.indexOf("margin-") != -1 || name.indexOf("padding-") != -1 || name.indexOf("-width") != -1){
					css[name] = value + 'px';
				}else{
					css[name] = value;
				}
			}
		});
		div.css(css);
	}
	
	if (portlet.attr != undefined && $.isEmptyObject(portlet.attr) == false){
		$.each( portlet.attr, function( name, value ) {
			if ($.trim(value) != ''){
				div.attr(name,value);
			}
		});
	}
	
	div.append(content);
	
	return div;
};
Video_Portlet_Class.prototype.portlet_save = function (portlet_id,modal_hide,toolbar){
	toolbar = (toolbar != undefined)?true:false;
	var _this = this;
	modal_hide = (modal_hide == undefined)?true:modal_hide;
	
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
	Bootstrap_Builder.change_flag = true;
	window.onbeforeunload = function(e) {
        var message = 'Data you have entered may not be saved. ';
        e.returnValue  = message;
        return message;
    }
    var sortable_id = $('#portlets_modal').data('sortable-id');
    if (toolbar == false){
	    var fields = $("#portlets_modal .portlet-style" ).serializeArray();
	    var style = {};
	    $.each( fields, function( i, field ) {
	    	style[field.name] = field.value;
	    });
	    portlet.style = style;
	    
	    fields = $("#portlets_modal .portlet-attr" ).serializeArray();
	    var attr = {};
	    $.each( fields, function( i, field ) {
	    	attr[field.name] = field.value;
	    });
	    portlet.attr = attr;
	    portlet.video_link = $('#portlets_modal #video-link').val();
	    portlet.video_aspect_ration = $('#portlets_modal #video-aspect-ration').val();
    }
    var video_link = '';
    var value = '';
    try{
    	video_id = portlet.video_link.split(/video\/|https?:\/\/vimeo\.com\//)[1].split(/[?&]/)[0];
    	if(video_id != null && video_id != '') {
    		video_link = 'https://player.vimeo.com/video/'+video_id;
    		value =  $('<div></div>').append(
					$('<div class="embed-responsive"></div>')
					.append('<iframe class="embed-responsive-item" src="'+video_link+'" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>')
					.addClass(portlet.video_aspect_ration)
			 	).html();
         }
    }catch (e){
    	var video_id = '';
        var url = portlet.video_link.replace(/(>|<)/gi,'').split(/(vi\/|v=|\/v\/|youtu\.be\/|\/embed\/)/);
        if(url[2] !== undefined) {
        	video_id = url[2].split(/[^0-9a-z_\-]/i);
        	video_id = video_id[0];
        } else {
        	video_id = url;
        }
        
        if(video_id != null && video_id != '') {
           video_link = 'https://www.youtube.com/embed/'+video_id;
        }
        value =  $('<div></div>').append(
					$('<div class="embed-responsive"></div>')
					.append('<iframe class="embed-responsive-item" src="'+video_link+'" allowfullscreen></iframe>')
					.addClass(portlet.video_aspect_ration)
			 	).html();
    }
    _this.portlet_render(portlet_id,sortable_id,value,modal_hide);
};
Video_Portlet_Class.prototype.portlet_modal = function (portlet_id){
	var _this = this;
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
    
    $('#portlets_modal').find('#portlets_modal_label').html('Video');
    $('#portlets_modal').find('#portlets_modal_body').empty();
    
    // render footer button.
    $('#portlets_modal').find('#portlets_modal_body')
    .after(
       $('<div></div>')
       .attr('id','portlets_modal_footer')
       .addClass('modal-footer')
       .append(
            $('<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>')     
       )
       .append(
            $('<button type="button" class="btn btn-primary">Apply</button>')
            .click(function(){
            	_this.portlet_save(portlet_id,false);
            })
       )
       .append(
            $('<button type="button" class="btn btn-primary">Save & close</button>')
            .click(function(){
            	_this.portlet_save(portlet_id);
            })
       )
    );
    // end render footer button.
    
    // render portlet design tab
    $('#portlets_modal').find('#portlets_modal_body').load('zoozoo-builder.php?action=load-plugin-file&project-theme='+$('#project-theme').val()+'&plugin=video&file=video-portlet.html',function(){
    	Bootstrap_Builder.tab_modal_resize();
    	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
    	if (portlet.video_link != undefined){
    		$('#portlets_modal #video-link').val(portlet.video_link);
    	}
    	if (portlet.video_aspect_ration != undefined){
    		$('#portlets_modal #video-aspect-ration').val(portlet.video_aspect_ration);
    	}
        
        if (portlet.style != undefined){
	    	$.each( portlet.style, function( name, value ) {
	    		if ($.trim(value) != ''){
		    		if (name != 'border-color' && name != 'background-color' && name != 'color'){
		    			$('#portlets_modal #'+ name).val(value);
		    		}else{
		    			$('#portlets_modal .'+ name+'-picker').colorpicker('setValue', value);
		    		}
	    		}
	    		
	    	});
        }
        if (portlet.attr != undefined){
	    	$.each( portlet.attr, function( name, value ) {
	    		if ($.trim(value) != ''){
	    			$('#portlets_modal #'+ name).val(value);
	    		}
	    		
	    	});
        }
        Bootstrap_Builder.modal_resize();
    });
    // end render row setting form
};

var Video_Portlet = new Video_Portlet_Class();

