/*
 * portlet: text-heading
 * portlet-type: text-heading
 * portlet-group: common
 * portlet-name: <i class="fa fa-header"></i> Text Heading
 * portlet-image: assets/images/no-image.png
 */
Text_Heading_Portlet_Class = function(){
	this.file_list = {};
	this.toolbar_name = 'Text Heading';
}
$.extend(Text_Heading_Portlet_Class.prototype, Abstract_Portlet_Class.prototype);
Text_Heading_Portlet_Class.prototype.advance_render = function(portlet_id,content){
	var _this = this;
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
	var tag = (portlet.heading_tag != undefined && $.trim(portlet.heading_tag) != '')?portlet.heading_tag:'div';
	var div = $('<'+tag+'></'+tag+'>');
	var css = {};
	if (portlet.style != undefined && $.isEmptyObject(portlet.style) == false){
		$.each( portlet.style, function( name, value ) {
			if ($.trim(value) != ''){
				if (name.indexOf("margin-") != -1 || name.indexOf("padding-") != -1 || name.indexOf("-width") != -1){
					css[name] = value + 'px';
				}else{
					css[name] = value;
				}
			}
		});
		div.css(css);
	}
	
	if (tag == 'a'){
		var heading_link_url = $.trim(portlet.heading_link_page) + '';
    	if (heading_link_url == ''){
    		heading_link_url = portlet.heading_link_text;
    	}else{
    		var object = (_this.file_list[heading_link_url] != undefined)?_this.file_list[heading_link_url]:'';
    		heading_link_url = object.file_name+'.html';
    	}
    	if (heading_link_url != ''){
    		div.attr('href',heading_link_url);
    		if (portlet.heading_link_new_tab_flag != undefined && portlet.heading_link_new_tab_flag == 'yes'){
    			div.attr('target',"_blank");
    		}
    	}
	}else{
		var a_tag = $('<a></a>');
		if (portlet.style.color != undefined && portlet.style.color != ''){
			a_tag.css({color:portlet.style.color});
		}
		var heading_link_url = $.trim(portlet.heading_link_page) + '';
    	if (heading_link_url == ''){
    		heading_link_url = portlet.heading_link_text;
    	}else{
    		var object = (_this.file_list[heading_link_url] != undefined)?_this.file_list[heading_link_url]:'';
    		heading_link_url = object.file_name+'.html';
    	}
    	if (heading_link_url != ''){
    		a_tag.attr('href',heading_link_url);
    		if (portlet.heading_link_new_tab_flag != undefined && portlet.heading_link_new_tab_flag == 'yes'){
    			a_tag.attr('target',"_blank");
    		}
    	}
	}

	if (portlet.attr != undefined && $.isEmptyObject(portlet.attr) == false){
		$.each( portlet.attr, function( name, value ) {
			if ($.trim(value) != ''){
				div.attr(name,value);
			}
		});
	}
	
	if (tag == 'a'){
		div.append(content);
		return div;
	}else{
		if (portlet.heading_link_flag != undefined && portlet.heading_link_flag == 'yes'){
			a_tag.append(content)
			return div.append(a_tag);
		}else{
			return div.append(content);
		}
	}
};
Text_Heading_Portlet_Class.prototype.portlet_save = function (portlet_id,modal_hide,toolbar){
	toolbar = (toolbar != undefined)?true:false;
	var _this = this;
	modal_hide = (modal_hide == undefined)?true:modal_hide;
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
	Bootstrap_Builder.change_flag = true;
	window.onbeforeunload = function(e) {
        var message = 'Data you have entered may not be saved. ';
        e.returnValue  = message;
        return message;
    }
    var sortable_id = $('#portlets_modal').data('sortable-id');
    if (toolbar == false){
	    var fields = $("#portlets_modal .portlet-style" ).serializeArray();
	    var style = {};
	    $.each( fields, function( i, field ) {
	    	style[field.name] = field.value;
	    });
	    portlet.style = style;
	    
	    fields = $("#portlets_modal .portlet-attr" ).serializeArray();
	    var attr = {};
	    $.each( fields, function( i, field ) {
	    	attr[field.name] = field.value;
	    });
	    portlet.attr = attr;
	    portlet.heading_text = $('#portlets_modal #heading-text').val();
	    portlet.heading_tag = $('#portlets_modal #heading-tag').val();
	    
	    portlet.heading_link_flag = $('#portlets_modal input[name="heading-link-flag"]:checked').val();
	    portlet.heading_link_page = $('#portlets_modal #heading-link-page').val();
	    portlet.heading_link_text = $('#portlets_modal #heading-link-text').val();
	    portlet.heading_link_new_tab_flag = $('#portlets_modal input[name="heading-link-new-tab-flag"]:checked').val();
    }
    
    _this.portlet_render(portlet_id,sortable_id,portlet.heading_text,modal_hide);
}
Text_Heading_Portlet_Class.prototype.portlet_modal = function (portlet_id){
	var _this = this;
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
    
    $('#portlets_modal').find('#portlets_modal_label').html('Text Heading');
    $('#portlets_modal').find('#portlets_modal_body').empty();
    
    // render footer button.
    $('#portlets_modal').find('#portlets_modal_body')
    .after(
       $('<div></div>')
       .attr('id','portlets_modal_footer')
       .addClass('modal-footer')
       .append(
            $('<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>')     
       )
       .append(
            $('<button type="button" class="btn btn-primary">Apply</button>')
            .click(function(){
            	_this.portlet_save(portlet_id,false);
            })
        )
       .append(
            $('<button type="button" class="btn btn-primary">Save & close</button>')
            .click(function(){
            	_this.portlet_save(portlet_id);
            })
       )
    );
    // end render footer button.
    
    // render portlet design tab
    $('#portlets_modal').find('#portlets_modal_body').load('zoozoo-builder.php?action=load-plugin-file&project-theme='+$('#project-theme').val()+'&plugin=text-heading&file=text-heading-portlet.html',function(){
    	Bootstrap_Builder.tab_modal_resize();
    	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
        if (portlet.heading_text !=undefined){
        	$('#portlets_modal #heading-text').val(portlet.heading_text);
        }
    	
        if (portlet.heading_tag != undefined){
        	$('#portlets_modal #heading-tag').val(portlet.heading_tag);
        }
        
        if (portlet.heading_link_flag != undefined && portlet.heading_link_flag != null){
        	var heading_link_flag = $('#portlets_modal input[name="heading-link-flag"][value="'+portlet.heading_link_flag+'"]');
        	heading_link_flag.attr('checked','checked');
    		if (heading_link_flag.val() == 'yes'){
        		$('#heading-url-link-container').show();
        	}else{
        		$('#heading-url-link-container').hide();
        	}
        }
        
        if (portlet.heading_link_text != undefined && portlet.heading_link_text != null){
        	$('#portlets_modal #heading-link-text').val(portlet.heading_link_text);
        }
        
        if (portlet.heading_link_new_tab_flag != undefined && portlet.heading_link_new_tab_flag != null){
        	$('#portlets_modal input[name="heading-link-new-tab-flag"][value="'+portlet.heading_link_new_tab_flag+'"]').attr('checked','checked');
        }
        
        
        var project_id = $('#project-id').val();
        $.get('zoozoo-builder.php',{action:'file-list','project-id':project_id},function(json){
        	_this.file_list = json;
        	if (json != undefined && json != null){
	        	$.each(json,function(k,v){
	        		$('#portlets_modal #heading-link-page').append(
						$('<option></option>')
						.attr('value',v.id)
						.append(v.file_name + '.html')
					);
	    		});
        	}
        	if (portlet.heading_link_page != undefined && portlet.heading_link_page != null){
            	$('#portlets_modal #heading-link-page').val(portlet.heading_link_page);
            }
        },'json');
        
        if (portlet.style != undefined){
	    	$.each( portlet.style, function( name, value ) {
	    		if ($.trim(value) != ''){
		    		if (name != 'border-color' && name != 'background-color' && name != 'color'){
		    			$('#portlets_modal #'+ name).val(value);
		    		}else{
		    			$('#portlets_modal .'+ name+'-picker').colorpicker('setValue', value);
		    		}
	    		}
	    		
	    	});
        }
        if (portlet.attr != undefined){
	    	$.each( portlet.attr, function( name, value ) {
	    		if ($.trim(value) != ''){
	    			$('#portlets_modal #'+ name).val(value);
	    		}
	    		
	    	});
        }
        Bootstrap_Builder.modal_resize();
    });
    // end render row setting form
};

var Text_Heading_Portlet = new Text_Heading_Portlet_Class();

