/*
 * portlet: tab
 * portlet-type: tab 
 * portlet-group: common
 * portlet-name: Tab
 * portlet-image: assets/images/no-image.png
 */
Tab_Portlet_Class = function(){
	this.toolbar_name = 'Tab';
	this.tab_id = '';
}
$.extend(Tab_Portlet_Class.prototype, Abstract_Portlet_Class.prototype);
Tab_Portlet_Class.prototype.advance_render = function(portlet_id,content){
	var _this = this;
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
	var div = $('<div></div>');
	var css = {};
	if (portlet.style != undefined && $.isEmptyObject(portlet.style) == false){
		$.each( portlet.style, function( name, value ) {
			if ($.trim(value) != ''){
				if (name.indexOf("margin-") != -1 || name.indexOf("padding-") != -1 || name.indexOf("-width") != -1){
					css[name] = value + 'px';
				}else{
					css[name] = value;
				}
			}
		});
		div.css(css);
	}
	
	if (portlet.attr != undefined && $.isEmptyObject(portlet.attr) == false){
		$.each( portlet.attr, function( name, value ) {
			if ($.trim(value) != ''){
				div.attr(name,value);
			}
		});
	}
	if (content != undefined && $.isPlainObject(content)){
		var nav_tabs = $('<ul class="nav nav-tabs"></ul>').attr('role','tablist').attr('id',portlet_id+'-tab').css({position:'relative'});
		var tab_content = $('<div></div>').addClass('tab-content');
		var counter = 0;
		$.each(content,function (k,v){
			active = (k == _this.tab_id || (counter == 0 && _this.tab_id == ''))?'active':'';
			nav_tabs.append(
				$('<li></li>').addClass(active).attr('role','presentation')
				.append(
					$('<input type="hidden" id="tab-id" name="tab-id">').val(k)
				)
				.append(
					$('<a aria-expanded ="true" aria-controls="'+k+'" id="'+k+'-tab" data-toggle="tab" role="tab" href="#'+k+'"></a>')
					.append(v.title)
				)
			);
			content[k].sortable_id = (v.sortable_id != undefined && v.sortable_id != null)?v.sortable_id:Bootstrap_Builder.guid();
			if ($('#' + content[k].sortable_id).length <= 0){
				tab_content.append(
					$('<div id="'+k+'" class="tab-pane fade in '+active+'" aria-labelledby="'+k+'-tab" role="tabpanel"></div>')
					.css({padding:'10px'})
					.append(
	                   $('<div class="sortable"></div>')
	                   .attr('id',content[k].sortable_id)
	                   .data('sortable-id',content[k].sortable_id)
	                )
				);
			}else{
				tab_content.append(
					$('<div id="'+k+'" class="tab-pane fade in '+active+'" aria-labelledby="'+k+'-tab" role="tabpanel"></div>')
					.css({padding:'10px'})
					.append(
						$('#' + content[k].sortable_id)
	                )
				);
			}
			counter++;
		});
		nav_tabs.children('li').children('a').on('shown.bs.tab', function (e) {
			var ul_offset = $('#'+portlet_id+'-tab').offset();
	    	var li_offset = $('#'+portlet_id+'-tab').children('li.active').offset();
	        $('#'+portlet_id).children('.portlet-toolbar').css({
	            left : li_offset.left - ul_offset.left,
	            top : -3
	        });
		});
		portlet.content = content;
	}
	
	_this.tab_id = '';
	
	div.append(nav_tabs).append(tab_content);
	return div;
};


Tab_Portlet_Class.prototype.after_render = function(portlet_id){
	if (Bootstrap_Builder.load_sortable == true){
		Bootstrap_Builder.sortable();
	}
}

Tab_Portlet_Class.prototype.portlet_copy = function(portlet_id){
	var portlet = (Bootstrap_Builder.portlet_copys[portlet_id] != undefined)?Bootstrap_Builder.portlet_copys[portlet_id]:{};
	portlet.sortable_id = (portlet.sortable_id != undefined)?portlet.sortable_id:'empty';
	if ($.isEmptyObject(portlet) == false && Bootstrap_Builder.sortable_ids[portlet.sortable_id] != undefined){
		portlet.sortable_id = Bootstrap_Builder.sortable_ids[portlet.sortable_id];
	}
	if (portlet.content != undefined && $.isEmptyObject(portlet.content) == false){
		$.each(portlet.content,function (k,v){
			var new_tab = v;
			Bootstrap_Builder.sortable_ids[v.sortable_id] = Bootstrap_Builder.guid();
			new_tab.id = Bootstrap_Builder.guid();
			new_tab.sortable_id = Bootstrap_Builder.sortable_ids[v.sortable_id];
			delete portlet.content[k];
			portlet.content[new_tab.id] = new_tab;
		});
	}
	portlet.portlet_id = Bootstrap_Builder.guid();
	
	return portlet;
}

Tab_Portlet_Class.prototype.portlet_toolbar = function(portlet_id,portlet){
	portlet.css({paddingTop:'20px'});
	var _this = this;
    // render toolbar
    var portlet_toolbar = $('<div class="portlet-toolbar btn-group" style="z-index:3001;"></div>');
    portlet_toolbar.append($('<a class="btn btn-default btn-xs portlet-toolbar-move"></a>').append('<i class="fa fa-arrows"></i> Tab'));
    portlet_toolbar.append(
        $('<a class="btn btn-primary btn-xs"></a>')
        .append('<i class="fa fa-files-o"></i>')
        .data('portlet-id',portlet_id)
        .click(function(){
        	$('#portlets_modal').data('copy_portlet_id',portlet_id);
    		var _portlets = Bootstrap_Builder.get_portlets($('#'+portlet_id));
    		_portlets = Bootstrap_Builder.portlet_copy(_portlets);
    		$.post('zoozoo-builder.php?action=portlet-copies&project-theme='+$('#project-theme').val(),{portlets:JSON.stringify(_portlets)},function(html){
    			Bootstrap_Builder.display_portlets(_portlets);
    		});
        })
    );
    portlet_toolbar.append(
              $('<a class="btn btn-primary btn-xs"></a>')
              .append('<i class="fa fa-pencil"></i>')
              .data('portlet-id',portlet_id)
              .click(function(){
                  var portlet_id = $(this).data('portlet-id');
                  var sortable_id = $('#' + portlet_id).data('sortable-id');
                  
                  Bootstrap_Builder.show_portlets(sortable_id,true,null,600);
                  var tab_id = $('#'+portlet_id+'-tab').children('li.active').children('#tab-id').val();
                  _this.portlet_modal(portlet_id,tab_id);
                  
                  $('.portlet-toolbar').hide();
              })
    );
    portlet_toolbar.append(
            $('<a class="btn btn-primary btn-xs"></a>')
            .append('<i class="fa fa-plus"></i>')
            .data('portlet-id',portlet_id)
            .click(function(){
                var portlet_id = $(this).data('portlet-id');
                var sortable_id = $('#' + portlet_id).data('sortable-id');
                Bootstrap_Builder.show_portlets(sortable_id,true,null,600);
                var tab_id = Bootstrap_Builder.guid();
                _this.portlet_modal(portlet_id,tab_id);
                $('.portlet-toolbar').hide();
            })
  );
    portlet_toolbar.append(
            $('<a class="btn btn-danger btn-xs"></a>')
            .append('<i class="fa fa-trash-o"></i>')
            .data('portlet-id',portlet_id)
            .click(function(){
            	$('.portlet-toolbar').hide();
                $('#delete-modal .modal-footer > #delete-portlet').remove();
                var delete_portlet = $('<button type="button" class="btn btn-danger" id="delete-portlet">Delete</button>');
                var portlet_id = $(this).data('portlet-id');
                delete_portlet.click(function(){
            		Bootstrap_Builder.change_flag = true;
            		window.onbeforeunload = function(e) {
                        var message = 'Data you have entered may not be saved. ';
                        e.returnValue  = message;
                        return message;
                    }
            		var tab_id = $('#'+portlet_id+'-tab').children('li.active').children('#tab-id').val();
            		var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
            		var content = portlet.content;
            		delete content[tab_id];
            		if ($.isEmptyObject(content)){
//            			$('#' + portlet_id).remove();
            			$('#delete-modal').data('portlet-id',portlet_id);
    	                delete Bootstrap_Builder.portlets[portlet_id];
            		}else{
            			var tab_active = $('#' + portlet_id+'-tab').children('li.active');
            			if (tab_active.prev().length > 0){
            				var new_tab_active = tab_active.prev().children('a');
            			}else{
            				var new_tab_active = tab_active.next().children('a');
            			}
            			
            			$('#'+tab_id).children('.sortable').children('.portlet').each(function(){
            				var portlet_id = $(this).attr('id');
            				var sortable_id = $('#'+new_tab_active.parent().children('#tab-id').val()).children('.sortable').attr('id');
            				if (Bootstrap_Builder.portlets[portlet_id] != undefined){
    	            			var portlet = Bootstrap_Builder.portlets[portlet_id];
    	            			portlet.sortable_id = sortable_id;
    	        			}
            				$('#'+new_tab_active.parent().children('#tab-id').val()).children('.sortable').append($(this));
            			});
            			tab_active.remove();
            			$('#'+tab_id).remove();
            			
            			new_tab_active.tab('show');
            		}
            		$('#delete-modal').modal('hide');
                });
                $('#delete-modal .modal-footer').append(delete_portlet);
            	$('#delete-modal').modal('show');
            })
    );
    portlet.append(portlet_toolbar);
    // end render toolbar
    
    portlet.hover(function() {
    	if (Bootstrap_Builder.is_sortable == false){
	    	var ul_offset = $('#'+portlet_id+'-tab').offset();
	    	var li_offset = $('#'+portlet_id+'-tab').children('li.active').offset();
	        $(this).children('.portlet-toolbar').css({
	            left : li_offset.left - ul_offset.left,
	            top : -3
	        });
	        $(this).find('.tab-pane').children('.sortable').css({borderColor:'#95a5a6'});
	        $(this).children('.portlet-toolbar').show();
    	}
    }, function() {
    	if (Bootstrap_Builder.is_sortable == false){
    		$(this).find('.tab-pane').children('.sortable').css({borderColor:'transparent'});
    		$(this).children('.portlet-toolbar').hide();
    	}
    });
};

Tab_Portlet_Class.prototype.portlet_save_2 = function (portlet_id,modal_hide,toolbar){
	toolbar = (toolbar != undefined)?true:false;
	var _this = this;
	modal_hide = (modal_hide == undefined)?true:modal_hide;
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
	Bootstrap_Builder.change_flag = true;
	window.onbeforeunload = function(e) {
        var message = 'Data you have entered may not be saved. ';
        e.returnValue  = message;
        return message;
    }
    var sortable_id = $('#portlets_modal').data('sortable-id');
    var fields = $("#portlets_modal .portlet-style" ).serializeArray();
    var style = {};
    $.each( fields, function( i, field ) {
    	style[field.name] = field.value;
    });
    portlet.style = style;
    
    fields = $("#portlets_modal .portlet-attr" ).serializeArray();
    var attr = {};
    $.each( fields, function( i, field ) {
    	attr[field.name] = field.value;
    });
    portlet.attr = attr;
    
    var content = (portlet.content != undefined && $.isPlainObject(portlet.content))?portlet.content:{};
    var tab_id = $('#portlets_modal #tab-id').val();
    var tab_title = $('#portlets_modal #tab-title').val();
    content[tab_id] = (content[tab_id] != undefined  && $.isPlainObject(portlet.content))?content[tab_id]:{};
    
    content[tab_id].id = tab_id;
    content[tab_id].title = tab_title;
    
    _this.tab_id = tab_id;
    _this.portlet_render(portlet_id,sortable_id,content,modal_hide);
};

Tab_Portlet_Class.prototype.portlet_modal = function (portlet_id,tab_id){
	var _this = this;
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
	tab_id = (tab_id != undefined)?tab_id:Bootstrap_Builder.guid();
    $('#portlets_modal').find('#portlets_modal_label').html('Tab');
    $('#portlets_modal').find('#portlets_modal_body').empty();
    
    // render footer button.
    $('#portlets_modal').find('#portlets_modal_body')
    .after(
       $('<div></div>')
       .attr('id','portlets_modal_footer')
       .addClass('modal-footer')
       .append(
            $('<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>')     
       )
       .append(
            $('<button type="button" class="btn btn-primary">Apply</button>')
            .click(function(){
            	_this.portlet_save_2(portlet_id,false);
            })
       )
       .append(
            $('<button type="button" class="btn btn-primary">Save & close</button>')
            .click(function(){
            	_this.portlet_save_2(portlet_id);
            })
       )
    );
    // end render footer button.
    
    // render portlet design tab
    $('#portlets_modal').find('#portlets_modal_body').load('zoozoo-builder.php?action=load-plugin-file&project-theme='+$('#project-theme').val()+'&plugin=tab&file=tab-portlet.html',function(){
    	Bootstrap_Builder.tab_modal_resize();
    	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
    	var content = (portlet.content != undefined && $.isPlainObject(portlet.content))?portlet.content:{};
    	$('#portlets_modal #tab-id').val(tab_id);
    	if (content[tab_id] != undefined && $.isPlainObject(content[tab_id])){
    		$('#portlets_modal #tab-title').val(content[tab_id].title);
    	}
    	
        if (portlet.style != undefined){
	    	$.each( portlet.style, function( name, value ) {
	    		if ($.trim(value) != ''){
		    		if (name != 'border-color' && name != 'background-color' && name != 'color'){
		    			$('#portlets_modal #'+ name).val(value);
		    		}else{
		    			$('#portlets_modal .'+ name+'-picker').colorpicker('setValue', value);
		    		}
	    		}
	    		
	    	});
        }
        if (portlet.attr != undefined){
	    	$.each( portlet.attr, function( name, value ) {
	    		if ($.trim(value) != ''){
	    			$('#portlets_modal #'+ name).val(value);
	    		}
	    		
	    	});
        }
        Bootstrap_Builder.modal_resize();
    });
    // end render row setting form
};

var Tab_Portlet = new Tab_Portlet_Class();

