/*
 * portlet: row
 * portlet-type: row 
 * portlet-group: common
 * portlet-name: <i class="fa fa-columns"></i> Row
 * portlet-image: assets/images/no-image.png
 * portlet-asset-js: plugins/row/assets/parallax.js-1.4.2/parallax.min.js
 */
var Row_Portlet = {
	portlet_render: function(portlet_id, sortable_id,content,modal_hide){
		if (content == undefined || content == null){
			var portlet_tmp = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
			content = portlet_tmp.content;
		}
	    var copy_portlet_id = $('#portlets_modal').data('copy_portlet_id');
	    
	    if (copy_portlet_id != undefined && copy_portlet_id != null){
	        var portlet = $('<div class="portlet"></div>').attr('id',portlet_id);
	        var portlet_content = $('<div class="portlet-content"></div>');
	        
	        portlet.data('sortable-id',sortable_id);
	        
	        portlet.append(portlet_content);
	        $('#' + copy_portlet_id).after(portlet);
	        $('#portlets_modal').data('copy_portlet_id', null);
	
	    }else if ($('#'+ portlet_id).length <= 0){
	        var portlet = $('<div class="portlet"></div>').attr('id',portlet_id);
	        var portlet_content = $('<div class="portlet-content"></div>');
	        portlet.data('sortable-id',sortable_id);
	        portlet.append(portlet_content);
	        
	        var insert_method = $('#portlets_modal').data('insert-method');
	        var o_portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
	        if (o_portlet.insert_method != undefined && o_portlet.insert_method != ''){
	        	insert_method  = o_portlet.insert_method;
	        }
	        
	        if (insert_method == 'append'){
	        	$('#' + sortable_id).append(portlet);
	        }else if (insert_method == 'prepend'){
	        	$('#' + sortable_id).prepend(portlet);
	        }else if (insert_method == 'replace_with'){
	        	$('#'+o_portlet.replace_with_id).replaceWith(portlet);
	        	delete o_portlet.replace_with_id;
	        }else if (insert_method == 'after'){
	        	$('#'+o_portlet.after_id).after(portlet);
	        	delete o_portlet.after_id;
	        }
	        
	        if (o_portlet.insert_method != undefined && o_portlet.insert_method != ''){
	        	delete o_portlet.insert_method;
	        }
	    }else{
	        var portlet = $('#'+ portlet_id);
	    }
	    
	    $('.portlet-'+portlet_id).children('.portlet-toolbar').remove();
	    
	    // render html code to preview
	    var portlet_object = Bootstrap_Builder.portlets[portlet_id];
	    portlet_object.content = content;
	    
	    var portlet_content = $('<div></div>').addClass('row').addClass('portlet-'+portlet_id).css({position:'relative'});
	    
	    var columns = content.row_column.split("+");
	    
	    var n_old = portlet.find('.portlet-'+portlet_id+' > div').length;
	    var n_new = columns.length;
	
	    var current_portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
	    current_portlet.content.children_sortable_id = (current_portlet.content.children_sortable_id != undefined)?current_portlet.content.children_sortable_id:[];
	    var children_sortable_id = [];
	    if (n_old > 0){
	    	if (n_old <= n_new){
	    		var i = 0;
	    		for(i=0; i< n_old; i++){
	        		var sortable_id = $(portlet.find('.portlet-'+portlet_id+' > div')[i]).children('.sortable').attr('id');
	        		if (sortable_id != null){
	        			  current_portlet.content.children_sortable_id[current_portlet.content.children_sortable_id.length] = sortable_id;
	        			  children_sortable_id[children_sortable_id.length] = sortable_id;
	        		}
	    			portlet_content
	                .append($(portlet.find('.portlet-'+portlet_id+' > div')[i]).attr('class','').addClass('col-sm-'+columns[i]));
	    			portlet.find('.portlet-'+portlet_id).prepend('<div></div>');
	    		}
	    		for(var j = i; j < n_new; j++){
	    			var sortable_id = Bootstrap_Builder.guid();
	    			current_portlet.content.children_sortable_id[current_portlet.content.children_sortable_id.length] = sortable_id;
	    			children_sortable_id[children_sortable_id.length] = sortable_id;
	                portlet_content
	                .append(
	                   $('<div></div>').addClass('col-sm-'+columns[j])
	                   .append(
	                       $('<div class="sortable"></div>')
	                       .attr('id',sortable_id)
	                       .data('sortable-id',sortable_id)
	                   )
	                );
	    		}
	    		
	    	}else{
	    		var last_portlet;
	    		for(i=0; i< n_new; i++){
	    			var sortable_id = $(portlet.find('.portlet-'+portlet_id+' > div')[i]).children('.sortable').attr('id');
	        		if (sortable_id != null){
	        			  current_portlet.content.children_sortable_id[current_portlet.content.children_sortable_id.length] = sortable_id;
	        			  children_sortable_id[children_sortable_id.length] = sortable_id;
	        		}
	    			last_portlet = $(portlet.find('.portlet-'+portlet_id+' > div')[i]).attr('class','').addClass('col-sm-'+columns[i]); 
	                portlet_content
	                .append(last_portlet);
	                portlet.find('.portlet-'+portlet_id).prepend('<div></div>');
	            }
	    		for(j=i; j< n_old; j++){
	    			portlet.find('.portlet-'+portlet_id+' > div .sortable > .portlet').each(function(){
	        			var portlet_id = $(this).attr('id');
	        			var sortable_id = last_portlet.children('.sortable').attr('id'); 
	        			if (Bootstrap_Builder.portlets[portlet_id] != undefined){
	            			var portlet = Bootstrap_Builder.portlets[portlet_id];
	            			portlet.sortable_id = sortable_id;
	        			}
	    				last_portlet.children('.sortable').append($(this));
	    			});
	    		}
	    		
	    	}
	    }else{
	    	for(var i=0; i< columns.length; i++){
	            var sortable_id =  (content.children_sortable_id != undefined && content.children_sortable_id[i])?content.children_sortable_id[i]:Bootstrap_Builder.guid();
	            current_portlet.content.children_sortable_id[current_portlet.content.children_sortable_id.length] = sortable_id;
	            children_sortable_id[children_sortable_id.length] = sortable_id;
	            portlet_content
	            .append(
	               $('<div></div>').addClass('col-sm-'+columns[i])
	               .append(
	                   $('<div class="sortable"></div>')
	                   .attr('id',sortable_id)
	                   .data('sortable-id',sortable_id)
	               )
	            );
	        }
	    }
	
	    current_portlet.content.children_sortable_id = children_sortable_id;
	    
	    if (content.row_container != undefined && content.row_container != null && content.row_container != '' && content.row_container != 'none'){
	    	portlet_content = $('<div></div>').addClass(content.row_container).append(portlet_content);
	    }
	    modal_hide = (modal_hide == undefined)?true:modal_hide;
	    if (modal_hide === true){
	    	$('#portlets_modal').modal('hide');
	    }
	    
	    portlet_content = Row_Portlet.advance_render(portlet_id,portlet_content);
	    
	    portlet.children('.portlet-content').empty();
	    portlet.children('.portlet-content').append(portlet_content);
	    
	    
	    // end render html code to preview
	    $('.portlet-'+portlet_id).css({marginTop:'20px'});
    	Row_Portlet.portlet_toolbar(portlet_id,portlet);
    	if (Bootstrap_Builder.load_sortable == true){
			Bootstrap_Builder.sortable();
		}
	},
	
	portlet_copy : function(portlet_id){
		var portlet = (Bootstrap_Builder.portlet_copys[portlet_id] != undefined)?Bootstrap_Builder.portlet_copys[portlet_id]:{};
		portlet.sortable_id = (portlet.sortable_id != undefined)?portlet.sortable_id:'empty';
		if ($.isEmptyObject(portlet) == false && Bootstrap_Builder.sortable_ids[portlet.sortable_id] != undefined){
			portlet.sortable_id = Bootstrap_Builder.sortable_ids[portlet.sortable_id];
		}
		if (portlet.content != undefined && portlet.content.children_sortable_id != undefined && $.isEmptyObject(portlet.content.children_sortable_id) == false){
			var new_children_sortable_id = [];
			$.each(portlet.content.children_sortable_id,function (k,v){
				Bootstrap_Builder.sortable_ids[v] = Bootstrap_Builder.guid();
				new_children_sortable_id[new_children_sortable_id.length] = Bootstrap_Builder.sortable_ids[v]; 
			});
			portlet.content.children_sortable_id = new_children_sortable_id;
		}
		portlet.portlet_id = Bootstrap_Builder.guid();
		
		return portlet;
	},
	
	portlet_toolbar: function(portlet_id,portlet){
		//portlet.css({paddingTop:'18px',paddingBottom:'10px'});
		
	    // render toolbar
	    var portlet_toolbar = $('<div class="portlet-toolbar btn-group" style="z-index:3001;"></div>');
	    portlet_toolbar.append($('<a class="btn btn-default btn-xs portlet-toolbar-move"></a>').append('<i class="fa fa-arrows"></i> Row'));
	    portlet_toolbar.append(
	            $('<a class="btn btn-primary btn-xs"></a>')
	            .append('<i class="fa fa-files-o"></i>')
	            .data('portlet-id',portlet_id)
	            .click(function(){
	            	$('#portlets_modal').data('copy_portlet_id',portlet_id);
	        		var _portlets = Bootstrap_Builder.get_portlets($('#'+portlet_id));
	        		_portlets = Bootstrap_Builder.portlet_copy(_portlets);
	        		$.post('zoozoo-builder.php?action=portlet-copies&project-theme='+$('#project-theme').val(),{portlets:JSON.stringify(_portlets)},function(html){
	        			Bootstrap_Builder.display_portlets(_portlets);
	        		});
	            })
	        );
	    portlet_toolbar.append(
	              $('<a class="btn btn-primary btn-xs"></a>')
	              .append('<i class="fa fa-pencil"></i>')
	              .data('portlet-id',portlet_id)
	              .click(function(){
	                  var portlet_id = $(this).data('portlet-id');
	                  var sortable_id = $('#' + portlet_id).data('sortable-id');
	                  
	                  // for get template block
//	                  	var _portlets = Bootstrap_Builder.get_portlets($('#'+portlet_id));
//	              		console.log(JSON.stringify(_portlets));
	                  // for get template block
	                  
	                  Bootstrap_Builder.show_portlets(sortable_id,true,null,600);
	                  Row_Portlet.portlet_modal(portlet_id);
	                  
	                  $('.portlet-toolbar').hide();
	              })
	    );
	    portlet_toolbar.append(
	            $('<a class="btn btn-danger btn-xs"></a>')
	            .append('<i class="fa fa-trash-o"></i>')
	            .data('portlet-id',portlet_id)
	            .click(function(){
	            	$('.portlet-toolbar').hide();
                    $('.portlet-mask').css({visibility:'hidden'});
	                $('.portlet-mask').width(6);
	                $('#delete-modal .modal-footer > #delete-portlet').remove();
	                
	                var delete_portlet = $('<button type="button" class="btn btn-danger" id="delete-portlet">Delete</button>');
	                var portlet_id = $(this).data('portlet-id');
	                
	                delete_portlet.click(function(){
	                	Bootstrap_Builder.change_flag = true;
	                	window.onbeforeunload = function(e) {
                            var message = 'Data you have entered may not be saved. ';
                            e.returnValue  = message;
                            return message;
                        }
	                	//$('#' + portlet_id).remove();
		                delete Bootstrap_Builder.portlets[portlet_id];
		                $('#delete-modal').data('portlet-id',portlet_id);
		                $('#delete-modal').modal('hide');
	                });
	                $('#delete-modal .modal-footer').append(delete_portlet);
	            	$('#delete-modal').modal('show');
	            })
	    );
	    $('.portlet-'+portlet_id).append(portlet_toolbar);
	    // end render toolbar
	    
	
	    portlet.hover(function() {
	    	if (Bootstrap_Builder.is_sortable == false){
		    	$('.portlet-'+portlet_id).children('.portlet-toolbar').each(function(){
		        	$(this).css({
		                left : '15px',
		                top : '-20px'
		            });
		        });
		    	$('.portlet-'+portlet_id).children('div').children('.sortable').css({borderColor:'#95a5a6'});
		        $('.portlet-'+portlet_id).children('.portlet-toolbar').show();
	    	}
	    }, function() {
	    	if (Bootstrap_Builder.is_sortable == false){
	    		$('.portlet-'+portlet_id).children('div').children('.sortable').css({borderColor:'transparent'});
	    		$('.portlet-'+portlet_id).children('.portlet-toolbar').hide();
	    	}
	    });
	    
	},
	
	portlet_save: function (portlet_id,modal_hide,toolbar){
		toolbar = (toolbar != undefined)?true:false;
		modal_hide = (modal_hide == undefined)?true:modal_hide;
		var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
    	portlet.background_image_link = $('#portlets_modal #background-image-link').val();
    	portlet.background_parallax = $('#portlets_modal input[name="background-parallax"]:checked').val();
    	
    	Bootstrap_Builder.change_flag = true;
    	window.onbeforeunload = function(e) {
            var message = 'Data you have entered may not be saved. ';
            e.returnValue  = message;
            return message;
        }
        var sortable_id = $('#portlets_modal').data('sortable-id');
        var content = {};
        if (toolbar == false){
	        content.row_column = $('#portlets_modal #row-column').val();
	        content.row_container = $('#portlets_modal input[name="row-container"]:checked').val();
	        
	        var fields = $("#portlets_modal .portlet-style" ).serializeArray();
	        var style = {};
	        $.each( fields, function( i, field ) {
	        	style[field.name] = field.value;
	        });
	        portlet.style = style;
        }else{
        	content = portlet.content;
        }
        
        Row_Portlet.portlet_render(portlet_id,sortable_id,content,modal_hide);
	},
	
	portlet_modal: function (portlet_id){
	    var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
	    
	    $('#portlets_modal').find('#portlets_modal_label').html('Row');
	    $('#portlets_modal').find('#portlets_modal_body').empty();
	    
	    $('#portlets_modal').find('#portlets_modal_body')
	    .after(
	       $('<div></div>')
	       .attr('id','portlets_modal_footer')
	       .addClass('modal-footer')
	       .append(
	            $('<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>')     
	       )
	       .append(
	            $('<button type="button" class="btn btn-primary">Apply</button>')
	            .click(function(){
	            	Row_Portlet.portlet_save(portlet_id,false);
	            	$('.portlet-'+portlet_id).children('div').children('.sortable').css({borderColor:'#95a5a6'});
	            })
	       )
	       .append(
	            $('<button type="button" class="btn btn-primary">Save & close</button>')
	            .click(function(){
	            	Row_Portlet.portlet_save(portlet_id);
	            })
	       )
	    );
	    
	    // render row setting form
	    
	    $('#portlets_modal').find('#portlets_modal_body').load('zoozoo-builder.php?action=load-plugin-file&project-theme='+$('#project-theme').val()+'&plugin=row&file=row-portlet.html',function(){
	    	Bootstrap_Builder.tab_modal_resize();
	    	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
	    	
	    	if (portlet.background_image_link != undefined && portlet.background_image_link != ''){
	    		$('#portlets_modal #background-image-file-frame > #background-image-upload-text').hide();
	    		$('#portlets_modal #background-image-file-frame-preview').attr('src',portlet.background_image_link).show();
	    		$('#portlets_modal #background-image-link').val(portlet.background_image_link);
	    		$('#portlets_modal #btn-background-image-delete').show();
	    	}
	    	
	    	if (portlet.background_parallax != undefined && portlet.background_parallax != ''){
	        	$('#portlets_modal input[name="background-parallax"][value="' + portlet.background_parallax + '"]').attr('checked', 'checked');
	        }
	    	
	    	
	    	$('#portlets_modal #background-image-file').fileupload({
		        url: 'zoozoo-builder.php?action=upload-image&field-name=background-image-file',
		        dataType: 'json',
		        done: function (e, data) {
		        	var file = data.result;
		        	if (file.background_image_file != undefined){
		        		$('#portlets_modal #background-image-file-frame > #background-image-upload-text').hide();
		        		$('#portlets_modal #background-image-file-frame-preview').attr('src',file.background_image_file).show();
		        		$('#portlets_modal #background-image-link').val(file.background_image_file);
		        	}
		        	$('#portlets_modal #background-image-upload-progress-bar').css('width','0px');
		        	$('#portlets_modal #btn-background-image-delete').show();
		        },
		        progressall: function (e, data) {
		            var progress = parseInt(data.loaded / data.total * 100, 10);
		            $('#portlets_modal #image-upload-progress-bar').css('width',progress + '%');
		        }
		    });
	    	
	    	if (portlet.content != undefined && portlet.content != null && $.isEmptyObject(portlet.content) == false){
		        if (portlet.content.row_column != undefined && portlet.content.row_column != null){
		        	$('#portlets_modal #row-column').val(portlet.content.row_column);
		        }
		        
		        if (portlet.content.row_container != undefined && portlet.content.row_container != null){
		        	$('#portlets_modal input[name="row-container"][value="' + portlet.content.row_container + '"]').attr('checked', 'checked');
		        }
		    }
	    	if (portlet.style != undefined){
		    	$.each( portlet.style, function( name, value ) {
		    		if ($.trim(value) != ''){
			    		if (name != 'border-color' && name != 'background-color' && name != 'color'){
			    			$('#portlets_modal #'+ name).val(value);
			    		}else{
			    			$('#portlets_modal .'+ name+'-picker').colorpicker('setValue', value);
			    		}
		    		}
		    		
		    	});
	    	}
	    	Bootstrap_Builder.modal_resize();
	    });
	    // end render row setting form
	},
	advance_render:function(portlet_id,content){
		var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
		
		var div = $('<div></div>');
		if (portlet.background_image_link != undefined && portlet.background_image_link != ''){
			div.css({backgroundImage: "url('"+portlet.background_image_link+"')"});
			if (portlet.background_parallax != undefined && portlet.background_parallax != '' && portlet.background_parallax == 'yes'){
				div
				.addClass('parallax-window')
				.data('parallax','scroll')
				.data('image-src',portlet.background_image_link);
			}
		}
		
		var css = {};
		if (portlet.style != undefined && $.isEmptyObject(portlet.style) == false){
			$.each( portlet.style, function( name, value ) {
				if ($.trim(value) != ''){
					if (name.indexOf("margin-") != -1 || name.indexOf("padding-") != -1 || name.indexOf("-width") != -1){
						css[name] = value + 'px';
					}else{
						css[name] = value;
					}
				}
			});
			div.css(css);
		}
		
		if (portlet.attr != undefined && $.isEmptyObject(portlet.attr) == false){
			$.each( portlet.attr, function( name, value ) {
				if ($.trim(value) != ''){
					div.attr(name,value);
				}
			});
		}
		
		div.append(content);
		
		return div;
	}
};