/*
 * portlet: pricing-table
 * portlet-type: pricing-table 
 * portlet-group: advance
 * portlet-name: Pricing Table
 * portlet-image: assets/images/no-image.png
 * portlet-asset-css: plugins/pricing-table/assets/css/pricing-table-portlet.css
 */
Pricing_Table_Portlet_Class = function(){
	this.toolbar_name = 'Pricing Table';
}
$.extend(Pricing_Table_Portlet_Class.prototype, Abstract_Portlet_Class.prototype);
Pricing_Table_Portlet_Class.prototype.advance_render = function(portlet_id,content){
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
	var div = $('<div></div>');
	div.addClass('panel').addClass('bhb-pricing-table');
	var css = {};
	if (portlet.style != undefined && $.isEmptyObject(portlet.style) == false){
		$.each( portlet.style, function( name, value ) {
			if ($.trim(value) != ''){
				if (name.indexOf("margin-") != -1 || name.indexOf("padding-") != -1 || name.indexOf("-width") != -1){
					css[name] = value + 'px';
				}else{
					css[name] = value;
				}
			}
		});
		div.css(css);
	}
	
	if (portlet.attr != undefined && $.isEmptyObject(portlet.attr) == false){
		$.each( portlet.attr, function( name, value ) {
			if ($.trim(value) != ''){
				div.attr(name,value);
			}
		});
	}
	content = (content != undefined && $.isEmptyObject(content) == false)?content:{};
	if (content.type != undefined && content.type != ''){
		div.addClass('panel-' + content.type);
	}
	content.title = (content.title != undefined && content.title != '')?content.title:'';
	div.append(
		$('<div class="panel-heading"></div>')
		.append('<h2 class="panel-title">'+content.title+'</h2>')
	);
	
	content.sortable_id = (content.sortable_id != undefined && content.sortable_id != '')?content.sortable_id:Bootstrap_Builder.guid();
	if ($('#' + content.sortable_id).length <= 0){
		div.append(
			$('<div class="panel-body"></div>').append(
		        $('<div class="sortable"></div>')
		        .attr('id',content.sortable_id)
		        .data('sortable-id',content.sortable_id)
	        )
	     );
	}else{
		div.append(
			$('<div class="panel-body"></div>').append(
				$('#' + content.sortable_id)
			)
		);
		div.find('.new-portlet-btn-'+portlet_id).remove();
	}
	
	var price = $('<div class="price"></div>')
	div.children('.panel-body').prepend(price);
	
	if (content.currency_symbol != undefined && content.currency_symbol != ''){
		price.append('<span class="currency-symbol text-muted">'+content.currency_symbol+'</span>')
	}
	if (content.price != undefined && content.price != ''){
		price.append('<strong>'+content.price+'</strong>')
	}
	if (content.sub_price != undefined && content.sub_price != ''){
		price.append('<sup>'+content.sub_price+'</sup>')
	}
	if (content.price_title != undefined && content.price_title != ''){
		price.append('<em class="text-muted">'+content.price_title+'</em>')
	}
	
	portlet.content = content;
	
	return div;
};

Pricing_Table_Portlet_Class.prototype.after_render = function(portlet_id){
	if (Bootstrap_Builder.load_sortable == true){
		Bootstrap_Builder.sortable();
	}
}

Pricing_Table_Portlet_Class.prototype.portlet_toolbar = function(portlet_id,portlet){
	var _this = this;
	var portlet_toolbar = $('<div class="portlet-toolbar btn-group" style="z-index:3001;"></div>');
    portlet_toolbar.append($('<a class="btn btn-default btn-xs portlet-toolbar-move"></a>').append('<i class="fa fa-arrows"></i> Pricing Table'));
    portlet_toolbar.append(
            $('<a class="btn btn-primary btn-xs"></a>')
            .append('<i class="fa fa-files-o"></i>')
            .data('portlet-id',portlet_id)
            .click(function(){
            	$('#portlets_modal').data('copy_portlet_id',portlet_id);
        		var _portlets = Bootstrap_Builder.get_portlets($('#'+portlet_id));
        		_portlets = Bootstrap_Builder.portlet_copy(_portlets);
//        		console.log(JSON.stringify(_portlets));
        		$.post('zoozoo-builder.php?action=portlet-copies&project-theme='+$('#project-theme').val(),{portlets:JSON.stringify(_portlets)},function(html){
        			Bootstrap_Builder.display_portlets(_portlets);
        		});
            })
        );
    portlet_toolbar.append(
              $('<a class="btn btn-primary btn-xs"></a>')
              .append('<i class="fa fa-pencil"></i>')
              .data('portlet-id',portlet_id)
              .click(function(){
                  var portlet_id = $(this).data('portlet-id');
                  var sortable_id = $('#' + portlet_id).data('sortable-id');
                  Bootstrap_Builder.show_portlets(sortable_id,true,null,600);
                  _this.portlet_modal(portlet_id);
                  $('.portlet-toolbar').hide();
              })
    );
    portlet_toolbar.append(
            $('<a class="btn btn-danger btn-xs"></a>')
            .append('<i class="fa fa-trash-o"></i>')
            .data('portlet-id',portlet_id)
            .click(function(){
            	$('.portlet-toolbar').hide();
                $('.portlet-mask').css({visibility:'hidden'});
                $('.portlet-mask').width(6);
                $('#delete-modal .modal-footer > #delete-portlet').remove();
                
                var delete_portlet = $('<button type="button" class="btn btn-danger" id="delete-portlet">Delete</button>');
                var portlet_id = $(this).data('portlet-id');
                
                delete_portlet.click(function(){
                	Bootstrap_Builder.change_flag = true;
                	window.onbeforeunload = function(e) {
                        var message = 'Data you have entered may not be saved. ';
                        e.returnValue  = message;
                        return message;
                    }
//                	$('#' + portlet_id).remove();
	                delete Bootstrap_Builder.portlets[portlet_id];
	                $('#delete-modal').data('portlet-id',portlet_id);
	                $('#delete-modal').modal('hide');
                });
                $('#delete-modal .modal-footer').append(delete_portlet);
            	$('#delete-modal').modal('show');
            })
    );
    portlet.append(portlet_toolbar);
    // end render toolbar
    

    portlet.hover(function() {
    	var toolbar_left = $(this).width() / 2 - 70;
    	$(this).children('.portlet-toolbar').each(function(){
        	$(this).css({
                left : toolbar_left+'px',
                top : '46px'
            });
        });
    	$(this).find('.panel-body').children('.sortable').css({borderColor:'#95a5a6'});
        portlet.children('.portlet-toolbar').show();
    }, function() {
    	$(this).find('.panel-body').children('.sortable').css({borderColor:'transparent'});
    	portlet.children('.portlet-toolbar').hide();
    });
    
    $('#portlets_modal').modal('hide');
};

Pricing_Table_Portlet_Class.prototype.portlet_copy = function(portlet_id){
	var portlet = (Bootstrap_Builder.portlet_copys[portlet_id] != undefined)?Bootstrap_Builder.portlet_copys[portlet_id]:{};
	portlet.sortable_id = (portlet.sortable_id != undefined)?portlet.sortable_id:'empty';
	if ($.isEmptyObject(portlet) == false && Bootstrap_Builder.sortable_ids[portlet.sortable_id] != undefined){
		portlet.sortable_id = Bootstrap_Builder.sortable_ids[portlet.sortable_id];
	}
	if (portlet.content != undefined && portlet.content.sortable_id != undefined){
		Bootstrap_Builder.sortable_ids[portlet.content.sortable_id] = Bootstrap_Builder.guid();
//		console.log(Bootstrap_Builder.sortable_ids[portlet.content.sortable_id]);
		portlet.content.sortable_id = Bootstrap_Builder.sortable_ids[portlet.content.sortable_id];
	}
	portlet.portlet_id = Bootstrap_Builder.guid();
	
	//console.log(portlet);
	
	return portlet;
}
Pricing_Table_Portlet_Class.prototype.portlet_save = function (portlet_id,modal_hide,toolbar){
	toolbar = (toolbar != undefined)?true:false;
	var _this = this;
	modal_hide = (modal_hide == undefined)?true:modal_hide;
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
	Bootstrap_Builder.change_flag = true;
	window.onbeforeunload = function(e) {
        var message = 'Data you have entered may not be saved. ';
        e.returnValue  = message;
        return message;
    }
    var sortable_id = $('#portlets_modal').data('sortable-id');
    portlet.content = (portlet.content !=undefined && $.isEmptyObject(portlet.content) == false)?portlet.content:{};
    var content = portlet.content;
    
    if (toolbar == false){
	    var fields = $("#portlets_modal .portlet-style" ).serializeArray();
	    var style = {};
	    $.each( fields, function( i, field ) {
	    	style[field.name] = field.value;
	    });
	    portlet.style = style;
	    fields = $("#portlets_modal .portlet-attr" ).serializeArray();
	    var attr = {};
	    $.each( fields, function( i, field ) {
	    	attr[field.name] = field.value;
	    });
	    portlet.attr = attr;
	    
	    content.title = $('#portlets_modal #title').val();
	    content.type = $('#portlets_modal #type').val();
	    content.price = $('#portlets_modal #price').val();
	    content.sub_price = $('#portlets_modal #sub-price').val();
	    content.currency_symbol = $('#portlets_modal #currency-symbol').val();
	    content.price_title = $('#portlets_modal #price-title').val();
    }
    
    _this.portlet_render(portlet_id,sortable_id,content,modal_hide);
};

Pricing_Table_Portlet_Class.prototype.portlet_modal = function (portlet_id){
	var _this = this;
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
    
    $('#portlets_modal').find('#portlets_modal_label').html('Pricing Table');
    $('#portlets_modal').find('#portlets_modal_body').empty();
    
    // render footer button.
    $('#portlets_modal').find('#portlets_modal_body')
    .after(
       $('<div></div>')
       .attr('id','portlets_modal_footer')
       .addClass('modal-footer')
       .append(
            $('<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>')     
       )
       .append(
            $('<button type="button" class="btn btn-primary">Apply</button>')
            .click(function(){
            	_this.portlet_save(portlet_id,false);
            })
       )
       .append(
            $('<button type="button" class="btn btn-primary">Save & close</button>')
            .click(function(){
            	_this.portlet_save(portlet_id);
            })
       )
    );
    // end render footer button.
    
    // render portlet design tab
    $('#portlets_modal').find('#portlets_modal_body').load('zoozoo-builder.php?action=load-plugin-file&project-theme='+$('#project-theme').val()+'&plugin=pricing-table&file=pricing-table-portlet.html',function(){
    	Bootstrap_Builder.tab_modal_resize();
    	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
    	var content = (portlet.content !=undefined && $.isEmptyObject(portlet.content) == false)?portlet.content:{};
    	if (content.title != undefined && content.title != ''){
    		$('#portlets_modal #title').val(content.title);
    	}
    	
    	if (content.type != undefined && content.type != ''){
    		$('#portlets_modal #type').val(content.type);
    	}
    	
    	if (content.price != undefined && content.price != ''){
    		$('#portlets_modal #price').val(content.price);
    	}
    	
    	if (content.sub_price != undefined && content.sub_price != ''){
    		$('#portlets_modal #sub-price').val(content.sub_price);
    	}
    	
    	if (content.currency_symbol != undefined && content.currency_symbol != ''){
    		$('#portlets_modal #currency-symbol').val(content.currency_symbol);
    	}
        
    	if (content.price_title != undefined && content.price_title != ''){
    		$('#portlets_modal #price-title').val(content.price_title);
    	}
    	
    	if (portlet.style != undefined){
	    	$.each( portlet.style, function( name, value ) {
	    		if ($.trim(value) != ''){
		    		if (name != 'border-color' && name != 'background-color' && name != 'color'){
		    			$('#portlets_modal #'+ name).val(value);
		    		}else{
		    			$('#portlets_modal .'+ name+'-picker').colorpicker('setValue', value);
		    		}
	    		}
	    		
	    	});
        }
        if (portlet.attr != undefined){
	    	$.each( portlet.attr, function( name, value ) {
	    		if ($.trim(value) != ''){
	    			$('#portlets_modal #'+ name).val(value);
	    		}
	    		
	    	});
        }
        Bootstrap_Builder.modal_resize();
    });
    // end render row setting form
};

var Pricing_Table_Portlet = new Pricing_Table_Portlet_Class();

