<form  style="margin-top:10px;margin-bottom:5px;">
    <div class="row">
        <div class="col-sm-6">
            <div class="form-group ">
                <label for="portfolio-title" class="control-label">Title <span class="red-star">*</span></label>
                <div>
                    <input class="form-control" name="portfolio-title" placeholder="Title" id="portfolio-title" type="text">
                </div>
            </div>
            <div class="form-group ">
                <label for="portfolio-description" class="control-label">Description</label>
                <textarea rows="10" class="form-control" id="portfolio-description"></textarea>
            </div>
        </div>
        <div class="col-sm-6">
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group ">
                        <label for="portfolio-category-id" class="control-label">Category</label>
                        <div>
                            <select class="form-control" name="portfolio-category-id" id="portfolio-category-id">
                                <option value=""></option>
                                <?php if (!empty($categories) && is_array($categories)){?>
                                <?php foreach ($categories as $id => $category){ ?>
                                <option value="<?php echo $id; ?>"><?php echo htmlspecialchars($category['name'],ENT_QUOTES);?></option>
                                <?php } ?>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group ">
                        <label for="portfolio-client" class="control-label">Client</label>
                        <div>
                            <input class="form-control" name="portfolio-client" placeholder="Client" id="portfolio-client" type="text">
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group ">
                        <label for="portfolio-date" class="control-label">Date</label>
                        <div>
                            <div class="input-group date" id="portfolio-date-container">
                                <input class="form-control" name="portfolio-date" placeholder="Date" data-date-format="YYYY-MM-DD" id="portfolio-date" type="text"> 
                                <span class="input-group-addon"> 
                                    <span class="fa fa-calendar glyphicon glyphicon-calendar"></span>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group ">
                        <label for="portfolio-status" class="control-label">Status</label>
                        <div>
                            <select class="form-control" name="portfolio-status" id="portfolio-status">
                                <option value="1" selected="selected">Public</option>
                                <option value="2">Unpublic</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-group ">
                <label for="portfolioPortfolio_status" class="control-label">Images</label>
                <div id="portfolio-images-container">
                    <div class="row" id="images"></div>
                    <input multiple="multiple" type="file" name="portfolio-images[]" id="portfolio-images" style="display:none;">
                    <a class="btn btn-default" id="portfolio-upload-button">
                        <i class="fa fa-cloud-upload"></i> Images
                     </a>
                </div>
            </div>
        </div>
    </div>
    <div class="text-right">
        <button class="btn btn-default" type="button" id="add-new-portfolio-cancel">Cancel</button>
        <button class="btn btn-primary" type="button" id="add-new-portfolio-save">Add new</button>
    </div>
</form>
<script>
$(function(){
	$('#portfolio-date-container').datetimepicker();
	$('#portlets_modal #portfolio-images-container #portfolio-upload-button').click(function(){
        $("#portlets_modal #portfolio-images-container #portfolio-images").trigger("click");
    });
});
</script>