<?php
class Portfolio_Portlet extends Bootstrap_Portlet{
    private $portfolio;
    public function __construct($portlets, $portlet, $portlet_id, $builder){
        $this->portfolio = new Option('portfolio-'.$portlet_id);
        parent::__construct($portlets, $portlet, $portlet_id, $builder);
    }
    public function index(){
        $portfolios = (!empty($this->portfolio->portfolios) && is_array($this->portfolio->portfolios))?$this->portfolio->portfolios:array();
        $portfolios = array_filter ( $portfolios, array($this,'search_params'));
        
        $page_index = (!empty($_GET['page-index']) && is_numeric($_GET['page-index']))?$_GET['page-index']:1;
        $num_per_page = 5;
        $total_portfolio= count($portfolios);
        $total_page = ceil($total_portfolio/$num_per_page);
        $portfolios = array_slice($portfolios, (($page_index - 1) * $num_per_page), $num_per_page);
        
        require dirname(__FILE__).'/views/index.php';
    }
    
    public function search_params($portfolio){
        if (!empty($_GET['s_title'])){
            if (stripos ( $portfolio ['title'], $_GET['s_title'] ) !== false){
                return true;
            }
    
            return false;
        }
    
        return true;
    }
    
    public function add(){
        if (isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] == 'POST' && !empty($_POST['portfolio']) && is_array($_POST['portfolio'])){
            $portfolios = (!empty($this->portfolio->portfolios) && is_array($this->portfolio->portfolios))?$this->portfolio->portfolios:array();
            $portfolios[$_POST['portfolio']['id']] = $_POST['portfolio'];
            $this->portfolio->portfolios = $portfolios;
        }else{
            $categories = $this->portfolio->categories;
            
            require dirname(__FILE__).'/views/add.php';
        }
    }
    
    public function portlet_copy(){
        if (!empty($_GET['portlet-id']) && !empty($_GET['new-portlet-id'])){
            $new_portfolio_obj = new Option('portfolio-'.$_GET['new-portlet-id']);
            
            $utility = new Utility();
            $categories = $this->portfolio->categories;
            $new_categories = array();
            $c_ids = array();
            
            foreach ($categories as $k => $v){
                $v['id'] = $utility->guid();
                $c_ids[$k] = $v['id'];
                $new_categories[$v['id']] = $v;
            }
            
            
            $portfolios = $this->portfolio->portfolios;
            $new_portfolios = array();
            foreach ($portfolios as $k => $v){
                $v['id'] = $utility->guid();
                if (!empty($c_ids[$v['category_id']])){
                    $v['category_id'] = $c_ids[$v['category_id']];
                }else{
                    $v['category_id'] = '';
                }
                $new_portfolios[$v['id']] = $v;
            }
            
            
            $new_portfolio_obj->portfolios = $new_portfolios;
            $new_portfolio_obj->categories = $new_categories; 
        }
    }
    
    public function portlet_delete(){
        if (!empty($_GET['portlet-id'])){
            $portfolio_obj = new Option('portfolio-'.$_GET['portlet-id']);
            $portfolio_obj->remove();
        }
    }
    
    public function edit(){
        $portfolios = (!empty($this->portfolio->portfolios) && is_array($this->portfolio->portfolios))?$this->portfolio->portfolios:array();
        if (isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] == 'POST' && !empty($_POST['portfolio']) && is_array($_POST['portfolio'])){
            $portfolios[$_POST['portfolio']['id']] = $_POST['portfolio'];
            $this->portfolio->portfolios = $portfolios;
        }else{
            $var = array();
            $portfolio = array();
            if (!empty($_GET['portfolio-id'])){
                $portfolio = (!empty($portfolios[$_GET['portfolio-id']]) && is_array($portfolios[$_GET['portfolio-id']]))?$portfolios[$_GET['portfolio-id']]:array();
            }
            $var['portfolio'] = $portfolio;
            ob_start();
            $categories = $this->portfolio->categories;
            require dirname(__FILE__).'/views/edit.php';
            $var['html'] = ob_get_contents();
            ob_get_clean();

            echo json_encode($var);
        }
    }
    
    public function delete(){
        if (isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] == 'POST' && !empty($_GET['portfolio-id'])){
            $portfolios = (!empty($this->portfolio->portfolios) && is_array($this->portfolio->portfolios))?$this->portfolio->portfolios:array();
            if (!empty($_GET['portfolio-id']) && !empty($portfolios[$_GET['portfolio-id']]) && is_array($portfolios[$_GET['portfolio-id']])){
                unset($portfolios[$_GET['portfolio-id']]);
                $this->portfolio->portfolios = $portfolios;
            }
        }
    }
    
    public function get_portfolios(){
        $var = array();
        $var['portfolios'] = $this->portfolio->portfolios;
        $var['categories'] = $this->portfolio->categories;
        
        echo json_encode($var);
    }
    
    /********************* Portfolio Category ************************/
    public function category_index(){
        $categories = (!empty($this->portfolio->categories) && is_array($this->portfolio->categories))?$this->portfolio->categories:array();
        $categories = array_filter ( $categories, array($this,'search_category_params'));
    
        $page_index = (!empty($_GET['page-index']) && is_numeric($_GET['page-index']))?$_GET['page-index']:1;
        $num_per_page = 5;
        $total_portfolio= count($categories);
        $total_page = ceil($total_portfolio/$num_per_page);
        $categories = array_slice($categories, (($page_index - 1) * $num_per_page), $num_per_page);
    
        require dirname(__FILE__).'/views/category-index.php';
    }
    
    public function search_category_params($category){
        if (!empty($_GET['s_name'])){
            if (stripos ( $category ['name'], $_GET['s_name'] ) !== false){
                return true;
            }
    
            return false;
        }
    
        return true;
    }
    
    
    public function category_add(){
        if (isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] == 'POST' && !empty($_POST['category']) && is_array($_POST['category'])){
            $categories = (!empty($this->portfolio->categories) && is_array($this->portfolio->categories))?$this->portfolio->categories:array();
            $categories[$_POST['category']['id']] = $_POST['category'];
            $this->portfolio->categories = $categories;
        }else{
            require dirname(__FILE__).'/views/category-add.php';
        }
    }
    
    public function category_edit(){
        $categories = (!empty($this->portfolio->categories) && is_array($this->portfolio->categories))?$this->portfolio->categories:array();
        if (isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] == 'POST' && !empty($_POST['category']) && is_array($_POST['category'])){
            $categories[$_POST['category']['id']] = $_POST['category'];
            $this->portfolio->categories = $categories;
        }else{
            $var = array();
            $category = array();
            if (!empty($_GET['category-id'])){
                $category = (!empty($categories[$_GET['category-id']]) && is_array($categories[$_GET['category-id']]))?$categories[$_GET['category-id']]:array();
            }
            $var['category'] = $category;
            ob_start();
            require dirname(__FILE__).'/views/category-edit.php';
            $var['html'] = ob_get_contents();
            ob_get_clean();
    
            echo json_encode($var);
        }
    }
    
    public function category_delete(){
        if (isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] == 'POST' && !empty($_GET['category-id'])){
            $categories = (!empty($this->portfolio->categories) && is_array($this->portfolio->categories))?$this->portfolio->categories:array();
            if (!empty($_GET['category-id']) && !empty($categories[$_GET['category-id']]) && is_array($categories[$_GET['category-id']])){
                unset($categories[$_GET['category-id']]);
                $this->portfolio->categories = $categories;
            }
        }
    }
    
    public function to_html(){
        $this->portlet['attr']['class'] = (!empty($this->portlet['attr']['class']))?$this->portlet['attr']['class'].' bhb-portfolio-isotope-container':'bhb-portfolio-isotope-container'; 
        
        return parent::to_html();
    }
}