/*
 * portlet: portfolio
 * portlet-type: portfolio
 * portlet-group: advance
 * portlet-name: Portfolio
 * portlet-image: assets/images/no-image.png
 * portlet-asset-css: plugins/portfolio/assets/css/portfolio-portlet.css
 * portlet-asset-js: plugins/portfolio/assets/isotope/js/jquery.isotope.min.js
 * portlet-asset-js: plugins/portfolio/assets/js/portfolio-portlet.js
 */
Portfolio_Portlet_Class = function(){
    this.toolbar_name = 'Portfolio';
    this.modal_width = 900;
    this.portfolio_message = '';
}
$.extend(Portfolio_Portlet_Class.prototype, Abstract_Portlet_Class.prototype);
Portfolio_Portlet_Class.prototype.advance_render = function(portlet_id,content){
    var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
    var div = $('<div></div>').addClass('bhb-portfolio-isotope-container');
    div.append(content);
    div.find('.portfolio-isotope-items>.portfolio-item>div>.caption').hide();
    
    return div;
};

Portfolio_Portlet_Class.prototype.portlet_copy = function(portlet_id){
	var portlet = (Bootstrap_Builder.portlet_copys[portlet_id] != undefined)?Bootstrap_Builder.portlet_copys[portlet_id]:{};
	portlet.sortable_id = (portlet.sortable_id != undefined)?portlet.sortable_id:'empty';
	if ($.isEmptyObject(portlet) == false && Bootstrap_Builder.sortable_ids[portlet.sortable_id] != undefined){
		portlet.sortable_id = Bootstrap_Builder.sortable_ids[portlet.sortable_id];
	}
	portlet.old_portlet_id = portlet_id;
	portlet.portlet_id = Bootstrap_Builder.guid();
	
	return portlet;
};

Portfolio_Portlet_Class.prototype.portlet_toolbar = function(portlet_id,portlet){
	var _this = this;
	portlet.append($('<div class="portlet-mask" style="top: 0px; left: 0px;   position: absolute; visibility: hidden; z-index: 3000; "></div>'));
    
    // render toolbar
    var portlet_toolbar = $('<div class="portlet-toolbar btn-group" style="z-index:3001;"></div>');
    portlet_toolbar.append($('<a class="btn btn-default btn-xs portlet-toolbar-move"></a>').append('<i class="fa fa-arrows"></i> '+this.toolbar_name));
    portlet_toolbar.append(
        $('<a class="btn btn-primary btn-xs"></a>')
        .append('<i class="fa fa-files-o"></i>')
        .data('portlet-id',portlet_id)
        .click(function(){
            var portlet_id = $(this).data('portlet-id');
            var sortable_id = $('#' + portlet_id).data('sortable-id');
            var portlet = Bootstrap_Builder.portlets[portlet_id];
            $('#portlets_modal').data('copy_portlet_id',portlet_id);
            
            new_portlet_id = Bootstrap_Builder.guid();
            Bootstrap_Builder.portlets[new_portlet_id] = $.extend(true,{}, portlet);
            Bootstrap_Builder.portlets[new_portlet_id].portlet_id = new_portlet_id;
            
            $.get('zoozoo-builder.php?action=load-plugin&project-theme='+$('#project-theme').val()+'&plugin=portfolio&portlet-id='+portlet_id+'&new-portlet-id='+new_portlet_id+'&method=portlet_copy',function(html){
            	_this.portlet_save(new_portlet_id,false);
            });
        })
    );
    portlet_toolbar.append(
              $('<a class="btn btn-primary btn-xs"></a>')
              .append('<i class="fa fa-pencil"></i>')
              .data('portlet-id',portlet_id)
              .click(function(){
                  var portlet_id = $(this).data('portlet-id');
                  var sortable_id = $('#' + portlet_id).data('sortable-id');
                  
                  // for get template block
//                  	var _portlets = Bootstrap_Builder.get_portlets($('#'+portlet_id));
//              		console.log(JSON.stringify(_portlets));
                  // for get template block
                  _this.modal_width = (_this.modal_width != undefined)?_this.modal_width:600; 
                  Bootstrap_Builder.show_portlets(sortable_id,true,null,_this.modal_width);
                  _this.portlet_modal(portlet_id);
                  
                  $('.portlet-toolbar').hide();
                  $('.portlet-mask').css({visibility:'hidden'});
                  $('.portlet-mask').width(6);
              })
    );
    portlet_toolbar.append(
            $('<a class="btn btn-danger btn-xs"></a>')
            .append('<i class="fa fa-trash-o"></i>')
            .data('portlet-id',portlet_id)
            .click(function(){
            	$('.portlet-toolbar').hide();
                $('.portlet-mask').css({visibility:'hidden'});
                $('.portlet-mask').width(6);
                $('#delete-modal .modal-footer > #delete-portlet').remove();
                
                var delete_portlet = $('<button type="button" class="btn btn-danger" id="delete-portlet">Delete</button>');
                var portlet_id = $(this).data('portlet-id');
                
                delete_portlet.click(function(){
                	$.get('zoozoo-builder.php?action=load-plugin&project-theme='+$('#project-theme').val()+'&plugin=portfolio&portlet-id='+portlet_id+'&method=portlet_delete',function(html){
	                	$('#delete-modal').data('portlet-id',portlet_id);
	                	$('#delete-modal').modal('hide');
                		Bootstrap_Builder.change_flag = true;
                		window.onbeforeunload = function(e) {
                            var message = 'Data you have entered may not be saved. ';
                            e.returnValue  = message;
                            return message;
                        }
                    	//$('#' + portlet_id).remove();
    	                delete Bootstrap_Builder.portlets[portlet_id];
                	});
                });
                $('#delete-modal .modal-footer').append(delete_portlet);
            	$('#delete-modal').modal('show');
            })
    );
    portlet.append(portlet_toolbar);
    // end render toolbar
    
    portlet.hover(function() {
        var toolbar_top = $(this).height() / 2
                - $(this).children('.portlet-toolbar').height()
                / 2;
        var toolbar_left = $(this).width() / 2 - 30;
        $(this).children('.portlet-toolbar').css({
            left : toolbar_left,
            top : toolbar_top
        });
        
        $(this).children('.portlet-toolbar').show();
        var portlet_mark_width = ($(this).outerWidth(true) > $(window).width())?$(window).width():$(this).outerWidth(true);
        $(this).children('.portlet-mask').css({'border':'3px dashed red',visibility:'visible'});
        $(this).children('.portlet-mask').css({top:'-'+$(this).find('.portlet-content > div').css('marginTop')});
        $(this).children('.portlet-mask').width(portlet_mark_width - 6);
        var portlet_content_height = $(this).find('.portlet-content').outerHeight(true);
        var portlet_content_div_height = $(this).find('.portlet-content > div').outerHeight(true);
        portlet_content_height = (portlet_content_height > portlet_content_div_height)?portlet_content_height:portlet_content_div_height;
        $(this).children('.portlet-mask').height(portlet_content_height - 6);
    }, function() {
        $(this).children('.portlet-toolbar').hide();
        $(this).children('.portlet-mask').css({visibility:'hidden'});
        $('.portlet-mask').width(6);
    });
};

Portfolio_Portlet_Class.prototype.portlet_save = function (portlet_id,modal_hide,toolbar){
	toolbar = (toolbar != undefined)?true:false;
	var _this = this;
	modal_hide = (modal_hide == undefined)?true:modal_hide;
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
    Bootstrap_Builder.change_flag = true;
    window.onbeforeunload = function(e) {
        var message = 'Data you have entered may not be saved. ';
        e.returnValue  = message;
        return message;
    }
    var sortable_id = $('#portlets_modal').data('sortable-id');
    
    $.get('zoozoo-builder.php?action=load-plugin&project-theme='+$('#project-theme').val()+'&plugin=portfolio&portlet-id='+portlet_id+'&method=get_portfolios',function(json){
    	var object = $('<div></div>');
    	var filters = $('<div></div>').addClass('portfolio-filters');
    	object.append(filters);
    	var categories = {};
    	if (json.categories != undefined){
    		categories = json.categories;
    		filters
			.append(
				$('<div></div>')
				.addClass('portfolio-filter-item')
				.addClass('active')
				.attr('data-filter','*')
				.css({display:'inline-block'})
				.append('All')
			);
    		$.each(categories,function(id, category){
    			if (category.status == '1'){
	    			filters
	    			.append(' | ')
	    			.append(
						$('<div></div>')
						.addClass('portfolio-filter-item')
						.attr('data-filter','.'+id)
						.css({display:'inline-block'})
						.append(category.name)
	    			);
    			}
    		});
    		
    	}
    	var isotope_container = $('<div></div>').addClass('row').addClass('portfolio-isotope-items');
    	if (json.portfolios != undefined){
    		var portfolio_modals = $('<div></div>');
    		var portfolios = json.portfolios;
    		$.each(portfolios, function(id, portfolio){
    			if (portfolio.status == '1'){
	    			isotope_container
	    			.append(
	    				$('<div class="col-xs-12 col-sm-6 col-md-4 col-lg-4"></div>')
	    				.addClass('portfolio-item')
	    				.addClass(portfolio.category_id)
	    				.append(
							$('<div></div>')
							.attr('data-portfolio-id',id)
							.append(
								$('<div class="caption"></div>')
								.append(
									$('<div class="caption-content"></div>').append('<i class="fa fa-search-plus fa-3x"></i>')
								)
		    				)
							.append(
								$('<img>').addClass('img-responsive').attr('src',portfolio.images[0])
							)
	    				)
	    			);
	    			var category_name = (categories[portfolio.category_id] != undefined && categories[portfolio.category_id].name != undefined)?'<p class="item-intro text-muted">Category: '+categories[portfolio.category_id].name+'</p>':'';
	    			var portfolio_attr = '';
	    			if (portfolio.client != undefined && $.trim(portfolio.client) != ''){
	    				portfolio_attr += ' <span>Client: <strong>'+portfolio.client+'</strong></span>';
	    			}
	    			if (portfolio.date != undefined && $.trim(portfolio.date) != ''){
	    				portfolio_attr += ' <span>Date: <strong>'+portfolio.date+'</strong></span>';
	    			}
	    			var portfolio_carousel = $('<div data-ride="carousel" class="carousel slide"></div>');
					portfolio_carousel
					.attr('id','carousel-'+portlet_id)
					.append(
						$('<div role="listbox" class="carousel-inner"></div>')
					)
					.append(
						$('<a data-slide="prev" role="button" href="#carousel-'+portlet_id+'" class="left carousel-control"></a>')
						.append(
							'<span aria-hidden="true" class="glyphicon glyphicon-chevron-left"></span> <span class="sr-only">Previous</span>'
						)
					)
					.append(
						$('<a data-slide="next" role="button" href="#carousel-'+portlet_id+'" class="right carousel-control"></a>')
						.append(
							'<span aria-hidden="true" class="glyphicon glyphicon-chevron-right"></span> <span class="sr-only">Next</span>'
						)
					);
	    			if (portfolio.images != undefined){
	    				var _active = 'active';
	    				$.each(portfolio.images,function(k,v){
	    					portfolio_carousel.find('.carousel-inner')
	    					.append(
								$('<div class="item '+_active+'"></div>')
								.append(
									 $('<img alt="" src="'+v+'" data-holder-rendered="true">')
								)
							)
							_active = '';
	    				});
	    			}
	    			portfolio_modals
	    			.append(
						$('<div class="portfolio-modal modal fade" id="portfolio-modal-'+id+'" tabindex="-1" role="dialog" aria-hidden="true"></div>')
						.append(
							$('<div class="modal-content"></div>')
							.append(
								$('<div class="close-modal" data-dismiss="modal"><div class="lr"><div class="rl"></div></div></div>')
							)
							.append(
								$('<div class="container"></div>')
								.append(
									$('<div class="row"></div>')
									.append(
										$('<div class="col-lg-8 col-lg-offset-2"></div>')
										.append(
											$('<div class="modal-body"></div>')
											.append(
												$('<h2></h2>').text(portfolio.title)
											)
											.append(category_name)
											.append(portfolio_carousel)
											.append(
												$('<p></p>').text(portfolio.description)
											)
											.append(
												$('<p></p>').append(portfolio_attr)
											)
											.append('<button type="button" class="btn btn-primary" data-dismiss="modal"><i class="fa fa-times"></i> Close Project</button>')
										)
									)
								)
							)
						)
	    			);
    			}
    		});
    	}
    	object.append(isotope_container);
    	object.append(portfolio_modals);
    	
    	var value = object.html();
    	
    	_this.portlet_render(portlet_id,sortable_id,value,modal_hide);
    },'json');
};

Portfolio_Portlet_Class.prototype.portlet_modal = function (portlet_id){
    var _this = this;
    var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
    
    $('#portlets_modal').find('#portlets_modal_label').html('Portfolios');
    $('#portlets_modal').find('#portlets_modal_body').empty();
    
    $('#portlets_modal').find('#portlets_modal_body')
    .after(
       $('<div></div>')
       .attr('id','portlets_modal_footer')
       .addClass('modal-footer')
       .append(
            $('<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>')     
       )
       .append(
            $('<button type="button" class="btn btn-primary">Apply</button>')
            .click(function(){
                _this.portlet_save(portlet_id,false);
            })
       )
       .append(
            $('<button type="button" class="btn btn-primary">Save & close</button>')
            .click(function(){
            	_this.portlet_save(portlet_id);
            })
       )
    );
    
    // render row setting form
    $('#portlets_modal').find('#portlets_modal_body').load('zoozoo-builder.php?action=load-plugin-file&project-theme='+$('#project-theme').val()+'&plugin=portfolio&file=portfolio-portlet.html',function(){
        Bootstrap_Builder.tab_modal_resize();
        var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
        _this.portlet_portfolio_index_action(portlet_id);
        _this.portlet_portfolio_category_index_action(portlet_id);
        
    });
    // end render row setting form
};

Portfolio_Portlet_Class.prototype.portlet_portfolio_index_action = function (portlet_id,s_title,page_index){
	$('#portlets_modal').find('#portlets_modal_label').html('Portfolios');
	var _this = this;
	s_title = (s_title !=undefined && s_title != '')?'&s_title='+ s_title:'';
	page_index = (page_index !=undefined && page_index != '')?'&page-index='+ page_index:'';
	$.get('zoozoo-builder.php?action=load-plugin&project-theme='+$('#project-theme').val()+'&plugin=portfolio&portlet-id='+portlet_id+'&method=index'+s_title+page_index,function(html){
		$('#portfolio-portlet-container #porfolio-tab').html(html);
		if (_this.portfolio_message != ''){
			$('#portfolio-portlet-container #porfolio-tab').prepend('<div role="alert" class="alert alert-success alert-dismissible fade in" style="margin:10px 0;"> <button aria-label="Close" data-dismiss="alert" class="close" type="button"><span aria-hidden="true">×</span></button>'+_this.portfolio_message+' </div>');
		}
    	$('#portfolio-portlet-container #porfolio-tab #add-new-portfolio').click(function(){
    		_this.portlet_portfolio_add_action(portlet_id);
    	});
    	
    	$('#portfolio-portlet-container #porfolio-tab .edit-portfolio').click(function(){
    		var portfolio_id = $(this).data('id');
    		_this.portlet_portfolio_edit_action(portlet_id,portfolio_id);
    	});
    	
    	$('#portfolio-portlet-container #porfolio-tab .delete-portfolio').click(function(){
    		var portfolio_id = $(this).data('id');
    		if (confirm('Are you sure to delete this portfolio?')){
    			_this.portlet_portfolio_delete_action(portlet_id,portfolio_id);
    		}
    	});
    	
    	$('#portfolio-portlet-container #porfolio-tab #portfolio-search').click(function(){
    		var s_title = $('#portfolio-portlet-container #porfolio-tab #s_title').val();
    		_this.portlet_portfolio_index_action(portlet_id,s_title);
    	});
    	
    	$('#portfolio-portlet-container #porfolio-tab #s_title').keypress(function(e) {
    	    if(e.which == 13) {
    	    	var s_title = $('#portfolio-portlet-container #porfolio-tab #s_title').val();
        		_this.portlet_portfolio_index_action(portlet_id,s_title);
        		e.preventDefault();
    	    }
    	});
    	
    	$('#portfolio-portlet-container #porfolio-tab .portfolio-pagination').click(function(e) {
    		var s_title = $('#portfolio-portlet-container #porfolio-tab #s_title').val();
    		var page_index = $(this).data('page-index');
    		_this.portlet_portfolio_index_action(portlet_id,s_title,page_index);
    		e.preventDefault();
    	});
    	_this.portfolio_message = '';
    	Bootstrap_Builder.modal_resize();
    });
};

Portfolio_Portlet_Class.prototype.image_render = function (image_path){
	$('#portlets_modal #portfolio-images-container #images').append(
		$('<div class="col-sm-3 text-center"></div>')
		.css({marginBottom:'5px'})
		.append(
			$('<input type="hidden" class="portfolio-image" >').val(image_path)
		)
		.append(
			$('<img class="img-responsive img-thumbnail">').attr('src',image_path)
			.css({cursor:'move'})
		)
		.append(
			$('<a class="btn btn-link btn-xs"></a>')
			.css({color:'#ac2925'})
			.click(function(){
				$(this).parent().remove();
			})
			.html('Delete')
		)
	)
};

Portfolio_Portlet_Class.prototype.portlet_portfolio_add_action = function (portlet_id){
	$('#portlets_modal').find('#portlets_modal_label').html('Add new portfolio');
	var _this = this;
	$.get('zoozoo-builder.php?action=load-plugin&project-theme='+$('#project-theme').val()+'&plugin=portfolio&portlet-id='+portlet_id+'&method=add',function(html){
    	$('#portfolio-portlet-container #porfolio-tab').html(html);
    	
    	$('#portlets_modal #portfolio-images-container #portfolio-images').fileupload({
	        url: 'zoozoo-builder.php?action=upload-image&field-name=portfolio-images',
	        dataType: 'json',
	        start:function(e){
	        	// begin loading
	        },
	        done: function (e, data) {
	        	var file = data.result;
	        	if (file.portfolio_images != undefined){
	        		_this.image_render(file.portfolio_images);
	        	}
	        	$('#portlets_modal #portfolio-images-container').parent().removeClass('has-error');
	    		$('#portlets_modal #portfolio-images-container .error-message').remove();
	        	// $('#portlets_modal #background-image-upload-progress-bar').css('width','0px');
	    		Bootstrap_Builder.modal_resize();
	        },
	        progressall: function (e, data) {
	            var progress = parseInt(data.loaded / data.total * 100, 10);
	            // $('#portlets_modal #image-upload-progress-bar').css('width',progress + '%');
	            // End loading
	        }
	    });
    	
    	$("#portlets_modal #portfolio-images-container #images").sortable({
			handle : ".img-thumbnail"
		});
    	
    	$('#portfolio-portlet-container #porfolio-tab #add-new-portfolio-cancel').click(function(){
    		_this.portlet_portfolio_index_action(portlet_id);
    	});
    	
    	$('#portfolio-portlet-container #porfolio-tab #add-new-portfolio-save').click(function(){
    		var portfolio = {};
    		portfolio.id = Bootstrap_Builder.guid();
    		portfolio.title = $('#portlets_modal #portfolio-title').val();
    		portfolio.description = $('#portlets_modal #portfolio-description').val();
			portfolio.category_id = $('#portlets_modal #portfolio-category-id').val();
			portfolio.client = $('#portlets_modal #portfolio-client').val();
			portfolio.date = $('#portlets_modal #portfolio-date').val();
			portfolio.status = $('#portlets_modal #portfolio-status').val();
			portfolio.images = [];
			$('#portlets_modal #portfolio-images-container #images .portfolio-image').each(function(){
				var image = $.trim($(this).val());
				if (image != ''){
					portfolio.images[portfolio.images.length] = image;
				}
			});
			if (_this.portlet_portfolio_validation(portfolio)){
				$.post('zoozoo-builder.php?action=load-plugin&project-theme='+$('#project-theme').val()+'&plugin=portfolio&portlet-id='+portlet_id+'&method=add',{portfolio:portfolio},function(html){
					_this.portfolio_message = 'The portfolio has been added successfully';
					_this.portlet_portfolio_index_action(portlet_id);
				});
			}
    	});
    	Bootstrap_Builder.modal_resize();
    });
};

Portfolio_Portlet_Class.prototype.portlet_portfolio_validation = function (portfolio){
	var validated = true;
	if (portfolio.title == undefined || portfolio.title == ''){
		if ($('#portlets_modal #portfolio-title').parent().parent().hasClass('has-error') == false){
			$('#portlets_modal #portfolio-title').parent().parent().addClass('has-error');
			$('#portlets_modal #portfolio-title').parent().append('<span class="help-block error-message">The title field is required.</span>');
		}
		validated = false;
	}else{
		$('#portlets_modal #portfolio-title').parent().parent().removeClass('has-error');
		$('#portlets_modal #portfolio-title').parent().children('.error-message').remove();
	}
	
	if (portfolio.images == undefined || portfolio.images.length <= 0){
		if ($('#portlets_modal #portfolio-images-container').parent().hasClass('has-error') == false){
			$('#portlets_modal #portfolio-images-container').parent().addClass('has-error');
			$('#portlets_modal #portfolio-images-container').append('<span class="help-block error-message">The images field are required.</span>');
		}
		validated = false;
	}else{
		$('#portlets_modal #portfolio-images-container').parent().removeClass('has-error');
		$('#portlets_modal #portfolio-images-container .error-message').remove();
	}
	
	return validated;
};

Portfolio_Portlet_Class.prototype.portlet_portfolio_edit_action = function (portlet_id,portfolio_id){
	$('#portlets_modal').find('#portlets_modal_label').html('Edit portfolio');
	var _this = this;
	$.get('zoozoo-builder.php?action=load-plugin&project-theme='+$('#project-theme').val()+'&plugin=portfolio&portlet-id='+portlet_id+'&method=edit&portfolio-id='+portfolio_id,function(json){
    	$('#portfolio-portlet-container #porfolio-tab').html(json.html);
    	
    	var portfolio = json.portfolio;
    	$('#portlets_modal #portfolio-title').val(portfolio.title);
		$('#portlets_modal #portfolio-description').val(portfolio.description);
		$('#portlets_modal #portfolio-category-id').val(portfolio.category_id);
		$('#portlets_modal #portfolio-client').val(portfolio.client);
		$('#portlets_modal #portfolio-date').val(portfolio.date );
		$('#portlets_modal #portfolio-status').val(portfolio.status);
		$.each(portfolio.images,function(k,v){
			 var image = $.trim(v);
				if (image != ''){
					_this.image_render(image);
				}
		});
		
		$("#portlets_modal #portfolio-images-container #images").sortable({
			handle : ".img-thumbnail"
		});
		
		$('#portlets_modal #portfolio-images-container #portfolio-images').fileupload({
	        url: 'zoozoo-builder.php?action=upload-image&field-name=portfolio-images',
	        dataType: 'json',
	        start:function(e){
	        	// begin loading
	        },
	        done: function (e, data) {
	        	var file = data.result;
	        	if (file.portfolio_images != undefined){
	        		_this.image_render(file.portfolio_images);
	        	}
	        	$('#portlets_modal #portfolio-images-container').parent().removeClass('has-error');
	    		$('#portlets_modal #portfolio-images-container .error-message').remove();
	        	// $('#portlets_modal #background-image-upload-progress-bar').css('width','0px');
	    		Bootstrap_Builder.modal_resize();
	        },
	        progressall: function (e, data) {
	            var progress = parseInt(data.loaded / data.total * 100, 10);
	            // $('#portlets_modal #image-upload-progress-bar').css('width',progress + '%');
	            // End loading
	        }
	    });
    	
    	$('#portfolio-portlet-container #porfolio-tab #edit-portfolio-cancel').click(function(){
    		_this.portlet_portfolio_index_action(portlet_id);
    	});
    	
    	$('#portfolio-portlet-container #porfolio-tab #edit-portfolio-save').click(function(){
    		var portfolio = {};
    		portfolio.id = portfolio_id;
    		portfolio.title = $('#portlets_modal #portfolio-title').val();
    		portfolio.description = $('#portlets_modal #portfolio-description').val();
			portfolio.category_id = $('#portlets_modal #portfolio-category-id').val();
			portfolio.client = $('#portlets_modal #portfolio-client').val();
			portfolio.date = $('#portlets_modal #portfolio-date').val();
			portfolio.status = $('#portlets_modal #portfolio-status').val();
			portfolio.images = [];
			$('#portlets_modal #portfolio-images-container #images .portfolio-image').each(function(){
				var image = $.trim($(this).val());
				if (image != ''){
					portfolio.images[portfolio.images.length] = image;
				}
			});
			if (_this.portlet_portfolio_validation(portfolio)){
	    		$.post('zoozoo-builder.php?action=load-plugin&project-theme='+$('#project-theme').val()+'&plugin=portfolio&portlet-id='+portlet_id+'&method=edit&portfolio-id='+portfolio_id,{portfolio:portfolio},function(html){
	    			_this.portfolio_message = 'The portfolio has been updated successfully';
	    			_this.portlet_portfolio_index_action(portlet_id);
	    		});
			}
    		
    	});
    	Bootstrap_Builder.modal_resize();
    },'json');
};

Portfolio_Portlet_Class.prototype.portlet_portfolio_delete_action = function (portlet_id,portfolio_id){
	var _this = this;
	$.post('zoozoo-builder.php?action=load-plugin&project-theme='+$('#project-theme').val()+'&plugin=portfolio&portlet-id='+portlet_id+'&method=delete&portfolio-id='+portfolio_id,function(html){
		_this.portfolio_message = 'The portfolio has been deleted successfully';
		_this.portlet_portfolio_index_action(portlet_id);
	});
};

/************ Portfolio Category ********************/


Portfolio_Portlet_Class.prototype.portlet_portfolio_category_index_action = function (portlet_id,s_name,page_index){
	$('#portlets_modal').find('#portlets_modal_label').html('Portfolios');
	var _this = this;
	s_name = (s_name !=undefined && s_name != '')?'&s_name='+ s_name:'';
	page_index = (page_index !=undefined && page_index != '')?'&page-index='+ page_index:'';
	$.get('zoozoo-builder.php?action=load-plugin&project-theme='+$('#project-theme').val()+'&plugin=portfolio&portlet-id='+portlet_id+'&method=category_index'+s_name+page_index,function(html){
		$('#portfolio-portlet-container #porfolio-category-tab').html(html);
		if (_this.portfolio_message != ''){
			$('#portfolio-portlet-container #porfolio-category-tab').prepend('<div role="alert" class="alert alert-success alert-dismissible fade in" style="margin:10px 0;"> <button aria-label="Close" data-dismiss="alert" class="close" type="button"><span aria-hidden="true">×</span></button>'+_this.portfolio_message+' </div>');
		}
    	$('#portfolio-portlet-container #porfolio-category-tab #add-new-portfolio-category').click(function(){
    		_this.portlet_portfolio_category_add_action(portlet_id);
    	});
    	
    	$('#portfolio-portlet-container #porfolio-category-tab .edit-portfolio-category').click(function(){
    		var category_id = $(this).data('id');
    		_this.portlet_portfolio_category_edit_action(portlet_id,category_id);
    	});
    	
    	$('#portfolio-portlet-container #porfolio-category-tab .delete-portfolio-category').click(function(){
    		var category_id = $(this).data('id');
    		if (confirm('Are you sure to delete this portfolio?')){
    			_this.portlet_portfolio_category_delete_action(portlet_id,category_id);
    		}
    	});
    	
    	$('#portfolio-portlet-container #porfolio-category-tab #portfolio-category-search').click(function(){
    		var s_name = $('#portfolio-portlet-container #porfolio-category-tab #s_name').val();
    		_this.portlet_portfolio_category_index_action(portlet_id,s_name);
    	});
    	
    	$('#portfolio-portlet-container #porfolio-category-tab #s_name').keypress(function(e) {
    	    if(e.which == 13) {
    	    	var s_name = $('#portfolio-portlet-container #porfolio-category-tab #s_name').val();
        		_this.portlet_portfolio_category_index_action(portlet_id,s_name);
        		e.preventDefault();
    	    }
    	});
    	
    	$('#portfolio-portlet-container #porfolio-category-tab .portfolio-category-pagination').click(function(e) {
    		var s_name = $('#portfolio-portlet-container #porfolio-category-tab #s_name').val();
    		var page_index = $(this).data('page-index');
    		_this.portlet_portfolio_category_index_action(portlet_id,s_name,page_index);
    		e.preventDefault();
    	});
    	_this.portfolio_message = '';
    });
};

Portfolio_Portlet_Class.prototype.portlet_portfolio_category_add_action = function (portlet_id){
	$('#portlets_modal').find('#portlets_modal_label').html('Add new portfolio category');
	var _this = this;
	$.get('zoozoo-builder.php?action=load-plugin&project-theme='+$('#project-theme').val()+'&plugin=portfolio&portlet-id='+portlet_id+'&method=category_add',function(html){
    	$('#portfolio-portlet-container #porfolio-category-tab').html(html);
    	
    	$('#portfolio-portlet-container #porfolio-category-tab #add-new-portfolio-category-cancel').click(function(){
    		_this.portlet_portfolio_category_index_action(portlet_id);
    	});
    	
    	$('#portfolio-portlet-container #porfolio-category-tab #add-new-portfolio-category-save').click(function(){
    		var category = {};
    		category.id = Bootstrap_Builder.guid();
    		category.name = $('#portlets_modal #category-name').val();
    		category.status = $('#portlets_modal #category-status').val();

			if (_this.portlet_portfolio_category_validation(category)){
				$.post('zoozoo-builder.php?action=load-plugin&project-theme='+$('#project-theme').val()+'&plugin=portfolio&portlet-id='+portlet_id+'&method=category_add',{category:category},function(html){
					_this.portfolio_message = 'The portfolio category has been added successfully';
					_this.portlet_portfolio_category_index_action(portlet_id);
				});
			}
    	});
    });
};

Portfolio_Portlet_Class.prototype.portlet_portfolio_category_validation = function (category){
	var validated = true;
	if (category.name == undefined || category.name == ''){
		if ($('#portlets_modal #category-name').parent().parent().hasClass('has-error') == false){
			$('#portlets_modal #category-name').parent().parent().addClass('has-error');
			$('#portlets_modal #category-name').parent().append('<span class="help-block error-message">The title field is required.</span>');
		}
		validated = false;
	}else{
		$('#portlets_modal #category-name').parent().parent().removeClass('has-error');
		$('#portlets_modal #category-name').parent().children('.error-message').remove();
	}
	
	
	return validated;
};


Portfolio_Portlet_Class.prototype.portlet_portfolio_category_edit_action = function (portlet_id,category_id){
	$('#portlets_modal').find('#portlets_modal_label').html('Edit portfolio');
	var _this = this;
	$.get('zoozoo-builder.php?action=load-plugin&project-theme='+$('#project-theme').val()+'&plugin=portfolio&portlet-id='+portlet_id+'&method=category_edit&category-id='+category_id,function(json){
    	$('#portfolio-portlet-container #porfolio-category-tab').html(json.html);
    	
    	var category = json.category;
    	$('#portlets_modal #category-name').val(category.name);
		$('#portlets_modal #category-status').val(category.status);
    	
    	$('#portfolio-portlet-container #porfolio-category-tab #edit-portfolio-category-cancel').click(function(){
    		_this.portlet_portfolio_category_index_action(portlet_id);
    	});
    	
    	$('#portfolio-portlet-container #porfolio-category-tab #edit-portfolio-category-save').click(function(){
    		var category = {};
    		category.id = category_id;
    		category.name = $('#portlets_modal #category-name').val();
    		category.status = $('#portlets_modal #category-status').val();

			if (_this.portlet_portfolio_category_validation(category)){
	    		$.post('zoozoo-builder.php?action=load-plugin&project-theme='+$('#project-theme').val()+'&plugin=portfolio&portlet-id='+portlet_id+'&method=category_edit&category-id='+category_id,{category:category},function(html){
	    			_this.portfolio_message = 'The portfolio has been updated successfully';
	    			_this.portlet_portfolio_category_index_action(portlet_id);
	    		});
			}
    		
    	});
    },'json');
};

Portfolio_Portlet_Class.prototype.portlet_portfolio_category_delete_action = function (portlet_id,category_id){
	var _this = this;
	$.post('zoozoo-builder.php?action=load-plugin&project-theme='+$('#project-theme').val()+'&plugin=portfolio&portlet-id='+portlet_id+'&method=category_delete&category-id='+category_id,function(html){
		_this.portfolio_message = 'The portfolio category has been deleted successfully';
		_this.portlet_portfolio_category_index_action(portlet_id);
	});
};


var Portfolio_Portlet = new Portfolio_Portlet_Class();