/*
 * portlet: navbar
 * portlet-type: navbar 
 * portlet-group: advance
 * portlet-name: <i class="fa fa-bars"></i> Navbar
 * portlet-image: assets/images/no-image.png
 * portlet-asset-js: plugins/navbar/assets/js/navbar-portlet.js
 * portlet-asset-js: plugins/navbar/assets/sticky-1.0.3/jquery.sticky.min.js
 * portlet-asset-js: plugins/navbar/assets/js/jquery.easing.1.3.min.js
 * portlet-asset-js: plugins/navbar/assets/js/anchor-scroll.js
 */
Navbar_Portlet_Class = function(){
	this.file_list = {};
	this.items = [];
	this.toolbar_name = 'Navbar';
}
$.extend(Navbar_Portlet_Class.prototype, Abstract_Portlet_Class.prototype);
Navbar_Portlet_Class.prototype.advance_render = function(portlet_id,content){
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
	var div = $('<div></div>');
	var css = {};
	if (portlet.style != undefined && $.isEmptyObject(portlet.style) == false){
		$.each( portlet.style, function( name, value ) {
			if ($.trim(value) != ''){
				if (name.indexOf("margin-") != -1 || name.indexOf("padding-") != -1 || name.indexOf("-width") != -1){
					css[name] = value + 'px';
				}else{
					css[name] = value;
				}
			}
		});
		div.css(css);
	}
	
	if (portlet.attr != undefined && $.isEmptyObject(portlet.attr) == false){
		$.each( portlet.attr, function( name, value ) {
			if ($.trim(value) != ''){
				div.attr(name,value);
			}
		});
	}
	div.append(content);
	
	$('#'+portlet_id).css({zIndex:50});
	
	return div;
};

Navbar_Portlet_Class.prototype.menu_builder_render = function(ol,menus,edit_item){
	var _this = this;
	if (edit_item == undefined){
		edit_item = {};
	}
		
	if (menus.length > 0){
	    for(var i = 0; i < menus.length; i++){
	        var menu = menus[i];
	        if (edit_item.id != undefined && edit_item.id == menu.id){
		        if (menu.children != undefined){
			        edit_item.children = menu.children;
		        }
		        menu = edit_item;
	        }
	        var li = $('<li></li>')
	        .addClass('dd-item').addClass('dd3-item')
	        .attr('id',menu.id)
	        .attr('data-id',menu.id)
	        .attr('data-item_id',menu.id)
	        .attr('data-item_name',menu.item_name)
	        .attr('data-item_page',menu.item_page)
	        .attr('data-item_link',menu.item_link)
	        .attr('data-item_type',menu.item_type)
	        .attr('data-item_anchor',menu.item_anchor);
	        if (menu.item_activated != undefined && menu.item_activated != null){
	        	li.attr('data-item_activated',menu.item_activated);
	        }else{
	        	li.attr('data-item_activated','no');
	        }
	        var div = $('<div></div>').addClass('dd-handle').addClass('dd3-handle').html('&nbsp;');
	        li.append(div);
	        var content = $('<div></div>').text(menu.item_name);
	        content.css('position','relative');
	        content
	        .append(
        		$('<i class="fa fa-pencil fa-lg"></i>')
        		.data('id',menu.id)
		        .data('item_id',menu.id)
		        .data('item_name',menu.item_name)
		        .data('item_page',menu.item_page)
		        .data('item_link',menu.item_link)
		        .data('item_type',menu.item_type)
		        .data('item_anchor',menu.item_anchor)
		        .data('item_activated',((menu.item_activated != undefined && menu.item_activated != null)?menu.item_activated:'no'))
        		.css({position:'absolute',right:'20px',top:'5px',color:'#0aaec4',left:'initial',marginRight:'0px',cursor:'pointer'})
        		.click(function(){
        			var item = $(this).data();
        			$('#portlets_modal #edit-item-container #item-id').val(item.id);
        			$('#portlets_modal #edit-item-container #item-name').val(item.item_name);
            		$('#portlets_modal #edit-item-container #item-page').val(item.item_page);
            		$('#portlets_modal #edit-item-container #item-link').val(item.item_link);
            		$('#portlets_modal #edit-new-item-url-container #item-anchor').val(item.item_anchor);
            		if (item.item_type != undefined && item.item_type != ''){
            			$('#portlets_modal #edit-item-container #item-type').val(item.item_type);
            			$('#portlets_modal #edit-new-item-url-container a[href="#e-'+item.item_type+'-tab"]').tab('show');
            		}
            		
            		$('#portlets_modal .menu-item-container').hide();
        			$('#portlets_modal #edit-item-container').show();
            		if (item.item_activated != undefined && item.item_activated != null){
            			$('#portlets_modal #edit-item-container input[name="item-e-activated"]').removeAttr('checked');
            			$('#portlets_modal #edit-item-container input[name="item-e-activated"]').each(function(){
            				var value = $(this).val();
            				if (value == item.item_activated){
            					$(this).prop('checked', true);
            				}
            			});
                    }
            		
        			
        		})
    		)
	        .append(
        		$('<i class="delete-menu-item fa fa-times fa-lg"></i>')
        		.data('id',menu.id)
        		.css({position:'absolute',right:'0px',top:'5px',color:'#ee5190',left:'initial',marginRight:'0px',cursor:'pointer'})
        		.click(function(){
        			var item_id = $(this).data('id');
        			$('#portlets_modal #delete-item-container #item-id').val(item_id);
        			$('#portlets_modal .menu-item-container').hide();
        			$('#portlets_modal #delete-item-container').show();
        		})
    		);
	        li.append($('<div></div>').addClass('dd3-content').append(content));
	        if (menu.children != undefined && menu.children.length > 0){
		        var col = $('<ol></ol>').addClass('dd-list');
		        li.append(col);
		        _this.menu_builder_render(col,menu.children,edit_item);
	        }
	        ol.append(li);
	    }
	}
};

Navbar_Portlet_Class.prototype.menu2html = function (portlet_id, items, mnu_class){
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
	var _this = this;
	if (mnu_class == undefined){
		if (portlet.nav_alignment == undefined || (portlet.nav_alignment != undefined && portlet.nav_alignment == 'right')){
			mnu_class = 'nav navbar-nav navbar-right';
		}else{
			mnu_class = 'nav navbar-nav';
		}
	}
	
	var ul = $('<ul class="'+mnu_class+'"></ul>');
	$.each(items,function(k,v){
		var li = $('<li></li>');
		if (v.item_activated != undefined && v.item_activated == 'yes'){
			li.addClass('active');
		}
		var a = $('<a></a>').addClass('bg-hover-color').html(v.item_name);
		if (v.item_type == 'page'){
			var html_file = (_this.file_list[v.item_page] != undefined)?_this.file_list[v.item_page]:{file_name:''};
			if (html_file.file_name != ''){
				a.attr('href',html_file.file_name+'.html');
			}else{
				a.attr('href','#');
			}
		}else if(v.item_type == 'link'){
			a.attr('href',v.item_link);
		}else if(v.item_type == 'anchor'){
			a.attr('href','#'+v.item_anchor);
			li.addClass('anchor-scroll');
		}
		li.append(a);
		if (v.children != undefined){
			a.attr('data-toggle','dropdown')
			.addClass('dropdown-toggle')
			.append(' <b class="caret"></b>');
			li.addClass('dropdown');
			li.append(_this.menu2html(portlet_id,v.children,'dropdown-menu'));
		}
		ul.append(li);
	})
	
	return ul;
};

Navbar_Portlet_Class.prototype.portlet_save = function (portlet_id,modal_hide,toolbar){
	toolbar = (toolbar != undefined)?true:false;
	var _this = this;
	modal_hide = (modal_hide == undefined)?true:modal_hide;
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
	
	Bootstrap_Builder.change_flag = true;
	window.onbeforeunload = function(e) {
        var message = 'Data you have entered may not be saved. ';
        e.returnValue  = message;
        return message;
    }
	var sortable_id = $('#portlets_modal').data('sortable-id');
	if (toolbar == false){
		portlet.logo_link = $('#portlets_modal #logo-link').val();
		portlet.logo_title = $('#portlets_modal #logo-title').val();
		portlet.logo_sub_title = $('#portlets_modal #logo-sub-title').val();
		portlet.nav_type = $('#portlets_modal #nav-type').val();
		portlet.nav_alignment = $('#portlets_modal input[name="nav-alignment"]:checked').val();
		portlet.nav_scrollspy = $('#portlets_modal input[name="nav-scrollspy"]:checked').val();
		_this.items = $('#portlets_modal #menu_builder').nestable('serialize');
		portlet.items = _this.items;
		var fields = $("#portlets_modal .portlet-style" ).serializeArray();
	    var style = {};
	    $.each( fields, function( i, field ) {
	    	style[field.name] = field.value;
	    });
	    portlet.style = style;
	    
	    fields = $("#portlets_modal .portlet-attr" ).serializeArray();
	    var attr = {};
	    $.each( fields, function( i, field ) {
	    	attr[field.name] = field.value;
	    });
	    portlet.attr = attr;
	}
    
	var value = $('<div></div>').append(_this.menu2html(portlet_id,portlet.items)).html();
	$.get('zoozoo-builder.php?action=load-plugin-file&project-theme='+$('#project-theme').val()+'&plugin=navbar&file=navbar-template.html',function(html){
		value = html.replace("{{navbar-menu}}", value);
		
		value = value.replace("{{logo-link}}", portlet.logo_link);
		if ($.trim(portlet.logo_link) == ''){
			value = value.replace("{{logo-image-display}}", 'display:none;');
		}else{
			value = value.replace("{{logo-image-display}}", '');
		}
		value = value.replace("{{logo-title}}", portlet.logo_title);
		value = value.replace("{{logo-sub-title}}", portlet.logo_sub_title);
		
		if (portlet.nav_type != undefined && portlet.nav_type != ''){
			value = value.replace("{{nav_type}}", portlet.nav_type);
		}else{
			value = value.replace("{{nav_type}}", 'default');
		}
		if (portlet.nav_scrollspy != undefined && portlet.nav_scrollspy == 'yes'){
			value = value.replace("{{scrollspy}}", "<input type='hidden' id='bhb-navbar-scrollspy' value ='1'>");
		}else{
			value = value.replace("{{scrollspy}}", "<input type='hidden' id='bhb-navbar-scrollspy' value ='0'>");
		}
		
		_this.portlet_render(portlet_id,sortable_id,value,modal_hide);
	});
}

Navbar_Portlet_Class.prototype.portlet_modal = function (portlet_id){
	var _this = this;
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
	
	$('#portlets_modal').find('#portlets_modal_label').html('Navbar');
    $('#portlets_modal').find('#portlets_modal_body').empty();
    $('#portlets_modal').find('#portlets_modal_body')
    .after(
       $('<div></div>')
       .attr('id','portlets_modal_footer')
       .addClass('modal-footer')
       .append(
            $('<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>')     
       )
       .append(
            $('<button type="button" class="btn btn-primary">Apply</button>')
            .click(function(){
            	_this.portlet_save(portlet_id,false);
            })
       )
       .append(
            $('<button type="button" class="btn btn-primary">Save & close</button>')
            .click(function(){
            	_this.portlet_save(portlet_id);
            })
       )
    );
    
    // render row setting form
    $('#portlets_modal').find('#portlets_modal_body').load('zoozoo-builder.php?action=load-plugin-file&project-theme='+$('#project-theme').val()+'&plugin=navbar&file=navbar-portlet.html',function(){
    	Bootstrap_Builder.tab_modal_resize();
    	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
    	
    	if (portlet.logo_title != undefined && portlet.logo_title != ''){
    		$('#portlets_modal #logo-title').val(portlet.logo_title);
    	}
    	
    	if (portlet.logo_sub_title != undefined && portlet.logo_sub_title){
    		$('#portlets_modal #logo-sub-title').val(portlet.logo_sub_title);
    	}
    	
    	if (portlet.nav_type != undefined && portlet.nav_type){
    		$('#portlets_modal #nav-type').val(portlet.nav_type);
    	}
    	
    	if (portlet.nav_alignment != undefined && portlet.nav_alignment != null){
        	$('#portlets_modal input[name="nav-alignment"][value="'+portlet.nav_alignment+'"]').attr('checked','checked');
        }
    	
    	if (portlet.nav_scrollspy != undefined && portlet.nav_scrollspy != null){
        	$('#portlets_modal input[name="nav-scrollspy"][value="'+portlet.nav_scrollspy+'"]').attr('checked','checked');
        }
    	
    	
    	if (portlet.logo_link != undefined && portlet.logo_link != ''){
    		$('#portlets_modal #logo-file-frame > #logo-upload-text').hide();
    		$('#portlets_modal #logo-file-frame-preview').attr('src',portlet.logo_link).show();
    		$('#portlets_modal #logo-link').val(portlet.logo_link);
    		$('#portlets_modal #btn-logo-delete').show();
    	}
    	
    	$('#portlets_modal #logo-file').fileupload({
	        url: 'zoozoo-builder.php?action=upload-image&field-name=logo-file',
	        dataType: 'json',
	        done: function (e, data) {
	        	var file = data.result;
	        	if (file.logo_file != undefined){
	        		$('#portlets_modal #logo-file-frame > #logo-upload-text').hide();
	        		$('#portlets_modal #logo-file-frame-preview').attr('src',file.logo_file).show();
	        		$('#portlets_modal #logo-link').val(file.logo_file);
	        	}
	        	$('#portlets_modal #logo-upload-progress-bar').css('width','0px');
	        	$('#portlets_modal #btn-logo-delete').show();
	        },
	        progressall: function (e, data) {
	            var progress = parseInt(data.loaded / data.total * 100, 10);
	            $('#portlets_modal #logo-upload-progress-bar').css('width',progress + '%');
	        }
	    });
    	
    	_this.items = (portlet.items != undefined)?portlet.items:[];
    	_this.menu_builder_render($('#menu_builder > ol'),_this.items);
    	$('#portlets_modal #menu_builder').nestable();
    	$('#portlets_modal #add-new-item-container #add-new-item').click(function(){
    		var item = {};
    		item.id = Bootstrap_Builder.guid();
    		item.item_name = $('#portlets_modal #add-new-item-container #item-name').val();
    		item.item_page = $('#portlets_modal #add-new-item-container #item-page').val();
    		item.item_link = $('#portlets_modal #add-new-item-container #item-link').val();
    		item.item_anchor = $('#portlets_modal #add-new-item-container #item-anchor').val();
    		item.item_type = $('#portlets_modal #add-new-item-container #item-type').val();
    		
    		item.item_activated = $('#portlets_modal input[name="item-activated"]:checked').val();
    		
    		_this.items = $('#portlets_modal #menu_builder').nestable('serialize');
    		_this.items[_this.items.length] = item;
	    	
    		var parent = $('#portlets_modal #menu_builder').parent();
    		$('#portlets_modal #menu_builder').remove();
    		parent.append($('<div id="menu_builder"></div>').addClass('dd'));
    		$('#portlets_modal #menu_builder').append('<ol class="dd-list"></ol>');
    		_this.menu_builder_render($('#portlets_modal #menu_builder > ol'),_this.items);
    		$('#portlets_modal #menu_builder').nestable();
    		$('#portlets_modal form')[0].reset();
    		Bootstrap_Builder.modal_resize();
    	});
    	
    	$('#add-new-item-url-container a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
    		$('#portlets_modal #add-new-item-container #item-type').val($(this).data('type'));
		});
    	$('#edit-new-item-url-container a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
    		$('#portlets_modal #edit-new-item-url-container #item-type').val($(this).data('type'));
		});
    	
    	$.each(Anchor_Portlet.anchors,function(k,v){
    		$('#add-new-item-url-container #item-anchor').append($('<option></option').attr('value',k).text(v));
    		$('#edit-new-item-url-container #item-anchor').append($('<option></option').attr('value',k).text(v));
    	});
    	
    	$('#portlets_modal #edit-item-container #btn-update-item').click(function(){
    		var item = {};
    		item.id = $('#portlets_modal #edit-item-container #item-id').val();
    		item.item_name = $('#portlets_modal #edit-item-container #item-name').val();
    		item.item_page = $('#portlets_modal #edit-item-container #item-page').val();
    		item.item_link = $('#portlets_modal #edit-item-container #item-link').val();
    		item.item_anchor = $('#portlets_modal #edit-item-container #item-anchor').val();
    		item.item_type = $('#portlets_modal #edit-new-item-url-container #item-type').val();
    		
    		item.item_activated = $('#portlets_modal input[name="item-e-activated"]:checked').val();
    		
    		var parent = $('#portlets_modal #menu_builder').parent();
    		_this.items = $('#portlets_modal #menu_builder').nestable('serialize');
    		$('#portlets_modal #menu_builder').remove();
    		parent.append($('<div id="menu_builder"></div>').addClass('dd'));
    		$('#portlets_modal #menu_builder').append('<ol class="dd-list"></ol>');
    		_this.menu_builder_render($('#portlets_modal #menu_builder > ol'),_this.items,item);
    		$('#portlets_modal #menu_builder').nestable();
    		$('#portlets_modal form')[0].reset();
    		$('#portlets_modal .menu-item-container').hide();
    		$('#portlets_modal #add-new-item-container').show();
    	});
    	
    	
    	$('#portlets_modal #delete-item-container #btn-delete-item').click(function(){
    		$('#portlets_modal  #'+$('#portlets_modal #delete-item-container #item-id').val()).remove();
    		$('#portlets_modal form')[0].reset();
    		$('#portlets_modal .menu-item-container').hide();
    		$('#portlets_modal #add-new-item-container').show();
    	});
    	var project_id = $('#project-id').val();
    	$.get('zoozoo-builder.php',{action:'file-list','project-id':project_id},function(json){
    		_this.file_list = json;
    		if (_this.file_list != undefined && _this.file_list != null){
	    		$.each(_this.file_list,function(k,v){
	    			$('#portlets_modal #item-page').append(
						$('<option></option>')
						.attr('value',v.id)
						.append(v.file_name + '.html')
					);
	    		});
    		}
    	},'json');
    	
    	if (portlet.style != undefined){
	    	$.each( portlet.style, function( name, value ) {
	    		if ($.trim(value) != ''){
		    		if (name != 'border-color' && name != 'background-color' && name != 'color'){
		    			$('#portlets_modal #'+ name).val(value);
		    		}else{
		    			$('#portlets_modal .'+ name+'-picker').colorpicker('setValue', value);
		    		}
	    		}
	    		
	    	});
        }
        if (portlet.attr != undefined){
	    	$.each( portlet.attr, function( name, value ) {
	    		if ($.trim(value) != ''){
	    			$('#portlets_modal #'+ name).val(value);
	    		}
	    		
	    	});
        }
        Bootstrap_Builder.modal_resize();
    });
    // end render row setting form
};

var Navbar_Portlet = new Navbar_Portlet_Class();