/*
 * portlet: image
 * portlet-type: image 
 * portlet-group: media
 * portlet-name: <i class="fa fa-file-image-o" ></i> Image
 * portlet-image: assets/images/no-image.png
 */
Image_Portlet_Class = function(){
	this.toolbar_name = 'Image';
}
$.extend(Image_Portlet_Class.prototype, Abstract_Portlet_Class.prototype);
Image_Portlet_Class.prototype.advance_render = function(portlet_id,content){
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
	var div = $('<div></div>');
	var css = {};
	if (portlet.style != undefined && $.isEmptyObject(portlet.style) == false){
		$.each( portlet.style, function( name, value ) {
			if ($.trim(value) != ''){
				if (name.indexOf("margin-") != -1 || name.indexOf("padding-") != -1 || name.indexOf("-width") != -1){
					css[name] = value + 'px';
				}else{
					css[name] = value;
				}
			}
		});
		div.css(css);
	}
	
	if (portlet.attr != undefined && $.isEmptyObject(portlet.attr) == false){
		$.each( portlet.attr, function( name, value ) {
			if ($.trim(value) != ''){
				div.attr(name,value);
			}
		});
	}
	
	if (portlet.image_alignment != ''){
		div.addClass('text-'+portlet.image_alignment);
	}
	
	div.append(content);
	
	return div;
};
Image_Portlet_Class.prototype.portlet_save = function (portlet_id,modal_hide,toolbar){
	toolbar = (toolbar != undefined)?true:false;
	var _this = this;
	modal_hide = (modal_hide == undefined)?true:modal_hide;
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
	Bootstrap_Builder.change_flag = true;
	window.onbeforeunload = function(e) {
        var message = 'Data you have entered may not be saved. ';
        e.returnValue  = message;
        return message;
    }
    var sortable_id = $('#portlets_modal').data('sortable-id');
    if (toolbar == false){
	    var fields = $("#portlets_modal .portlet-style" ).serializeArray();
	    var style = {};
	    $.each( fields, function( i, field ) {
	    	style[field.name] = field.value;
	    });
	    portlet.style = style;
	    
	    fields = $("#portlets_modal .portlet-attr" ).serializeArray();
	    var attr = {};
	    $.each( fields, function( i, field ) {
	    	attr[field.name] = field.value;
	    });
	    portlet.attr = attr;
	    
	    portlet.image_link = $('#portlets_modal #image-link').val();
	    portlet.image_width = $.trim($('#portlets_modal #image-width').val());
	    portlet.image_height = $.trim($('#portlets_modal #image-height').val());
	    portlet.image_alignment = $('#portlets_modal #image-alignment').val();
	    portlet.image_style = $('#portlets_modal #image-style').val();
    }
    var image_div = $('<div></div>')
    var image_tag = $('<img>');
    if (portlet.image_link != ''){
    	image_tag.attr('src',portlet.image_link);
    }
    
    if (portlet.image_width == '' && portlet.image_height == ''){
    	image_tag.addClass('img-responsive');
    }else{
    	if (portlet.image_width != ''){
    		image_tag.css('width',portlet.image_width+'px');
    	}
    	if (portlet.image_height != ''){
    		image_tag.css('height',portlet.image_height+'px');
    	}
    }
    
    if (portlet.image_style != ''){
    	image_tag.addClass('img-'+portlet.image_style);
    }
    image_div.append(image_tag);
    var value = image_div.html();
    _this.portlet_render(portlet_id,sortable_id,value,modal_hide);
};

Image_Portlet_Class.prototype.portlet_modal = function (portlet_id){
	var _this = this;
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
    
    $('#portlets_modal').find('#portlets_modal_label').html('Image');
    $('#portlets_modal').find('#portlets_modal_body').empty();
    
    // render footer button.
    $('#portlets_modal').find('#portlets_modal_body')
    .after(
       $('<div></div>')
       .attr('id','portlets_modal_footer')
       .addClass('modal-footer')
       .append(
            $('<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>')     
       )
       .append(
            $('<button type="button" class="btn btn-primary">Apply</button>')
            .click(function(){
            	_this.portlet_save(portlet_id,false);
            })
       )
       .append(
            $('<button type="button" class="btn btn-primary">Save & close</button>')
            .click(function(){
            	_this.portlet_save(portlet_id);
            })
       )
    );
    // end render footer button.
    
    // render portlet design tab
    $('#portlets_modal').find('#portlets_modal_body').load('zoozoo-builder.php?action=load-plugin-file&project-theme='+$('#project-theme').val()+'&plugin=image&file=image-portlet.html',function(){
    	Bootstrap_Builder.tab_modal_resize();
    	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
    	
    	if (portlet.image_link != undefined && portlet.image_link != ''){
    		$('#portlets_modal #image-file-frame > #image-upload-text').hide();
    		$('#portlets_modal #image-file-frame-preview').attr('src',portlet.image_link).show();
    		$('#portlets_modal #image-link').val(portlet.image_link);
    	}
        
    	if (portlet.image_width != undefined && portlet.image_width != ''){
    		$('#portlets_modal #image-width').val(portlet.image_width);
    	}
    	
    	if (portlet.image_height != undefined && portlet.image_height != ''){
    		$('#portlets_modal #image-height').val(portlet.image_height);
    	}
    	
    	if (portlet.image_alignment != undefined && portlet.image_alignment != ''){
    		$('#portlets_modal #image-alignment').val(portlet.image_alignment);
    	}
    	
    	if (portlet.image_style != undefined && portlet.image_style != ''){
    		$('#portlets_modal #image-style').val(portlet.image_style);
    	}
    	
    	 $('#portlets_modal #image-file').fileupload({
	        url: 'zoozoo-builder.php?action=upload-image',
	        dataType: 'json',
	        done: function (e, data) {
	        	var file = data.result;
	        	if (file.image_file != undefined){
	        		$('#portlets_modal #image-file-frame > #image-upload-text').hide();
	        		$('#portlets_modal #image-file-frame-preview').attr('src',file.image_file).show();
	        		$('#portlets_modal #image-link').val(file.image_file);
	        	}
	        	$('#portlets_modal #image-upload-progress-bar').css('width','0px');
	        },
	        progressall: function (e, data) {
	            var progress = parseInt(data.loaded / data.total * 100, 10);
	            $('#portlets_modal #image-upload-progress-bar').css('width',progress + '%');
	        }
	    });
    	
        if (portlet.style != undefined){
	    	$.each( portlet.style, function( name, value ) {
	    		if ($.trim(value) != ''){
		    		if (name != 'border-color' && name != 'background-color' && name != 'color'){
		    			$('#portlets_modal #'+ name).val(value);
		    		}else{
		    			$('#portlets_modal .'+ name+'-picker').colorpicker('setValue', value);
		    		}
	    		}
	    		
	    	});
        }
        if (portlet.attr != undefined){
	    	$.each( portlet.attr, function( name, value ) {
	    		if ($.trim(value) != ''){
	    			$('#portlets_modal #'+ name).val(value);
	    		}
	    		
	    	});
        }
        
        Bootstrap_Builder.modal_resize();
    });
    // end render row setting form
};

var Image_Portlet = new Image_Portlet_Class();

