/*
 * portlet: icon
 * portlet-type: icon 
 * portlet-group: media
 * portlet-name: Icon
 * portlet-image: assets/images/no-image.png
 */
Icon_Portlet_Class = function(){
    this.toolbar_name = 'Icon';
};
$.extend(Icon_Portlet_Class.prototype, Abstract_Portlet_Class.prototype);
Icon_Portlet_Class.prototype.advance_render = function(portlet_id,content){
    var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
    var div = $('<div></div>');
    var css = {};
    if (portlet.style != undefined && $.isEmptyObject(portlet.style) == false){
        $.each( portlet.style, function( name, value ) {
            if ($.trim(value) != ''){
                if (name.indexOf("margin-") != -1 || name.indexOf("padding-") != -1 || name.indexOf("-width") != -1){
                    css[name] = value + 'px';
                }else{
                    css[name] = value;
                }
            }
        });
        div.css(css);
    }
    
    if (portlet.attr != undefined && $.isEmptyObject(portlet.attr) == false){
        $.each( portlet.attr, function( name, value ) {
            if ($.trim(value) != ''){
                div.attr(name,value);
            }
        });
    }
    $('#'+portlet_id).css({display:'block'});
	div.css({display:'block',marginRight:'0px'});
    switch (portlet.icon_alignment){
		case 'left':
			div.css({textAlign:'left'});
			break;
		case 'right':
			div.css({textAlign:'right'});
			break;
		case 'center':
			div.css({textAlign:'center'});
			break;
		case 'inline':
			$('#'+portlet_id).css({display:'inline-block'});
			div.css({display:'inline-block',marginRight:'5px'});
			break;
	}
    
    div.append(content);
    
    return div;
};
Icon_Portlet_Class.prototype.portlet_save = function (portlet_id,modal_hide,toolbar){
	toolbar = (toolbar != undefined)?true:false;
	var _this = this;
	modal_hide = (modal_hide == undefined)?true:modal_hide;
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
    Bootstrap_Builder.change_flag = true;
    window.onbeforeunload = function(e) {
        var message = 'Data you have entered may not be saved. ';
        e.returnValue  = message;
        return message;
    }
    var sortable_id = $('#portlets_modal').data('sortable-id');
    if (toolbar == false){
	    var fields = $("#portlets_modal .portlet-style" ).serializeArray();
	    var style = {};
	    $.each( fields, function( i, field ) {
	        style[field.name] = field.value;
	    });
	    portlet.style = style;
	    
	    fields = $("#portlets_modal .portlet-attr" ).serializeArray();
	    var attr = {};
	    $.each( fields, function( i, field ) {
	        attr[field.name] = field.value;
	    });
	    portlet.attr = attr;
	    
	    portlet.icon = $('#portlets_modal #icon').val();
	    portlet.icon_color = $('#portlets_modal #icon-color').val();
	    portlet.icon_background_shape = $('#portlets_modal #icon-background-shape').val(); 
	    portlet.icon_size = $('#portlets_modal #icon-size').val();
	    portlet.icon_background_color = $('#portlets_modal #icon-background-color').val();
	    portlet.icon_alignment = $('#portlets_modal #icon-alignment').val(); 
	    
	    portlet.icon_link_flag = $('#portlets_modal input[name="icon-link-flag"]:checked').val();
	    portlet.icon_link_page = $('#portlets_modal #icon-link-page').val();
	    portlet.icon_link_text = $('#portlets_modal #icon-link-text').val();
    }
    var div_icon = $('<div></div>');
    var div_height = '';
    var div_width = '';
    var div_line_height = '';
    var icon_font_size = '';
    switch (portlet.icon_size){
	    case 'mini':
			div_height = '2.4em';
	    	div_width = '2.4em';
	    	div_line_height = '1.1em';
	    	icon_font_size = '1.1em';
			break;
	    case 'small':
			div_height = '3em';
	    	div_width = '3em';
	    	div_line_height = '1.5em';
	    	icon_font_size = '1.5em';
			break;
    	case 'normal':
    		div_height = '3.8em';
	    	div_width = '3.8em';
	    	div_line_height = '2em';
	    	icon_font_size = '2em';
    		break;
    	case 'large':
    		div_height = '5em';
	    	div_width = '5em';
	    	div_line_height = '2.8em';
	    	icon_font_size = '2.8em';
    		break;
	    case 'extra-large':
	    	div_height = '7.2em';
	    	div_width = '7.2em';
	    	div_line_height = '4.8em';
	    	icon_font_size = '4.8em';
	    	break;
    };
    div_icon
    .css({
    	height: div_height,
    	width: div_width,
    	display:'inline-block',
    	lineHeight:div_line_height,
    	border:'2px solid transparent',
    	backgroundColor:portlet.icon_background_color,
    	position:'relative'
    })
    .append(
		$('<i class="'+portlet.icon+'"></i>')
		.css({
			position:'absolute',
			top:'50%',
			left:'50%',
			fontSize:icon_font_size,
			color:portlet.icon_color,
			transform:'translate(-50%,-50%)'
		})
    );
    
    switch (portlet.icon_background_shape){
	    case 'none':
	    	div_icon.css({backgroundColor:'transparent'});
	    	break;
		case 'circle':
			div_icon.css({borderRadius:'50%'});
			break;
		case 'square':
			break;
		case 'rounded':
			div_icon.css({borderRadius:'6px'});
			break;
		case 'outline-cricle':
			div_icon.css({borderRadius:'50%'});
			div_icon.css({backgroundColor:'transparent'});
			div_icon.css({borderColor:portlet.icon_background_color});
			break;
		case 'outline-squared':
			div_icon.css({backgroundColor:'transparent'});
			div_icon.css({borderColor:portlet.icon_background_color});
			break;
		case 'outline-rounded':
			div_icon.css({borderRadius:'6px'});
			div_icon.css({backgroundColor:'transparent'});
			div_icon.css({borderColor:portlet.icon_background_color});
			break;
    }
    
    if (portlet.icon_link_flag == 'yes'){
    	var icon_link_url = $.trim(portlet.icon_link_page) + '';
    	if (icon_link_url == ''){
    		icon_link_url = portlet.icon_link_text;
    	}else{
    		var object = (_this.file_list[icon_link_url] != undefined)?_this.file_list[icon_link_url]:'';
    		icon_link_url = object.file_name+'.html';
    	}
    	if (icon_link_url != ''){
    		div_icon = $('<a></a>').css({textDecoration:'none'}).attr('href',icon_link_url).append(div_icon);
    	}
    	
    }
    
    var value = $('<div></div').append(div_icon).html();
    
    _this.portlet_render(portlet_id,sortable_id,value,modal_hide);
};
Icon_Portlet_Class.prototype.portlet_modal = function (portlet_id){
    var _this = this;
    var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
    
    $('#portlets_modal').find('#portlets_modal_label').html('Icon');
    $('#portlets_modal').find('#portlets_modal_body').empty();
    
    // render footer button.
    $('#portlets_modal').find('#portlets_modal_body')
    .after(
       $('<div></div>')
       .attr('id','portlets_modal_footer')
       .addClass('modal-footer')
       .append(
            $('<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>')     
       )
       .append(
            $('<button type="button" class="btn btn-primary">Apply</button>')
            .click(function(){
            	_this.portlet_save(portlet_id,false);
            })
       )
       .append(
            $('<button type="button" class="btn btn-primary">Save & close</button>')
            .click(function(){
            	_this.portlet_save(portlet_id);
            })
       )
    );
    // end render footer button.
    
    // render portlet design tab
    $('#portlets_modal').find('#portlets_modal_body').load('zoozoo-builder.php?action=load-plugin-file&project-theme='+$('#project-theme').val()+'&plugin=icon&file=icon-portlet.html',function(){
        Bootstrap_Builder.tab_modal_resize();
        var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
        
        if (portlet.icon != undefined && portlet.icon != null){
        	$('#portlets_modal #icon').val(portlet.icon);
        	$('#portlets_modal #span-icon').empty();
        	$('#portlets_modal #span-icon').append($('<i></i>').addClass(portlet.icon).addClass('fa-lg'));
        }
        
        if (portlet.icon_color != undefined && portlet.icon_color != null && $.trim(portlet.icon_color) != ''){
        	$('#portlets_modal .icon-color-picker').colorpicker('setValue', portlet.icon_color);
        }
        
        if (portlet.icon_background_shape != undefined && portlet.icon_background_shape != null){
        	$('#portlets_modal #icon-background-shape').val(portlet.icon_background_shape);
        }
        
        if (portlet.icon_size != undefined && portlet.icon_size != null){
        	$('#portlets_modal #icon-size').val(portlet.icon_size);
        }
        
        if (portlet.icon_background_color != undefined && portlet.icon_background_color != null && $.trim(portlet.icon_background_color) != ''){
        	$('#portlets_modal .icon-background-color-picker').colorpicker('setValue', portlet.icon_background_color);
        }
        
        if (portlet.icon_alignment != undefined && portlet.icon_alignment != null){
        	$('#portlets_modal #icon-alignment').val(portlet.icon_alignment);
        }
        
        if (portlet.icon_link_flag != undefined && portlet.icon_link_flag != null){
        	var icon_link_flag = $('#portlets_modal input[name="icon-link-flag"][value="'+portlet.icon_link_flag+'"]');
        	icon_link_flag.attr('checked','checked');
    		if (icon_link_flag.val() == 'yes'){
        		$('#icon-url-link-container').show();
        	}else{
        		$('#icon-url-link-container').hide();
        	}
        }
        
        if (portlet.icon_link_text != undefined && portlet.icon_link_text != null){
        	$('#portlets_modal #icon-link-text').val(portlet.icon_link_text);
        }
        
        var project_id = $('#project-id').val();
        $.get('zoozoo-builder.php',{action:'file-list','project-id':project_id},function(json){
        	_this.file_list = json;
        	if (json != undefined && json != null){
	        	$.each(json,function(k,v){
	        		$('#portlets_modal #icon-link-page').append(
						$('<option></option>')
						.attr('value',v.id)
						.append(v.file_name + '.html')
					);
	    		});
        	}
        	if (portlet.icon_link_page != undefined && portlet.icon_link_page != null){
            	$('#portlets_modal #icon-link-page').val(portlet.icon_link_page);
            }
        },'json');
        
        if (portlet.style != undefined){
            $.each( portlet.style, function( name, value ) {
                if ($.trim(value) != ''){
                    if (name != 'border-color' && name != 'background-color' && name != 'color'){
                        $('#portlets_modal #'+ name).val(value);
                    }else{
                        $('#portlets_modal .'+ name+'-picker').colorpicker('setValue', value);
                    }
                }
                
            });
        }
        if (portlet.attr != undefined){
            $.each( portlet.attr, function( name, value ) {
                if ($.trim(value) != ''){
                    $('#portlets_modal #'+ name).val(value);
                }
                
            });
        }
        Bootstrap_Builder.modal_resize();
    });
    // end render row setting form
};

var Icon_Portlet = new Icon_Portlet_Class();

