/*
 * portlet: html-code
 * portlet-type: html-code 
 * portlet-group: common
 * portlet-name: <i class="fa fa-code"></i> Html Code
 * portlet-image: assets/images/no-image.png
 */
Html_Code_Portlet_Class = function(){
	this.toolbar_name = 'Html Code';
}
$.extend(Html_Code_Portlet_Class.prototype, Abstract_Portlet_Class.prototype);
Html_Code_Portlet_Class.prototype.advance_render = function(portlet_id,content){
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
	var div = $('<div></div>');
	div.append(content);
	
	return div;
};
Html_Code_Portlet_Class.prototype.portlet_save = function (portlet_id,modal_hide,toolbar){
	toolbar = (toolbar != undefined)?true:false;
	var _this = this;
	modal_hide = (modal_hide == undefined)?true:modal_hide;
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
	Bootstrap_Builder.change_flag = true;
	window.onbeforeunload = function(e) {
        var message = 'Data you have entered may not be saved. ';
        e.returnValue  = message;
        return message;
    }
	var sortable_id = $('#portlets_modal').data('sortable-id');
	
	var value;
	if (toolbar == false){
		value = Bootstrap_Builder.html_code_mirror.getValue();
	}else{
		value = portlet.content;
	}
	_this.portlet_render(portlet_id,sortable_id,value,modal_hide);
}
Html_Code_Portlet_Class.prototype.portlet_modal = function (portlet_id){
	var _this = this;
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
	
	$('#portlets_modal').find('#portlets_modal_label').html('Html code');
    $('#portlets_modal').find('#portlets_modal_body').empty();
    
    $('#portlets_modal').find('#portlets_modal_body')
    .after(
       $('<div></div>')
       .attr('id','portlets_modal_footer')
       .addClass('modal-footer')
       .append(
            $('<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>')     
       )
       .append(
            $('<button type="button" class="btn btn-primary">Apply</button>')
            .click(function(){
            	_this.portlet_save(portlet_id,false);
            })
       )
       .append(
            $('<button type="button" class="btn btn-primary">Save & close</button>')
            .click(function(){
            	_this.portlet_save(portlet_id);
            })
       )
    );
    
    // render row setting form
    $('#portlets_modal').find('#portlets_modal_body').load('zoozoo-builder.php?action=load-plugin-file&project-theme='+$('#project-theme').val()+'&plugin=html-code&file=html-code-portlet.html',function(){
    	Bootstrap_Builder.tab_modal_resize();
    	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
    	if (portlet.content != undefined && portlet.content != null){
        	$('#portlets_modal').find('#html-code-mirror').val(portlet.content);
        }
    	
    	Bootstrap_Builder.html_code_mirror = CodeMirror.fromTextArea(document.getElementById("html-code-mirror"), {
            lineNumbers: true,
            mode: "text/html",
            matchBrackets: true,
            scrollbarStyle: "simple" 
        });
    	
    	Bootstrap_Builder.modal_resize();
    });
    // end render row setting form
};

var Html_Code_Portlet = new Html_Code_Portlet_Class();