/*
 * portlet: google-map
 * portlet-type: google-map 
 * portlet-group: common
 * portlet-name: <i class="fa fa-map-marker"></i> Google Map
 * portlet-image: assets/images/no-image.png
 */
Google_Map_Portlet_Class = function(){
	this.toolbar_name = 'Google Map';
}
$.extend(Google_Map_Portlet_Class.prototype, Abstract_Portlet_Class.prototype);
Google_Map_Portlet_Class.prototype.advance_render = function(portlet_id,content){
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
	var div = $('<div></div>');
	var css = {};
	if (portlet.style != undefined && $.isEmptyObject(portlet.style) == false){
		$.each( portlet.style, function( name, value ) {
			if ($.trim(value) != ''){
				if (name.indexOf("margin-") != -1 || name.indexOf("padding-") != -1 || name.indexOf("-width") != -1){
					css[name] = value + 'px';
				}else{
					css[name] = value;
				}
			}
		});
		div.css(css);
	}
	
	if (portlet.attr != undefined && $.isEmptyObject(portlet.attr) == false){
		$.each( portlet.attr, function( name, value ) {
			if ($.trim(value) != ''){
				div.attr(name,value);
			}
		});
	}
	
	div.append(content);
	
	return div;
};
Google_Map_Portlet_Class.prototype.portlet_save = function (portlet_id,modal_hide,toolbar){
	toolbar = (toolbar != undefined)?true:false;
	var _this = this;
	modal_hide = (modal_hide == undefined)?true:modal_hide;
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
	Bootstrap_Builder.change_flag = true;
	window.onbeforeunload = function(e) {
        var message = 'Data you have entered may not be saved. ';
        e.returnValue  = message;
        return message;
    }
    var sortable_id = $('#portlets_modal').data('sortable-id');
    if (toolbar == false){
	    var fields = $("#portlets_modal .portlet-style" ).serializeArray();
	    var style = {};
	    $.each( fields, function( i, field ) {
	    	style[field.name] = field.value;
	    });
	    portlet.style = style;
	    
	    fields = $("#portlets_modal .portlet-attr" ).serializeArray();
	    var attr = {};
	    $.each( fields, function( i, field ) {
	    	attr[field.name] = field.value;
	    });
	    portlet.attr = attr;
	    portlet.iframe_map = $('#portlets_modal #iframe-map').val();
	    portlet.iframe_map_height = $('#portlets_modal #iframe-map-height').val();
	    portlet.iframe_map_height = ($.trim(portlet.iframe_map_height) != '')?portlet.iframe_map_height:'450';
    }
    var iframe_map_src = $('<div></div>').append(portlet.iframe_map).find('iframe').attr('src');
    var iframe_map = '<iframe width="100%" height="'+portlet.iframe_map_height+'" frameborder="0" style="border:0; pointer-events:none;" src="'+iframe_map_src+'" allowfullscreen></iframe>';
    _this.portlet_render(portlet_id,sortable_id,iframe_map,modal_hide);
}

Google_Map_Portlet_Class.prototype.portlet_modal = function (portlet_id){
	var _this = this;
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
    
    $('#portlets_modal').find('#portlets_modal_label').html('Google map');
    $('#portlets_modal').find('#portlets_modal_body').empty();
    
    // render footer button.
    $('#portlets_modal').find('#portlets_modal_body')
    .after(
       $('<div></div>')
       .attr('id','portlets_modal_footer')
       .addClass('modal-footer')
       .append(
            $('<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>')     
       )
       .append(
            $('<button type="button" class="btn btn-primary">Apply</button>')
            .click(function(){
            	_this.portlet_save(portlet_id,false);
            })
       )
       .append(
            $('<button type="button" class="btn btn-primary">Save & close</button>')
            .click(function(){
            	_this.portlet_save(portlet_id);
            })
       )
    );
    // end render footer button.
    
    // render portlet design tab
    $('#portlets_modal').find('#portlets_modal_body').load('zoozoo-builder.php?action=load-plugin-file&project-theme='+$('#project-theme').val()+'&plugin=google-map&file=google-map-portlet.html',function(){
    	Bootstrap_Builder.tab_modal_resize();
    	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
    	if (portlet.iframe_map != undefined && portlet.iframe_map != ''){
    		$('#portlets_modal #iframe-map').val(portlet.iframe_map);
    	}
    	if (portlet.iframe_map_height != undefined && portlet.iframe_map_height != ''){
    		$('#portlets_modal #iframe-map-height').val(portlet.iframe_map_height);
    	}
        if (portlet.style != undefined){
	    	$.each( portlet.style, function( name, value ) {
	    		if ($.trim(value) != ''){
		    		if (name != 'border-color' && name != 'background-color' && name != 'color'){
		    			$('#portlets_modal #'+ name).val(value);
		    		}else{
		    			$('#portlets_modal .'+ name+'-picker').colorpicker('setValue', value);
		    		}
	    		}
	    		
	    	});
        }
        if (portlet.attr != undefined){
	    	$.each( portlet.attr, function( name, value ) {
	    		if ($.trim(value) != ''){
	    			$('#portlets_modal #'+ name).val(value);
	    		}
	    		
	    	});
        }
        Bootstrap_Builder.modal_resize();
    });
    // end render row setting form
};

var Google_Map_Portlet = new Google_Map_Portlet_Class();

