/*
 * portlet: form
 * portlet-type: form 
 * portlet-group: form
 * portlet-name: Form
 * portlet-image: assets/images/no-image.png
 */
Form_Portlet_Class = function(){
	this.toolbar_name = 'Form';
}
$.extend(Form_Portlet_Class.prototype, Abstract_Portlet_Class.prototype);
Form_Portlet_Class.prototype.advance_render = function(portlet_id,content){
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
	var div = $('<form></form>');
	var css = {};
	if (portlet.style != undefined && $.isEmptyObject(portlet.style) == false){
		$.each( portlet.style, function( name, value ) {
			if ($.trim(value) != ''){
				if (name.indexOf("margin-") != -1 || name.indexOf("padding-") != -1 || name.indexOf("-width") != -1){
					css[name] = value + 'px';
				}else{
					css[name] = value;
				}
			}
		});
		div.css(css);
	}
	
	if (portlet.attr != undefined && $.isEmptyObject(portlet.attr) == false){
		$.each( portlet.attr, function( name, value ) {
			if ($.trim(value) != ''){
				div.attr(name,value);
			}
		});
	}
	content = (content != undefined)?content:{};
	content.sortable_id = (content.sortable_id != undefined && content.sortable_id != '')?content.sortable_id:Bootstrap_Builder.guid();
	if ($('#' + content.sortable_id).length <= 0){
		div.append(
	        $('<div class="sortable"></div>')
	        .attr('id',content.sortable_id)
	        .data('sortable-id',content.sortable_id)
	     );
	}else{
		div.append(
			$('#' + content.sortable_id)
		);
		div.find('.new-portlet-btn-'+portlet_id).remove();
	}
	portlet.content = content;
	
	return div;
};

Form_Portlet_Class.prototype.portlet_copy = function(portlet_id){
	var portlet = (Bootstrap_Builder.portlet_copys[portlet_id] != undefined)?Bootstrap_Builder.portlet_copys[portlet_id]:{};
	portlet.sortable_id = (portlet.sortable_id != undefined)?portlet.sortable_id:'empty';
	if ($.isEmptyObject(portlet) == false && Bootstrap_Builder.sortable_ids[portlet.sortable_id] != undefined){
		portlet.sortable_id = Bootstrap_Builder.sortable_ids[portlet.sortable_id];
	}
	if (portlet.content != undefined && portlet.content.sortable_id != undefined){
		Bootstrap_Builder.sortable_ids[portlet.content.sortable_id] = Bootstrap_Builder.guid();
		portlet.content.sortable_id = Bootstrap_Builder.sortable_ids[portlet.content.sortable_id];
	}
	portlet.portlet_id = Bootstrap_Builder.guid();
	
	return portlet;
}

Form_Portlet_Class.prototype.after_render = function(portlet_id){
	if (Bootstrap_Builder.load_sortable == true){
		Bootstrap_Builder.sortable();
	}
}

Form_Portlet_Class.prototype.portlet_toolbar = function(portlet_id,portlet){
	var _this = this;
	portlet.css({paddingTop:'20px'});
	var portlet_toolbar = $('<div class="portlet-toolbar btn-group" style="z-index:3001;"></div>');
    portlet_toolbar.append($('<a class="btn btn-default btn-xs portlet-toolbar-move"></a>').append('<i class="fa fa-arrows"></i> Form'));
    portlet_toolbar.append(
        $('<a class="btn btn-primary btn-xs"></a>')
        .append('<i class="fa fa-files-o"></i>')
        .data('portlet-id',portlet_id)
        .click(function(){
        	$('#portlets_modal').data('copy_portlet_id',portlet_id);
    		var _portlets = Bootstrap_Builder.get_portlets($('#'+portlet_id));
    		_portlets = Bootstrap_Builder.portlet_copy(_portlets);
//    		console.log(JSON.stringify(_portlets));
    		$.post('zoozoo-builder.php?action=portlet-copies&project-theme='+$('#project-theme').val(),{portlets:JSON.stringify(_portlets)},function(html){
    			Bootstrap_Builder.display_portlets(_portlets);
    		});
        })
    );
    portlet_toolbar.append(
              $('<a class="btn btn-primary btn-xs"></a>')
              .append('<i class="fa fa-pencil"></i>')
              .data('portlet-id',portlet_id)
              .click(function(){
                  var portlet_id = $(this).data('portlet-id');
                  var sortable_id = $('#' + portlet_id).data('sortable-id');
                  Bootstrap_Builder.show_portlets(sortable_id,true,null,600);
                  _this.portlet_modal(portlet_id);
                  $('.portlet-toolbar').hide();
              })
    );
    portlet_toolbar.append(
            $('<a class="btn btn-danger btn-xs"></a>')
            .append('<i class="fa fa-trash-o"></i>')
            .data('portlet-id',portlet_id)
            .click(function(){
            	$('.portlet-toolbar').hide();
                $('.portlet-mask').css({visibility:'hidden'});
                $('.portlet-mask').width(6);
                $('#delete-modal .modal-footer > #delete-portlet').remove();
                
                var delete_portlet = $('<button type="button" class="btn btn-danger" id="delete-portlet">Delete</button>');
                var portlet_id = $(this).data('portlet-id');
                
                delete_portlet.click(function(){
                	Bootstrap_Builder.change_flag = true;
                	window.onbeforeunload = function(e) {
                        var message = 'Data you have entered may not be saved. ';
                        e.returnValue  = message;
                        return message;
                    }
//                	$('#' + portlet_id).remove();
	                delete Bootstrap_Builder.portlets[portlet_id];
	                $('#delete-modal').data('portlet-id',portlet_id);
	                $('#delete-modal').modal('hide');
                });
                $('#delete-modal .modal-footer').append(delete_portlet);
            	$('#delete-modal').modal('show');
            })
    );
    portlet.append(portlet_toolbar);
    // end render toolbar
    

    portlet.hover(function() {
    	if (Bootstrap_Builder.is_sortable == false){
	    	$(this).children('.portlet-toolbar').each(function(){
	        	$(this).css({
	                left : '0px',
	                top : '0px'
	            });
	        });
	    	$(this).find('form').children('.sortable').css({borderColor:'#95a5a6'});
	        portlet.children('.portlet-toolbar').show();
    	}
    }, function() {
    	if (Bootstrap_Builder.is_sortable == false){
    		$(this).find('form').children('.sortable').css({borderColor:'transparent'});
    		portlet.children('.portlet-toolbar').hide();
    	}
    });
    
};

Form_Portlet_Class.prototype.portlet_save = function (portlet_id,modal_hide,toolbar){
	toolbar = (toolbar != undefined)?true:false;
	var _this = this;
	modal_hide = (modal_hide == undefined)?true:modal_hide;
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
	portlet.content = (portlet.content !=undefined && $.isEmptyObject(portlet.content) == false)?portlet.content:{};
	Bootstrap_Builder.change_flag = true;
	window.onbeforeunload = function(e) {
        var message = 'Data you have entered may not be saved. ';
        e.returnValue  = message;
        return message;
    }
    var sortable_id = $('#portlets_modal').data('sortable-id');
    if (toolbar == false){
	    var fields = $("#portlets_modal .portlet-style" ).serializeArray();
	    var style = {};
	    $.each( fields, function( i, field ) {
	    	style[field.name] = field.value;
	    });
	    portlet.style = style;
	    
	    fields = $("#portlets_modal .portlet-attr" ).serializeArray();
	    var attr = {};
	    $.each( fields, function( i, field ) {
	    	attr[field.name] = field.value;
	    });
	    portlet.attr = attr;
    }
    var content = portlet.content;
    
    _this.portlet_render(portlet_id,sortable_id,content,modal_hide);
}

Form_Portlet_Class.prototype.portlet_modal = function (portlet_id){
	var _this = this;
	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
    
    $('#portlets_modal').find('#portlets_modal_label').html('Form');
    $('#portlets_modal').find('#portlets_modal_body').empty();
    
    // render footer button.
    $('#portlets_modal').find('#portlets_modal_body')
    .after(
       $('<div></div>')
       .attr('id','portlets_modal_footer')
       .addClass('modal-footer')
       .append(
            $('<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>')     
       )
       .append(
            $('<button type="button" class="btn btn-primary">Apply</button>')
            .click(function(){
            	_this.portlet_save(portlet_id,false);
            })
       )
       .append(
            $('<button type="button" class="btn btn-primary">Save & close</button>')
            .click(function(){
            	_this.portlet_save(portlet_id);
            })
       )
    );
    // end render footer button.
    
    // render portlet design tab
    $('#portlets_modal').find('#portlets_modal_body').load('zoozoo-builder.php?action=load-plugin-file&project-theme='+$('#project-theme').val()+'&plugin=form&file=form-portlet.html',function(){
    	Bootstrap_Builder.tab_modal_resize();
    	var portlet = (Bootstrap_Builder.portlets[portlet_id] != undefined)?Bootstrap_Builder.portlets[portlet_id]:{};
        
        if (portlet.style != undefined){
	    	$.each( portlet.style, function( name, value ) {
	    		if ($.trim(value) != ''){
		    		if (name != 'border-color' && name != 'background-color' && name != 'color'){
		    			$('#portlets_modal #'+ name).val(value);
		    		}else{
		    			$('#portlets_modal .'+ name+'-picker').colorpicker('setValue', value);
		    		}
	    		}
	    		
	    	});
        }
        if (portlet.attr != undefined){
	    	$.each( portlet.attr, function( name, value ) {
	    		if ($.trim(value) != ''){
	    			$('#portlets_modal #'+ name).val(value);
	    		}
	    		
	    	});
        }
        Bootstrap_Builder.modal_resize();
    });
    // end render row setting form
};

var Form_Portlet = new Form_Portlet_Class();

